# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBandwidthResult',
    'AwaitableGetBandwidthResult',
    'get_bandwidth',
    'get_bandwidth_output',
]

@pulumi.output_type
class GetBandwidthResult:
    """
    A collection of values returned by getBandwidth.
    """
    def __init__(__self__, bandwidth_type=None, charge_mode=None, enterprise_project_id=None, id=None, name=None, publicips=None, region=None, share_type=None, size=None, status=None):
        if bandwidth_type and not isinstance(bandwidth_type, str):
            raise TypeError("Expected argument 'bandwidth_type' to be a str")
        pulumi.set(__self__, "bandwidth_type", bandwidth_type)
        if charge_mode and not isinstance(charge_mode, str):
            raise TypeError("Expected argument 'charge_mode' to be a str")
        pulumi.set(__self__, "charge_mode", charge_mode)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if publicips and not isinstance(publicips, list):
            raise TypeError("Expected argument 'publicips' to be a list")
        pulumi.set(__self__, "publicips", publicips)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if share_type and not isinstance(share_type, str):
            raise TypeError("Expected argument 'share_type' to be a str")
        pulumi.set(__self__, "share_type", share_type)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> _builtins.str:
        """
        Indicates the bandwidth type.
        """
        return pulumi.get(self, "bandwidth_type")

    @_builtins.property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> _builtins.str:
        """
        Indicates whether the billing is based on traffic, bandwidth, or 95th percentile bandwidth (enhanced).
        """
        return pulumi.get(self, "charge_mode")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def publicips(self) -> Sequence['outputs.GetBandwidthPublicipResult']:
        """
        An array of EIPs that use the bandwidth. The object includes the following:
        """
        return pulumi.get(self, "publicips")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> _builtins.str:
        """
        Indicates whether the bandwidth is shared or dedicated.
        """
        return pulumi.get(self, "share_type")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Indicates the bandwidth status.
        """
        return pulumi.get(self, "status")


class AwaitableGetBandwidthResult(GetBandwidthResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBandwidthResult(
            bandwidth_type=self.bandwidth_type,
            charge_mode=self.charge_mode,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            publicips=self.publicips,
            region=self.region,
            share_type=self.share_type,
            size=self.size,
            status=self.status)


def get_bandwidth(enterprise_project_id: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  size: Optional[_builtins.int] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBandwidthResult:
    """
    Provides details about a specific bandwidth.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    bandwidth_name = config.require_object("bandwidthName")
    bandwidth1 = sbercloud.Eip.get_bandwidth(name=bandwidth_name)
    ```


    :param _builtins.str enterprise_project_id: The enterprise project id of the Shared Bandwidth to retrieve.
    :param _builtins.str name: The name of the Shared Bandwidth to retrieve.
    :param _builtins.str region: The region in which to obtain the bandwidth. If omitted, the provider-level region will
           be used.
    :param _builtins.int size: The size of the Shared Bandwidth to retrieve. The value ranges from 5 to 2000 G.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['size'] = size
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Eip/getBandwidth:getBandwidth', __args__, opts=opts, typ=GetBandwidthResult).value

    return AwaitableGetBandwidthResult(
        bandwidth_type=pulumi.get(__ret__, 'bandwidth_type'),
        charge_mode=pulumi.get(__ret__, 'charge_mode'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        publicips=pulumi.get(__ret__, 'publicips'),
        region=pulumi.get(__ret__, 'region'),
        share_type=pulumi.get(__ret__, 'share_type'),
        size=pulumi.get(__ret__, 'size'),
        status=pulumi.get(__ret__, 'status'))
def get_bandwidth_output(enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         name: Optional[pulumi.Input[_builtins.str]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBandwidthResult]:
    """
    Provides details about a specific bandwidth.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    bandwidth_name = config.require_object("bandwidthName")
    bandwidth1 = sbercloud.Eip.get_bandwidth(name=bandwidth_name)
    ```


    :param _builtins.str enterprise_project_id: The enterprise project id of the Shared Bandwidth to retrieve.
    :param _builtins.str name: The name of the Shared Bandwidth to retrieve.
    :param _builtins.str region: The region in which to obtain the bandwidth. If omitted, the provider-level region will
           be used.
    :param _builtins.int size: The size of the Shared Bandwidth to retrieve. The value ranges from 5 to 2000 G.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['size'] = size
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Eip/getBandwidth:getBandwidth', __args__, opts=opts, typ=GetBandwidthResult)
    return __ret__.apply(lambda __response__: GetBandwidthResult(
        bandwidth_type=pulumi.get(__response__, 'bandwidth_type'),
        charge_mode=pulumi.get(__response__, 'charge_mode'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        publicips=pulumi.get(__response__, 'publicips'),
        region=pulumi.get(__response__, 'region'),
        share_type=pulumi.get(__response__, 'share_type'),
        size=pulumi.get(__response__, 'size'),
        status=pulumi.get(__response__, 'status')))
