# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetEipResult',
    'AwaitableGetEipResult',
    'get_eip',
    'get_eip_output',
]

@pulumi.output_type
class GetEipResult:
    """
    A collection of values returned by getEip.
    """
    def __init__(__self__, bandwidth_id=None, bandwidth_name=None, bandwidth_share_type=None, bandwidth_size=None, created_at=None, enterprise_project_id=None, id=None, ip_version=None, ipv6_address=None, name=None, port_id=None, private_ip=None, public_ip=None, region=None, status=None, type=None):
        if bandwidth_id and not isinstance(bandwidth_id, str):
            raise TypeError("Expected argument 'bandwidth_id' to be a str")
        pulumi.set(__self__, "bandwidth_id", bandwidth_id)
        if bandwidth_name and not isinstance(bandwidth_name, str):
            raise TypeError("Expected argument 'bandwidth_name' to be a str")
        pulumi.set(__self__, "bandwidth_name", bandwidth_name)
        if bandwidth_share_type and not isinstance(bandwidth_share_type, str):
            raise TypeError("Expected argument 'bandwidth_share_type' to be a str")
        pulumi.set(__self__, "bandwidth_share_type", bandwidth_share_type)
        if bandwidth_size and not isinstance(bandwidth_size, int):
            raise TypeError("Expected argument 'bandwidth_size' to be a int")
        pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_version and not isinstance(ip_version, int):
            raise TypeError("Expected argument 'ip_version' to be a int")
        pulumi.set(__self__, "ip_version", ip_version)
        if ipv6_address and not isinstance(ipv6_address, str):
            raise TypeError("Expected argument 'ipv6_address' to be a str")
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if port_id and not isinstance(port_id, str):
            raise TypeError("Expected argument 'port_id' to be a str")
        pulumi.set(__self__, "port_id", port_id)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if public_ip and not isinstance(public_ip, str):
            raise TypeError("Expected argument 'public_ip' to be a str")
        pulumi.set(__self__, "public_ip", public_ip)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="bandwidthId")
    def bandwidth_id(self) -> _builtins.str:
        """
        The bandwidth id of the EIP.
        """
        return pulumi.get(self, "bandwidth_id")

    @_builtins.property
    @pulumi.getter(name="bandwidthName")
    def bandwidth_name(self) -> _builtins.str:
        return pulumi.get(self, "bandwidth_name")

    @_builtins.property
    @pulumi.getter(name="bandwidthShareType")
    def bandwidth_share_type(self) -> _builtins.str:
        """
        The bandwidth share type of the EIP.
        """
        return pulumi.get(self, "bandwidth_share_type")

    @_builtins.property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> _builtins.int:
        """
        The bandwidth size of the EIP.
        """
        return pulumi.get(self, "bandwidth_size")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.int:
        """
        The IP version, either 4 or 6.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> _builtins.str:
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> _builtins.str:
        return pulumi.get(self, "port_id")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> _builtins.str:
        """
        The private ip of the EIP.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> _builtins.str:
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the EIP.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the EIP.
        """
        return pulumi.get(self, "type")


class AwaitableGetEipResult(GetEipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEipResult(
            bandwidth_id=self.bandwidth_id,
            bandwidth_name=self.bandwidth_name,
            bandwidth_share_type=self.bandwidth_share_type,
            bandwidth_size=self.bandwidth_size,
            created_at=self.created_at,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            ip_version=self.ip_version,
            ipv6_address=self.ipv6_address,
            name=self.name,
            port_id=self.port_id,
            private_ip=self.private_ip,
            public_ip=self.public_ip,
            region=self.region,
            status=self.status,
            type=self.type)


def get_eip(enterprise_project_id: Optional[_builtins.str] = None,
            port_id: Optional[_builtins.str] = None,
            public_ip: Optional[_builtins.str] = None,
            region: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEipResult:
    """
    Use this data source to get the details of an available EIP.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    by_address = sbercloud.Eip.get_eip(public_ip="123.60.208.163")
    ```


    :param _builtins.str enterprise_project_id: The enterprise project id of the EIP.
    :param _builtins.str port_id: The port id of the EIP.
    :param _builtins.str public_ip: The public ip address of the EIP.
    :param _builtins.str region: The region in which to obtain the EIP. If omitted, the provider-level region will be
           used.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['portId'] = port_id
    __args__['publicIp'] = public_ip
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Eip/getEip:getEip', __args__, opts=opts, typ=GetEipResult).value

    return AwaitableGetEipResult(
        bandwidth_id=pulumi.get(__ret__, 'bandwidth_id'),
        bandwidth_name=pulumi.get(__ret__, 'bandwidth_name'),
        bandwidth_share_type=pulumi.get(__ret__, 'bandwidth_share_type'),
        bandwidth_size=pulumi.get(__ret__, 'bandwidth_size'),
        created_at=pulumi.get(__ret__, 'created_at'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        ip_version=pulumi.get(__ret__, 'ip_version'),
        ipv6_address=pulumi.get(__ret__, 'ipv6_address'),
        name=pulumi.get(__ret__, 'name'),
        port_id=pulumi.get(__ret__, 'port_id'),
        private_ip=pulumi.get(__ret__, 'private_ip'),
        public_ip=pulumi.get(__ret__, 'public_ip'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'))
def get_eip_output(enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   port_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   public_ip: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEipResult]:
    """
    Use this data source to get the details of an available EIP.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    by_address = sbercloud.Eip.get_eip(public_ip="123.60.208.163")
    ```


    :param _builtins.str enterprise_project_id: The enterprise project id of the EIP.
    :param _builtins.str port_id: The port id of the EIP.
    :param _builtins.str public_ip: The public ip address of the EIP.
    :param _builtins.str region: The region in which to obtain the EIP. If omitted, the provider-level region will be
           used.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['portId'] = port_id
    __args__['publicIp'] = public_ip
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Eip/getEip:getEip', __args__, opts=opts, typ=GetEipResult)
    return __ret__.apply(lambda __response__: GetEipResult(
        bandwidth_id=pulumi.get(__response__, 'bandwidth_id'),
        bandwidth_name=pulumi.get(__response__, 'bandwidth_name'),
        bandwidth_share_type=pulumi.get(__response__, 'bandwidth_share_type'),
        bandwidth_size=pulumi.get(__response__, 'bandwidth_size'),
        created_at=pulumi.get(__response__, 'created_at'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        ip_version=pulumi.get(__response__, 'ip_version'),
        ipv6_address=pulumi.get(__response__, 'ipv6_address'),
        name=pulumi.get(__response__, 'name'),
        port_id=pulumi.get(__response__, 'port_id'),
        private_ip=pulumi.get(__response__, 'private_ip'),
        public_ip=pulumi.get(__response__, 'public_ip'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type')))
