# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEipsResult',
    'AwaitableGetEipsResult',
    'get_eips',
    'get_eips_output',
]

@pulumi.output_type
class GetEipsResult:
    """
    A collection of values returned by getEips.
    """
    def __init__(__self__, eips=None, enterprise_project_id=None, id=None, ids=None, ip_version=None, port_ids=None, private_ips=None, public_ips=None, region=None, tags=None):
        if eips and not isinstance(eips, list):
            raise TypeError("Expected argument 'eips' to be a list")
        pulumi.set(__self__, "eips", eips)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if ip_version and not isinstance(ip_version, int):
            raise TypeError("Expected argument 'ip_version' to be a int")
        pulumi.set(__self__, "ip_version", ip_version)
        if port_ids and not isinstance(port_ids, list):
            raise TypeError("Expected argument 'port_ids' to be a list")
        pulumi.set(__self__, "port_ids", port_ids)
        if private_ips and not isinstance(private_ips, list):
            raise TypeError("Expected argument 'private_ips' to be a list")
        pulumi.set(__self__, "private_ips", private_ips)
        if public_ips and not isinstance(public_ips, list):
            raise TypeError("Expected argument 'public_ips' to be a list")
        pulumi.set(__self__, "public_ips", public_ips)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def eips(self) -> Sequence['outputs.GetEipsEipResult']:
        """
        Indicates a list of all EIPs found. Structure is documented below.
        """
        return pulumi.get(self, "eips")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        """
        The the enterprise project ID of the EIP.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[_builtins.int]:
        """
        The ip version of the EIP.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="portIds")
    def port_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "port_ids")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "public_ips")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The key/value pairs which associated with the EIP.
        """
        return pulumi.get(self, "tags")


class AwaitableGetEipsResult(GetEipsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEipsResult(
            eips=self.eips,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            ids=self.ids,
            ip_version=self.ip_version,
            port_ids=self.port_ids,
            private_ips=self.private_ips,
            public_ips=self.public_ips,
            region=self.region,
            tags=self.tags)


def get_eips(enterprise_project_id: Optional[_builtins.str] = None,
             ids: Optional[Sequence[_builtins.str]] = None,
             ip_version: Optional[_builtins.int] = None,
             port_ids: Optional[Sequence[_builtins.str]] = None,
             private_ips: Optional[Sequence[_builtins.str]] = None,
             public_ips: Optional[Sequence[_builtins.str]] = None,
             region: Optional[_builtins.str] = None,
             tags: Optional[Mapping[str, _builtins.str]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEipsResult:
    """
    Use this data source to get a list of EIPs.

    ## Example Usage

    An example filter by name and tag

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    public_ip = config.require_object("publicIp")
    eip = sbercloud.Eip.get_eips(public_ips=[public_ip],
        tags={
            "foo": "bar",
        })
    pulumi.export("eipIds", [__item.id for __item in eip.eips])
    ```


    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID which the desired EIP belongs to.
    :param Sequence[_builtins.str] ids: Specifies an array of one or more IDs of the desired EIP.
    :param _builtins.int ip_version: Specifies ip version of the desired EIP. The options are:
    :param Sequence[_builtins.str] port_ids: Specifies an array of one or more port ids which bound to the desired EIP.
    :param Sequence[_builtins.str] public_ips: Specifies an array of one or more public ip addresses of the desired EIP.
    :param _builtins.str region: Specifies the region in which to obtain the EIP. If omitted, the provider-level region
           will be used.
    :param Mapping[str, _builtins.str] tags: Specifies the included key/value pairs which associated with the desired EIP.
           
           > A maximum of 10 tag keys are allowed for each query operation. Each tag key can have up to 10 tag values.
           The tag key cannot be left blank or set to an empty string. Each tag key must be unique, and each tag value in a
           tag must be unique, use commas(,) to separate the multiple values. An empty for values indicates any value.
           The values are in the OR relationship.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['ids'] = ids
    __args__['ipVersion'] = ip_version
    __args__['portIds'] = port_ids
    __args__['privateIps'] = private_ips
    __args__['publicIps'] = public_ips
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Eip/getEips:getEips', __args__, opts=opts, typ=GetEipsResult).value

    return AwaitableGetEipsResult(
        eips=pulumi.get(__ret__, 'eips'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        ip_version=pulumi.get(__ret__, 'ip_version'),
        port_ids=pulumi.get(__ret__, 'port_ids'),
        private_ips=pulumi.get(__ret__, 'private_ips'),
        public_ips=pulumi.get(__ret__, 'public_ips'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_eips_output(enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                    ip_version: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                    port_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                    private_ips: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                    public_ips: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                    region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEipsResult]:
    """
    Use this data source to get a list of EIPs.

    ## Example Usage

    An example filter by name and tag

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    public_ip = config.require_object("publicIp")
    eip = sbercloud.Eip.get_eips(public_ips=[public_ip],
        tags={
            "foo": "bar",
        })
    pulumi.export("eipIds", [__item.id for __item in eip.eips])
    ```


    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID which the desired EIP belongs to.
    :param Sequence[_builtins.str] ids: Specifies an array of one or more IDs of the desired EIP.
    :param _builtins.int ip_version: Specifies ip version of the desired EIP. The options are:
    :param Sequence[_builtins.str] port_ids: Specifies an array of one or more port ids which bound to the desired EIP.
    :param Sequence[_builtins.str] public_ips: Specifies an array of one or more public ip addresses of the desired EIP.
    :param _builtins.str region: Specifies the region in which to obtain the EIP. If omitted, the provider-level region
           will be used.
    :param Mapping[str, _builtins.str] tags: Specifies the included key/value pairs which associated with the desired EIP.
           
           > A maximum of 10 tag keys are allowed for each query operation. Each tag key can have up to 10 tag values.
           The tag key cannot be left blank or set to an empty string. Each tag key must be unique, and each tag value in a
           tag must be unique, use commas(,) to separate the multiple values. An empty for values indicates any value.
           The values are in the OR relationship.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['ids'] = ids
    __args__['ipVersion'] = ip_version
    __args__['portIds'] = port_ids
    __args__['privateIps'] = private_ips
    __args__['publicIps'] = public_ips
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Eip/getEips:getEips', __args__, opts=opts, typ=GetEipsResult)
    return __ret__.apply(lambda __response__: GetEipsResult(
        eips=pulumi.get(__response__, 'eips'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        ip_version=pulumi.get(__response__, 'ip_version'),
        port_ids=pulumi.get(__response__, 'port_ids'),
        private_ips=pulumi.get(__response__, 'private_ips'),
        public_ips=pulumi.get(__response__, 'public_ips'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
