# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBandwidthPublicipResult',
    'GetEipsEipResult',
]

@pulumi.output_type
class GetBandwidthPublicipResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 ip_address: _builtins.str,
                 ip_version: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.str id: The ID of the EIP or IPv6 port that uses the bandwidth.
        :param _builtins.str ip_address: The IPv4 or IPv6 address.
        :param _builtins.int ip_version: The IP version, either 4 or 6.
        :param _builtins.str type: The EIP type.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the EIP or IPv6 port that uses the bandwidth.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IPv4 or IPv6 address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.int:
        """
        The IP version, either 4 or 6.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The EIP type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetEipsEipResult(dict):
    def __init__(__self__, *,
                 bandwidth_id: _builtins.str,
                 bandwidth_name: _builtins.str,
                 bandwidth_share_type: _builtins.str,
                 bandwidth_size: _builtins.int,
                 created_at: _builtins.str,
                 enterprise_project_id: _builtins.str,
                 id: _builtins.str,
                 ip_version: _builtins.int,
                 name: _builtins.str,
                 port_id: _builtins.str,
                 private_ip: _builtins.str,
                 public_ip: _builtins.str,
                 public_ipv6: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 type: _builtins.str):
        """
        :param _builtins.str bandwidth_id: The bandwidth id of the EIP.
        :param _builtins.str bandwidth_name: The bandwidth name of the EIP.
        :param _builtins.str bandwidth_share_type: The bandwidth share type of the EIP.
        :param _builtins.int bandwidth_size: The bandwidth size of the EIP.
        :param _builtins.str enterprise_project_id: Specifies the enterprise project ID which the desired EIP belongs to.
        :param _builtins.str id: The ID of the EIP.
        :param _builtins.int ip_version: Specifies ip version of the desired EIP. The options are:
        :param _builtins.str name: The name of the EIP.
        :param _builtins.str port_id: The port id bound to the EIP.
        :param _builtins.str private_ip: The private ip address of the EIP.
        :param _builtins.str public_ip: The public ip address of the EIP.
        :param _builtins.str public_ipv6: The public ipv6 address of the EIP.
        :param _builtins.str status: The status of the EIP.
        :param Mapping[str, _builtins.str] tags: Specifies the included key/value pairs which associated with the desired EIP.
               
               > A maximum of 10 tag keys are allowed for each query operation. Each tag key can have up to 10 tag values.
               The tag key cannot be left blank or set to an empty string. Each tag key must be unique, and each tag value in a
               tag must be unique, use commas(,) to separate the multiple values. An empty for values indicates any value.
               The values are in the OR relationship.
        :param _builtins.str type: The type of the EIP.
        """
        pulumi.set(__self__, "bandwidth_id", bandwidth_id)
        pulumi.set(__self__, "bandwidth_name", bandwidth_name)
        pulumi.set(__self__, "bandwidth_share_type", bandwidth_share_type)
        pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port_id", port_id)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "public_ipv6", public_ipv6)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="bandwidthId")
    def bandwidth_id(self) -> _builtins.str:
        """
        The bandwidth id of the EIP.
        """
        return pulumi.get(self, "bandwidth_id")

    @_builtins.property
    @pulumi.getter(name="bandwidthName")
    def bandwidth_name(self) -> _builtins.str:
        """
        The bandwidth name of the EIP.
        """
        return pulumi.get(self, "bandwidth_name")

    @_builtins.property
    @pulumi.getter(name="bandwidthShareType")
    def bandwidth_share_type(self) -> _builtins.str:
        """
        The bandwidth share type of the EIP.
        """
        return pulumi.get(self, "bandwidth_share_type")

    @_builtins.property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> _builtins.int:
        """
        The bandwidth size of the EIP.
        """
        return pulumi.get(self, "bandwidth_size")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        """
        Specifies the enterprise project ID which the desired EIP belongs to.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the EIP.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.int:
        """
        Specifies ip version of the desired EIP. The options are:
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the EIP.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> _builtins.str:
        """
        The port id bound to the EIP.
        """
        return pulumi.get(self, "port_id")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> _builtins.str:
        """
        The private ip address of the EIP.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> _builtins.str:
        """
        The public ip address of the EIP.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="publicIpv6")
    def public_ipv6(self) -> _builtins.str:
        """
        The public ipv6 address of the EIP.
        """
        return pulumi.get(self, "public_ipv6")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the EIP.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Specifies the included key/value pairs which associated with the desired EIP.

        > A maximum of 10 tag keys are allowed for each query operation. Each tag key can have up to 10 tag values.
        The tag key cannot be left blank or set to an empty string. Each tag key must be unique, and each tag value in a
        tag must be unique, use commas(,) to separate the multiple values. An empty for values indicates any value.
        The values are in the OR relationship.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the EIP.
        """
        return pulumi.get(self, "type")


