# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    """
    A collection of values returned by getCertificate.
    """
    def __init__(__self__, description=None, domain=None, expiration=None, id=None, name=None, region=None, type=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if expiration and not isinstance(expiration, str):
            raise TypeError("Expected argument 'expiration' to be a str")
        pulumi.set(__self__, "expiration", expiration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Human-readable description for the Certificate.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain of the Certificate. This parameter is valid only when `type` is "server".
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> _builtins.str:
        """
        Indicates the time when the certificate expires.
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            description=self.description,
            domain=self.domain,
            expiration=self.expiration,
            id=self.id,
            name=self.name,
            region=self.region,
            type=self.type)


def get_certificate(name: Optional[_builtins.str] = None,
                    region: Optional[_builtins.str] = None,
                    type: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    Use this data source to get the certificates in SberCloud Elastic Load Balance (ELB).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    certificate_name = config.require_object("certificateName")
    test = sbercloud.Elb.get_certificate(name=certificate_name,
        type="server")
    ```


    :param _builtins.str name: The name of certificate. The value is case sensitive and does not supports fuzzy matching.
           
           > **NOTE:** The certificate name is not unique. Only returns the last created one when matched multiple certificates.
    :param _builtins.str region: The region in which to obtain the ELB certificate. If omitted, the provider-level region
           will be used.
    :param _builtins.str type: Specifies the certificate type. The default value is `server`. The value can be one of the
           following:
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Elb/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        description=pulumi.get(__ret__, 'description'),
        domain=pulumi.get(__ret__, 'domain'),
        expiration=pulumi.get(__ret__, 'expiration'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        type=pulumi.get(__ret__, 'type'))
def get_certificate_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateResult]:
    """
    Use this data source to get the certificates in SberCloud Elastic Load Balance (ELB).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    certificate_name = config.require_object("certificateName")
    test = sbercloud.Elb.get_certificate(name=certificate_name,
        type="server")
    ```


    :param _builtins.str name: The name of certificate. The value is case sensitive and does not supports fuzzy matching.
           
           > **NOTE:** The certificate name is not unique. Only returns the last created one when matched multiple certificates.
    :param _builtins.str region: The region in which to obtain the ELB certificate. If omitted, the provider-level region
           will be used.
    :param _builtins.str type: Specifies the certificate type. The default value is `server`. The value can be one of the
           following:
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Elb/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult)
    return __ret__.apply(lambda __response__: GetCertificateResult(
        description=pulumi.get(__response__, 'description'),
        domain=pulumi.get(__response__, 'domain'),
        expiration=pulumi.get(__response__, 'expiration'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        type=pulumi.get(__response__, 'type')))
