# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetListenersResult',
    'AwaitableGetListenersResult',
    'get_listeners',
    'get_listeners_output',
]

@pulumi.output_type
class GetListenersResult:
    """
    A collection of values returned by getListeners.
    """
    def __init__(__self__, client_ca_tls_container_ref=None, default_pool_id=None, default_tls_container_ref=None, description=None, enterprise_project_id=None, http2_enable=None, id=None, listener_id=None, listeners=None, loadbalancer_id=None, name=None, protocol=None, protocol_port=None, region=None, tls_ciphers_policy=None):
        if client_ca_tls_container_ref and not isinstance(client_ca_tls_container_ref, str):
            raise TypeError("Expected argument 'client_ca_tls_container_ref' to be a str")
        pulumi.set(__self__, "client_ca_tls_container_ref", client_ca_tls_container_ref)
        if default_pool_id and not isinstance(default_pool_id, str):
            raise TypeError("Expected argument 'default_pool_id' to be a str")
        pulumi.set(__self__, "default_pool_id", default_pool_id)
        if default_tls_container_ref and not isinstance(default_tls_container_ref, str):
            raise TypeError("Expected argument 'default_tls_container_ref' to be a str")
        pulumi.set(__self__, "default_tls_container_ref", default_tls_container_ref)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if http2_enable and not isinstance(http2_enable, str):
            raise TypeError("Expected argument 'http2_enable' to be a str")
        pulumi.set(__self__, "http2_enable", http2_enable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listener_id and not isinstance(listener_id, str):
            raise TypeError("Expected argument 'listener_id' to be a str")
        pulumi.set(__self__, "listener_id", listener_id)
        if listeners and not isinstance(listeners, list):
            raise TypeError("Expected argument 'listeners' to be a list")
        pulumi.set(__self__, "listeners", listeners)
        if loadbalancer_id and not isinstance(loadbalancer_id, str):
            raise TypeError("Expected argument 'loadbalancer_id' to be a str")
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if protocol_port and not isinstance(protocol_port, str):
            raise TypeError("Expected argument 'protocol_port' to be a str")
        pulumi.set(__self__, "protocol_port", protocol_port)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tls_ciphers_policy and not isinstance(tls_ciphers_policy, str):
            raise TypeError("Expected argument 'tls_ciphers_policy' to be a str")
        pulumi.set(__self__, "tls_ciphers_policy", tls_ciphers_policy)

    @_builtins.property
    @pulumi.getter(name="clientCaTlsContainerRef")
    def client_ca_tls_container_ref(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "client_ca_tls_container_ref")

    @_builtins.property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> Optional[_builtins.str]:
        """
        The ID of the default pool with which the ELB listener is associated.
        """
        return pulumi.get(self, "default_pool_id")

    @_builtins.property
    @pulumi.getter(name="defaultTlsContainerRef")
    def default_tls_container_ref(self) -> Optional[_builtins.str]:
        """
        The ID of the server certificate used by the listener.
        """
        return pulumi.get(self, "default_tls_container_ref")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of the ELB listener.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> Optional[_builtins.str]:
        """
        Whether the ELB listener uses HTTP/2.
        """
        return pulumi.get(self, "http2_enable")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.GetListenersListenerResult']:
        """
        Listener list.
        The object structure is documented below.
        """
        return pulumi.get(self, "listeners")

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The listener name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The listener protocol.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> Optional[_builtins.str]:
        """
        The front-end listening port of the listener.
        """
        return pulumi.get(self, "protocol_port")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="tlsCiphersPolicy")
    def tls_ciphers_policy(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tls_ciphers_policy")


class AwaitableGetListenersResult(GetListenersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListenersResult(
            client_ca_tls_container_ref=self.client_ca_tls_container_ref,
            default_pool_id=self.default_pool_id,
            default_tls_container_ref=self.default_tls_container_ref,
            description=self.description,
            enterprise_project_id=self.enterprise_project_id,
            http2_enable=self.http2_enable,
            id=self.id,
            listener_id=self.listener_id,
            listeners=self.listeners,
            loadbalancer_id=self.loadbalancer_id,
            name=self.name,
            protocol=self.protocol,
            protocol_port=self.protocol_port,
            region=self.region,
            tls_ciphers_policy=self.tls_ciphers_policy)


def get_listeners(client_ca_tls_container_ref: Optional[_builtins.str] = None,
                  default_pool_id: Optional[_builtins.str] = None,
                  default_tls_container_ref: Optional[_builtins.str] = None,
                  description: Optional[_builtins.str] = None,
                  enterprise_project_id: Optional[_builtins.str] = None,
                  http2_enable: Optional[_builtins.str] = None,
                  listener_id: Optional[_builtins.str] = None,
                  loadbalancer_id: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  protocol: Optional[_builtins.str] = None,
                  protocol_port: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  tls_ciphers_policy: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListenersResult:
    """
    Use this data source to query the list of ELB listeners.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    protocol = config.require_object("protocol")
    test = sbercloud.Elb.get_listeners(protocol=protocol)
    ```


    :param _builtins.str default_pool_id: The ID of the default pool with which the ELB listener is associated.
    :param _builtins.str default_tls_container_ref: The ID of the server certificate used by the listener.
    :param _builtins.str description: The description of the ELB listener.
    :param _builtins.str http2_enable: Whether the ELB listener uses HTTP/2.
    :param _builtins.str name: The listener name.
    :param _builtins.str protocol: The listener protocol.  
           The valid values are **TCP**, **UDP**, **HTTP** and **TERMINATED_HTTPS**.
    :param _builtins.str protocol_port: The front-end listening port of the listener.  
           The valid value is range from `1` to `65535`.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['clientCaTlsContainerRef'] = client_ca_tls_container_ref
    __args__['defaultPoolId'] = default_pool_id
    __args__['defaultTlsContainerRef'] = default_tls_container_ref
    __args__['description'] = description
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['http2Enable'] = http2_enable
    __args__['listenerId'] = listener_id
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['name'] = name
    __args__['protocol'] = protocol
    __args__['protocolPort'] = protocol_port
    __args__['region'] = region
    __args__['tlsCiphersPolicy'] = tls_ciphers_policy
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Elb/getListeners:getListeners', __args__, opts=opts, typ=GetListenersResult).value

    return AwaitableGetListenersResult(
        client_ca_tls_container_ref=pulumi.get(__ret__, 'client_ca_tls_container_ref'),
        default_pool_id=pulumi.get(__ret__, 'default_pool_id'),
        default_tls_container_ref=pulumi.get(__ret__, 'default_tls_container_ref'),
        description=pulumi.get(__ret__, 'description'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        http2_enable=pulumi.get(__ret__, 'http2_enable'),
        id=pulumi.get(__ret__, 'id'),
        listener_id=pulumi.get(__ret__, 'listener_id'),
        listeners=pulumi.get(__ret__, 'listeners'),
        loadbalancer_id=pulumi.get(__ret__, 'loadbalancer_id'),
        name=pulumi.get(__ret__, 'name'),
        protocol=pulumi.get(__ret__, 'protocol'),
        protocol_port=pulumi.get(__ret__, 'protocol_port'),
        region=pulumi.get(__ret__, 'region'),
        tls_ciphers_policy=pulumi.get(__ret__, 'tls_ciphers_policy'))
def get_listeners_output(client_ca_tls_container_ref: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         default_pool_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         default_tls_container_ref: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         http2_enable: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         listener_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         loadbalancer_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         protocol: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         protocol_port: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         tls_ciphers_policy: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetListenersResult]:
    """
    Use this data source to query the list of ELB listeners.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    protocol = config.require_object("protocol")
    test = sbercloud.Elb.get_listeners(protocol=protocol)
    ```


    :param _builtins.str default_pool_id: The ID of the default pool with which the ELB listener is associated.
    :param _builtins.str default_tls_container_ref: The ID of the server certificate used by the listener.
    :param _builtins.str description: The description of the ELB listener.
    :param _builtins.str http2_enable: Whether the ELB listener uses HTTP/2.
    :param _builtins.str name: The listener name.
    :param _builtins.str protocol: The listener protocol.  
           The valid values are **TCP**, **UDP**, **HTTP** and **TERMINATED_HTTPS**.
    :param _builtins.str protocol_port: The front-end listening port of the listener.  
           The valid value is range from `1` to `65535`.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['clientCaTlsContainerRef'] = client_ca_tls_container_ref
    __args__['defaultPoolId'] = default_pool_id
    __args__['defaultTlsContainerRef'] = default_tls_container_ref
    __args__['description'] = description
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['http2Enable'] = http2_enable
    __args__['listenerId'] = listener_id
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['name'] = name
    __args__['protocol'] = protocol
    __args__['protocolPort'] = protocol_port
    __args__['region'] = region
    __args__['tlsCiphersPolicy'] = tls_ciphers_policy
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Elb/getListeners:getListeners', __args__, opts=opts, typ=GetListenersResult)
    return __ret__.apply(lambda __response__: GetListenersResult(
        client_ca_tls_container_ref=pulumi.get(__response__, 'client_ca_tls_container_ref'),
        default_pool_id=pulumi.get(__response__, 'default_pool_id'),
        default_tls_container_ref=pulumi.get(__response__, 'default_tls_container_ref'),
        description=pulumi.get(__response__, 'description'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        http2_enable=pulumi.get(__response__, 'http2_enable'),
        id=pulumi.get(__response__, 'id'),
        listener_id=pulumi.get(__response__, 'listener_id'),
        listeners=pulumi.get(__response__, 'listeners'),
        loadbalancer_id=pulumi.get(__response__, 'loadbalancer_id'),
        name=pulumi.get(__response__, 'name'),
        protocol=pulumi.get(__response__, 'protocol'),
        protocol_port=pulumi.get(__response__, 'protocol_port'),
        region=pulumi.get(__response__, 'region'),
        tls_ciphers_policy=pulumi.get(__response__, 'tls_ciphers_policy')))
