# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLoadbalancerResult',
    'AwaitableGetLoadbalancerResult',
    'get_loadbalancer',
    'get_loadbalancer_output',
]

@pulumi.output_type
class GetLoadbalancerResult:
    """
    A collection of values returned by getLoadbalancer.
    """
    def __init__(__self__, description=None, enterprise_project_id=None, id=None, name=None, public_ip=None, region=None, status=None, tags=None, vip_address=None, vip_port_id=None, vip_subnet_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_ip and not isinstance(public_ip, str):
            raise TypeError("Expected argument 'public_ip' to be a str")
        pulumi.set(__self__, "public_ip", public_ip)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vip_address and not isinstance(vip_address, str):
            raise TypeError("Expected argument 'vip_address' to be a str")
        pulumi.set(__self__, "vip_address", vip_address)
        if vip_port_id and not isinstance(vip_port_id, str):
            raise TypeError("Expected argument 'vip_port_id' to be a str")
        pulumi.set(__self__, "vip_port_id", vip_port_id)
        if vip_subnet_id and not isinstance(vip_subnet_id, str):
            raise TypeError("Expected argument 'vip_subnet_id' to be a str")
        pulumi.set(__self__, "vip_subnet_id", vip_subnet_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> _builtins.str:
        """
        The EIP address that is associated to the Load Balancer instance.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tags associated with the load balancer.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> _builtins.str:
        return pulumi.get(self, "vip_address")

    @_builtins.property
    @pulumi.getter(name="vipPortId")
    def vip_port_id(self) -> _builtins.str:
        """
        The ID of the port bound to the private IP address of the load balancer.
        """
        return pulumi.get(self, "vip_port_id")

    @_builtins.property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> _builtins.str:
        return pulumi.get(self, "vip_subnet_id")


class AwaitableGetLoadbalancerResult(GetLoadbalancerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadbalancerResult(
            description=self.description,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            public_ip=self.public_ip,
            region=self.region,
            status=self.status,
            tags=self.tags,
            vip_address=self.vip_address,
            vip_port_id=self.vip_port_id,
            vip_subnet_id=self.vip_subnet_id)


def get_loadbalancer(description: Optional[_builtins.str] = None,
                     enterprise_project_id: Optional[_builtins.str] = None,
                     id: Optional[_builtins.str] = None,
                     name: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     status: Optional[_builtins.str] = None,
                     vip_address: Optional[_builtins.str] = None,
                     vip_subnet_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadbalancerResult:
    """
    Use this data source to get available SberCloud elb load balancer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    lb_name = config.require_object("lbName")
    test = sbercloud.Elb.get_loadbalancer(name=lb_name)
    ```


    :param _builtins.str description: Specifies the supplementary information about the load balancer.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project id of the load balancer.
    :param _builtins.str id: Specifies the data source ID of the load balancer in UUID format.
    :param _builtins.str name: Specifies the name of the load balancer.
    :param _builtins.str region: Specifies the region in which to obtain the load balancer. If omitted, the
           provider-level region will be used.
    :param _builtins.str status: Specifies the operating status of the load balancer. Valid values are *ONLINE* and
           *FROZEN*.
    :param _builtins.str vip_address: Specifies the private IP address of the load balancer.
    :param _builtins.str vip_subnet_id: Specifies the **IPv4 subnet ID** of the subnet where the load balancer works.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    __args__['vipAddress'] = vip_address
    __args__['vipSubnetId'] = vip_subnet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Elb/getLoadbalancer:getLoadbalancer', __args__, opts=opts, typ=GetLoadbalancerResult).value

    return AwaitableGetLoadbalancerResult(
        description=pulumi.get(__ret__, 'description'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        public_ip=pulumi.get(__ret__, 'public_ip'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        vip_address=pulumi.get(__ret__, 'vip_address'),
        vip_port_id=pulumi.get(__ret__, 'vip_port_id'),
        vip_subnet_id=pulumi.get(__ret__, 'vip_subnet_id'))
def get_loadbalancer_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            vip_address: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            vip_subnet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoadbalancerResult]:
    """
    Use this data source to get available SberCloud elb load balancer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    lb_name = config.require_object("lbName")
    test = sbercloud.Elb.get_loadbalancer(name=lb_name)
    ```


    :param _builtins.str description: Specifies the supplementary information about the load balancer.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project id of the load balancer.
    :param _builtins.str id: Specifies the data source ID of the load balancer in UUID format.
    :param _builtins.str name: Specifies the name of the load balancer.
    :param _builtins.str region: Specifies the region in which to obtain the load balancer. If omitted, the
           provider-level region will be used.
    :param _builtins.str status: Specifies the operating status of the load balancer. Valid values are *ONLINE* and
           *FROZEN*.
    :param _builtins.str vip_address: Specifies the private IP address of the load balancer.
    :param _builtins.str vip_subnet_id: Specifies the **IPv4 subnet ID** of the subnet where the load balancer works.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    __args__['vipAddress'] = vip_address
    __args__['vipSubnetId'] = vip_subnet_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Elb/getLoadbalancer:getLoadbalancer', __args__, opts=opts, typ=GetLoadbalancerResult)
    return __ret__.apply(lambda __response__: GetLoadbalancerResult(
        description=pulumi.get(__response__, 'description'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        public_ip=pulumi.get(__response__, 'public_ip'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        vip_address=pulumi.get(__response__, 'vip_address'),
        vip_port_id=pulumi.get(__response__, 'vip_port_id'),
        vip_subnet_id=pulumi.get(__response__, 'vip_subnet_id')))
