# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['L7ruleArgs', 'L7rule']

@pulumi.input_type
class L7ruleArgs:
    def __init__(__self__, *,
                 compare_type: pulumi.Input[_builtins.str],
                 l7policy_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str],
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a L7rule resource.
        :param pulumi.Input[_builtins.str] compare_type: The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        :param pulumi.Input[_builtins.str] l7policy_id: The ID of the L7 Policy to query. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] type: The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
               L7 Rule.
        :param pulumi.Input[_builtins.str] value: The value to use for the comparison. For example, the file type to compare.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the L7 Rule. The value can only be true (UP).
        :param pulumi.Input[_builtins.str] key: The key to use for the comparison. For example, the name of the cookie to
               evaluate. Valid when `type` is set to COOKIE or HEADER. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the L7 Rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Rule.
        """
        pulumi.set(__self__, "compare_type", compare_type)
        pulumi.set(__self__, "l7policy_id", l7policy_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tenant_id is not None:
            warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="compareType")
    def compare_type(self) -> pulumi.Input[_builtins.str]:
        """
        The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        """
        return pulumi.get(self, "compare_type")

    @compare_type.setter
    def compare_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compare_type", value)

    @_builtins.property
    @pulumi.getter(name="l7policyId")
    def l7policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the L7 Policy to query. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "l7policy_id")

    @l7policy_id.setter
    def l7policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "l7policy_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
        L7 Rule.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The value to use for the comparison. For example, the file type to compare.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The administrative state of the L7 Rule. The value can only be true (UP).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_state_up", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for the comparison. For example, the name of the cookie to
        evaluate. Valid when `type` is set to COOKIE or HEADER. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the L7 Rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""tenant_id is deprecated""")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _L7ruleState:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 compare_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 l7policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering L7rule resources.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the L7 Rule. The value can only be true (UP).
        :param pulumi.Input[_builtins.str] compare_type: The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        :param pulumi.Input[_builtins.str] key: The key to use for the comparison. For example, the name of the cookie to
               evaluate. Valid when `type` is set to COOKIE or HEADER. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] l7policy_id: The ID of the L7 Policy to query. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the Listener owning this resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the L7 Rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] type: The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
               L7 Rule.
        :param pulumi.Input[_builtins.str] value: The value to use for the comparison. For example, the file type to compare.
        """
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if compare_type is not None:
            pulumi.set(__self__, "compare_type", compare_type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if l7policy_id is not None:
            pulumi.set(__self__, "l7policy_id", l7policy_id)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tenant_id is not None:
            warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The administrative state of the L7 Rule. The value can only be true (UP).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_state_up", value)

    @_builtins.property
    @pulumi.getter(name="compareType")
    def compare_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        """
        return pulumi.get(self, "compare_type")

    @compare_type.setter
    def compare_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compare_type", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for the comparison. For example, the name of the cookie to
        evaluate. Valid when `type` is set to COOKIE or HEADER. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="l7policyId")
    def l7policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the L7 Policy to query. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "l7policy_id")

    @l7policy_id.setter
    def l7policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "l7policy_id", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Listener owning this resource.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the L7 Rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""tenant_id is deprecated""")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
        L7 Rule.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value to use for the comparison. For example, the file type to compare.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("sbercloud:Elb/l7rule:L7rule")
class L7rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 compare_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 l7policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an ELB L7 Rule resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        loadbalancer1 = sbercloud.elb.Loadbalancer("loadbalancer_1",
            name="loadbalancer_1",
            vip_subnet_id=subnet_id)
        listener1 = sbercloud.elb.Listener("listener_1",
            name="listener_1",
            protocol="HTTP",
            protocol_port=8080,
            loadbalancer_id=loadbalancer1.id)
        pool1 = sbercloud.elb.Pool("pool_1",
            name="pool_1",
            protocol="HTTP",
            lb_method="ROUND_ROBIN",
            loadbalancer_id=loadbalancer1.id)
        l7policy1 = sbercloud.elb.L7policy("l7policy_1",
            name="test",
            action="REDIRECT_TO_POOL",
            description="test l7 policy",
            position=1,
            listener_id=listener1.id,
            redirect_pool_id=pool1.id)
        l7rule1 = sbercloud.elb.L7rule("l7rule_1",
            l7policy_id=l7policy1.id,
            type="PATH",
            compare_type="EQUAL_TO",
            value="/api")
        ```

        ## Import

        Load Balancer L7 Rule can be imported using the L7 Policy ID and L7 Rule ID separated by a slash, e.g.:

        ```sh
        $ pulumi import sbercloud:Elb/l7rule:L7rule l7rule_1 e0bd694a-abbe-450e-b329-0931fd1cc5eb/4086b0c9-b18c-4d1c-b6b8-4c56c3ad2a9e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the L7 Rule. The value can only be true (UP).
        :param pulumi.Input[_builtins.str] compare_type: The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        :param pulumi.Input[_builtins.str] key: The key to use for the comparison. For example, the name of the cookie to
               evaluate. Valid when `type` is set to COOKIE or HEADER. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] l7policy_id: The ID of the L7 Policy to query. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the L7 Rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] type: The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
               L7 Rule.
        :param pulumi.Input[_builtins.str] value: The value to use for the comparison. For example, the file type to compare.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: L7ruleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB L7 Rule resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        loadbalancer1 = sbercloud.elb.Loadbalancer("loadbalancer_1",
            name="loadbalancer_1",
            vip_subnet_id=subnet_id)
        listener1 = sbercloud.elb.Listener("listener_1",
            name="listener_1",
            protocol="HTTP",
            protocol_port=8080,
            loadbalancer_id=loadbalancer1.id)
        pool1 = sbercloud.elb.Pool("pool_1",
            name="pool_1",
            protocol="HTTP",
            lb_method="ROUND_ROBIN",
            loadbalancer_id=loadbalancer1.id)
        l7policy1 = sbercloud.elb.L7policy("l7policy_1",
            name="test",
            action="REDIRECT_TO_POOL",
            description="test l7 policy",
            position=1,
            listener_id=listener1.id,
            redirect_pool_id=pool1.id)
        l7rule1 = sbercloud.elb.L7rule("l7rule_1",
            l7policy_id=l7policy1.id,
            type="PATH",
            compare_type="EQUAL_TO",
            value="/api")
        ```

        ## Import

        Load Balancer L7 Rule can be imported using the L7 Policy ID and L7 Rule ID separated by a slash, e.g.:

        ```sh
        $ pulumi import sbercloud:Elb/l7rule:L7rule l7rule_1 e0bd694a-abbe-450e-b329-0931fd1cc5eb/4086b0c9-b18c-4d1c-b6b8-4c56c3ad2a9e
        ```

        :param str resource_name: The name of the resource.
        :param L7ruleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(L7ruleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 compare_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 l7policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = L7ruleArgs.__new__(L7ruleArgs)

            __props__.__dict__["admin_state_up"] = admin_state_up
            if compare_type is None and not opts.urn:
                raise TypeError("Missing required property 'compare_type'")
            __props__.__dict__["compare_type"] = compare_type
            __props__.__dict__["key"] = key
            if l7policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'l7policy_id'")
            __props__.__dict__["l7policy_id"] = l7policy_id
            __props__.__dict__["region"] = region
            __props__.__dict__["tenant_id"] = tenant_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            __props__.__dict__["listener_id"] = None
        super(L7rule, __self__).__init__(
            'sbercloud:Elb/l7rule:L7rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
            compare_type: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            l7policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'L7rule':
        """
        Get an existing L7rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the L7 Rule. The value can only be true (UP).
        :param pulumi.Input[_builtins.str] compare_type: The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        :param pulumi.Input[_builtins.str] key: The key to use for the comparison. For example, the name of the cookie to
               evaluate. Valid when `type` is set to COOKIE or HEADER. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] l7policy_id: The ID of the L7 Policy to query. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the Listener owning this resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the L7 Rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] type: The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
               L7 Rule.
        :param pulumi.Input[_builtins.str] value: The value to use for the comparison. For example, the file type to compare.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _L7ruleState.__new__(_L7ruleState)

        __props__.__dict__["admin_state_up"] = admin_state_up
        __props__.__dict__["compare_type"] = compare_type
        __props__.__dict__["key"] = key
        __props__.__dict__["l7policy_id"] = l7policy_id
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["region"] = region
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["type"] = type
        __props__.__dict__["value"] = value
        return L7rule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The administrative state of the L7 Rule. The value can only be true (UP).
        """
        return pulumi.get(self, "admin_state_up")

    @_builtins.property
    @pulumi.getter(name="compareType")
    def compare_type(self) -> pulumi.Output[_builtins.str]:
        """
        The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        """
        return pulumi.get(self, "compare_type")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key to use for the comparison. For example, the name of the cookie to
        evaluate. Valid when `type` is set to COOKIE or HEADER. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="l7policyId")
    def l7policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the L7 Policy to query. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "l7policy_id")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Listener owning this resource.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the L7 Rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""tenant_id is deprecated""")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
        L7 Rule.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        The value to use for the comparison. For example, the file type to compare.
        """
        return pulumi.get(self, "value")

