# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 loadbalancer_id: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 protocol_port: pulumi.Input[_builtins.int],
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_ca_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 http2_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 insert_headers: Optional[pulumi.Input['ListenerInsertHeadersArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_ciphers_policy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.str] protocol: The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the listener. A valid value is true (UP) or false (
               DOWN).
        :param pulumi.Input[_builtins.int] connection_limit: The maximum number of connections allowed for the listener. The value ranges from
               -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
               number of connections.
        :param pulumi.Input[_builtins.str] default_pool_id: The ID of the default pool with which the listener is associated.
               Changing this creates a new listener.
        :param pulumi.Input[_builtins.str] default_tls_container_ref: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the listener.
        :param pulumi.Input[_builtins.bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the listener. Does not have to be unique.
        :param pulumi.Input[_builtins.str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sni_container_refs: Lists the IDs of SNI certificates (server certificates with a domain name)
               used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the listener.
        """
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "protocol_port", protocol_port)
        if admin_state_up is not None:
            warnings.warn("""admin_state_up is deprecated""", DeprecationWarning)
            pulumi.log.warn("""admin_state_up is deprecated: admin_state_up is deprecated""")
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if client_ca_tls_container_ref is not None:
            pulumi.set(__self__, "client_ca_tls_container_ref", client_ca_tls_container_ref)
        if connection_limit is not None:
            warnings.warn("""connection_limit is deprecated""", DeprecationWarning)
            pulumi.log.warn("""connection_limit is deprecated: connection_limit is deprecated""")
        if connection_limit is not None:
            pulumi.set(__self__, "connection_limit", connection_limit)
        if default_pool_id is not None:
            pulumi.set(__self__, "default_pool_id", default_pool_id)
        if default_tls_container_ref is not None:
            pulumi.set(__self__, "default_tls_container_ref", default_tls_container_ref)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if http2_enable is not None:
            pulumi.set(__self__, "http2_enable", http2_enable)
        if insert_headers is not None:
            pulumi.set(__self__, "insert_headers", insert_headers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protection_reason is not None:
            pulumi.set(__self__, "protection_reason", protection_reason)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sni_container_refs is not None:
            pulumi.set(__self__, "sni_container_refs", sni_container_refs)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if tls_ciphers_policy is not None:
            pulumi.set(__self__, "tls_ciphers_policy", tls_ciphers_policy)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The load balancer on which to provision this listener. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> pulumi.Input[_builtins.int]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol_port")

    @protocol_port.setter
    def protocol_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "protocol_port", value)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    @_utilities.deprecated("""admin_state_up is deprecated""")
    def admin_state_up(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The administrative state of the listener. A valid value is true (UP) or false (
        DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_state_up", value)

    @_builtins.property
    @pulumi.getter(name="clientCaTlsContainerRef")
    def client_ca_tls_container_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "client_ca_tls_container_ref")

    @client_ca_tls_container_ref.setter
    def client_ca_tls_container_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_ca_tls_container_ref", value)

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    @_utilities.deprecated("""connection_limit is deprecated""")
    def connection_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of connections allowed for the listener. The value ranges from
        -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
        number of connections.
        """
        return pulumi.get(self, "connection_limit")

    @connection_limit.setter
    def connection_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_limit", value)

    @_builtins.property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the default pool with which the listener is associated.
        Changing this creates a new listener.
        """
        return pulumi.get(self, "default_pool_id")

    @default_pool_id.setter
    def default_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultTlsContainerRef")
    def default_tls_container_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the server certificate used by the listener. This
        parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "default_tls_container_ref")

    @default_tls_container_ref.setter
    def default_tls_container_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_tls_container_ref", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use HTTP/2. The default value is false. This parameter is valid
        only when the protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "http2_enable")

    @http2_enable.setter
    def http2_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "http2_enable", value)

    @_builtins.property
    @pulumi.getter(name="insertHeaders")
    def insert_headers(self) -> Optional[pulumi.Input['ListenerInsertHeadersArgs']]:
        return pulumi.get(self, "insert_headers")

    @insert_headers.setter
    def insert_headers(self, value: Optional[pulumi.Input['ListenerInsertHeadersArgs']]):
        pulumi.set(self, "insert_headers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the listener. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @protection_reason.setter
    def protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_status", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the listener resource. If omitted, the
        provider-level region will be used. Changing this creates a new listener.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sniContainerRefs")
    def sni_container_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Lists the IDs of SNI certificates (server certificates with a domain name)
        used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "sni_container_refs")

    @sni_container_refs.setter
    def sni_container_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sni_container_refs", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the listener.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""tenant_id is deprecated""")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="tlsCiphersPolicy")
    def tls_ciphers_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tls_ciphers_policy")

    @tls_ciphers_policy.setter
    def tls_ciphers_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_ciphers_policy", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_ca_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 http2_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 insert_headers: Optional[pulumi.Input['ListenerInsertHeadersArgs']] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_ciphers_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the listener. A valid value is true (UP) or false (
               DOWN).
        :param pulumi.Input[_builtins.int] connection_limit: The maximum number of connections allowed for the listener. The value ranges from
               -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
               number of connections.
        :param pulumi.Input[_builtins.str] default_pool_id: The ID of the default pool with which the listener is associated.
               Changing this creates a new listener.
        :param pulumi.Input[_builtins.str] default_tls_container_ref: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the listener.
        :param pulumi.Input[_builtins.bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the listener. Does not have to be unique.
        :param pulumi.Input[_builtins.str] protocol: The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[_builtins.str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sni_container_refs: Lists the IDs of SNI certificates (server certificates with a domain name)
               used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the listener.
        """
        if admin_state_up is not None:
            warnings.warn("""admin_state_up is deprecated""", DeprecationWarning)
            pulumi.log.warn("""admin_state_up is deprecated: admin_state_up is deprecated""")
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if client_ca_tls_container_ref is not None:
            pulumi.set(__self__, "client_ca_tls_container_ref", client_ca_tls_container_ref)
        if connection_limit is not None:
            warnings.warn("""connection_limit is deprecated""", DeprecationWarning)
            pulumi.log.warn("""connection_limit is deprecated: connection_limit is deprecated""")
        if connection_limit is not None:
            pulumi.set(__self__, "connection_limit", connection_limit)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if default_pool_id is not None:
            pulumi.set(__self__, "default_pool_id", default_pool_id)
        if default_tls_container_ref is not None:
            pulumi.set(__self__, "default_tls_container_ref", default_tls_container_ref)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if http2_enable is not None:
            pulumi.set(__self__, "http2_enable", http2_enable)
        if insert_headers is not None:
            pulumi.set(__self__, "insert_headers", insert_headers)
        if loadbalancer_id is not None:
            pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protection_reason is not None:
            pulumi.set(__self__, "protection_reason", protection_reason)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_port is not None:
            pulumi.set(__self__, "protocol_port", protocol_port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sni_container_refs is not None:
            pulumi.set(__self__, "sni_container_refs", sni_container_refs)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if tls_ciphers_policy is not None:
            pulumi.set(__self__, "tls_ciphers_policy", tls_ciphers_policy)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    @_utilities.deprecated("""admin_state_up is deprecated""")
    def admin_state_up(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The administrative state of the listener. A valid value is true (UP) or false (
        DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_state_up", value)

    @_builtins.property
    @pulumi.getter(name="clientCaTlsContainerRef")
    def client_ca_tls_container_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "client_ca_tls_container_ref")

    @client_ca_tls_container_ref.setter
    def client_ca_tls_container_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_ca_tls_container_ref", value)

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    @_utilities.deprecated("""connection_limit is deprecated""")
    def connection_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of connections allowed for the listener. The value ranges from
        -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
        number of connections.
        """
        return pulumi.get(self, "connection_limit")

    @connection_limit.setter
    def connection_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_limit", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the default pool with which the listener is associated.
        Changing this creates a new listener.
        """
        return pulumi.get(self, "default_pool_id")

    @default_pool_id.setter
    def default_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultTlsContainerRef")
    def default_tls_container_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the server certificate used by the listener. This
        parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "default_tls_container_ref")

    @default_tls_container_ref.setter
    def default_tls_container_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_tls_container_ref", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use HTTP/2. The default value is false. This parameter is valid
        only when the protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "http2_enable")

    @http2_enable.setter
    def http2_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "http2_enable", value)

    @_builtins.property
    @pulumi.getter(name="insertHeaders")
    def insert_headers(self) -> Optional[pulumi.Input['ListenerInsertHeadersArgs']]:
        return pulumi.get(self, "insert_headers")

    @insert_headers.setter
    def insert_headers(self, value: Optional[pulumi.Input['ListenerInsertHeadersArgs']]):
        pulumi.set(self, "insert_headers", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load balancer on which to provision this listener. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the listener. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @protection_reason.setter
    def protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_status", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol_port")

    @protocol_port.setter
    def protocol_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "protocol_port", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the listener resource. If omitted, the
        provider-level region will be used. Changing this creates a new listener.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sniContainerRefs")
    def sni_container_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Lists the IDs of SNI certificates (server certificates with a domain name)
        used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "sni_container_refs")

    @sni_container_refs.setter
    def sni_container_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sni_container_refs", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the listener.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""tenant_id is deprecated""")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="tlsCiphersPolicy")
    def tls_ciphers_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tls_ciphers_policy")

    @tls_ciphers_policy.setter
    def tls_ciphers_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_ciphers_policy", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:Elb/listener:Listener")
class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_ca_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 http2_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 insert_headers: Optional[pulumi.Input[Union['ListenerInsertHeadersArgs', 'ListenerInsertHeadersArgsDict']]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_ciphers_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an ELB listener resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        listener1 = sbercloud.elb.Listener("listener_1",
            protocol="HTTP",
            protocol_port=8080,
            loadbalancer_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        ```

        ## Import

        ELB listener can be imported using the listener ID, e.g.

        ```sh
        $ pulumi import sbercloud:Elb/listener:Listener listener_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the listener. A valid value is true (UP) or false (
               DOWN).
        :param pulumi.Input[_builtins.int] connection_limit: The maximum number of connections allowed for the listener. The value ranges from
               -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
               number of connections.
        :param pulumi.Input[_builtins.str] default_pool_id: The ID of the default pool with which the listener is associated.
               Changing this creates a new listener.
        :param pulumi.Input[_builtins.str] default_tls_container_ref: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the listener.
        :param pulumi.Input[_builtins.bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the listener. Does not have to be unique.
        :param pulumi.Input[_builtins.str] protocol: The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[_builtins.str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sni_container_refs: Lists the IDs of SNI certificates (server certificates with a domain name)
               used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the listener.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB listener resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        listener1 = sbercloud.elb.Listener("listener_1",
            protocol="HTTP",
            protocol_port=8080,
            loadbalancer_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        ```

        ## Import

        ELB listener can be imported using the listener ID, e.g.

        ```sh
        $ pulumi import sbercloud:Elb/listener:Listener listener_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_ca_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 http2_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 insert_headers: Optional[pulumi.Input[Union['ListenerInsertHeadersArgs', 'ListenerInsertHeadersArgsDict']]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_ciphers_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["admin_state_up"] = admin_state_up
            __props__.__dict__["client_ca_tls_container_ref"] = client_ca_tls_container_ref
            __props__.__dict__["connection_limit"] = connection_limit
            __props__.__dict__["default_pool_id"] = default_pool_id
            __props__.__dict__["default_tls_container_ref"] = default_tls_container_ref
            __props__.__dict__["description"] = description
            __props__.__dict__["http2_enable"] = http2_enable
            __props__.__dict__["insert_headers"] = insert_headers
            if loadbalancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'loadbalancer_id'")
            __props__.__dict__["loadbalancer_id"] = loadbalancer_id
            __props__.__dict__["name"] = name
            __props__.__dict__["protection_reason"] = protection_reason
            __props__.__dict__["protection_status"] = protection_status
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if protocol_port is None and not opts.urn:
                raise TypeError("Missing required property 'protocol_port'")
            __props__.__dict__["protocol_port"] = protocol_port
            __props__.__dict__["region"] = region
            __props__.__dict__["sni_container_refs"] = sni_container_refs
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["tls_ciphers_policy"] = tls_ciphers_policy
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(Listener, __self__).__init__(
            'sbercloud:Elb/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
            client_ca_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
            connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            http2_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            insert_headers: Optional[pulumi.Input[Union['ListenerInsertHeadersArgs', 'ListenerInsertHeadersArgsDict']]] = None,
            loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
            protection_status: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            tls_ciphers_policy: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the listener. A valid value is true (UP) or false (
               DOWN).
        :param pulumi.Input[_builtins.int] connection_limit: The maximum number of connections allowed for the listener. The value ranges from
               -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
               number of connections.
        :param pulumi.Input[_builtins.str] default_pool_id: The ID of the default pool with which the listener is associated.
               Changing this creates a new listener.
        :param pulumi.Input[_builtins.str] default_tls_container_ref: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the listener.
        :param pulumi.Input[_builtins.bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the listener. Does not have to be unique.
        :param pulumi.Input[_builtins.str] protocol: The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[_builtins.str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sni_container_refs: Lists the IDs of SNI certificates (server certificates with a domain name)
               used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the listener.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["admin_state_up"] = admin_state_up
        __props__.__dict__["client_ca_tls_container_ref"] = client_ca_tls_container_ref
        __props__.__dict__["connection_limit"] = connection_limit
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["default_pool_id"] = default_pool_id
        __props__.__dict__["default_tls_container_ref"] = default_tls_container_ref
        __props__.__dict__["description"] = description
        __props__.__dict__["http2_enable"] = http2_enable
        __props__.__dict__["insert_headers"] = insert_headers
        __props__.__dict__["loadbalancer_id"] = loadbalancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["protection_reason"] = protection_reason
        __props__.__dict__["protection_status"] = protection_status
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["protocol_port"] = protocol_port
        __props__.__dict__["region"] = region
        __props__.__dict__["sni_container_refs"] = sni_container_refs
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["tls_ciphers_policy"] = tls_ciphers_policy
        __props__.__dict__["updated_at"] = updated_at
        return Listener(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    @_utilities.deprecated("""admin_state_up is deprecated""")
    def admin_state_up(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The administrative state of the listener. A valid value is true (UP) or false (
        DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @_builtins.property
    @pulumi.getter(name="clientCaTlsContainerRef")
    def client_ca_tls_container_ref(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "client_ca_tls_container_ref")

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    @_utilities.deprecated("""connection_limit is deprecated""")
    def connection_limit(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of connections allowed for the listener. The value ranges from
        -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
        number of connections.
        """
        return pulumi.get(self, "connection_limit")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the default pool with which the listener is associated.
        Changing this creates a new listener.
        """
        return pulumi.get(self, "default_pool_id")

    @_builtins.property
    @pulumi.getter(name="defaultTlsContainerRef")
    def default_tls_container_ref(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the server certificate used by the listener. This
        parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "default_tls_container_ref")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable description for the listener.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to use HTTP/2. The default value is false. This parameter is valid
        only when the protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "http2_enable")

    @_builtins.property
    @pulumi.getter(name="insertHeaders")
    def insert_headers(self) -> pulumi.Output['outputs.ListenerInsertHeaders']:
        return pulumi.get(self, "insert_headers")

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The load balancer on which to provision this listener. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable name for the listener. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "protection_status")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> pulumi.Output[_builtins.int]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol_port")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the listener resource. If omitted, the
        provider-level region will be used. Changing this creates a new listener.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sniContainerRefs")
    def sni_container_refs(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Lists the IDs of SNI certificates (server certificates with a domain name)
        used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "sni_container_refs")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the listener.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""tenant_id is deprecated""")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="tlsCiphersPolicy")
    def tls_ciphers_policy(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tls_ciphers_policy")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

