# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LoadbalancerArgs', 'Loadbalancer']

@pulumi.input_type
class LoadbalancerArgs:
    def __init__(__self__, *,
                 vip_subnet_id: pulumi.Input[_builtins.str],
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vip_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Loadbalancer resource.
        :param pulumi.Input[_builtins.str] vip_subnet_id: The network on which to allocate the loadbalancer's address. A tenant
               can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
               shared). Changing this creates a new loadbalancer.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the loadbalancer. A valid value is true (UP) or
               false (DOWN).
        :param pulumi.Input[_builtins.str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[_builtins.str] flavor: schema: Deprecated
        :param pulumi.Input[_builtins.str] loadbalancer_provider: schema: Deprecated
        :param pulumi.Input[_builtins.str] name: Human-readable name for the loadbalancer. Does not have to be unique.
        :param pulumi.Input[_builtins.str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: schema: Deprecated
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[_builtins.str] vip_address: The ip address of the load balancer. Changing this creates a new
               loadbalancer.
        """
        pulumi.set(__self__, "vip_subnet_id", vip_subnet_id)
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if loadbalancer_provider is not None:
            pulumi.set(__self__, "loadbalancer_provider", loadbalancer_provider)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if protection_reason is not None:
            pulumi.set(__self__, "protection_reason", protection_reason)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if vip_address is not None:
            pulumi.set(__self__, "vip_address", vip_address)

    @_builtins.property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The network on which to allocate the loadbalancer's address. A tenant
        can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
        shared). Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "vip_subnet_id")

    @vip_subnet_id.setter
    def vip_subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vip_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The administrative state of the loadbalancer. A valid value is true (UP) or
        false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_state_up", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the loadbalancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the loadbalancer. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerProvider")
    def loadbalancer_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "loadbalancer_provider")

    @loadbalancer_provider.setter
    def loadbalancer_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_provider", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the loadbalancer. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @protection_reason.setter
    def protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_status", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the loadbalancer resource. If omitted, the
        provider-level region will be used. Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the loadbalancer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""tenant_id is deprecated""")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ip address of the load balancer. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "vip_address")

    @vip_address.setter
    def vip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vip_address", value)


@pulumi.input_type
class _LoadbalancerState:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 frozen_scene: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 vip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 vip_port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vip_subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Loadbalancer resources.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the loadbalancer. A valid value is true (UP) or
               false (DOWN).
        :param pulumi.Input[_builtins.str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[_builtins.str] flavor: schema: Deprecated
        :param pulumi.Input[_builtins.str] loadbalancer_provider: schema: Deprecated
        :param pulumi.Input[_builtins.str] name: Human-readable name for the loadbalancer. Does not have to be unique.
        :param pulumi.Input[_builtins.str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: schema: Deprecated
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[_builtins.str] vip_address: The ip address of the load balancer. Changing this creates a new
               loadbalancer.
        :param pulumi.Input[_builtins.str] vip_port_id: The Port ID of the Load Balancer IP.
        :param pulumi.Input[_builtins.str] vip_subnet_id: The network on which to allocate the loadbalancer's address. A tenant
               can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
               shared). Changing this creates a new loadbalancer.
        """
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if frozen_scene is not None:
            pulumi.set(__self__, "frozen_scene", frozen_scene)
        if loadbalancer_provider is not None:
            pulumi.set(__self__, "loadbalancer_provider", loadbalancer_provider)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if protection_reason is not None:
            pulumi.set(__self__, "protection_reason", protection_reason)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vip_address is not None:
            pulumi.set(__self__, "vip_address", vip_address)
        if vip_port_id is not None:
            pulumi.set(__self__, "vip_port_id", vip_port_id)
        if vip_subnet_id is not None:
            pulumi.set(__self__, "vip_subnet_id", vip_subnet_id)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The administrative state of the loadbalancer. A valid value is true (UP) or
        false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_state_up", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charge_mode")

    @charge_mode.setter
    def charge_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_mode", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the loadbalancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the loadbalancer. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="frozenScene")
    def frozen_scene(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "frozen_scene")

    @frozen_scene.setter
    def frozen_scene(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frozen_scene", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerProvider")
    def loadbalancer_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "loadbalancer_provider")

    @loadbalancer_provider.setter
    def loadbalancer_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_provider", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the loadbalancer. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @protection_reason.setter
    def protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_status", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the loadbalancer resource. If omitted, the
        provider-level region will be used. Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the loadbalancer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""tenant_id is deprecated""")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ip address of the load balancer. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "vip_address")

    @vip_address.setter
    def vip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vip_address", value)

    @_builtins.property
    @pulumi.getter(name="vipPortId")
    def vip_port_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Port ID of the Load Balancer IP.
        """
        return pulumi.get(self, "vip_port_id")

    @vip_port_id.setter
    def vip_port_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vip_port_id", value)

    @_builtins.property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network on which to allocate the loadbalancer's address. A tenant
        can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
        shared). Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "vip_subnet_id")

    @vip_subnet_id.setter
    def vip_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vip_subnet_id", value)


@pulumi.type_token("sbercloud:Elb/loadbalancer:Loadbalancer")
class Loadbalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 vip_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an ELB loadbalancer resource within SberCloud.

        ## Example Usage

        ### Basic Loadbalancer

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        lb1 = sbercloud.elb.Loadbalancer("lb_1", vip_subnet_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        ```

        ### Loadbalancer With EIP

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        lb1 = sbercloud.elb.Loadbalancer("lb_1", vip_subnet_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        eip1 = sbercloud.NetworkingEipAssociate("eip_1",
            public_ip="1.2.3.4",
            port_id=lb1.vip_port_id)
        ```

        ## Import

        Load balancers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Elb/loadbalancer:Loadbalancer test 3e3632db-36c6-4b28-a92e-e72e6562daa6
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the loadbalancer. A valid value is true (UP) or
               false (DOWN).
        :param pulumi.Input[_builtins.str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[_builtins.str] flavor: schema: Deprecated
        :param pulumi.Input[_builtins.str] loadbalancer_provider: schema: Deprecated
        :param pulumi.Input[_builtins.str] name: Human-readable name for the loadbalancer. Does not have to be unique.
        :param pulumi.Input[_builtins.str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: schema: Deprecated
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[_builtins.str] vip_address: The ip address of the load balancer. Changing this creates a new
               loadbalancer.
        :param pulumi.Input[_builtins.str] vip_subnet_id: The network on which to allocate the loadbalancer's address. A tenant
               can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
               shared). Changing this creates a new loadbalancer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB loadbalancer resource within SberCloud.

        ## Example Usage

        ### Basic Loadbalancer

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        lb1 = sbercloud.elb.Loadbalancer("lb_1", vip_subnet_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        ```

        ### Loadbalancer With EIP

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        lb1 = sbercloud.elb.Loadbalancer("lb_1", vip_subnet_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        eip1 = sbercloud.NetworkingEipAssociate("eip_1",
            public_ip="1.2.3.4",
            port_id=lb1.vip_port_id)
        ```

        ## Import

        Load balancers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Elb/loadbalancer:Loadbalancer test 3e3632db-36c6-4b28-a92e-e72e6562daa6
        ```

        :param str resource_name: The name of the resource.
        :param LoadbalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 vip_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerArgs.__new__(LoadbalancerArgs)

            __props__.__dict__["admin_state_up"] = admin_state_up
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["loadbalancer_provider"] = loadbalancer_provider
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["protection_reason"] = protection_reason
            __props__.__dict__["protection_status"] = protection_status
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["vip_address"] = vip_address
            if vip_subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'vip_subnet_id'")
            __props__.__dict__["vip_subnet_id"] = vip_subnet_id
            __props__.__dict__["charge_mode"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["frozen_scene"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["vip_port_id"] = None
        super(Loadbalancer, __self__).__init__(
            'sbercloud:Elb/loadbalancer:Loadbalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            flavor: Optional[pulumi.Input[_builtins.str]] = None,
            frozen_scene: Optional[pulumi.Input[_builtins.str]] = None,
            loadbalancer_provider: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
            protection_status: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            vip_address: Optional[pulumi.Input[_builtins.str]] = None,
            vip_port_id: Optional[pulumi.Input[_builtins.str]] = None,
            vip_subnet_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Loadbalancer':
        """
        Get an existing Loadbalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the loadbalancer. A valid value is true (UP) or
               false (DOWN).
        :param pulumi.Input[_builtins.str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[_builtins.str] flavor: schema: Deprecated
        :param pulumi.Input[_builtins.str] loadbalancer_provider: schema: Deprecated
        :param pulumi.Input[_builtins.str] name: Human-readable name for the loadbalancer. Does not have to be unique.
        :param pulumi.Input[_builtins.str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: schema: Deprecated
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[_builtins.str] vip_address: The ip address of the load balancer. Changing this creates a new
               loadbalancer.
        :param pulumi.Input[_builtins.str] vip_port_id: The Port ID of the Load Balancer IP.
        :param pulumi.Input[_builtins.str] vip_subnet_id: The network on which to allocate the loadbalancer's address. A tenant
               can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
               shared). Changing this creates a new loadbalancer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerState.__new__(_LoadbalancerState)

        __props__.__dict__["admin_state_up"] = admin_state_up
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["charge_mode"] = charge_mode
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["frozen_scene"] = frozen_scene
        __props__.__dict__["loadbalancer_provider"] = loadbalancer_provider
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["protection_reason"] = protection_reason
        __props__.__dict__["protection_status"] = protection_status
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["vip_address"] = vip_address
        __props__.__dict__["vip_port_id"] = vip_port_id
        __props__.__dict__["vip_subnet_id"] = vip_subnet_id
        return Loadbalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The administrative state of the loadbalancer. A valid value is true (UP) or
        false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "charge_mode")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable description for the loadbalancer.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project id of the loadbalancer. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="frozenScene")
    def frozen_scene(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "frozen_scene")

    @_builtins.property
    @pulumi.getter(name="loadbalancerProvider")
    def loadbalancer_provider(self) -> pulumi.Output[_builtins.str]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "loadbalancer_provider")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable name for the loadbalancer. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "protection_status")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the loadbalancer resource. If omitted, the
        provider-level region will be used. Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the loadbalancer.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""tenant_id is deprecated""")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The ip address of the load balancer. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "vip_address")

    @_builtins.property
    @pulumi.getter(name="vipPortId")
    def vip_port_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Port ID of the Load Balancer IP.
        """
        return pulumi.get(self, "vip_port_id")

    @_builtins.property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The network on which to allocate the loadbalancer's address. A tenant
        can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
        shared). Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "vip_subnet_id")

