# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ListenerInsertHeaders',
    'PoolPersistence',
    'GetListenersListenerResult',
    'GetListenersListenerInsertHeaderResult',
    'GetListenersListenerLoadbalancerResult',
    'GetPoolsPoolResult',
    'GetPoolsPoolListenerResult',
    'GetPoolsPoolLoadbalancerResult',
    'GetPoolsPoolMemberResult',
    'GetPoolsPoolPersistenceResult',
]

@pulumi.output_type
class ListenerInsertHeaders(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "xForwardedElbIp":
            suggest = "x_forwarded_elb_ip"
        elif key == "xForwardedHost":
            suggest = "x_forwarded_host"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerInsertHeaders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerInsertHeaders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerInsertHeaders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 x_forwarded_elb_ip: Optional[_builtins.str] = None,
                 x_forwarded_host: Optional[_builtins.str] = None):
        if x_forwarded_elb_ip is not None:
            pulumi.set(__self__, "x_forwarded_elb_ip", x_forwarded_elb_ip)
        if x_forwarded_host is not None:
            pulumi.set(__self__, "x_forwarded_host", x_forwarded_host)

    @_builtins.property
    @pulumi.getter(name="xForwardedElbIp")
    def x_forwarded_elb_ip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "x_forwarded_elb_ip")

    @_builtins.property
    @pulumi.getter(name="xForwardedHost")
    def x_forwarded_host(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "x_forwarded_host")


@pulumi.output_type
class PoolPersistence(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieName":
            suggest = "cookie_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolPersistence. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolPersistence.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolPersistence.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 cookie_name: Optional[_builtins.str] = None,
                 timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.str type: The type of persistence mode. The current specification supports SOURCE_IP,
               HTTP_COOKIE, and APP_COOKIE.
        :param _builtins.str cookie_name: The name of the cookie if persistence mode is set appropriately. Required
               if `type = APP_COOKIE`.
        :param _builtins.int timeout: Specifies the sticky session timeout duration in minutes. This parameter is
               invalid when type is set to APP_COOKIE. The value range varies depending on the protocol of the backend server group:
               + When the protocol of the backend server group is TCP or UDP, the value ranges from 1 to 60.
               + When the protocol of the backend server group is HTTP or HTTPS, the value ranges from 1 to 1440.
        """
        pulumi.set(__self__, "type", type)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of persistence mode. The current specification supports SOURCE_IP,
        HTTP_COOKIE, and APP_COOKIE.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[_builtins.str]:
        """
        The name of the cookie if persistence mode is set appropriately. Required
        if `type = APP_COOKIE`.
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        Specifies the sticky session timeout duration in minutes. This parameter is
        invalid when type is set to APP_COOKIE. The value range varies depending on the protocol of the backend server group:
        + When the protocol of the backend server group is TCP or UDP, the value ranges from 1 to 60.
        + When the protocol of the backend server group is HTTP or HTTPS, the value ranges from 1 to 1440.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class GetListenersListenerResult(dict):
    def __init__(__self__, *,
                 client_ca_tls_container_ref: _builtins.str,
                 connection_limit: _builtins.int,
                 created_at: _builtins.str,
                 default_pool_id: _builtins.str,
                 default_tls_container_ref: _builtins.str,
                 description: _builtins.str,
                 http2_enable: _builtins.bool,
                 id: _builtins.str,
                 insert_headers: Sequence['outputs.GetListenersListenerInsertHeaderResult'],
                 loadbalancers: Sequence['outputs.GetListenersListenerLoadbalancerResult'],
                 name: _builtins.str,
                 protection_reason: _builtins.str,
                 protection_status: _builtins.str,
                 protocol: _builtins.str,
                 protocol_port: _builtins.int,
                 sni_container_refs: Sequence[_builtins.str],
                 tags: Mapping[str, _builtins.str],
                 tls_ciphers_policy: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.int connection_limit: The maximum number of connections allowed for the listener.
        :param _builtins.str default_pool_id: The ID of the default pool with which the ELB listener is associated.
        :param _builtins.str default_tls_container_ref: The ID of the server certificate used by the listener.
        :param _builtins.str description: The description of the ELB listener.
        :param _builtins.bool http2_enable: Whether the ELB listener uses HTTP/2.
        :param _builtins.str id: The ELB loadbalancer ID.
        :param Sequence['GetListenersListenerLoadbalancerArgs'] loadbalancers: Listener list.
               The object structure is documented below.
        :param _builtins.str name: The listener name.
        :param _builtins.str protocol: The listener protocol.  
               The valid values are **TCP**, **UDP**, **HTTP** and **TERMINATED_HTTPS**.
        :param _builtins.int protocol_port: The front-end listening port of the listener.  
               The valid value is range from `1` to `65535`.
        :param Sequence[_builtins.str] sni_container_refs: List of the SNI certificate (server certificates with a domain name) IDs used by the listener.
        """
        pulumi.set(__self__, "client_ca_tls_container_ref", client_ca_tls_container_ref)
        pulumi.set(__self__, "connection_limit", connection_limit)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "default_pool_id", default_pool_id)
        pulumi.set(__self__, "default_tls_container_ref", default_tls_container_ref)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "http2_enable", http2_enable)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "insert_headers", insert_headers)
        pulumi.set(__self__, "loadbalancers", loadbalancers)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protection_reason", protection_reason)
        pulumi.set(__self__, "protection_status", protection_status)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "protocol_port", protocol_port)
        pulumi.set(__self__, "sni_container_refs", sni_container_refs)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "tls_ciphers_policy", tls_ciphers_policy)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="clientCaTlsContainerRef")
    def client_ca_tls_container_ref(self) -> _builtins.str:
        return pulumi.get(self, "client_ca_tls_container_ref")

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> _builtins.int:
        """
        The maximum number of connections allowed for the listener.
        """
        return pulumi.get(self, "connection_limit")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> _builtins.str:
        """
        The ID of the default pool with which the ELB listener is associated.
        """
        return pulumi.get(self, "default_pool_id")

    @_builtins.property
    @pulumi.getter(name="defaultTlsContainerRef")
    def default_tls_container_ref(self) -> _builtins.str:
        """
        The ID of the server certificate used by the listener.
        """
        return pulumi.get(self, "default_tls_container_ref")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the ELB listener.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> _builtins.bool:
        """
        Whether the ELB listener uses HTTP/2.
        """
        return pulumi.get(self, "http2_enable")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ELB loadbalancer ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="insertHeaders")
    def insert_headers(self) -> Sequence['outputs.GetListenersListenerInsertHeaderResult']:
        return pulumi.get(self, "insert_headers")

    @_builtins.property
    @pulumi.getter
    def loadbalancers(self) -> Sequence['outputs.GetListenersListenerLoadbalancerResult']:
        """
        Listener list.
        The object structure is documented below.
        """
        return pulumi.get(self, "loadbalancers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The listener name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> _builtins.str:
        return pulumi.get(self, "protection_reason")

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> _builtins.str:
        return pulumi.get(self, "protection_status")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The listener protocol.  
        The valid values are **TCP**, **UDP**, **HTTP** and **TERMINATED_HTTPS**.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> _builtins.int:
        """
        The front-end listening port of the listener.  
        The valid value is range from `1` to `65535`.
        """
        return pulumi.get(self, "protocol_port")

    @_builtins.property
    @pulumi.getter(name="sniContainerRefs")
    def sni_container_refs(self) -> Sequence[_builtins.str]:
        """
        List of the SNI certificate (server certificates with a domain name) IDs used by the listener.
        """
        return pulumi.get(self, "sni_container_refs")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tlsCiphersPolicy")
    def tls_ciphers_policy(self) -> _builtins.str:
        return pulumi.get(self, "tls_ciphers_policy")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetListenersListenerInsertHeaderResult(dict):
    def __init__(__self__, *,
                 x_forwarded_elb_ip: _builtins.str,
                 x_forwarded_host: _builtins.str):
        pulumi.set(__self__, "x_forwarded_elb_ip", x_forwarded_elb_ip)
        pulumi.set(__self__, "x_forwarded_host", x_forwarded_host)

    @_builtins.property
    @pulumi.getter(name="xForwardedElbIp")
    def x_forwarded_elb_ip(self) -> _builtins.str:
        return pulumi.get(self, "x_forwarded_elb_ip")

    @_builtins.property
    @pulumi.getter(name="xForwardedHost")
    def x_forwarded_host(self) -> _builtins.str:
        return pulumi.get(self, "x_forwarded_host")


@pulumi.output_type
class GetListenersListenerLoadbalancerResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The ELB loadbalancer ID.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ELB loadbalancer ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPoolsPoolResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 healthmonitor_id: _builtins.str,
                 id: _builtins.str,
                 lb_method: _builtins.str,
                 listeners: Sequence['outputs.GetPoolsPoolListenerResult'],
                 loadbalancers: Sequence['outputs.GetPoolsPoolLoadbalancerResult'],
                 members: Sequence['outputs.GetPoolsPoolMemberResult'],
                 name: _builtins.str,
                 persistences: Sequence['outputs.GetPoolsPoolPersistenceResult'],
                 protection_reason: _builtins.str,
                 protection_status: _builtins.str,
                 protocol: _builtins.str):
        """
        :param _builtins.str description: Specifies the description of the ELB pool.
        :param _builtins.str healthmonitor_id: Specifies the health monitor ID of the ELB pool.
        :param _builtins.str id: The listener, loadbalancer or member ID.
        :param _builtins.str lb_method: Specifies the method of the ELB pool. Must be one of ROUND_ROBIN, LEAST_CONNECTIONS,
               or SOURCE_IP.
        :param Sequence['GetPoolsPoolListenerArgs'] listeners: The listener list. The object structure is documented below.
        :param Sequence['GetPoolsPoolLoadbalancerArgs'] loadbalancers: The loadbalancer list. The object structure is documented below.
        :param Sequence['GetPoolsPoolMemberArgs'] members: The member list. The object structure is documented below.
        :param _builtins.str name: Specifies the name of the ELB pool.
        :param Sequence['GetPoolsPoolPersistenceArgs'] persistences: Indicates whether connections in the same session will be processed by the same pool member or not.
               The object structure is documented below.
        :param _builtins.str protocol: Specifies the protocol of the ELB pool. This can either be TCP, UDP or HTTP.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "healthmonitor_id", healthmonitor_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lb_method", lb_method)
        pulumi.set(__self__, "listeners", listeners)
        pulumi.set(__self__, "loadbalancers", loadbalancers)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "persistences", persistences)
        pulumi.set(__self__, "protection_reason", protection_reason)
        pulumi.set(__self__, "protection_status", protection_status)
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Specifies the description of the ELB pool.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="healthmonitorId")
    def healthmonitor_id(self) -> _builtins.str:
        """
        Specifies the health monitor ID of the ELB pool.
        """
        return pulumi.get(self, "healthmonitor_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The listener, loadbalancer or member ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lbMethod")
    def lb_method(self) -> _builtins.str:
        """
        Specifies the method of the ELB pool. Must be one of ROUND_ROBIN, LEAST_CONNECTIONS,
        or SOURCE_IP.
        """
        return pulumi.get(self, "lb_method")

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.GetPoolsPoolListenerResult']:
        """
        The listener list. The object structure is documented below.
        """
        return pulumi.get(self, "listeners")

    @_builtins.property
    @pulumi.getter
    def loadbalancers(self) -> Sequence['outputs.GetPoolsPoolLoadbalancerResult']:
        """
        The loadbalancer list. The object structure is documented below.
        """
        return pulumi.get(self, "loadbalancers")

    @_builtins.property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetPoolsPoolMemberResult']:
        """
        The member list. The object structure is documented below.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the ELB pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def persistences(self) -> Sequence['outputs.GetPoolsPoolPersistenceResult']:
        """
        Indicates whether connections in the same session will be processed by the same pool member or not.
        The object structure is documented below.
        """
        return pulumi.get(self, "persistences")

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> _builtins.str:
        return pulumi.get(self, "protection_reason")

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> _builtins.str:
        return pulumi.get(self, "protection_status")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Specifies the protocol of the ELB pool. This can either be TCP, UDP or HTTP.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetPoolsPoolListenerResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The listener, loadbalancer or member ID.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The listener, loadbalancer or member ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPoolsPoolLoadbalancerResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The listener, loadbalancer or member ID.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The listener, loadbalancer or member ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPoolsPoolMemberResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The listener, loadbalancer or member ID.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The listener, loadbalancer or member ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPoolsPoolPersistenceResult(dict):
    def __init__(__self__, *,
                 cookie_name: _builtins.str,
                 timeout: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.str cookie_name: The name of the cookie if persistence mode is set appropriately.
        :param _builtins.str type: The type of persistence mode.
        """
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> _builtins.str:
        """
        The name of the cookie if persistence mode is set appropriately.
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of persistence mode.
        """
        return pulumi.get(self, "type")


