# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WhitelistArgs', 'Whitelist']

@pulumi.input_type
class WhitelistArgs:
    def __init__(__self__, *,
                 listener_id: pulumi.Input[_builtins.str],
                 enable_whitelist: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Whitelist resource.
        :param pulumi.Input[_builtins.str] listener_id: The Listener ID that the whitelist will be associated with. Changing this
               creates a new whitelist.
        :param pulumi.Input[_builtins.bool] enable_whitelist: Specify whether to enable access control.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB whitelist resource. If omitted, the
               provider-level region will be used. Changing this creates a new whitelist.
        :param pulumi.Input[_builtins.str] whitelist: Specifies the IP addresses in the whitelist. Use commas(,) to separate the multiple
               IP addresses.
        """
        pulumi.set(__self__, "listener_id", listener_id)
        if enable_whitelist is not None:
            pulumi.set(__self__, "enable_whitelist", enable_whitelist)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tenant_id is not None:
            warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if whitelist is not None:
            pulumi.set(__self__, "whitelist", whitelist)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Listener ID that the whitelist will be associated with. Changing this
        creates a new whitelist.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter(name="enableWhitelist")
    def enable_whitelist(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specify whether to enable access control.
        """
        return pulumi.get(self, "enable_whitelist")

    @enable_whitelist.setter
    def enable_whitelist(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_whitelist", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the ELB whitelist resource. If omitted, the
        provider-level region will be used. Changing this creates a new whitelist.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""tenant_id is deprecated""")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def whitelist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP addresses in the whitelist. Use commas(,) to separate the multiple
        IP addresses.
        """
        return pulumi.get(self, "whitelist")

    @whitelist.setter
    def whitelist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "whitelist", value)


@pulumi.input_type
class _WhitelistState:
    def __init__(__self__, *,
                 enable_whitelist: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Whitelist resources.
        :param pulumi.Input[_builtins.bool] enable_whitelist: Specify whether to enable access control.
        :param pulumi.Input[_builtins.str] listener_id: The Listener ID that the whitelist will be associated with. Changing this
               creates a new whitelist.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB whitelist resource. If omitted, the
               provider-level region will be used. Changing this creates a new whitelist.
        :param pulumi.Input[_builtins.str] whitelist: Specifies the IP addresses in the whitelist. Use commas(,) to separate the multiple
               IP addresses.
        """
        if enable_whitelist is not None:
            pulumi.set(__self__, "enable_whitelist", enable_whitelist)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tenant_id is not None:
            warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if whitelist is not None:
            pulumi.set(__self__, "whitelist", whitelist)

    @_builtins.property
    @pulumi.getter(name="enableWhitelist")
    def enable_whitelist(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specify whether to enable access control.
        """
        return pulumi.get(self, "enable_whitelist")

    @enable_whitelist.setter
    def enable_whitelist(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_whitelist", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Listener ID that the whitelist will be associated with. Changing this
        creates a new whitelist.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the ELB whitelist resource. If omitted, the
        provider-level region will be used. Changing this creates a new whitelist.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""tenant_id is deprecated""")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def whitelist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP addresses in the whitelist. Use commas(,) to separate the multiple
        IP addresses.
        """
        return pulumi.get(self, "whitelist")

    @whitelist.setter
    def whitelist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "whitelist", value)


@pulumi.type_token("sbercloud:Elb/whitelist:Whitelist")
class Whitelist(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_whitelist: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an ELB whitelist resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        listener1 = sbercloud.elb.Listener("listener_1",
            name="listener_1",
            protocol="HTTP",
            protocol_port=8080,
            loadbalancer_id=loadbalancer_id)
        whitelist1 = sbercloud.elb.Whitelist("whitelist_1",
            enable_whitelist=True,
            whitelist="192.168.11.1,192.168.0.1/24,192.168.201.18/8",
            listener_id=listener1.id)
        ```

        ## Import

        ELB whitelist can be imported using the whitelist ID, e.g.

        ```sh
        $ pulumi import sbercloud:Elb/whitelist:Whitelist whitelist_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enable_whitelist: Specify whether to enable access control.
        :param pulumi.Input[_builtins.str] listener_id: The Listener ID that the whitelist will be associated with. Changing this
               creates a new whitelist.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB whitelist resource. If omitted, the
               provider-level region will be used. Changing this creates a new whitelist.
        :param pulumi.Input[_builtins.str] whitelist: Specifies the IP addresses in the whitelist. Use commas(,) to separate the multiple
               IP addresses.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WhitelistArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB whitelist resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        listener1 = sbercloud.elb.Listener("listener_1",
            name="listener_1",
            protocol="HTTP",
            protocol_port=8080,
            loadbalancer_id=loadbalancer_id)
        whitelist1 = sbercloud.elb.Whitelist("whitelist_1",
            enable_whitelist=True,
            whitelist="192.168.11.1,192.168.0.1/24,192.168.201.18/8",
            listener_id=listener1.id)
        ```

        ## Import

        ELB whitelist can be imported using the whitelist ID, e.g.

        ```sh
        $ pulumi import sbercloud:Elb/whitelist:Whitelist whitelist_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param WhitelistArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WhitelistArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_whitelist: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WhitelistArgs.__new__(WhitelistArgs)

            __props__.__dict__["enable_whitelist"] = enable_whitelist
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
            __props__.__dict__["region"] = region
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["whitelist"] = whitelist
        super(Whitelist, __self__).__init__(
            'sbercloud:Elb/whitelist:Whitelist',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_whitelist: Optional[pulumi.Input[_builtins.bool]] = None,
            listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            whitelist: Optional[pulumi.Input[_builtins.str]] = None) -> 'Whitelist':
        """
        Get an existing Whitelist resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enable_whitelist: Specify whether to enable access control.
        :param pulumi.Input[_builtins.str] listener_id: The Listener ID that the whitelist will be associated with. Changing this
               creates a new whitelist.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB whitelist resource. If omitted, the
               provider-level region will be used. Changing this creates a new whitelist.
        :param pulumi.Input[_builtins.str] whitelist: Specifies the IP addresses in the whitelist. Use commas(,) to separate the multiple
               IP addresses.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WhitelistState.__new__(_WhitelistState)

        __props__.__dict__["enable_whitelist"] = enable_whitelist
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["region"] = region
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["whitelist"] = whitelist
        return Whitelist(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="enableWhitelist")
    def enable_whitelist(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specify whether to enable access control.
        """
        return pulumi.get(self, "enable_whitelist")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Listener ID that the whitelist will be associated with. Changing this
        creates a new whitelist.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the ELB whitelist resource. If omitted, the
        provider-level region will be used. Changing this creates a new whitelist.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""tenant_id is deprecated""")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def whitelist(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the IP addresses in the whitelist. Use commas(,) to separate the multiple
        IP addresses.
        """
        return pulumi.get(self, "whitelist")

