# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ElbIpgroupArgs', 'ElbIpgroup']

@pulumi.input_type
class ElbIpgroupArgs:
    def __init__(__self__, *,
                 ip_lists: pulumi.Input[Sequence[pulumi.Input['ElbIpgroupIpListArgs']]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ElbIpgroup resource.
        :param pulumi.Input[Sequence[pulumi.Input['ElbIpgroupIpListArgs']]] ip_lists: Specifies an array of one or more ip addresses. The ip_list object structure is
               documented below.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the ip group.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the ip group. Changing this
               creates a new ip group.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the ip group.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ip group resource. If omitted, the
               provider-level region will be used. Changing this creates a new ip group.
        """
        pulumi.set(__self__, "ip_lists", ip_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> pulumi.Input[Sequence[pulumi.Input['ElbIpgroupIpListArgs']]]:
        """
        Specifies an array of one or more ip addresses. The ip_list object structure is
        documented below.
        """
        return pulumi.get(self, "ip_lists")

    @ip_lists.setter
    def ip_lists(self, value: pulumi.Input[Sequence[pulumi.Input['ElbIpgroupIpListArgs']]]):
        pulumi.set(self, "ip_lists", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the ip group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the ip group. Changing this
        creates a new ip group.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the ip group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the ip group resource. If omitted, the
        provider-level region will be used. Changing this creates a new ip group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ElbIpgroupState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ElbIpgroupIpListArgs']]]] = None,
                 listener_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ElbIpgroup resources.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the ip group.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the ip group. Changing this
               creates a new ip group.
        :param pulumi.Input[Sequence[pulumi.Input['ElbIpgroupIpListArgs']]] ip_lists: Specifies an array of one or more ip addresses. The ip_list object structure is
               documented below.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the ip group.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ip group resource. If omitted, the
               provider-level region will be used. Changing this creates a new ip group.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ip_lists is not None:
            pulumi.set(__self__, "ip_lists", ip_lists)
        if listener_ids is not None:
            pulumi.set(__self__, "listener_ids", listener_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the ip group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the ip group. Changing this
        creates a new ip group.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElbIpgroupIpListArgs']]]]:
        """
        Specifies an array of one or more ip addresses. The ip_list object structure is
        documented below.
        """
        return pulumi.get(self, "ip_lists")

    @ip_lists.setter
    def ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElbIpgroupIpListArgs']]]]):
        pulumi.set(self, "ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="listenerIds")
    def listener_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "listener_ids")

    @listener_ids.setter
    def listener_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "listener_ids", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the ip group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the ip group resource. If omitted, the
        provider-level region will be used. Changing this creates a new ip group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:index/elbIpgroup:ElbIpgroup")
class ElbIpgroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbIpgroupIpListArgs', 'ElbIpgroupIpListArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Dedicated ELB Ip Group resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        basic = sbercloud.ElbIpgroup("basic",
            name="basic",
            description="basic example",
            ip_lists=[{
                "ip": "192.168.10.10",
                "description": "ECS01",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the ip group.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the ip group. Changing this
               creates a new ip group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElbIpgroupIpListArgs', 'ElbIpgroupIpListArgsDict']]]] ip_lists: Specifies an array of one or more ip addresses. The ip_list object structure is
               documented below.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the ip group.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ip group resource. If omitted, the
               provider-level region will be used. Changing this creates a new ip group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElbIpgroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dedicated ELB Ip Group resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        basic = sbercloud.ElbIpgroup("basic",
            name="basic",
            description="basic example",
            ip_lists=[{
                "ip": "192.168.10.10",
                "description": "ECS01",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ElbIpgroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElbIpgroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbIpgroupIpListArgs', 'ElbIpgroupIpListArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElbIpgroupArgs.__new__(ElbIpgroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if ip_lists is None and not opts.urn:
                raise TypeError("Missing required property 'ip_lists'")
            __props__.__dict__["ip_lists"] = ip_lists
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["created_at"] = None
            __props__.__dict__["listener_ids"] = None
            __props__.__dict__["updated_at"] = None
        super(ElbIpgroup, __self__).__init__(
            'sbercloud:index/elbIpgroup:ElbIpgroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbIpgroupIpListArgs', 'ElbIpgroupIpListArgsDict']]]]] = None,
            listener_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'ElbIpgroup':
        """
        Get an existing ElbIpgroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the ip group.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the ip group. Changing this
               creates a new ip group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElbIpgroupIpListArgs', 'ElbIpgroupIpListArgsDict']]]] ip_lists: Specifies an array of one or more ip addresses. The ip_list object structure is
               documented below.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the ip group.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ip group resource. If omitted, the
               provider-level region will be used. Changing this creates a new ip group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElbIpgroupState.__new__(_ElbIpgroupState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["ip_lists"] = ip_lists
        __props__.__dict__["listener_ids"] = listener_ids
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["updated_at"] = updated_at
        return ElbIpgroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable description for the ip group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project id of the ip group. Changing this
        creates a new ip group.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> pulumi.Output[Sequence['outputs.ElbIpgroupIpList']]:
        """
        Specifies an array of one or more ip addresses. The ip_list object structure is
        documented below.
        """
        return pulumi.get(self, "ip_lists")

    @_builtins.property
    @pulumi.getter(name="listenerIds")
    def listener_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "listener_ids")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable name for the ip group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the ip group resource. If omitted, the
        provider-level region will be used. Changing this creates a new ip group.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

