# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ElbL7policyArgs', 'ElbL7policy']

@pulumi.input_type
class ElbL7policyArgs:
    def __init__(__self__, *,
                 listener_id: pulumi.Input[_builtins.str],
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_response_config: Optional[pulumi.Input['ElbL7policyFixedResponseConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 redirect_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_pools_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ElbL7policyRedirectPoolsConfigArgs']]]] = None,
                 redirect_pools_extend_config: Optional[pulumi.Input['ElbL7policyRedirectPoolsExtendConfigArgs']] = None,
                 redirect_pools_sticky_session_config: Optional[pulumi.Input['ElbL7policyRedirectPoolsStickySessionConfigArgs']] = None,
                 redirect_url_config: Optional[pulumi.Input['ElbL7policyRedirectUrlConfigArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ElbL7policy resource.
        :param pulumi.Input[_builtins.str] listener_id: The Listener on which the L7 Policy will be associated with. Changing
               this creates a new L7 Policy.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the L7 Policy.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the L7 Policy. Does not have to be unique.
        :param pulumi.Input[_builtins.str] redirect_pool_id: Requests matching this policy will be redirected to the pool with this ID.
        :param pulumi.Input[_builtins.str] region: The region in which to create the L7 Policy resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Policy.
        """
        pulumi.set(__self__, "listener_id", listener_id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fixed_response_config is not None:
            pulumi.set(__self__, "fixed_response_config", fixed_response_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if redirect_listener_id is not None:
            pulumi.set(__self__, "redirect_listener_id", redirect_listener_id)
        if redirect_pool_id is not None:
            pulumi.set(__self__, "redirect_pool_id", redirect_pool_id)
        if redirect_pools_configs is not None:
            pulumi.set(__self__, "redirect_pools_configs", redirect_pools_configs)
        if redirect_pools_extend_config is not None:
            pulumi.set(__self__, "redirect_pools_extend_config", redirect_pools_extend_config)
        if redirect_pools_sticky_session_config is not None:
            pulumi.set(__self__, "redirect_pools_sticky_session_config", redirect_pools_sticky_session_config)
        if redirect_url_config is not None:
            pulumi.set(__self__, "redirect_url_config", redirect_url_config)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Listener on which the L7 Policy will be associated with. Changing
        this creates a new L7 Policy.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the L7 Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="fixedResponseConfig")
    def fixed_response_config(self) -> Optional[pulumi.Input['ElbL7policyFixedResponseConfigArgs']]:
        return pulumi.get(self, "fixed_response_config")

    @fixed_response_config.setter
    def fixed_response_config(self, value: Optional[pulumi.Input['ElbL7policyFixedResponseConfigArgs']]):
        pulumi.set(self, "fixed_response_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the L7 Policy. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="redirectListenerId")
    def redirect_listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "redirect_listener_id")

    @redirect_listener_id.setter
    def redirect_listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redirect_listener_id", value)

    @_builtins.property
    @pulumi.getter(name="redirectPoolId")
    def redirect_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Requests matching this policy will be redirected to the pool with this ID.
        """
        return pulumi.get(self, "redirect_pool_id")

    @redirect_pool_id.setter
    def redirect_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redirect_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="redirectPoolsConfigs")
    def redirect_pools_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElbL7policyRedirectPoolsConfigArgs']]]]:
        return pulumi.get(self, "redirect_pools_configs")

    @redirect_pools_configs.setter
    def redirect_pools_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElbL7policyRedirectPoolsConfigArgs']]]]):
        pulumi.set(self, "redirect_pools_configs", value)

    @_builtins.property
    @pulumi.getter(name="redirectPoolsExtendConfig")
    def redirect_pools_extend_config(self) -> Optional[pulumi.Input['ElbL7policyRedirectPoolsExtendConfigArgs']]:
        return pulumi.get(self, "redirect_pools_extend_config")

    @redirect_pools_extend_config.setter
    def redirect_pools_extend_config(self, value: Optional[pulumi.Input['ElbL7policyRedirectPoolsExtendConfigArgs']]):
        pulumi.set(self, "redirect_pools_extend_config", value)

    @_builtins.property
    @pulumi.getter(name="redirectPoolsStickySessionConfig")
    def redirect_pools_sticky_session_config(self) -> Optional[pulumi.Input['ElbL7policyRedirectPoolsStickySessionConfigArgs']]:
        return pulumi.get(self, "redirect_pools_sticky_session_config")

    @redirect_pools_sticky_session_config.setter
    def redirect_pools_sticky_session_config(self, value: Optional[pulumi.Input['ElbL7policyRedirectPoolsStickySessionConfigArgs']]):
        pulumi.set(self, "redirect_pools_sticky_session_config", value)

    @_builtins.property
    @pulumi.getter(name="redirectUrlConfig")
    def redirect_url_config(self) -> Optional[pulumi.Input['ElbL7policyRedirectUrlConfigArgs']]:
        return pulumi.get(self, "redirect_url_config")

    @redirect_url_config.setter
    def redirect_url_config(self, value: Optional[pulumi.Input['ElbL7policyRedirectUrlConfigArgs']]):
        pulumi.set(self, "redirect_url_config", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the L7 Policy resource. If omitted, the
        provider-level region will be used. Changing this creates a new L7 Policy.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ElbL7policyState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_response_config: Optional[pulumi.Input['ElbL7policyFixedResponseConfigArgs']] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 provisioning_status: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_pools_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ElbL7policyRedirectPoolsConfigArgs']]]] = None,
                 redirect_pools_extend_config: Optional[pulumi.Input['ElbL7policyRedirectPoolsExtendConfigArgs']] = None,
                 redirect_pools_sticky_session_config: Optional[pulumi.Input['ElbL7policyRedirectPoolsStickySessionConfigArgs']] = None,
                 redirect_url_config: Optional[pulumi.Input['ElbL7policyRedirectUrlConfigArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ElbL7policy resources.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the L7 Policy.
        :param pulumi.Input[_builtins.str] listener_id: The Listener on which the L7 Policy will be associated with. Changing
               this creates a new L7 Policy.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the L7 Policy. Does not have to be unique.
        :param pulumi.Input[_builtins.str] redirect_pool_id: Requests matching this policy will be redirected to the pool with this ID.
        :param pulumi.Input[_builtins.str] region: The region in which to create the L7 Policy resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Policy.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fixed_response_config is not None:
            pulumi.set(__self__, "fixed_response_config", fixed_response_config)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)
        if redirect_listener_id is not None:
            pulumi.set(__self__, "redirect_listener_id", redirect_listener_id)
        if redirect_pool_id is not None:
            pulumi.set(__self__, "redirect_pool_id", redirect_pool_id)
        if redirect_pools_configs is not None:
            pulumi.set(__self__, "redirect_pools_configs", redirect_pools_configs)
        if redirect_pools_extend_config is not None:
            pulumi.set(__self__, "redirect_pools_extend_config", redirect_pools_extend_config)
        if redirect_pools_sticky_session_config is not None:
            pulumi.set(__self__, "redirect_pools_sticky_session_config", redirect_pools_sticky_session_config)
        if redirect_url_config is not None:
            pulumi.set(__self__, "redirect_url_config", redirect_url_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the L7 Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="fixedResponseConfig")
    def fixed_response_config(self) -> Optional[pulumi.Input['ElbL7policyFixedResponseConfigArgs']]:
        return pulumi.get(self, "fixed_response_config")

    @fixed_response_config.setter
    def fixed_response_config(self, value: Optional[pulumi.Input['ElbL7policyFixedResponseConfigArgs']]):
        pulumi.set(self, "fixed_response_config", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Listener on which the L7 Policy will be associated with. Changing
        this creates a new L7 Policy.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the L7 Policy. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "provisioning_status")

    @provisioning_status.setter
    def provisioning_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioning_status", value)

    @_builtins.property
    @pulumi.getter(name="redirectListenerId")
    def redirect_listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "redirect_listener_id")

    @redirect_listener_id.setter
    def redirect_listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redirect_listener_id", value)

    @_builtins.property
    @pulumi.getter(name="redirectPoolId")
    def redirect_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Requests matching this policy will be redirected to the pool with this ID.
        """
        return pulumi.get(self, "redirect_pool_id")

    @redirect_pool_id.setter
    def redirect_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redirect_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="redirectPoolsConfigs")
    def redirect_pools_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElbL7policyRedirectPoolsConfigArgs']]]]:
        return pulumi.get(self, "redirect_pools_configs")

    @redirect_pools_configs.setter
    def redirect_pools_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElbL7policyRedirectPoolsConfigArgs']]]]):
        pulumi.set(self, "redirect_pools_configs", value)

    @_builtins.property
    @pulumi.getter(name="redirectPoolsExtendConfig")
    def redirect_pools_extend_config(self) -> Optional[pulumi.Input['ElbL7policyRedirectPoolsExtendConfigArgs']]:
        return pulumi.get(self, "redirect_pools_extend_config")

    @redirect_pools_extend_config.setter
    def redirect_pools_extend_config(self, value: Optional[pulumi.Input['ElbL7policyRedirectPoolsExtendConfigArgs']]):
        pulumi.set(self, "redirect_pools_extend_config", value)

    @_builtins.property
    @pulumi.getter(name="redirectPoolsStickySessionConfig")
    def redirect_pools_sticky_session_config(self) -> Optional[pulumi.Input['ElbL7policyRedirectPoolsStickySessionConfigArgs']]:
        return pulumi.get(self, "redirect_pools_sticky_session_config")

    @redirect_pools_sticky_session_config.setter
    def redirect_pools_sticky_session_config(self, value: Optional[pulumi.Input['ElbL7policyRedirectPoolsStickySessionConfigArgs']]):
        pulumi.set(self, "redirect_pools_sticky_session_config", value)

    @_builtins.property
    @pulumi.getter(name="redirectUrlConfig")
    def redirect_url_config(self) -> Optional[pulumi.Input['ElbL7policyRedirectUrlConfigArgs']]:
        return pulumi.get(self, "redirect_url_config")

    @redirect_url_config.setter
    def redirect_url_config(self, value: Optional[pulumi.Input['ElbL7policyRedirectUrlConfigArgs']]):
        pulumi.set(self, "redirect_url_config", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the L7 Policy resource. If omitted, the
        provider-level region will be used. Changing this creates a new L7 Policy.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:index/elbL7policy:ElbL7policy")
class ElbL7policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_response_config: Optional[pulumi.Input[Union['ElbL7policyFixedResponseConfigArgs', 'ElbL7policyFixedResponseConfigArgsDict']]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 redirect_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_pools_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbL7policyRedirectPoolsConfigArgs', 'ElbL7policyRedirectPoolsConfigArgsDict']]]]] = None,
                 redirect_pools_extend_config: Optional[pulumi.Input[Union['ElbL7policyRedirectPoolsExtendConfigArgs', 'ElbL7policyRedirectPoolsExtendConfigArgsDict']]] = None,
                 redirect_pools_sticky_session_config: Optional[pulumi.Input[Union['ElbL7policyRedirectPoolsStickySessionConfigArgs', 'ElbL7policyRedirectPoolsStickySessionConfigArgsDict']]] = None,
                 redirect_url_config: Optional[pulumi.Input[Union['ElbL7policyRedirectUrlConfigArgs', 'ElbL7policyRedirectUrlConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an ELB L7 Policy resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        listener_id = config.require_object("listenerId")
        pool_id = config.require_object("poolId")
        policy1 = sbercloud.ElbL7policy("policy_1",
            name="policy_1",
            description="test description",
            listener_id=listener_id,
            redirect_pool_id=pool_id)
        ```

        ## Import

        ELB policy can be imported using the policy ID, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbL7policy:ElbL7policy policy_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the L7 Policy.
        :param pulumi.Input[_builtins.str] listener_id: The Listener on which the L7 Policy will be associated with. Changing
               this creates a new L7 Policy.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the L7 Policy. Does not have to be unique.
        :param pulumi.Input[_builtins.str] redirect_pool_id: Requests matching this policy will be redirected to the pool with this ID.
        :param pulumi.Input[_builtins.str] region: The region in which to create the L7 Policy resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElbL7policyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB L7 Policy resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        listener_id = config.require_object("listenerId")
        pool_id = config.require_object("poolId")
        policy1 = sbercloud.ElbL7policy("policy_1",
            name="policy_1",
            description="test description",
            listener_id=listener_id,
            redirect_pool_id=pool_id)
        ```

        ## Import

        ELB policy can be imported using the policy ID, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbL7policy:ElbL7policy policy_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param ElbL7policyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElbL7policyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_response_config: Optional[pulumi.Input[Union['ElbL7policyFixedResponseConfigArgs', 'ElbL7policyFixedResponseConfigArgsDict']]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 redirect_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_pools_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbL7policyRedirectPoolsConfigArgs', 'ElbL7policyRedirectPoolsConfigArgsDict']]]]] = None,
                 redirect_pools_extend_config: Optional[pulumi.Input[Union['ElbL7policyRedirectPoolsExtendConfigArgs', 'ElbL7policyRedirectPoolsExtendConfigArgsDict']]] = None,
                 redirect_pools_sticky_session_config: Optional[pulumi.Input[Union['ElbL7policyRedirectPoolsStickySessionConfigArgs', 'ElbL7policyRedirectPoolsStickySessionConfigArgsDict']]] = None,
                 redirect_url_config: Optional[pulumi.Input[Union['ElbL7policyRedirectUrlConfigArgs', 'ElbL7policyRedirectUrlConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElbL7policyArgs.__new__(ElbL7policyArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            __props__.__dict__["fixed_response_config"] = fixed_response_config
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
            __props__.__dict__["name"] = name
            __props__.__dict__["priority"] = priority
            __props__.__dict__["redirect_listener_id"] = redirect_listener_id
            __props__.__dict__["redirect_pool_id"] = redirect_pool_id
            __props__.__dict__["redirect_pools_configs"] = redirect_pools_configs
            __props__.__dict__["redirect_pools_extend_config"] = redirect_pools_extend_config
            __props__.__dict__["redirect_pools_sticky_session_config"] = redirect_pools_sticky_session_config
            __props__.__dict__["redirect_url_config"] = redirect_url_config
            __props__.__dict__["region"] = region
            __props__.__dict__["created_at"] = None
            __props__.__dict__["enterprise_project_id"] = None
            __props__.__dict__["provisioning_status"] = None
            __props__.__dict__["updated_at"] = None
        super(ElbL7policy, __self__).__init__(
            'sbercloud:index/elbL7policy:ElbL7policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            fixed_response_config: Optional[pulumi.Input[Union['ElbL7policyFixedResponseConfigArgs', 'ElbL7policyFixedResponseConfigArgsDict']]] = None,
            listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            provisioning_status: Optional[pulumi.Input[_builtins.str]] = None,
            redirect_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            redirect_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            redirect_pools_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbL7policyRedirectPoolsConfigArgs', 'ElbL7policyRedirectPoolsConfigArgsDict']]]]] = None,
            redirect_pools_extend_config: Optional[pulumi.Input[Union['ElbL7policyRedirectPoolsExtendConfigArgs', 'ElbL7policyRedirectPoolsExtendConfigArgsDict']]] = None,
            redirect_pools_sticky_session_config: Optional[pulumi.Input[Union['ElbL7policyRedirectPoolsStickySessionConfigArgs', 'ElbL7policyRedirectPoolsStickySessionConfigArgsDict']]] = None,
            redirect_url_config: Optional[pulumi.Input[Union['ElbL7policyRedirectUrlConfigArgs', 'ElbL7policyRedirectUrlConfigArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'ElbL7policy':
        """
        Get an existing ElbL7policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the L7 Policy.
        :param pulumi.Input[_builtins.str] listener_id: The Listener on which the L7 Policy will be associated with. Changing
               this creates a new L7 Policy.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the L7 Policy. Does not have to be unique.
        :param pulumi.Input[_builtins.str] redirect_pool_id: Requests matching this policy will be redirected to the pool with this ID.
        :param pulumi.Input[_builtins.str] region: The region in which to create the L7 Policy resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElbL7policyState.__new__(_ElbL7policyState)

        __props__.__dict__["action"] = action
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["fixed_response_config"] = fixed_response_config
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["provisioning_status"] = provisioning_status
        __props__.__dict__["redirect_listener_id"] = redirect_listener_id
        __props__.__dict__["redirect_pool_id"] = redirect_pool_id
        __props__.__dict__["redirect_pools_configs"] = redirect_pools_configs
        __props__.__dict__["redirect_pools_extend_config"] = redirect_pools_extend_config
        __props__.__dict__["redirect_pools_sticky_session_config"] = redirect_pools_sticky_session_config
        __props__.__dict__["redirect_url_config"] = redirect_url_config
        __props__.__dict__["region"] = region
        __props__.__dict__["updated_at"] = updated_at
        return ElbL7policy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable description for the L7 Policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="fixedResponseConfig")
    def fixed_response_config(self) -> pulumi.Output['outputs.ElbL7policyFixedResponseConfig']:
        return pulumi.get(self, "fixed_response_config")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Listener on which the L7 Policy will be associated with. Changing
        this creates a new L7 Policy.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable name for the L7 Policy. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "provisioning_status")

    @_builtins.property
    @pulumi.getter(name="redirectListenerId")
    def redirect_listener_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "redirect_listener_id")

    @_builtins.property
    @pulumi.getter(name="redirectPoolId")
    def redirect_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        Requests matching this policy will be redirected to the pool with this ID.
        """
        return pulumi.get(self, "redirect_pool_id")

    @_builtins.property
    @pulumi.getter(name="redirectPoolsConfigs")
    def redirect_pools_configs(self) -> pulumi.Output[Sequence['outputs.ElbL7policyRedirectPoolsConfig']]:
        return pulumi.get(self, "redirect_pools_configs")

    @_builtins.property
    @pulumi.getter(name="redirectPoolsExtendConfig")
    def redirect_pools_extend_config(self) -> pulumi.Output['outputs.ElbL7policyRedirectPoolsExtendConfig']:
        return pulumi.get(self, "redirect_pools_extend_config")

    @_builtins.property
    @pulumi.getter(name="redirectPoolsStickySessionConfig")
    def redirect_pools_sticky_session_config(self) -> pulumi.Output['outputs.ElbL7policyRedirectPoolsStickySessionConfig']:
        return pulumi.get(self, "redirect_pools_sticky_session_config")

    @_builtins.property
    @pulumi.getter(name="redirectUrlConfig")
    def redirect_url_config(self) -> pulumi.Output['outputs.ElbL7policyRedirectUrlConfig']:
        return pulumi.get(self, "redirect_url_config")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the L7 Policy resource. If omitted, the
        provider-level region will be used. Changing this creates a new L7 Policy.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

