# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ElbL7ruleArgs', 'ElbL7rule']

@pulumi.input_type
class ElbL7ruleArgs:
    def __init__(__self__, *,
                 compare_type: pulumi.Input[_builtins.str],
                 l7policy_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ElbL7ruleConditionArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ElbL7rule resource.
        :param pulumi.Input[_builtins.str] compare_type: The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        :param pulumi.Input[_builtins.str] l7policy_id: The ID of the L7 Policy. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] type: The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
               L7 Rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the L7 Rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] value: The value to use for the comparison.
        """
        pulumi.set(__self__, "compare_type", compare_type)
        pulumi.set(__self__, "l7policy_id", l7policy_id)
        pulumi.set(__self__, "type", type)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="compareType")
    def compare_type(self) -> pulumi.Input[_builtins.str]:
        """
        The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        """
        return pulumi.get(self, "compare_type")

    @compare_type.setter
    def compare_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compare_type", value)

    @_builtins.property
    @pulumi.getter(name="l7policyId")
    def l7policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the L7 Policy. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "l7policy_id")

    @l7policy_id.setter
    def l7policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "l7policy_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
        L7 Rule.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElbL7ruleConditionArgs']]]]:
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElbL7ruleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the L7 Rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value to use for the comparison.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _ElbL7ruleState:
    def __init__(__self__, *,
                 compare_type: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ElbL7ruleConditionArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 l7policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ElbL7rule resources.
        :param pulumi.Input[_builtins.str] compare_type: The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        :param pulumi.Input[_builtins.str] l7policy_id: The ID of the L7 Policy. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the L7 Rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] type: The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
               L7 Rule.
        :param pulumi.Input[_builtins.str] value: The value to use for the comparison.
        """
        if compare_type is not None:
            pulumi.set(__self__, "compare_type", compare_type)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if l7policy_id is not None:
            pulumi.set(__self__, "l7policy_id", l7policy_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="compareType")
    def compare_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        """
        return pulumi.get(self, "compare_type")

    @compare_type.setter
    def compare_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compare_type", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElbL7ruleConditionArgs']]]]:
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElbL7ruleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="l7policyId")
    def l7policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the L7 Policy. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "l7policy_id")

    @l7policy_id.setter
    def l7policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "l7policy_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the L7 Rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
        L7 Rule.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value to use for the comparison.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("sbercloud:index/elbL7rule:ElbL7rule")
class ElbL7rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compare_type: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbL7ruleConditionArgs', 'ElbL7ruleConditionArgsDict']]]]] = None,
                 l7policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an ELB L7 Rule resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        l7policy_id = config.require_object("l7policyId")
        l7rule1 = sbercloud.ElbL7rule("l7rule_1",
            l7policy_id=l7policy_id,
            type="PATH",
            compare_type="EQUAL_TO",
            value="/api")
        ```

        ## Import

        ELB L7 rule can be imported using the L7 policy ID and L7 rule ID separated by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbL7rule:ElbL7rule rule_1 e0bd694a-abbe-450e-b329-0931fd1cc5eb/4086b0c9-b18c-4d1c-b6b8-4c56c3ad2a9e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compare_type: The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        :param pulumi.Input[_builtins.str] l7policy_id: The ID of the L7 Policy. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the L7 Rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] type: The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
               L7 Rule.
        :param pulumi.Input[_builtins.str] value: The value to use for the comparison.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElbL7ruleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB L7 Rule resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        l7policy_id = config.require_object("l7policyId")
        l7rule1 = sbercloud.ElbL7rule("l7rule_1",
            l7policy_id=l7policy_id,
            type="PATH",
            compare_type="EQUAL_TO",
            value="/api")
        ```

        ## Import

        ELB L7 rule can be imported using the L7 policy ID and L7 rule ID separated by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbL7rule:ElbL7rule rule_1 e0bd694a-abbe-450e-b329-0931fd1cc5eb/4086b0c9-b18c-4d1c-b6b8-4c56c3ad2a9e
        ```

        :param str resource_name: The name of the resource.
        :param ElbL7ruleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElbL7ruleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compare_type: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbL7ruleConditionArgs', 'ElbL7ruleConditionArgsDict']]]]] = None,
                 l7policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElbL7ruleArgs.__new__(ElbL7ruleArgs)

            if compare_type is None and not opts.urn:
                raise TypeError("Missing required property 'compare_type'")
            __props__.__dict__["compare_type"] = compare_type
            __props__.__dict__["conditions"] = conditions
            if l7policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'l7policy_id'")
            __props__.__dict__["l7policy_id"] = l7policy_id
            __props__.__dict__["region"] = region
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["value"] = value
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(ElbL7rule, __self__).__init__(
            'sbercloud:index/elbL7rule:ElbL7rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compare_type: Optional[pulumi.Input[_builtins.str]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbL7ruleConditionArgs', 'ElbL7ruleConditionArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            l7policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'ElbL7rule':
        """
        Get an existing ElbL7rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compare_type: The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        :param pulumi.Input[_builtins.str] l7policy_id: The ID of the L7 Policy. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] region: The region in which to create the L7 Rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Rule.
        :param pulumi.Input[_builtins.str] type: The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
               L7 Rule.
        :param pulumi.Input[_builtins.str] value: The value to use for the comparison.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElbL7ruleState.__new__(_ElbL7ruleState)

        __props__.__dict__["compare_type"] = compare_type
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["l7policy_id"] = l7policy_id
        __props__.__dict__["region"] = region
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["value"] = value
        return ElbL7rule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compareType")
    def compare_type(self) -> pulumi.Output[_builtins.str]:
        """
        The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        """
        return pulumi.get(self, "compare_type")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.ElbL7ruleCondition']]:
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="l7policyId")
    def l7policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the L7 Policy. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "l7policy_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the L7 Rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
        L7 Rule.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        The value to use for the comparison.
        """
        return pulumi.get(self, "value")

