# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ElbListenerArgs', 'ElbListener']

@pulumi.input_type
class ElbListenerArgs:
    def __init__(__self__, *,
                 loadbalancer_id: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 advanced_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 cps: Optional[pulumi.Input[_builtins.int]] = None,
                 default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_member_retry: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_quic_upgrade: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_elb: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_host: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_proto: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_request_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tls_certificate: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tls_cipher: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tls_protocol: Optional[pulumi.Input[_builtins.bool]] = None,
                 gzip_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 http2_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_group: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_group_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 max_connection: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['ElbListenerPortRangeArgs']]]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 proxy_protocol_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 quic_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 real_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 response_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sni_match_algo: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_early_data_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tls_ciphers_policy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ElbListener resource.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.str] protocol: The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
               new listener.
        :param pulumi.Input[_builtins.str] access_policy: Specifies the access policy for the listener. Valid options are *white* and
               *black*.
        :param pulumi.Input[_builtins.bool] advanced_forwarding_enabled: Specifies whether to enable advanced forwarding.
               If advanced forwarding is enabled, more flexible forwarding policies and rules are supported.
        :param pulumi.Input[_builtins.str] ca_certificate: Specifies the ID of the CA certificate used by the listener. This parameter is
               valid when protocol is set to *HTTPS*.
        :param pulumi.Input[_builtins.str] default_pool_id: The ID of the default pool with which the listener is associated. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the listener.
        :param pulumi.Input[_builtins.bool] forward_eip: Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
               backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
               *HTTPS*.
        :param pulumi.Input[_builtins.bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *HTTPS*.
        :param pulumi.Input[_builtins.int] idle_timeout: Specifies the idle timeout for the listener. Value range: 0 to 4000.
        :param pulumi.Input[_builtins.str] ip_group: Specifies the ip group id for the listener.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the listener.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[_builtins.bool] real_ip: Specifies whether to transfer the source IP address of the client to backend servers
               through the HTTP header of the packet. The default value is false. This parameter is valid only when the protocol is
               set to **HTTP** or **HTTPS**.
        :param pulumi.Input[_builtins.str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[_builtins.int] request_timeout: Specifies the request timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[_builtins.int] response_timeout: Specifies the response timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[_builtins.str] server_certificate: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *HTTPS*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sni_certificates: Lists the IDs of SNI certificates (server certificates with a domain name) used
               by the listener. This parameter is valid when protocol is set to *HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the listener.
        :param pulumi.Input[_builtins.str] tls_ciphers_policy: Specifies the TLS cipher policy for the listener. Valid options are:
               tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
               This parameter is valid when protocol is set to *HTTPS*.
        """
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        pulumi.set(__self__, "protocol", protocol)
        if access_policy is not None:
            pulumi.set(__self__, "access_policy", access_policy)
        if advanced_forwarding_enabled is not None:
            pulumi.set(__self__, "advanced_forwarding_enabled", advanced_forwarding_enabled)
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if cps is not None:
            pulumi.set(__self__, "cps", cps)
        if default_pool_id is not None:
            pulumi.set(__self__, "default_pool_id", default_pool_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_member_retry is not None:
            pulumi.set(__self__, "enable_member_retry", enable_member_retry)
        if enable_quic_upgrade is not None:
            pulumi.set(__self__, "enable_quic_upgrade", enable_quic_upgrade)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if forward_eip is not None:
            pulumi.set(__self__, "forward_eip", forward_eip)
        if forward_elb is not None:
            pulumi.set(__self__, "forward_elb", forward_elb)
        if forward_host is not None:
            pulumi.set(__self__, "forward_host", forward_host)
        if forward_port is not None:
            pulumi.set(__self__, "forward_port", forward_port)
        if forward_proto is not None:
            pulumi.set(__self__, "forward_proto", forward_proto)
        if forward_request_port is not None:
            pulumi.set(__self__, "forward_request_port", forward_request_port)
        if forward_tls_certificate is not None:
            pulumi.set(__self__, "forward_tls_certificate", forward_tls_certificate)
        if forward_tls_cipher is not None:
            pulumi.set(__self__, "forward_tls_cipher", forward_tls_cipher)
        if forward_tls_protocol is not None:
            pulumi.set(__self__, "forward_tls_protocol", forward_tls_protocol)
        if gzip_enable is not None:
            pulumi.set(__self__, "gzip_enable", gzip_enable)
        if http2_enable is not None:
            pulumi.set(__self__, "http2_enable", http2_enable)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if ip_group is not None:
            pulumi.set(__self__, "ip_group", ip_group)
        if ip_group_enable is not None:
            pulumi.set(__self__, "ip_group_enable", ip_group_enable)
        if max_connection is not None:
            pulumi.set(__self__, "max_connection", max_connection)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_ranges is not None:
            pulumi.set(__self__, "port_ranges", port_ranges)
        if protection_reason is not None:
            pulumi.set(__self__, "protection_reason", protection_reason)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if protocol_port is not None:
            pulumi.set(__self__, "protocol_port", protocol_port)
        if proxy_protocol_enable is not None:
            pulumi.set(__self__, "proxy_protocol_enable", proxy_protocol_enable)
        if quic_listener_id is not None:
            pulumi.set(__self__, "quic_listener_id", quic_listener_id)
        if real_ip is not None:
            pulumi.set(__self__, "real_ip", real_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if response_timeout is not None:
            pulumi.set(__self__, "response_timeout", response_timeout)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if server_certificate is not None:
            pulumi.set(__self__, "server_certificate", server_certificate)
        if sni_certificates is not None:
            pulumi.set(__self__, "sni_certificates", sni_certificates)
        if sni_match_algo is not None:
            pulumi.set(__self__, "sni_match_algo", sni_match_algo)
        if ssl_early_data_enable is not None:
            pulumi.set(__self__, "ssl_early_data_enable", ssl_early_data_enable)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_ciphers_policy is not None:
            pulumi.set(__self__, "tls_ciphers_policy", tls_ciphers_policy)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The load balancer on which to provision this listener. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the access policy for the listener. Valid options are *white* and
        *black*.
        """
        return pulumi.get(self, "access_policy")

    @access_policy.setter
    def access_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policy", value)

    @_builtins.property
    @pulumi.getter(name="advancedForwardingEnabled")
    def advanced_forwarding_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable advanced forwarding.
        If advanced forwarding is enabled, more flexible forwarding policies and rules are supported.
        """
        return pulumi.get(self, "advanced_forwarding_enabled")

    @advanced_forwarding_enabled.setter
    def advanced_forwarding_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advanced_forwarding_enabled", value)

    @_builtins.property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the CA certificate used by the listener. This parameter is
        valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_certificate", value)

    @_builtins.property
    @pulumi.getter
    def cps(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "cps")

    @cps.setter
    def cps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cps", value)

    @_builtins.property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the default pool with which the listener is associated. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "default_pool_id")

    @default_pool_id.setter
    def default_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableMemberRetry")
    def enable_member_retry(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_member_retry")

    @enable_member_retry.setter
    def enable_member_retry(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_member_retry", value)

    @_builtins.property
    @pulumi.getter(name="enableQuicUpgrade")
    def enable_quic_upgrade(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_quic_upgrade")

    @enable_quic_upgrade.setter
    def enable_quic_upgrade(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_quic_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="forwardEip")
    def forward_eip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
        backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
        *HTTPS*.
        """
        return pulumi.get(self, "forward_eip")

    @forward_eip.setter
    def forward_eip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_eip", value)

    @_builtins.property
    @pulumi.getter(name="forwardElb")
    def forward_elb(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_elb")

    @forward_elb.setter
    def forward_elb(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_elb", value)

    @_builtins.property
    @pulumi.getter(name="forwardHost")
    def forward_host(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_host")

    @forward_host.setter
    def forward_host(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_host", value)

    @_builtins.property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_port")

    @forward_port.setter
    def forward_port(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_port", value)

    @_builtins.property
    @pulumi.getter(name="forwardProto")
    def forward_proto(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_proto")

    @forward_proto.setter
    def forward_proto(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_proto", value)

    @_builtins.property
    @pulumi.getter(name="forwardRequestPort")
    def forward_request_port(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_request_port")

    @forward_request_port.setter
    def forward_request_port(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_request_port", value)

    @_builtins.property
    @pulumi.getter(name="forwardTlsCertificate")
    def forward_tls_certificate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_tls_certificate")

    @forward_tls_certificate.setter
    def forward_tls_certificate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_tls_certificate", value)

    @_builtins.property
    @pulumi.getter(name="forwardTlsCipher")
    def forward_tls_cipher(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_tls_cipher")

    @forward_tls_cipher.setter
    def forward_tls_cipher(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_tls_cipher", value)

    @_builtins.property
    @pulumi.getter(name="forwardTlsProtocol")
    def forward_tls_protocol(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_tls_protocol")

    @forward_tls_protocol.setter
    def forward_tls_protocol(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_tls_protocol", value)

    @_builtins.property
    @pulumi.getter(name="gzipEnable")
    def gzip_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "gzip_enable")

    @gzip_enable.setter
    def gzip_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "gzip_enable", value)

    @_builtins.property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use HTTP/2. The default value is false. This parameter is valid
        only when the protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "http2_enable")

    @http2_enable.setter
    def http2_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "http2_enable", value)

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the idle timeout for the listener. Value range: 0 to 4000.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_timeout", value)

    @_builtins.property
    @pulumi.getter(name="ipGroup")
    def ip_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ip group id for the listener.
        """
        return pulumi.get(self, "ip_group")

    @ip_group.setter
    def ip_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_group", value)

    @_builtins.property
    @pulumi.getter(name="ipGroupEnable")
    def ip_group_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ip_group_enable")

    @ip_group_enable.setter
    def ip_group_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_group_enable", value)

    @_builtins.property
    @pulumi.getter(name="maxConnection")
    def max_connection(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "max_connection")

    @max_connection.setter
    def max_connection(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_connection", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the listener.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElbListenerPortRangeArgs']]]]:
        return pulumi.get(self, "port_ranges")

    @port_ranges.setter
    def port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElbListenerPortRangeArgs']]]]):
        pulumi.set(self, "port_ranges", value)

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @protection_reason.setter
    def protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_status", value)

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol_port")

    @protocol_port.setter
    def protocol_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "protocol_port", value)

    @_builtins.property
    @pulumi.getter(name="proxyProtocolEnable")
    def proxy_protocol_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "proxy_protocol_enable")

    @proxy_protocol_enable.setter
    def proxy_protocol_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "proxy_protocol_enable", value)

    @_builtins.property
    @pulumi.getter(name="quicListenerId")
    def quic_listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "quic_listener_id")

    @quic_listener_id.setter
    def quic_listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quic_listener_id", value)

    @_builtins.property
    @pulumi.getter(name="realIp")
    def real_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to transfer the source IP address of the client to backend servers
        through the HTTP header of the packet. The default value is false. This parameter is valid only when the protocol is
        set to **HTTP** or **HTTPS**.
        """
        return pulumi.get(self, "real_ip")

    @real_ip.setter
    def real_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "real_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the listener resource. If omitted, the
        provider-level region will be used. Changing this creates a new listener.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the request timeout for the listener. Value range: 1 to 300. This
        parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "request_timeout", value)

    @_builtins.property
    @pulumi.getter(name="responseTimeout")
    def response_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the response timeout for the listener. Value range: 1 to 300. This
        parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "response_timeout")

    @response_timeout.setter
    def response_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "response_timeout", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the server certificate used by the listener. This
        parameter is mandatory when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "server_certificate")

    @server_certificate.setter
    def server_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_certificate", value)

    @_builtins.property
    @pulumi.getter(name="sniCertificates")
    def sni_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Lists the IDs of SNI certificates (server certificates with a domain name) used
        by the listener. This parameter is valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "sni_certificates")

    @sni_certificates.setter
    def sni_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sni_certificates", value)

    @_builtins.property
    @pulumi.getter(name="sniMatchAlgo")
    def sni_match_algo(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "sni_match_algo")

    @sni_match_algo.setter
    def sni_match_algo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sni_match_algo", value)

    @_builtins.property
    @pulumi.getter(name="sslEarlyDataEnable")
    def ssl_early_data_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ssl_early_data_enable")

    @ssl_early_data_enable.setter
    def ssl_early_data_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_early_data_enable", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the listener.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tlsCiphersPolicy")
    def tls_ciphers_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the TLS cipher policy for the listener. Valid options are:
        tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
        This parameter is valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "tls_ciphers_policy")

    @tls_ciphers_policy.setter
    def tls_ciphers_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_ciphers_policy", value)


@pulumi.input_type
class _ElbListenerState:
    def __init__(__self__, *,
                 access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 advanced_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 cps: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_member_retry: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_quic_upgrade: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_elb: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_host: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_proto: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_request_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tls_certificate: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tls_cipher: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tls_protocol: Optional[pulumi.Input[_builtins.bool]] = None,
                 gzip_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 http2_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_group: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_group_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_connection: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['ElbListenerPortRangeArgs']]]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 proxy_protocol_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 quic_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 real_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 response_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sni_match_algo: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_early_data_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tls_ciphers_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ElbListener resources.
        :param pulumi.Input[_builtins.str] access_policy: Specifies the access policy for the listener. Valid options are *white* and
               *black*.
        :param pulumi.Input[_builtins.bool] advanced_forwarding_enabled: Specifies whether to enable advanced forwarding.
               If advanced forwarding is enabled, more flexible forwarding policies and rules are supported.
        :param pulumi.Input[_builtins.str] ca_certificate: Specifies the ID of the CA certificate used by the listener. This parameter is
               valid when protocol is set to *HTTPS*.
        :param pulumi.Input[_builtins.str] default_pool_id: The ID of the default pool with which the listener is associated. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the listener.
        :param pulumi.Input[_builtins.bool] forward_eip: Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
               backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
               *HTTPS*.
        :param pulumi.Input[_builtins.bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *HTTPS*.
        :param pulumi.Input[_builtins.int] idle_timeout: Specifies the idle timeout for the listener. Value range: 0 to 4000.
        :param pulumi.Input[_builtins.str] ip_group: Specifies the ip group id for the listener.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the listener.
        :param pulumi.Input[_builtins.str] protocol: The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
               new listener.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[_builtins.bool] real_ip: Specifies whether to transfer the source IP address of the client to backend servers
               through the HTTP header of the packet. The default value is false. This parameter is valid only when the protocol is
               set to **HTTP** or **HTTPS**.
        :param pulumi.Input[_builtins.str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[_builtins.int] request_timeout: Specifies the request timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[_builtins.int] response_timeout: Specifies the response timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[_builtins.str] server_certificate: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *HTTPS*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sni_certificates: Lists the IDs of SNI certificates (server certificates with a domain name) used
               by the listener. This parameter is valid when protocol is set to *HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the listener.
        :param pulumi.Input[_builtins.str] tls_ciphers_policy: Specifies the TLS cipher policy for the listener. Valid options are:
               tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
               This parameter is valid when protocol is set to *HTTPS*.
        """
        if access_policy is not None:
            pulumi.set(__self__, "access_policy", access_policy)
        if advanced_forwarding_enabled is not None:
            pulumi.set(__self__, "advanced_forwarding_enabled", advanced_forwarding_enabled)
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if cps is not None:
            pulumi.set(__self__, "cps", cps)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if default_pool_id is not None:
            pulumi.set(__self__, "default_pool_id", default_pool_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_member_retry is not None:
            pulumi.set(__self__, "enable_member_retry", enable_member_retry)
        if enable_quic_upgrade is not None:
            pulumi.set(__self__, "enable_quic_upgrade", enable_quic_upgrade)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if forward_eip is not None:
            pulumi.set(__self__, "forward_eip", forward_eip)
        if forward_elb is not None:
            pulumi.set(__self__, "forward_elb", forward_elb)
        if forward_host is not None:
            pulumi.set(__self__, "forward_host", forward_host)
        if forward_port is not None:
            pulumi.set(__self__, "forward_port", forward_port)
        if forward_proto is not None:
            pulumi.set(__self__, "forward_proto", forward_proto)
        if forward_request_port is not None:
            pulumi.set(__self__, "forward_request_port", forward_request_port)
        if forward_tls_certificate is not None:
            pulumi.set(__self__, "forward_tls_certificate", forward_tls_certificate)
        if forward_tls_cipher is not None:
            pulumi.set(__self__, "forward_tls_cipher", forward_tls_cipher)
        if forward_tls_protocol is not None:
            pulumi.set(__self__, "forward_tls_protocol", forward_tls_protocol)
        if gzip_enable is not None:
            pulumi.set(__self__, "gzip_enable", gzip_enable)
        if http2_enable is not None:
            pulumi.set(__self__, "http2_enable", http2_enable)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if ip_group is not None:
            pulumi.set(__self__, "ip_group", ip_group)
        if ip_group_enable is not None:
            pulumi.set(__self__, "ip_group_enable", ip_group_enable)
        if loadbalancer_id is not None:
            pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if max_connection is not None:
            pulumi.set(__self__, "max_connection", max_connection)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_ranges is not None:
            pulumi.set(__self__, "port_ranges", port_ranges)
        if protection_reason is not None:
            pulumi.set(__self__, "protection_reason", protection_reason)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_port is not None:
            pulumi.set(__self__, "protocol_port", protocol_port)
        if proxy_protocol_enable is not None:
            pulumi.set(__self__, "proxy_protocol_enable", proxy_protocol_enable)
        if quic_listener_id is not None:
            pulumi.set(__self__, "quic_listener_id", quic_listener_id)
        if real_ip is not None:
            pulumi.set(__self__, "real_ip", real_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if response_timeout is not None:
            pulumi.set(__self__, "response_timeout", response_timeout)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if server_certificate is not None:
            pulumi.set(__self__, "server_certificate", server_certificate)
        if sni_certificates is not None:
            pulumi.set(__self__, "sni_certificates", sni_certificates)
        if sni_match_algo is not None:
            pulumi.set(__self__, "sni_match_algo", sni_match_algo)
        if ssl_early_data_enable is not None:
            pulumi.set(__self__, "ssl_early_data_enable", ssl_early_data_enable)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_ciphers_policy is not None:
            pulumi.set(__self__, "tls_ciphers_policy", tls_ciphers_policy)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the access policy for the listener. Valid options are *white* and
        *black*.
        """
        return pulumi.get(self, "access_policy")

    @access_policy.setter
    def access_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policy", value)

    @_builtins.property
    @pulumi.getter(name="advancedForwardingEnabled")
    def advanced_forwarding_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable advanced forwarding.
        If advanced forwarding is enabled, more flexible forwarding policies and rules are supported.
        """
        return pulumi.get(self, "advanced_forwarding_enabled")

    @advanced_forwarding_enabled.setter
    def advanced_forwarding_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advanced_forwarding_enabled", value)

    @_builtins.property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the CA certificate used by the listener. This parameter is
        valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_certificate", value)

    @_builtins.property
    @pulumi.getter
    def cps(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "cps")

    @cps.setter
    def cps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cps", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the default pool with which the listener is associated. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "default_pool_id")

    @default_pool_id.setter
    def default_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableMemberRetry")
    def enable_member_retry(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_member_retry")

    @enable_member_retry.setter
    def enable_member_retry(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_member_retry", value)

    @_builtins.property
    @pulumi.getter(name="enableQuicUpgrade")
    def enable_quic_upgrade(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_quic_upgrade")

    @enable_quic_upgrade.setter
    def enable_quic_upgrade(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_quic_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="forwardEip")
    def forward_eip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
        backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
        *HTTPS*.
        """
        return pulumi.get(self, "forward_eip")

    @forward_eip.setter
    def forward_eip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_eip", value)

    @_builtins.property
    @pulumi.getter(name="forwardElb")
    def forward_elb(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_elb")

    @forward_elb.setter
    def forward_elb(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_elb", value)

    @_builtins.property
    @pulumi.getter(name="forwardHost")
    def forward_host(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_host")

    @forward_host.setter
    def forward_host(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_host", value)

    @_builtins.property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_port")

    @forward_port.setter
    def forward_port(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_port", value)

    @_builtins.property
    @pulumi.getter(name="forwardProto")
    def forward_proto(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_proto")

    @forward_proto.setter
    def forward_proto(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_proto", value)

    @_builtins.property
    @pulumi.getter(name="forwardRequestPort")
    def forward_request_port(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_request_port")

    @forward_request_port.setter
    def forward_request_port(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_request_port", value)

    @_builtins.property
    @pulumi.getter(name="forwardTlsCertificate")
    def forward_tls_certificate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_tls_certificate")

    @forward_tls_certificate.setter
    def forward_tls_certificate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_tls_certificate", value)

    @_builtins.property
    @pulumi.getter(name="forwardTlsCipher")
    def forward_tls_cipher(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_tls_cipher")

    @forward_tls_cipher.setter
    def forward_tls_cipher(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_tls_cipher", value)

    @_builtins.property
    @pulumi.getter(name="forwardTlsProtocol")
    def forward_tls_protocol(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "forward_tls_protocol")

    @forward_tls_protocol.setter
    def forward_tls_protocol(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_tls_protocol", value)

    @_builtins.property
    @pulumi.getter(name="gzipEnable")
    def gzip_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "gzip_enable")

    @gzip_enable.setter
    def gzip_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "gzip_enable", value)

    @_builtins.property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use HTTP/2. The default value is false. This parameter is valid
        only when the protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "http2_enable")

    @http2_enable.setter
    def http2_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "http2_enable", value)

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the idle timeout for the listener. Value range: 0 to 4000.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_timeout", value)

    @_builtins.property
    @pulumi.getter(name="ipGroup")
    def ip_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ip group id for the listener.
        """
        return pulumi.get(self, "ip_group")

    @ip_group.setter
    def ip_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_group", value)

    @_builtins.property
    @pulumi.getter(name="ipGroupEnable")
    def ip_group_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ip_group_enable")

    @ip_group_enable.setter
    def ip_group_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_group_enable", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load balancer on which to provision this listener. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter(name="maxConnection")
    def max_connection(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "max_connection")

    @max_connection.setter
    def max_connection(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_connection", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the listener.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElbListenerPortRangeArgs']]]]:
        return pulumi.get(self, "port_ranges")

    @port_ranges.setter
    def port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElbListenerPortRangeArgs']]]]):
        pulumi.set(self, "port_ranges", value)

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @protection_reason.setter
    def protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_status", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol_port")

    @protocol_port.setter
    def protocol_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "protocol_port", value)

    @_builtins.property
    @pulumi.getter(name="proxyProtocolEnable")
    def proxy_protocol_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "proxy_protocol_enable")

    @proxy_protocol_enable.setter
    def proxy_protocol_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "proxy_protocol_enable", value)

    @_builtins.property
    @pulumi.getter(name="quicListenerId")
    def quic_listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "quic_listener_id")

    @quic_listener_id.setter
    def quic_listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quic_listener_id", value)

    @_builtins.property
    @pulumi.getter(name="realIp")
    def real_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to transfer the source IP address of the client to backend servers
        through the HTTP header of the packet. The default value is false. This parameter is valid only when the protocol is
        set to **HTTP** or **HTTPS**.
        """
        return pulumi.get(self, "real_ip")

    @real_ip.setter
    def real_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "real_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the listener resource. If omitted, the
        provider-level region will be used. Changing this creates a new listener.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the request timeout for the listener. Value range: 1 to 300. This
        parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "request_timeout", value)

    @_builtins.property
    @pulumi.getter(name="responseTimeout")
    def response_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the response timeout for the listener. Value range: 1 to 300. This
        parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "response_timeout")

    @response_timeout.setter
    def response_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "response_timeout", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the server certificate used by the listener. This
        parameter is mandatory when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "server_certificate")

    @server_certificate.setter
    def server_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_certificate", value)

    @_builtins.property
    @pulumi.getter(name="sniCertificates")
    def sni_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Lists the IDs of SNI certificates (server certificates with a domain name) used
        by the listener. This parameter is valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "sni_certificates")

    @sni_certificates.setter
    def sni_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sni_certificates", value)

    @_builtins.property
    @pulumi.getter(name="sniMatchAlgo")
    def sni_match_algo(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "sni_match_algo")

    @sni_match_algo.setter
    def sni_match_algo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sni_match_algo", value)

    @_builtins.property
    @pulumi.getter(name="sslEarlyDataEnable")
    def ssl_early_data_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ssl_early_data_enable")

    @ssl_early_data_enable.setter
    def ssl_early_data_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_early_data_enable", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the listener.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tlsCiphersPolicy")
    def tls_ciphers_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the TLS cipher policy for the listener. Valid options are:
        tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
        This parameter is valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "tls_ciphers_policy")

    @tls_ciphers_policy.setter
    def tls_ciphers_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_ciphers_policy", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:index/elbListener:ElbListener")
class ElbListener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 advanced_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 cps: Optional[pulumi.Input[_builtins.int]] = None,
                 default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_member_retry: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_quic_upgrade: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_elb: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_host: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_proto: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_request_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tls_certificate: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tls_cipher: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tls_protocol: Optional[pulumi.Input[_builtins.bool]] = None,
                 gzip_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 http2_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_group: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_group_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_connection: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbListenerPortRangeArgs', 'ElbListenerPortRangeArgsDict']]]]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 proxy_protocol_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 quic_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 real_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 response_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sni_match_algo: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_early_data_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tls_ciphers_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an ELB listener resource within SberCloud.

        ## Import

        ELB listener can be imported using the listener ID, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbListener:ElbListener listener_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_policy: Specifies the access policy for the listener. Valid options are *white* and
               *black*.
        :param pulumi.Input[_builtins.bool] advanced_forwarding_enabled: Specifies whether to enable advanced forwarding.
               If advanced forwarding is enabled, more flexible forwarding policies and rules are supported.
        :param pulumi.Input[_builtins.str] ca_certificate: Specifies the ID of the CA certificate used by the listener. This parameter is
               valid when protocol is set to *HTTPS*.
        :param pulumi.Input[_builtins.str] default_pool_id: The ID of the default pool with which the listener is associated. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the listener.
        :param pulumi.Input[_builtins.bool] forward_eip: Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
               backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
               *HTTPS*.
        :param pulumi.Input[_builtins.bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *HTTPS*.
        :param pulumi.Input[_builtins.int] idle_timeout: Specifies the idle timeout for the listener. Value range: 0 to 4000.
        :param pulumi.Input[_builtins.str] ip_group: Specifies the ip group id for the listener.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the listener.
        :param pulumi.Input[_builtins.str] protocol: The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
               new listener.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[_builtins.bool] real_ip: Specifies whether to transfer the source IP address of the client to backend servers
               through the HTTP header of the packet. The default value is false. This parameter is valid only when the protocol is
               set to **HTTP** or **HTTPS**.
        :param pulumi.Input[_builtins.str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[_builtins.int] request_timeout: Specifies the request timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[_builtins.int] response_timeout: Specifies the response timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[_builtins.str] server_certificate: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *HTTPS*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sni_certificates: Lists the IDs of SNI certificates (server certificates with a domain name) used
               by the listener. This parameter is valid when protocol is set to *HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the listener.
        :param pulumi.Input[_builtins.str] tls_ciphers_policy: Specifies the TLS cipher policy for the listener. Valid options are:
               tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
               This parameter is valid when protocol is set to *HTTPS*.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElbListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB listener resource within SberCloud.

        ## Import

        ELB listener can be imported using the listener ID, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbListener:ElbListener listener_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param ElbListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElbListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 advanced_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 cps: Optional[pulumi.Input[_builtins.int]] = None,
                 default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_member_retry: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_quic_upgrade: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_elb: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_host: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_proto: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_request_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tls_certificate: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tls_cipher: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tls_protocol: Optional[pulumi.Input[_builtins.bool]] = None,
                 gzip_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 http2_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_group: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_group_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_connection: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbListenerPortRangeArgs', 'ElbListenerPortRangeArgsDict']]]]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 proxy_protocol_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 quic_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 real_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 response_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sni_match_algo: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_early_data_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tls_ciphers_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElbListenerArgs.__new__(ElbListenerArgs)

            __props__.__dict__["access_policy"] = access_policy
            __props__.__dict__["advanced_forwarding_enabled"] = advanced_forwarding_enabled
            __props__.__dict__["ca_certificate"] = ca_certificate
            __props__.__dict__["cps"] = cps
            __props__.__dict__["default_pool_id"] = default_pool_id
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_member_retry"] = enable_member_retry
            __props__.__dict__["enable_quic_upgrade"] = enable_quic_upgrade
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["forward_eip"] = forward_eip
            __props__.__dict__["forward_elb"] = forward_elb
            __props__.__dict__["forward_host"] = forward_host
            __props__.__dict__["forward_port"] = forward_port
            __props__.__dict__["forward_proto"] = forward_proto
            __props__.__dict__["forward_request_port"] = forward_request_port
            __props__.__dict__["forward_tls_certificate"] = forward_tls_certificate
            __props__.__dict__["forward_tls_cipher"] = forward_tls_cipher
            __props__.__dict__["forward_tls_protocol"] = forward_tls_protocol
            __props__.__dict__["gzip_enable"] = gzip_enable
            __props__.__dict__["http2_enable"] = http2_enable
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["ip_group"] = ip_group
            __props__.__dict__["ip_group_enable"] = ip_group_enable
            if loadbalancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'loadbalancer_id'")
            __props__.__dict__["loadbalancer_id"] = loadbalancer_id
            __props__.__dict__["max_connection"] = max_connection
            __props__.__dict__["name"] = name
            __props__.__dict__["port_ranges"] = port_ranges
            __props__.__dict__["protection_reason"] = protection_reason
            __props__.__dict__["protection_status"] = protection_status
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["protocol_port"] = protocol_port
            __props__.__dict__["proxy_protocol_enable"] = proxy_protocol_enable
            __props__.__dict__["quic_listener_id"] = quic_listener_id
            __props__.__dict__["real_ip"] = real_ip
            __props__.__dict__["region"] = region
            __props__.__dict__["request_timeout"] = request_timeout
            __props__.__dict__["response_timeout"] = response_timeout
            __props__.__dict__["security_policy_id"] = security_policy_id
            __props__.__dict__["server_certificate"] = server_certificate
            __props__.__dict__["sni_certificates"] = sni_certificates
            __props__.__dict__["sni_match_algo"] = sni_match_algo
            __props__.__dict__["ssl_early_data_enable"] = ssl_early_data_enable
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tls_ciphers_policy"] = tls_ciphers_policy
            __props__.__dict__["created_at"] = None
            __props__.__dict__["enterprise_project_id"] = None
            __props__.__dict__["updated_at"] = None
        super(ElbListener, __self__).__init__(
            'sbercloud:index/elbListener:ElbListener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policy: Optional[pulumi.Input[_builtins.str]] = None,
            advanced_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            cps: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_member_retry: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_quic_upgrade: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            forward_eip: Optional[pulumi.Input[_builtins.bool]] = None,
            forward_elb: Optional[pulumi.Input[_builtins.bool]] = None,
            forward_host: Optional[pulumi.Input[_builtins.bool]] = None,
            forward_port: Optional[pulumi.Input[_builtins.bool]] = None,
            forward_proto: Optional[pulumi.Input[_builtins.bool]] = None,
            forward_request_port: Optional[pulumi.Input[_builtins.bool]] = None,
            forward_tls_certificate: Optional[pulumi.Input[_builtins.bool]] = None,
            forward_tls_cipher: Optional[pulumi.Input[_builtins.bool]] = None,
            forward_tls_protocol: Optional[pulumi.Input[_builtins.bool]] = None,
            gzip_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            http2_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            ip_group: Optional[pulumi.Input[_builtins.str]] = None,
            ip_group_enable: Optional[pulumi.Input[_builtins.str]] = None,
            loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            max_connection: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbListenerPortRangeArgs', 'ElbListenerPortRangeArgsDict']]]]] = None,
            protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
            protection_status: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
            proxy_protocol_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            quic_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            real_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            response_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            server_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            sni_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sni_match_algo: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_early_data_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tls_ciphers_policy: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'ElbListener':
        """
        Get an existing ElbListener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_policy: Specifies the access policy for the listener. Valid options are *white* and
               *black*.
        :param pulumi.Input[_builtins.bool] advanced_forwarding_enabled: Specifies whether to enable advanced forwarding.
               If advanced forwarding is enabled, more flexible forwarding policies and rules are supported.
        :param pulumi.Input[_builtins.str] ca_certificate: Specifies the ID of the CA certificate used by the listener. This parameter is
               valid when protocol is set to *HTTPS*.
        :param pulumi.Input[_builtins.str] default_pool_id: The ID of the default pool with which the listener is associated. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the listener.
        :param pulumi.Input[_builtins.bool] forward_eip: Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
               backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
               *HTTPS*.
        :param pulumi.Input[_builtins.bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *HTTPS*.
        :param pulumi.Input[_builtins.int] idle_timeout: Specifies the idle timeout for the listener. Value range: 0 to 4000.
        :param pulumi.Input[_builtins.str] ip_group: Specifies the ip group id for the listener.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the listener.
        :param pulumi.Input[_builtins.str] protocol: The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
               new listener.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[_builtins.bool] real_ip: Specifies whether to transfer the source IP address of the client to backend servers
               through the HTTP header of the packet. The default value is false. This parameter is valid only when the protocol is
               set to **HTTP** or **HTTPS**.
        :param pulumi.Input[_builtins.str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[_builtins.int] request_timeout: Specifies the request timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[_builtins.int] response_timeout: Specifies the response timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[_builtins.str] server_certificate: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *HTTPS*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sni_certificates: Lists the IDs of SNI certificates (server certificates with a domain name) used
               by the listener. This parameter is valid when protocol is set to *HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the listener.
        :param pulumi.Input[_builtins.str] tls_ciphers_policy: Specifies the TLS cipher policy for the listener. Valid options are:
               tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
               This parameter is valid when protocol is set to *HTTPS*.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElbListenerState.__new__(_ElbListenerState)

        __props__.__dict__["access_policy"] = access_policy
        __props__.__dict__["advanced_forwarding_enabled"] = advanced_forwarding_enabled
        __props__.__dict__["ca_certificate"] = ca_certificate
        __props__.__dict__["cps"] = cps
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["default_pool_id"] = default_pool_id
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_member_retry"] = enable_member_retry
        __props__.__dict__["enable_quic_upgrade"] = enable_quic_upgrade
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["forward_eip"] = forward_eip
        __props__.__dict__["forward_elb"] = forward_elb
        __props__.__dict__["forward_host"] = forward_host
        __props__.__dict__["forward_port"] = forward_port
        __props__.__dict__["forward_proto"] = forward_proto
        __props__.__dict__["forward_request_port"] = forward_request_port
        __props__.__dict__["forward_tls_certificate"] = forward_tls_certificate
        __props__.__dict__["forward_tls_cipher"] = forward_tls_cipher
        __props__.__dict__["forward_tls_protocol"] = forward_tls_protocol
        __props__.__dict__["gzip_enable"] = gzip_enable
        __props__.__dict__["http2_enable"] = http2_enable
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["ip_group"] = ip_group
        __props__.__dict__["ip_group_enable"] = ip_group_enable
        __props__.__dict__["loadbalancer_id"] = loadbalancer_id
        __props__.__dict__["max_connection"] = max_connection
        __props__.__dict__["name"] = name
        __props__.__dict__["port_ranges"] = port_ranges
        __props__.__dict__["protection_reason"] = protection_reason
        __props__.__dict__["protection_status"] = protection_status
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["protocol_port"] = protocol_port
        __props__.__dict__["proxy_protocol_enable"] = proxy_protocol_enable
        __props__.__dict__["quic_listener_id"] = quic_listener_id
        __props__.__dict__["real_ip"] = real_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["request_timeout"] = request_timeout
        __props__.__dict__["response_timeout"] = response_timeout
        __props__.__dict__["security_policy_id"] = security_policy_id
        __props__.__dict__["server_certificate"] = server_certificate
        __props__.__dict__["sni_certificates"] = sni_certificates
        __props__.__dict__["sni_match_algo"] = sni_match_algo
        __props__.__dict__["ssl_early_data_enable"] = ssl_early_data_enable
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tls_ciphers_policy"] = tls_ciphers_policy
        __props__.__dict__["updated_at"] = updated_at
        return ElbListener(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the access policy for the listener. Valid options are *white* and
        *black*.
        """
        return pulumi.get(self, "access_policy")

    @_builtins.property
    @pulumi.getter(name="advancedForwardingEnabled")
    def advanced_forwarding_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable advanced forwarding.
        If advanced forwarding is enabled, more flexible forwarding policies and rules are supported.
        """
        return pulumi.get(self, "advanced_forwarding_enabled")

    @_builtins.property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the CA certificate used by the listener. This parameter is
        valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "ca_certificate")

    @_builtins.property
    @pulumi.getter
    def cps(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "cps")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the default pool with which the listener is associated. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "default_pool_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable description for the listener.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableMemberRetry")
    def enable_member_retry(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "enable_member_retry")

    @_builtins.property
    @pulumi.getter(name="enableQuicUpgrade")
    def enable_quic_upgrade(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "enable_quic_upgrade")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="forwardEip")
    def forward_eip(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
        backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
        *HTTPS*.
        """
        return pulumi.get(self, "forward_eip")

    @_builtins.property
    @pulumi.getter(name="forwardElb")
    def forward_elb(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "forward_elb")

    @_builtins.property
    @pulumi.getter(name="forwardHost")
    def forward_host(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "forward_host")

    @_builtins.property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "forward_port")

    @_builtins.property
    @pulumi.getter(name="forwardProto")
    def forward_proto(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "forward_proto")

    @_builtins.property
    @pulumi.getter(name="forwardRequestPort")
    def forward_request_port(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "forward_request_port")

    @_builtins.property
    @pulumi.getter(name="forwardTlsCertificate")
    def forward_tls_certificate(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "forward_tls_certificate")

    @_builtins.property
    @pulumi.getter(name="forwardTlsCipher")
    def forward_tls_cipher(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "forward_tls_cipher")

    @_builtins.property
    @pulumi.getter(name="forwardTlsProtocol")
    def forward_tls_protocol(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "forward_tls_protocol")

    @_builtins.property
    @pulumi.getter(name="gzipEnable")
    def gzip_enable(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "gzip_enable")

    @_builtins.property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to use HTTP/2. The default value is false. This parameter is valid
        only when the protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "http2_enable")

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the idle timeout for the listener. Value range: 0 to 4000.
        """
        return pulumi.get(self, "idle_timeout")

    @_builtins.property
    @pulumi.getter(name="ipGroup")
    def ip_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ip group id for the listener.
        """
        return pulumi.get(self, "ip_group")

    @_builtins.property
    @pulumi.getter(name="ipGroupEnable")
    def ip_group_enable(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ip_group_enable")

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The load balancer on which to provision this listener. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter(name="maxConnection")
    def max_connection(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "max_connection")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable name for the listener.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> pulumi.Output[Optional[Sequence['outputs.ElbListenerPortRange']]]:
        return pulumi.get(self, "port_ranges")

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "protection_status")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> pulumi.Output[_builtins.int]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol_port")

    @_builtins.property
    @pulumi.getter(name="proxyProtocolEnable")
    def proxy_protocol_enable(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "proxy_protocol_enable")

    @_builtins.property
    @pulumi.getter(name="quicListenerId")
    def quic_listener_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "quic_listener_id")

    @_builtins.property
    @pulumi.getter(name="realIp")
    def real_ip(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to transfer the source IP address of the client to backend servers
        through the HTTP header of the packet. The default value is false. This parameter is valid only when the protocol is
        set to **HTTP** or **HTTPS**.
        """
        return pulumi.get(self, "real_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the listener resource. If omitted, the
        provider-level region will be used. Changing this creates a new listener.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the request timeout for the listener. Value range: 1 to 300. This
        parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "request_timeout")

    @_builtins.property
    @pulumi.getter(name="responseTimeout")
    def response_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the response timeout for the listener. Value range: 1 to 300. This
        parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "response_timeout")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "security_policy_id")

    @_builtins.property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the server certificate used by the listener. This
        parameter is mandatory when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "server_certificate")

    @_builtins.property
    @pulumi.getter(name="sniCertificates")
    def sni_certificates(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Lists the IDs of SNI certificates (server certificates with a domain name) used
        by the listener. This parameter is valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "sni_certificates")

    @_builtins.property
    @pulumi.getter(name="sniMatchAlgo")
    def sni_match_algo(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "sni_match_algo")

    @_builtins.property
    @pulumi.getter(name="sslEarlyDataEnable")
    def ssl_early_data_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "ssl_early_data_enable")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the listener.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tlsCiphersPolicy")
    def tls_ciphers_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the TLS cipher policy for the listener. Valid options are:
        tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
        This parameter is valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "tls_ciphers_policy")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

