# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ElbLoadbalancerArgs', 'ElbLoadbalancer']

@pulumi.input_type
class ElbLoadbalancerArgs:
    def __init__(__self__, *,
                 availability_zones: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 autoscaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_vpc_backend: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 iptype: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 l4_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 l7_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 min_l7_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sharetype: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 waf_failure_action: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ElbLoadbalancer resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the list of AZ names. Changing this parameter will create a
               new resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        :param pulumi.Input[_builtins.bool] autoscaling_enabled: Specifies whether autoscaling is enabled. Valid values are **true** and
               **false**.
        :param pulumi.Input[_builtins.str] bandwidth_charge_mode: Bandwidth billing type. Changing this parameter will create a
               new resource.
        :param pulumi.Input[_builtins.int] bandwidth_size: Bandwidth size. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] cross_vpc_backend: Enable this if you want to associate the IP addresses of backend servers with
               your load balancer. Can only be true when updating.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[_builtins.str] iptype: Elastic IP type. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ipv4_address: The ipv4 address of the load balancer.
        :param pulumi.Input[_builtins.str] ipv4_eip_id: The ID of the EIP. Changing this parameter will create a new resource.
               
               > **NOTE:** If the ipv4_eip_id parameter is configured, you do not need to configure the bandwidth parameters:
               `iptype`, `bandwidth_charge_mode`, `bandwidth_size` and `share_type`.
        :param pulumi.Input[_builtins.str] ipv4_subnet_id: The **IPv4 subnet ID** of the subnet on which to allocate the loadbalancer's
               ipv4 address.
        :param pulumi.Input[_builtins.str] ipv6_address: The ipv6 address of the Load Balancer.
        :param pulumi.Input[_builtins.str] ipv6_bandwidth_id: The ipv6 bandwidth id. Only support shared bandwidth.
        :param pulumi.Input[_builtins.str] ipv6_network_id: The **ID** of the subnet on which to allocate the loadbalancer's ipv6 address.
        :param pulumi.Input[_builtins.str] l4_flavor_id: The L4 flavor id of the load balancer.
        :param pulumi.Input[_builtins.str] l7_flavor_id: The L7 flavor id of the load balancer.
        :param pulumi.Input[_builtins.str] min_l7_flavor_id: Specifies the ID of the minimum Layer-7 flavor for elastic scaling.
               This parameter cannot be left blank if there are HTTP or HTTPS listeners.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the loadbalancer.
        :param pulumi.Input[_builtins.str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[_builtins.str] sharetype: Bandwidth sharing type. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc on which to create the loadbalancer. Changing this creates a new
               loadbalancer.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if autoscaling_enabled is not None:
            pulumi.set(__self__, "autoscaling_enabled", autoscaling_enabled)
        if backend_subnets is not None:
            pulumi.set(__self__, "backend_subnets", backend_subnets)
        if bandwidth_charge_mode is not None:
            pulumi.set(__self__, "bandwidth_charge_mode", bandwidth_charge_mode)
        if bandwidth_id is not None:
            pulumi.set(__self__, "bandwidth_id", bandwidth_id)
        if bandwidth_size is not None:
            pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if cross_vpc_backend is not None:
            pulumi.set(__self__, "cross_vpc_backend", cross_vpc_backend)
        if deletion_protection_enable is not None:
            pulumi.set(__self__, "deletion_protection_enable", deletion_protection_enable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if iptype is not None:
            pulumi.set(__self__, "iptype", iptype)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_eip_id is not None:
            pulumi.set(__self__, "ipv4_eip_id", ipv4_eip_id)
        if ipv4_subnet_id is not None:
            pulumi.set(__self__, "ipv4_subnet_id", ipv4_subnet_id)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_bandwidth_id is not None:
            pulumi.set(__self__, "ipv6_bandwidth_id", ipv6_bandwidth_id)
        if ipv6_network_id is not None:
            pulumi.set(__self__, "ipv6_network_id", ipv6_network_id)
        if l4_flavor_id is not None:
            pulumi.set(__self__, "l4_flavor_id", l4_flavor_id)
        if l7_flavor_id is not None:
            pulumi.set(__self__, "l7_flavor_id", l7_flavor_id)
        if loadbalancer_type is not None:
            pulumi.set(__self__, "loadbalancer_type", loadbalancer_type)
        if min_l7_flavor_id is not None:
            pulumi.set(__self__, "min_l7_flavor_id", min_l7_flavor_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if protection_reason is not None:
            pulumi.set(__self__, "protection_reason", protection_reason)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sharetype is not None:
            pulumi.set(__self__, "sharetype", sharetype)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if waf_failure_action is not None:
            pulumi.set(__self__, "waf_failure_action", waf_failure_action)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the list of AZ names. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoscalingEnabled")
    def autoscaling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether autoscaling is enabled. Valid values are **true** and
        **false**.
        """
        return pulumi.get(self, "autoscaling_enabled")

    @autoscaling_enabled.setter
    def autoscaling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "autoscaling_enabled", value)

    @_builtins.property
    @pulumi.getter(name="backendSubnets")
    def backend_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "backend_subnets")

    @backend_subnets.setter
    def backend_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "backend_subnets", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthChargeMode")
    def bandwidth_charge_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bandwidth billing type. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "bandwidth_charge_mode")

    @bandwidth_charge_mode.setter
    def bandwidth_charge_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_charge_mode", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthId")
    def bandwidth_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "bandwidth_id")

    @bandwidth_id.setter
    def bandwidth_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_id", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Bandwidth size. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bandwidth_size")

    @bandwidth_size.setter
    def bandwidth_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth_size", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="crossVpcBackend")
    def cross_vpc_backend(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable this if you want to associate the IP addresses of backend servers with
        your load balancer. Can only be true when updating.
        """
        return pulumi.get(self, "cross_vpc_backend")

    @cross_vpc_backend.setter
    def cross_vpc_backend(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_vpc_backend", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnable")
    def deletion_protection_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection_enable")

    @deletion_protection_enable.setter
    def deletion_protection_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the loadbalancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the loadbalancer. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter
    def iptype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Elastic IP type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "iptype")

    @iptype.setter
    def iptype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iptype", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ipv4 address of the load balancer.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="ipv4EipId")
    def ipv4_eip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the EIP. Changing this parameter will create a new resource.

        > **NOTE:** If the ipv4_eip_id parameter is configured, you do not need to configure the bandwidth parameters:
        `iptype`, `bandwidth_charge_mode`, `bandwidth_size` and `share_type`.
        """
        return pulumi.get(self, "ipv4_eip_id")

    @ipv4_eip_id.setter
    def ipv4_eip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_eip_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv4SubnetId")
    def ipv4_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The **IPv4 subnet ID** of the subnet on which to allocate the loadbalancer's
        ipv4 address.
        """
        return pulumi.get(self, "ipv4_subnet_id")

    @ipv4_subnet_id.setter
    def ipv4_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ipv6 address of the Load Balancer.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @_builtins.property
    @pulumi.getter(name="ipv6BandwidthId")
    def ipv6_bandwidth_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ipv6 bandwidth id. Only support shared bandwidth.
        """
        return pulumi.get(self, "ipv6_bandwidth_id")

    @ipv6_bandwidth_id.setter
    def ipv6_bandwidth_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_bandwidth_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6NetworkId")
    def ipv6_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The **ID** of the subnet on which to allocate the loadbalancer's ipv6 address.
        """
        return pulumi.get(self, "ipv6_network_id")

    @ipv6_network_id.setter
    def ipv6_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_network_id", value)

    @_builtins.property
    @pulumi.getter(name="l4FlavorId")
    def l4_flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The L4 flavor id of the load balancer.
        """
        return pulumi.get(self, "l4_flavor_id")

    @l4_flavor_id.setter
    def l4_flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "l4_flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="l7FlavorId")
    def l7_flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The L7 flavor id of the load balancer.
        """
        return pulumi.get(self, "l7_flavor_id")

    @l7_flavor_id.setter
    def l7_flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "l7_flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerType")
    def loadbalancer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "loadbalancer_type")

    @loadbalancer_type.setter
    def loadbalancer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_type", value)

    @_builtins.property
    @pulumi.getter(name="minL7FlavorId")
    def min_l7_flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the minimum Layer-7 flavor for elastic scaling.
        This parameter cannot be left blank if there are HTTP or HTTPS listeners.
        """
        return pulumi.get(self, "min_l7_flavor_id")

    @min_l7_flavor_id.setter
    def min_l7_flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_l7_flavor_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the loadbalancer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @protection_reason.setter
    def protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_status", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the loadbalancer resource. If omitted, the
        provider-level region will be used. Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def sharetype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bandwidth sharing type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "sharetype")

    @sharetype.setter
    def sharetype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sharetype", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the loadbalancer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vpc on which to create the loadbalancer. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="wafFailureAction")
    def waf_failure_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "waf_failure_action")

    @waf_failure_action.setter
    def waf_failure_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "waf_failure_action", value)


@pulumi.input_type
class _ElbLoadbalancerState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 autoscaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
                 charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_vpc_backend: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 elb_virsubnet_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 frozen_scene: Optional[pulumi.Input[_builtins.str]] = None,
                 guaranteed: Optional[pulumi.Input[_builtins.bool]] = None,
                 gw_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iptype: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_eip: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_eip: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 l4_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 l7_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 min_l7_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operating_status: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 public_border_group: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sharetype: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 waf_failure_action: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ElbLoadbalancer resources.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        :param pulumi.Input[_builtins.bool] autoscaling_enabled: Specifies whether autoscaling is enabled. Valid values are **true** and
               **false**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the list of AZ names. Changing this parameter will create a
               new resource.
        :param pulumi.Input[_builtins.str] bandwidth_charge_mode: Bandwidth billing type. Changing this parameter will create a
               new resource.
        :param pulumi.Input[_builtins.int] bandwidth_size: Bandwidth size. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] cross_vpc_backend: Enable this if you want to associate the IP addresses of backend servers with
               your load balancer. Can only be true when updating.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[_builtins.str] iptype: Elastic IP type. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ipv4_address: The ipv4 address of the load balancer.
        :param pulumi.Input[_builtins.str] ipv4_eip: The ipv4 eip address of the Load Balancer.
        :param pulumi.Input[_builtins.str] ipv4_eip_id: The ID of the EIP. Changing this parameter will create a new resource.
               
               > **NOTE:** If the ipv4_eip_id parameter is configured, you do not need to configure the bandwidth parameters:
               `iptype`, `bandwidth_charge_mode`, `bandwidth_size` and `share_type`.
        :param pulumi.Input[_builtins.str] ipv4_subnet_id: The **IPv4 subnet ID** of the subnet on which to allocate the loadbalancer's
               ipv4 address.
        :param pulumi.Input[_builtins.str] ipv6_address: The ipv6 address of the Load Balancer.
        :param pulumi.Input[_builtins.str] ipv6_bandwidth_id: The ipv6 bandwidth id. Only support shared bandwidth.
        :param pulumi.Input[_builtins.str] ipv6_eip: The ipv6 eip address of the Load Balancer.
        :param pulumi.Input[_builtins.str] ipv6_eip_id: The ipv6 eip id of the Load Balancer.
        :param pulumi.Input[_builtins.str] ipv6_network_id: The **ID** of the subnet on which to allocate the loadbalancer's ipv6 address.
        :param pulumi.Input[_builtins.str] l4_flavor_id: The L4 flavor id of the load balancer.
        :param pulumi.Input[_builtins.str] l7_flavor_id: The L7 flavor id of the load balancer.
        :param pulumi.Input[_builtins.str] min_l7_flavor_id: Specifies the ID of the minimum Layer-7 flavor for elastic scaling.
               This parameter cannot be left blank if there are HTTP or HTTPS listeners.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the loadbalancer.
        :param pulumi.Input[_builtins.str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[_builtins.str] sharetype: Bandwidth sharing type. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc on which to create the loadbalancer. Changing this creates a new
               loadbalancer.
        """
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if autoscaling_enabled is not None:
            pulumi.set(__self__, "autoscaling_enabled", autoscaling_enabled)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if backend_subnets is not None:
            pulumi.set(__self__, "backend_subnets", backend_subnets)
        if bandwidth_charge_mode is not None:
            pulumi.set(__self__, "bandwidth_charge_mode", bandwidth_charge_mode)
        if bandwidth_id is not None:
            pulumi.set(__self__, "bandwidth_id", bandwidth_id)
        if bandwidth_size is not None:
            pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if cross_vpc_backend is not None:
            pulumi.set(__self__, "cross_vpc_backend", cross_vpc_backend)
        if deletion_protection_enable is not None:
            pulumi.set(__self__, "deletion_protection_enable", deletion_protection_enable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if elb_virsubnet_type is not None:
            pulumi.set(__self__, "elb_virsubnet_type", elb_virsubnet_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if frozen_scene is not None:
            pulumi.set(__self__, "frozen_scene", frozen_scene)
        if guaranteed is not None:
            pulumi.set(__self__, "guaranteed", guaranteed)
        if gw_flavor_id is not None:
            pulumi.set(__self__, "gw_flavor_id", gw_flavor_id)
        if iptype is not None:
            pulumi.set(__self__, "iptype", iptype)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_eip is not None:
            pulumi.set(__self__, "ipv4_eip", ipv4_eip)
        if ipv4_eip_id is not None:
            pulumi.set(__self__, "ipv4_eip_id", ipv4_eip_id)
        if ipv4_port_id is not None:
            pulumi.set(__self__, "ipv4_port_id", ipv4_port_id)
        if ipv4_subnet_id is not None:
            pulumi.set(__self__, "ipv4_subnet_id", ipv4_subnet_id)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_bandwidth_id is not None:
            pulumi.set(__self__, "ipv6_bandwidth_id", ipv6_bandwidth_id)
        if ipv6_eip is not None:
            pulumi.set(__self__, "ipv6_eip", ipv6_eip)
        if ipv6_eip_id is not None:
            pulumi.set(__self__, "ipv6_eip_id", ipv6_eip_id)
        if ipv6_network_id is not None:
            pulumi.set(__self__, "ipv6_network_id", ipv6_network_id)
        if l4_flavor_id is not None:
            pulumi.set(__self__, "l4_flavor_id", l4_flavor_id)
        if l7_flavor_id is not None:
            pulumi.set(__self__, "l7_flavor_id", l7_flavor_id)
        if loadbalancer_type is not None:
            pulumi.set(__self__, "loadbalancer_type", loadbalancer_type)
        if min_l7_flavor_id is not None:
            pulumi.set(__self__, "min_l7_flavor_id", min_l7_flavor_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operating_status is not None:
            pulumi.set(__self__, "operating_status", operating_status)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if protection_reason is not None:
            pulumi.set(__self__, "protection_reason", protection_reason)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if public_border_group is not None:
            pulumi.set(__self__, "public_border_group", public_border_group)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sharetype is not None:
            pulumi.set(__self__, "sharetype", sharetype)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if waf_failure_action is not None:
            pulumi.set(__self__, "waf_failure_action", waf_failure_action)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoscalingEnabled")
    def autoscaling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether autoscaling is enabled. Valid values are **true** and
        **false**.
        """
        return pulumi.get(self, "autoscaling_enabled")

    @autoscaling_enabled.setter
    def autoscaling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "autoscaling_enabled", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of AZ names. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="backendSubnets")
    def backend_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "backend_subnets")

    @backend_subnets.setter
    def backend_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "backend_subnets", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthChargeMode")
    def bandwidth_charge_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bandwidth billing type. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "bandwidth_charge_mode")

    @bandwidth_charge_mode.setter
    def bandwidth_charge_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_charge_mode", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthId")
    def bandwidth_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "bandwidth_id")

    @bandwidth_id.setter
    def bandwidth_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_id", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Bandwidth size. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bandwidth_size")

    @bandwidth_size.setter
    def bandwidth_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth_size", value)

    @_builtins.property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charge_mode")

    @charge_mode.setter
    def charge_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_mode", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="crossVpcBackend")
    def cross_vpc_backend(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable this if you want to associate the IP addresses of backend servers with
        your load balancer. Can only be true when updating.
        """
        return pulumi.get(self, "cross_vpc_backend")

    @cross_vpc_backend.setter
    def cross_vpc_backend(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_vpc_backend", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnable")
    def deletion_protection_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection_enable")

    @deletion_protection_enable.setter
    def deletion_protection_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the loadbalancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="elbVirsubnetType")
    def elb_virsubnet_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "elb_virsubnet_type")

    @elb_virsubnet_type.setter
    def elb_virsubnet_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "elb_virsubnet_type", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the loadbalancer. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="frozenScene")
    def frozen_scene(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "frozen_scene")

    @frozen_scene.setter
    def frozen_scene(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frozen_scene", value)

    @_builtins.property
    @pulumi.getter
    def guaranteed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "guaranteed")

    @guaranteed.setter
    def guaranteed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "guaranteed", value)

    @_builtins.property
    @pulumi.getter(name="gwFlavorId")
    def gw_flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "gw_flavor_id")

    @gw_flavor_id.setter
    def gw_flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gw_flavor_id", value)

    @_builtins.property
    @pulumi.getter
    def iptype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Elastic IP type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "iptype")

    @iptype.setter
    def iptype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iptype", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ipv4 address of the load balancer.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Eip")
    def ipv4_eip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ipv4 eip address of the Load Balancer.
        """
        return pulumi.get(self, "ipv4_eip")

    @ipv4_eip.setter
    def ipv4_eip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_eip", value)

    @_builtins.property
    @pulumi.getter(name="ipv4EipId")
    def ipv4_eip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the EIP. Changing this parameter will create a new resource.

        > **NOTE:** If the ipv4_eip_id parameter is configured, you do not need to configure the bandwidth parameters:
        `iptype`, `bandwidth_charge_mode`, `bandwidth_size` and `share_type`.
        """
        return pulumi.get(self, "ipv4_eip_id")

    @ipv4_eip_id.setter
    def ipv4_eip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_eip_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv4PortId")
    def ipv4_port_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ipv4_port_id")

    @ipv4_port_id.setter
    def ipv4_port_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_port_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv4SubnetId")
    def ipv4_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The **IPv4 subnet ID** of the subnet on which to allocate the loadbalancer's
        ipv4 address.
        """
        return pulumi.get(self, "ipv4_subnet_id")

    @ipv4_subnet_id.setter
    def ipv4_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ipv6 address of the Load Balancer.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @_builtins.property
    @pulumi.getter(name="ipv6BandwidthId")
    def ipv6_bandwidth_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ipv6 bandwidth id. Only support shared bandwidth.
        """
        return pulumi.get(self, "ipv6_bandwidth_id")

    @ipv6_bandwidth_id.setter
    def ipv6_bandwidth_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_bandwidth_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Eip")
    def ipv6_eip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ipv6 eip address of the Load Balancer.
        """
        return pulumi.get(self, "ipv6_eip")

    @ipv6_eip.setter
    def ipv6_eip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_eip", value)

    @_builtins.property
    @pulumi.getter(name="ipv6EipId")
    def ipv6_eip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ipv6 eip id of the Load Balancer.
        """
        return pulumi.get(self, "ipv6_eip_id")

    @ipv6_eip_id.setter
    def ipv6_eip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_eip_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6NetworkId")
    def ipv6_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The **ID** of the subnet on which to allocate the loadbalancer's ipv6 address.
        """
        return pulumi.get(self, "ipv6_network_id")

    @ipv6_network_id.setter
    def ipv6_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_network_id", value)

    @_builtins.property
    @pulumi.getter(name="l4FlavorId")
    def l4_flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The L4 flavor id of the load balancer.
        """
        return pulumi.get(self, "l4_flavor_id")

    @l4_flavor_id.setter
    def l4_flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "l4_flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="l7FlavorId")
    def l7_flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The L7 flavor id of the load balancer.
        """
        return pulumi.get(self, "l7_flavor_id")

    @l7_flavor_id.setter
    def l7_flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "l7_flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerType")
    def loadbalancer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "loadbalancer_type")

    @loadbalancer_type.setter
    def loadbalancer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_type", value)

    @_builtins.property
    @pulumi.getter(name="minL7FlavorId")
    def min_l7_flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the minimum Layer-7 flavor for elastic scaling.
        This parameter cannot be left blank if there are HTTP or HTTPS listeners.
        """
        return pulumi.get(self, "min_l7_flavor_id")

    @min_l7_flavor_id.setter
    def min_l7_flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_l7_flavor_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the loadbalancer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="operatingStatus")
    def operating_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "operating_status")

    @operating_status.setter
    def operating_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operating_status", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @protection_reason.setter
    def protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_status", value)

    @_builtins.property
    @pulumi.getter(name="publicBorderGroup")
    def public_border_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_border_group")

    @public_border_group.setter
    def public_border_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_border_group", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the loadbalancer resource. If omitted, the
        provider-level region will be used. Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def sharetype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bandwidth sharing type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "sharetype")

    @sharetype.setter
    def sharetype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sharetype", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the loadbalancer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vpc on which to create the loadbalancer. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="wafFailureAction")
    def waf_failure_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "waf_failure_action")

    @waf_failure_action.setter
    def waf_failure_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "waf_failure_action", value)


@pulumi.type_token("sbercloud:index/elbLoadbalancer:ElbLoadbalancer")
class ElbLoadbalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 autoscaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_vpc_backend: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 iptype: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 l4_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 l7_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 min_l7_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sharetype: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 waf_failure_action: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Dedicated Load Balancer resource within SberCloud.

        ## Example Usage

        ### Basic Loadbalancer

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        basic = sbercloud.ElbLoadbalancer("basic",
            name="basic",
            description="basic example",
            cross_vpc_backend=True,
            vpc_id="{{ vpc_id }}",
            ipv4_subnet_id="{{ ipv4_subnet_id }}",
            l4_flavor_id="{{ l4_flavor_id }}",
            l7_flavor_id="{{ l7_flavor_id }}",
            availability_zones=[
                "ru-moscow-1a",
                "ru-moscow-1b",
            ],
            enterprise_project_id="{{ eps_id }}")
        ```

        ### Loadbalancer With Existing EIP

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        basic = sbercloud.ElbLoadbalancer("basic",
            name="basic",
            description="basic example",
            cross_vpc_backend=True,
            vpc_id="{{ vpc_id }}",
            ipv6_network_id="{{ ipv6_network_id }}",
            ipv6_bandwidth_id="{{ ipv6_bandwidth_id }}",
            ipv4_subnet_id="{{ ipv4_subnet_id }}",
            l4_flavor_id="{{ l4_flavor_id }}",
            l7_flavor_id="{{ l7_flavor_id }}",
            availability_zones=[
                "ru-moscow-1a",
                "ru-moscow-1b",
            ],
            enterprise_project_id="{{ eps_id }}",
            ipv4_eip_id="{{ eip_id }}")
        ```

        ### Loadbalancer With EIP

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        basic = sbercloud.ElbLoadbalancer("basic",
            name="basic",
            description="basic example",
            cross_vpc_backend=True,
            vpc_id="{{ vpc_id }}",
            ipv6_network_id="{{ ipv6_network_id }}",
            ipv6_bandwidth_id="{{ ipv6_bandwidth_id }}",
            ipv4_subnet_id="{{ ipv4_subnet_id }}",
            l4_flavor_id="{{ l4_flavor_id }}",
            l7_flavor_id="{{ l7_flavor_id }}",
            availability_zones=[
                "ru-moscow-1a",
                "ru-moscow-1b",
            ],
            enterprise_project_id="{{ eps_id }}",
            iptype="5_bgp",
            bandwidth_charge_mode="traffic",
            sharetype="PER",
            bandwidth_size=10)
        ```

        ## Import

        ELB loadbalancer can be imported using the loadbalancer ID, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbLoadbalancer:ElbLoadbalancer loadbalancer_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `ipv6_bandwidth_id`, `iptype`,

        `bandwidth_charge_mode`, `sharetype` and `bandwidth_size`.

        It is generally recommended running `pulumi preview` after importing a loadbalancer.

        You can then decide if changes should be applied to the loadbalancer, or the resource

        definition should be updated to align with the loadbalancer. Also you can ignore changes as below.

        resource "sbercloud_elb_loadbalancer" "loadbalancer_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              ipv6_bandwidth_id, iptype, bandwidth_charge_mode, sharetype, bandwidth_size,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        :param pulumi.Input[_builtins.bool] autoscaling_enabled: Specifies whether autoscaling is enabled. Valid values are **true** and
               **false**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the list of AZ names. Changing this parameter will create a
               new resource.
        :param pulumi.Input[_builtins.str] bandwidth_charge_mode: Bandwidth billing type. Changing this parameter will create a
               new resource.
        :param pulumi.Input[_builtins.int] bandwidth_size: Bandwidth size. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] cross_vpc_backend: Enable this if you want to associate the IP addresses of backend servers with
               your load balancer. Can only be true when updating.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[_builtins.str] iptype: Elastic IP type. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ipv4_address: The ipv4 address of the load balancer.
        :param pulumi.Input[_builtins.str] ipv4_eip_id: The ID of the EIP. Changing this parameter will create a new resource.
               
               > **NOTE:** If the ipv4_eip_id parameter is configured, you do not need to configure the bandwidth parameters:
               `iptype`, `bandwidth_charge_mode`, `bandwidth_size` and `share_type`.
        :param pulumi.Input[_builtins.str] ipv4_subnet_id: The **IPv4 subnet ID** of the subnet on which to allocate the loadbalancer's
               ipv4 address.
        :param pulumi.Input[_builtins.str] ipv6_address: The ipv6 address of the Load Balancer.
        :param pulumi.Input[_builtins.str] ipv6_bandwidth_id: The ipv6 bandwidth id. Only support shared bandwidth.
        :param pulumi.Input[_builtins.str] ipv6_network_id: The **ID** of the subnet on which to allocate the loadbalancer's ipv6 address.
        :param pulumi.Input[_builtins.str] l4_flavor_id: The L4 flavor id of the load balancer.
        :param pulumi.Input[_builtins.str] l7_flavor_id: The L7 flavor id of the load balancer.
        :param pulumi.Input[_builtins.str] min_l7_flavor_id: Specifies the ID of the minimum Layer-7 flavor for elastic scaling.
               This parameter cannot be left blank if there are HTTP or HTTPS listeners.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the loadbalancer.
        :param pulumi.Input[_builtins.str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[_builtins.str] sharetype: Bandwidth sharing type. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc on which to create the loadbalancer. Changing this creates a new
               loadbalancer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElbLoadbalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dedicated Load Balancer resource within SberCloud.

        ## Example Usage

        ### Basic Loadbalancer

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        basic = sbercloud.ElbLoadbalancer("basic",
            name="basic",
            description="basic example",
            cross_vpc_backend=True,
            vpc_id="{{ vpc_id }}",
            ipv4_subnet_id="{{ ipv4_subnet_id }}",
            l4_flavor_id="{{ l4_flavor_id }}",
            l7_flavor_id="{{ l7_flavor_id }}",
            availability_zones=[
                "ru-moscow-1a",
                "ru-moscow-1b",
            ],
            enterprise_project_id="{{ eps_id }}")
        ```

        ### Loadbalancer With Existing EIP

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        basic = sbercloud.ElbLoadbalancer("basic",
            name="basic",
            description="basic example",
            cross_vpc_backend=True,
            vpc_id="{{ vpc_id }}",
            ipv6_network_id="{{ ipv6_network_id }}",
            ipv6_bandwidth_id="{{ ipv6_bandwidth_id }}",
            ipv4_subnet_id="{{ ipv4_subnet_id }}",
            l4_flavor_id="{{ l4_flavor_id }}",
            l7_flavor_id="{{ l7_flavor_id }}",
            availability_zones=[
                "ru-moscow-1a",
                "ru-moscow-1b",
            ],
            enterprise_project_id="{{ eps_id }}",
            ipv4_eip_id="{{ eip_id }}")
        ```

        ### Loadbalancer With EIP

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        basic = sbercloud.ElbLoadbalancer("basic",
            name="basic",
            description="basic example",
            cross_vpc_backend=True,
            vpc_id="{{ vpc_id }}",
            ipv6_network_id="{{ ipv6_network_id }}",
            ipv6_bandwidth_id="{{ ipv6_bandwidth_id }}",
            ipv4_subnet_id="{{ ipv4_subnet_id }}",
            l4_flavor_id="{{ l4_flavor_id }}",
            l7_flavor_id="{{ l7_flavor_id }}",
            availability_zones=[
                "ru-moscow-1a",
                "ru-moscow-1b",
            ],
            enterprise_project_id="{{ eps_id }}",
            iptype="5_bgp",
            bandwidth_charge_mode="traffic",
            sharetype="PER",
            bandwidth_size=10)
        ```

        ## Import

        ELB loadbalancer can be imported using the loadbalancer ID, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbLoadbalancer:ElbLoadbalancer loadbalancer_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `ipv6_bandwidth_id`, `iptype`,

        `bandwidth_charge_mode`, `sharetype` and `bandwidth_size`.

        It is generally recommended running `pulumi preview` after importing a loadbalancer.

        You can then decide if changes should be applied to the loadbalancer, or the resource

        definition should be updated to align with the loadbalancer. Also you can ignore changes as below.

        resource "sbercloud_elb_loadbalancer" "loadbalancer_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              ipv6_bandwidth_id, iptype, bandwidth_charge_mode, sharetype, bandwidth_size,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param ElbLoadbalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElbLoadbalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 autoscaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_vpc_backend: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 iptype: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 l4_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 l7_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 min_l7_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sharetype: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 waf_failure_action: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElbLoadbalancerArgs.__new__(ElbLoadbalancerArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["autoscaling_enabled"] = autoscaling_enabled
            if availability_zones is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zones'")
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["backend_subnets"] = backend_subnets
            __props__.__dict__["bandwidth_charge_mode"] = bandwidth_charge_mode
            __props__.__dict__["bandwidth_id"] = bandwidth_id
            __props__.__dict__["bandwidth_size"] = bandwidth_size
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["cross_vpc_backend"] = cross_vpc_backend
            __props__.__dict__["deletion_protection_enable"] = deletion_protection_enable
            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["iptype"] = iptype
            __props__.__dict__["ipv4_address"] = ipv4_address
            __props__.__dict__["ipv4_eip_id"] = ipv4_eip_id
            __props__.__dict__["ipv4_subnet_id"] = ipv4_subnet_id
            __props__.__dict__["ipv6_address"] = ipv6_address
            __props__.__dict__["ipv6_bandwidth_id"] = ipv6_bandwidth_id
            __props__.__dict__["ipv6_network_id"] = ipv6_network_id
            __props__.__dict__["l4_flavor_id"] = l4_flavor_id
            __props__.__dict__["l7_flavor_id"] = l7_flavor_id
            __props__.__dict__["loadbalancer_type"] = loadbalancer_type
            __props__.__dict__["min_l7_flavor_id"] = min_l7_flavor_id
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["protection_reason"] = protection_reason
            __props__.__dict__["protection_status"] = protection_status
            __props__.__dict__["region"] = region
            __props__.__dict__["sharetype"] = sharetype
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["waf_failure_action"] = waf_failure_action
            __props__.__dict__["charge_mode"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["elb_virsubnet_type"] = None
            __props__.__dict__["frozen_scene"] = None
            __props__.__dict__["guaranteed"] = None
            __props__.__dict__["gw_flavor_id"] = None
            __props__.__dict__["ipv4_eip"] = None
            __props__.__dict__["ipv4_port_id"] = None
            __props__.__dict__["ipv6_eip"] = None
            __props__.__dict__["ipv6_eip_id"] = None
            __props__.__dict__["operating_status"] = None
            __props__.__dict__["public_border_group"] = None
            __props__.__dict__["updated_at"] = None
        super(ElbLoadbalancer, __self__).__init__(
            'sbercloud:index/elbLoadbalancer:ElbLoadbalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            autoscaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backend_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bandwidth_charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
            charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            cross_vpc_backend: Optional[pulumi.Input[_builtins.bool]] = None,
            deletion_protection_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            elb_virsubnet_type: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            frozen_scene: Optional[pulumi.Input[_builtins.str]] = None,
            guaranteed: Optional[pulumi.Input[_builtins.bool]] = None,
            gw_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
            iptype: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_eip: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_port_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_eip: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_eip_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            l4_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
            l7_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
            loadbalancer_type: Optional[pulumi.Input[_builtins.str]] = None,
            min_l7_flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            operating_status: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
            protection_status: Optional[pulumi.Input[_builtins.str]] = None,
            public_border_group: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            sharetype: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            waf_failure_action: Optional[pulumi.Input[_builtins.str]] = None) -> 'ElbLoadbalancer':
        """
        Get an existing ElbLoadbalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        :param pulumi.Input[_builtins.bool] autoscaling_enabled: Specifies whether autoscaling is enabled. Valid values are **true** and
               **false**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the list of AZ names. Changing this parameter will create a
               new resource.
        :param pulumi.Input[_builtins.str] bandwidth_charge_mode: Bandwidth billing type. Changing this parameter will create a
               new resource.
        :param pulumi.Input[_builtins.int] bandwidth_size: Bandwidth size. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] cross_vpc_backend: Enable this if you want to associate the IP addresses of backend servers with
               your load balancer. Can only be true when updating.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[_builtins.str] iptype: Elastic IP type. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ipv4_address: The ipv4 address of the load balancer.
        :param pulumi.Input[_builtins.str] ipv4_eip: The ipv4 eip address of the Load Balancer.
        :param pulumi.Input[_builtins.str] ipv4_eip_id: The ID of the EIP. Changing this parameter will create a new resource.
               
               > **NOTE:** If the ipv4_eip_id parameter is configured, you do not need to configure the bandwidth parameters:
               `iptype`, `bandwidth_charge_mode`, `bandwidth_size` and `share_type`.
        :param pulumi.Input[_builtins.str] ipv4_subnet_id: The **IPv4 subnet ID** of the subnet on which to allocate the loadbalancer's
               ipv4 address.
        :param pulumi.Input[_builtins.str] ipv6_address: The ipv6 address of the Load Balancer.
        :param pulumi.Input[_builtins.str] ipv6_bandwidth_id: The ipv6 bandwidth id. Only support shared bandwidth.
        :param pulumi.Input[_builtins.str] ipv6_eip: The ipv6 eip address of the Load Balancer.
        :param pulumi.Input[_builtins.str] ipv6_eip_id: The ipv6 eip id of the Load Balancer.
        :param pulumi.Input[_builtins.str] ipv6_network_id: The **ID** of the subnet on which to allocate the loadbalancer's ipv6 address.
        :param pulumi.Input[_builtins.str] l4_flavor_id: The L4 flavor id of the load balancer.
        :param pulumi.Input[_builtins.str] l7_flavor_id: The L7 flavor id of the load balancer.
        :param pulumi.Input[_builtins.str] min_l7_flavor_id: Specifies the ID of the minimum Layer-7 flavor for elastic scaling.
               This parameter cannot be left blank if there are HTTP or HTTPS listeners.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the loadbalancer.
        :param pulumi.Input[_builtins.str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[_builtins.str] sharetype: Bandwidth sharing type. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc on which to create the loadbalancer. Changing this creates a new
               loadbalancer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElbLoadbalancerState.__new__(_ElbLoadbalancerState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["autoscaling_enabled"] = autoscaling_enabled
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["backend_subnets"] = backend_subnets
        __props__.__dict__["bandwidth_charge_mode"] = bandwidth_charge_mode
        __props__.__dict__["bandwidth_id"] = bandwidth_id
        __props__.__dict__["bandwidth_size"] = bandwidth_size
        __props__.__dict__["charge_mode"] = charge_mode
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["cross_vpc_backend"] = cross_vpc_backend
        __props__.__dict__["deletion_protection_enable"] = deletion_protection_enable
        __props__.__dict__["description"] = description
        __props__.__dict__["elb_virsubnet_type"] = elb_virsubnet_type
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["frozen_scene"] = frozen_scene
        __props__.__dict__["guaranteed"] = guaranteed
        __props__.__dict__["gw_flavor_id"] = gw_flavor_id
        __props__.__dict__["iptype"] = iptype
        __props__.__dict__["ipv4_address"] = ipv4_address
        __props__.__dict__["ipv4_eip"] = ipv4_eip
        __props__.__dict__["ipv4_eip_id"] = ipv4_eip_id
        __props__.__dict__["ipv4_port_id"] = ipv4_port_id
        __props__.__dict__["ipv4_subnet_id"] = ipv4_subnet_id
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["ipv6_bandwidth_id"] = ipv6_bandwidth_id
        __props__.__dict__["ipv6_eip"] = ipv6_eip
        __props__.__dict__["ipv6_eip_id"] = ipv6_eip_id
        __props__.__dict__["ipv6_network_id"] = ipv6_network_id
        __props__.__dict__["l4_flavor_id"] = l4_flavor_id
        __props__.__dict__["l7_flavor_id"] = l7_flavor_id
        __props__.__dict__["loadbalancer_type"] = loadbalancer_type
        __props__.__dict__["min_l7_flavor_id"] = min_l7_flavor_id
        __props__.__dict__["name"] = name
        __props__.__dict__["operating_status"] = operating_status
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["protection_reason"] = protection_reason
        __props__.__dict__["protection_status"] = protection_status
        __props__.__dict__["public_border_group"] = public_border_group
        __props__.__dict__["region"] = region
        __props__.__dict__["sharetype"] = sharetype
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["waf_failure_action"] = waf_failure_action
        return ElbLoadbalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoscalingEnabled")
    def autoscaling_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether autoscaling is enabled. Valid values are **true** and
        **false**.
        """
        return pulumi.get(self, "autoscaling_enabled")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of AZ names. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="backendSubnets")
    def backend_subnets(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "backend_subnets")

    @_builtins.property
    @pulumi.getter(name="bandwidthChargeMode")
    def bandwidth_charge_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Bandwidth billing type. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "bandwidth_charge_mode")

    @_builtins.property
    @pulumi.getter(name="bandwidthId")
    def bandwidth_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "bandwidth_id")

    @_builtins.property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> pulumi.Output[_builtins.int]:
        """
        Bandwidth size. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bandwidth_size")

    @_builtins.property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "charge_mode")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="crossVpcBackend")
    def cross_vpc_backend(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable this if you want to associate the IP addresses of backend servers with
        your load balancer. Can only be true when updating.
        """
        return pulumi.get(self, "cross_vpc_backend")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnable")
    def deletion_protection_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection_enable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable description for the loadbalancer.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="elbVirsubnetType")
    def elb_virsubnet_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "elb_virsubnet_type")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project id of the loadbalancer. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="frozenScene")
    def frozen_scene(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "frozen_scene")

    @_builtins.property
    @pulumi.getter
    def guaranteed(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "guaranteed")

    @_builtins.property
    @pulumi.getter(name="gwFlavorId")
    def gw_flavor_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "gw_flavor_id")

    @_builtins.property
    @pulumi.getter
    def iptype(self) -> pulumi.Output[_builtins.str]:
        """
        Elastic IP type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "iptype")

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> pulumi.Output[_builtins.str]:
        """
        The ipv4 address of the load balancer.
        """
        return pulumi.get(self, "ipv4_address")

    @_builtins.property
    @pulumi.getter(name="ipv4Eip")
    def ipv4_eip(self) -> pulumi.Output[_builtins.str]:
        """
        The ipv4 eip address of the Load Balancer.
        """
        return pulumi.get(self, "ipv4_eip")

    @_builtins.property
    @pulumi.getter(name="ipv4EipId")
    def ipv4_eip_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the EIP. Changing this parameter will create a new resource.

        > **NOTE:** If the ipv4_eip_id parameter is configured, you do not need to configure the bandwidth parameters:
        `iptype`, `bandwidth_charge_mode`, `bandwidth_size` and `share_type`.
        """
        return pulumi.get(self, "ipv4_eip_id")

    @_builtins.property
    @pulumi.getter(name="ipv4PortId")
    def ipv4_port_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ipv4_port_id")

    @_builtins.property
    @pulumi.getter(name="ipv4SubnetId")
    def ipv4_subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The **IPv4 subnet ID** of the subnet on which to allocate the loadbalancer's
        ipv4 address.
        """
        return pulumi.get(self, "ipv4_subnet_id")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[_builtins.str]:
        """
        The ipv6 address of the Load Balancer.
        """
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter(name="ipv6BandwidthId")
    def ipv6_bandwidth_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ipv6 bandwidth id. Only support shared bandwidth.
        """
        return pulumi.get(self, "ipv6_bandwidth_id")

    @_builtins.property
    @pulumi.getter(name="ipv6Eip")
    def ipv6_eip(self) -> pulumi.Output[_builtins.str]:
        """
        The ipv6 eip address of the Load Balancer.
        """
        return pulumi.get(self, "ipv6_eip")

    @_builtins.property
    @pulumi.getter(name="ipv6EipId")
    def ipv6_eip_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ipv6 eip id of the Load Balancer.
        """
        return pulumi.get(self, "ipv6_eip_id")

    @_builtins.property
    @pulumi.getter(name="ipv6NetworkId")
    def ipv6_network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The **ID** of the subnet on which to allocate the loadbalancer's ipv6 address.
        """
        return pulumi.get(self, "ipv6_network_id")

    @_builtins.property
    @pulumi.getter(name="l4FlavorId")
    def l4_flavor_id(self) -> pulumi.Output[_builtins.str]:
        """
        The L4 flavor id of the load balancer.
        """
        return pulumi.get(self, "l4_flavor_id")

    @_builtins.property
    @pulumi.getter(name="l7FlavorId")
    def l7_flavor_id(self) -> pulumi.Output[_builtins.str]:
        """
        The L7 flavor id of the load balancer.
        """
        return pulumi.get(self, "l7_flavor_id")

    @_builtins.property
    @pulumi.getter(name="loadbalancerType")
    def loadbalancer_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "loadbalancer_type")

    @_builtins.property
    @pulumi.getter(name="minL7FlavorId")
    def min_l7_flavor_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the minimum Layer-7 flavor for elastic scaling.
        This parameter cannot be left blank if there are HTTP or HTTPS listeners.
        """
        return pulumi.get(self, "min_l7_flavor_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable name for the loadbalancer.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="operatingStatus")
    def operating_status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "operating_status")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "protection_status")

    @_builtins.property
    @pulumi.getter(name="publicBorderGroup")
    def public_border_group(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "public_border_group")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the loadbalancer resource. If omitted, the
        provider-level region will be used. Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def sharetype(self) -> pulumi.Output[_builtins.str]:
        """
        Bandwidth sharing type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "sharetype")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the loadbalancer.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The vpc on which to create the loadbalancer. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="wafFailureAction")
    def waf_failure_action(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "waf_failure_action")

