# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ElbMemberArgs', 'ElbMember']

@pulumi.input_type
class ElbMemberArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[_builtins.str],
                 pool_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ElbMember resource.
        :param pulumi.Input[_builtins.str] address: The IP address of the member to receive traffic from the load balancer.
               Changing this creates a new member.
        :param pulumi.Input[_builtins.str] pool_id: The id of the pool that this member will be assigned to.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the member.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new member.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB member resource. If omitted, the the
               provider-level region will be used. Changing this creates a new member.
        :param pulumi.Input[_builtins.str] subnet_id: The **IPv4 or IPv6 subnet ID** of the subnet in which to access the member.
               + The IPv4 or IPv6 subnet must be in the same VPC as the subnet of the load balancer.
               + If this parameter is not specified, **cross-VPC backend** has been enabled for the load balancer.
               In this case, cross-VPC backend servers must use private IPv4 addresses,
               and the protocol of the backend server group must be TCP, HTTP, or HTTPS.
        :param pulumi.Input[_builtins.int] weight: A positive integer value that indicates the relative portion of traffic that this member
               should receive from the pool. For example, a member with a weight of 10 receives five times as much traffic as a
               member with a weight of 2.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "pool_id", pool_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol_port is not None:
            pulumi.set(__self__, "protocol_port", protocol_port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address of the member to receive traffic from the load balancer.
        Changing this creates a new member.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the pool that this member will be assigned to.
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pool_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the member.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new member.
        """
        return pulumi.get(self, "protocol_port")

    @protocol_port.setter
    def protocol_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "protocol_port", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the ELB member resource. If omitted, the the
        provider-level region will be used. Changing this creates a new member.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The **IPv4 or IPv6 subnet ID** of the subnet in which to access the member.
        + The IPv4 or IPv6 subnet must be in the same VPC as the subnet of the load balancer.
        + If this parameter is not specified, **cross-VPC backend** has been enabled for the load balancer.
        In this case, cross-VPC backend servers must use private IPv4 addresses,
        and the protocol of the backend server group must be TCP, HTTP, or HTTPS.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A positive integer value that indicates the relative portion of traffic that this member
        should receive from the pool. For example, a member with a weight of 10 receives five times as much traffic as a
        member with a weight of 2.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class _ElbMemberState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 member_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operating_status: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 reasons: Optional[pulumi.Input[Sequence[pulumi.Input['ElbMemberReasonArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ElbMemberStatusArgs']]]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ElbMember resources.
        :param pulumi.Input[_builtins.str] address: The IP address of the member to receive traffic from the load balancer.
               Changing this creates a new member.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the member.
        :param pulumi.Input[_builtins.str] pool_id: The id of the pool that this member will be assigned to.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new member.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB member resource. If omitted, the the
               provider-level region will be used. Changing this creates a new member.
        :param pulumi.Input[_builtins.str] subnet_id: The **IPv4 or IPv6 subnet ID** of the subnet in which to access the member.
               + The IPv4 or IPv6 subnet must be in the same VPC as the subnet of the load balancer.
               + If this parameter is not specified, **cross-VPC backend** has been enabled for the load balancer.
               In this case, cross-VPC backend servers must use private IPv4 addresses,
               and the protocol of the backend server group must be TCP, HTTP, or HTTPS.
        :param pulumi.Input[_builtins.int] weight: A positive integer value that indicates the relative portion of traffic that this member
               should receive from the pool. For example, a member with a weight of 10 receives five times as much traffic as a
               member with a weight of 2.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if member_type is not None:
            pulumi.set(__self__, "member_type", member_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operating_status is not None:
            pulumi.set(__self__, "operating_status", operating_status)
        if pool_id is not None:
            pulumi.set(__self__, "pool_id", pool_id)
        if protocol_port is not None:
            pulumi.set(__self__, "protocol_port", protocol_port)
        if reasons is not None:
            pulumi.set(__self__, "reasons", reasons)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the member to receive traffic from the load balancer.
        Changing this creates a new member.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="memberType")
    def member_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "member_type")

    @member_type.setter
    def member_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "member_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the member.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="operatingStatus")
    def operating_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "operating_status")

    @operating_status.setter
    def operating_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operating_status", value)

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the pool that this member will be assigned to.
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_id", value)

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new member.
        """
        return pulumi.get(self, "protocol_port")

    @protocol_port.setter
    def protocol_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "protocol_port", value)

    @_builtins.property
    @pulumi.getter
    def reasons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElbMemberReasonArgs']]]]:
        return pulumi.get(self, "reasons")

    @reasons.setter
    def reasons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElbMemberReasonArgs']]]]):
        pulumi.set(self, "reasons", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the ELB member resource. If omitted, the the
        provider-level region will be used. Changing this creates a new member.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElbMemberStatusArgs']]]]:
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElbMemberStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The **IPv4 or IPv6 subnet ID** of the subnet in which to access the member.
        + The IPv4 or IPv6 subnet must be in the same VPC as the subnet of the load balancer.
        + If this parameter is not specified, **cross-VPC backend** has been enabled for the load balancer.
        In this case, cross-VPC backend servers must use private IPv4 addresses,
        and the protocol of the backend server group must be TCP, HTTP, or HTTPS.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A positive integer value that indicates the relative portion of traffic that this member
        should receive from the pool. For example, a member with a weight of 10 receives five times as much traffic as a
        member with a weight of 2.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weight", value)


@pulumi.type_token("sbercloud:index/elbMember:ElbMember")
class ElbMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages an ELB member resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        elb_pool_id = config.require_object("elbPoolId")
        ipv4_subnet_id = config.require_object("ipv4SubnetId")
        member1 = sbercloud.ElbMember("member_1",
            address="192.168.199.23",
            protocol_port=8080,
            pool_id=elb_pool_id,
            subnet_id=ipv4_subnet_id)
        ```

        ## Import

        ELB member can be imported using the pool ID and member ID separated by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbMember:ElbMember member_1 e0bd694a-abbe-450e-b329-0931fd1cc5eb/4086b0c9-b18c-4d1c-b6b8-4c56c3ad2a9e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The IP address of the member to receive traffic from the load balancer.
               Changing this creates a new member.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the member.
        :param pulumi.Input[_builtins.str] pool_id: The id of the pool that this member will be assigned to.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new member.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB member resource. If omitted, the the
               provider-level region will be used. Changing this creates a new member.
        :param pulumi.Input[_builtins.str] subnet_id: The **IPv4 or IPv6 subnet ID** of the subnet in which to access the member.
               + The IPv4 or IPv6 subnet must be in the same VPC as the subnet of the load balancer.
               + If this parameter is not specified, **cross-VPC backend** has been enabled for the load balancer.
               In this case, cross-VPC backend servers must use private IPv4 addresses,
               and the protocol of the backend server group must be TCP, HTTP, or HTTPS.
        :param pulumi.Input[_builtins.int] weight: A positive integer value that indicates the relative portion of traffic that this member
               should receive from the pool. For example, a member with a weight of 10 receives five times as much traffic as a
               member with a weight of 2.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElbMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB member resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        elb_pool_id = config.require_object("elbPoolId")
        ipv4_subnet_id = config.require_object("ipv4SubnetId")
        member1 = sbercloud.ElbMember("member_1",
            address="192.168.199.23",
            protocol_port=8080,
            pool_id=elb_pool_id,
            subnet_id=ipv4_subnet_id)
        ```

        ## Import

        ELB member can be imported using the pool ID and member ID separated by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbMember:ElbMember member_1 e0bd694a-abbe-450e-b329-0931fd1cc5eb/4086b0c9-b18c-4d1c-b6b8-4c56c3ad2a9e
        ```

        :param str resource_name: The name of the resource.
        :param ElbMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElbMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElbMemberArgs.__new__(ElbMemberArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            __props__.__dict__["name"] = name
            if pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'pool_id'")
            __props__.__dict__["pool_id"] = pool_id
            __props__.__dict__["protocol_port"] = protocol_port
            __props__.__dict__["region"] = region
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["weight"] = weight
            __props__.__dict__["created_at"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["ip_version"] = None
            __props__.__dict__["member_type"] = None
            __props__.__dict__["operating_status"] = None
            __props__.__dict__["reasons"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["updated_at"] = None
        super(ElbMember, __self__).__init__(
            'sbercloud:index/elbMember:ElbMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            member_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            operating_status: Optional[pulumi.Input[_builtins.str]] = None,
            pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
            reasons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbMemberReasonArgs', 'ElbMemberReasonArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbMemberStatusArgs', 'ElbMemberStatusArgsDict']]]]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            weight: Optional[pulumi.Input[_builtins.int]] = None) -> 'ElbMember':
        """
        Get an existing ElbMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The IP address of the member to receive traffic from the load balancer.
               Changing this creates a new member.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the member.
        :param pulumi.Input[_builtins.str] pool_id: The id of the pool that this member will be assigned to.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new member.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB member resource. If omitted, the the
               provider-level region will be used. Changing this creates a new member.
        :param pulumi.Input[_builtins.str] subnet_id: The **IPv4 or IPv6 subnet ID** of the subnet in which to access the member.
               + The IPv4 or IPv6 subnet must be in the same VPC as the subnet of the load balancer.
               + If this parameter is not specified, **cross-VPC backend** has been enabled for the load balancer.
               In this case, cross-VPC backend servers must use private IPv4 addresses,
               and the protocol of the backend server group must be TCP, HTTP, or HTTPS.
        :param pulumi.Input[_builtins.int] weight: A positive integer value that indicates the relative portion of traffic that this member
               should receive from the pool. For example, a member with a weight of 10 receives five times as much traffic as a
               member with a weight of 2.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElbMemberState.__new__(_ElbMemberState)

        __props__.__dict__["address"] = address
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["member_type"] = member_type
        __props__.__dict__["name"] = name
        __props__.__dict__["operating_status"] = operating_status
        __props__.__dict__["pool_id"] = pool_id
        __props__.__dict__["protocol_port"] = protocol_port
        __props__.__dict__["reasons"] = reasons
        __props__.__dict__["region"] = region
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["weight"] = weight
        return ElbMember(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the member to receive traffic from the load balancer.
        Changing this creates a new member.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="memberType")
    def member_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "member_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable name for the member.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="operatingStatus")
    def operating_status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "operating_status")

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the pool that this member will be assigned to.
        """
        return pulumi.get(self, "pool_id")

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> pulumi.Output[_builtins.int]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new member.
        """
        return pulumi.get(self, "protocol_port")

    @_builtins.property
    @pulumi.getter
    def reasons(self) -> pulumi.Output[Sequence['outputs.ElbMemberReason']]:
        return pulumi.get(self, "reasons")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the ELB member resource. If omitted, the the
        provider-level region will be used. Changing this creates a new member.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.ElbMemberStatus']]:
        return pulumi.get(self, "statuses")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The **IPv4 or IPv6 subnet ID** of the subnet in which to access the member.
        + The IPv4 or IPv6 subnet must be in the same VPC as the subnet of the load balancer.
        + If this parameter is not specified, **cross-VPC backend** has been enabled for the load balancer.
        In this case, cross-VPC backend servers must use private IPv4 addresses,
        and the protocol of the backend server group must be TCP, HTTP, or HTTPS.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> pulumi.Output[_builtins.int]:
        """
        A positive integer value that indicates the relative portion of traffic that this member
        should receive from the pool. For example, a member with a weight of 10 receives five times as much traffic as a
        member with a weight of 2.
        """
        return pulumi.get(self, "weight")

