# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ElbMonitorArgs', 'ElbMonitor']

@pulumi.input_type
class ElbMonitorArgs:
    def __init__(__self__, *,
                 interval: pulumi.Input[_builtins.int],
                 max_retries: pulumi.Input[_builtins.int],
                 pool_id: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 timeout: pulumi.Input[_builtins.int],
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status_code: Optional[pulumi.Input[_builtins.str]] = None,
                 url_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ElbMonitor resource.
        :param pulumi.Input[_builtins.int] interval: Specifies the interval between health checks, in seconds.
               Value ranges from **1** to **50**.
        :param pulumi.Input[_builtins.int] max_retries: Specifies the number of consecutive health checks when the health check result of
               a backend server changes from OFFLINE to ONLINE. Value ranges from **1** to **50**.
        :param pulumi.Input[_builtins.str] pool_id: Specifies the ID of the backend server group for which the health check is
               configured. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.str] protocol: Specifies the health check protocol. Value options: **TCP**, **UDP_CONNECT**,
               **HTTP**, or **HTTPS**.
               + If the protocol of the backend server is **QUIC**, the value can only be **UDP_CONNECT**.
               + If the protocol of the backend server is **UDP**, the value can only be **UDP_CONNECT**.
               + If the protocol of the backend server is **TCP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
               + If the protocol of the backend server is **HTTP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
               + If the protocol of the backend server is **HTTPS**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
        :param pulumi.Input[_builtins.int] timeout: Specifies the maximum time required for waiting for a response from the health check,
               in seconds. Value ranges from **1** to **50**. It is recommended that you set the value less than that of
               parameter `interval`.
        :param pulumi.Input[_builtins.str] domain_name: Specifies the domain name that HTTP requests are sent to during the health check.
               The domain name consists of 1 to 100 characters, can contain only digits, letters, hyphens (-), and periods (.) and
               must start with a digit or letter. The value is left blank by default, indicating that the virtual IP address of the
               load balancer is used as the destination address of HTTP requests. This parameter is available only when `protocol`
               is set to **HTTP** or **HTTPS**.
        :param pulumi.Input[_builtins.int] port: Specifies the port used for the health check. If this parameter is left blank, a port of
               the backend server will be used by default.  Value ranges from **1** to **65535**.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB monitor resource. If omitted, the
               provider-level region will be used. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.str] status_code: Specifies the expected HTTP status code. This parameter will take effect only when
               `protocol` is set to **HTTP** or **HTTPS**. Value options are as follows:
               + A specific value, for example: **200**.
               + A list of values that are separated with commas (,), for example: **200,202**.
               + A value range, for example: **200-204**.
               
               Defaults to **200**.
        :param pulumi.Input[_builtins.str] url_path: Specifies the HTTP request path for the health check. The value must start with a
               slash (/), can contain letters, digits, hyphens (-), slash (/), periods (.), percent signs (%), hashes(#), and(&)
               and the special characters: `~!()*[]@$^:',+`, and the default value is **/**. This parameter is available only when
               `protocol` is set to **HTTP** or **HTTPS**.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "max_retries", max_retries)
        pulumi.set(__self__, "pool_id", pool_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "timeout", timeout)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the interval between health checks, in seconds.
        Value ranges from **1** to **50**.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the number of consecutive health checks when the health check result of
        a backend server changes from OFFLINE to ONLINE. Value ranges from **1** to **50**.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the backend server group for which the health check is
        configured. Changing this creates a new monitor.
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pool_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the health check protocol. Value options: **TCP**, **UDP_CONNECT**,
        **HTTP**, or **HTTPS**.
        + If the protocol of the backend server is **QUIC**, the value can only be **UDP_CONNECT**.
        + If the protocol of the backend server is **UDP**, the value can only be **UDP_CONNECT**.
        + If the protocol of the backend server is **TCP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
        + If the protocol of the backend server is **HTTP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
        + If the protocol of the backend server is **HTTPS**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the maximum time required for waiting for a response from the health check,
        in seconds. Value ranges from **1** to **50**. It is recommended that you set the value less than that of
        parameter `interval`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the domain name that HTTP requests are sent to during the health check.
        The domain name consists of 1 to 100 characters, can contain only digits, letters, hyphens (-), and periods (.) and
        must start with a digit or letter. The value is left blank by default, indicating that the virtual IP address of the
        load balancer is used as the destination address of HTTP requests. This parameter is available only when `protocol`
        is set to **HTTP** or **HTTPS**.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the port used for the health check. If this parameter is left blank, a port of
        the backend server will be used by default.  Value ranges from **1** to **65535**.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the ELB monitor resource. If omitted, the
        provider-level region will be used. Changing this creates a new monitor.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the expected HTTP status code. This parameter will take effect only when
        `protocol` is set to **HTTP** or **HTTPS**. Value options are as follows:
        + A specific value, for example: **200**.
        + A list of values that are separated with commas (,), for example: **200,202**.
        + A value range, for example: **200-204**.

        Defaults to **200**.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_code", value)

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the HTTP request path for the health check. The value must start with a
        slash (/), can contain letters, digits, hyphens (-), slash (/), periods (.), percent signs (%), hashes(#), and(&)
        and the special characters: `~!()*[]@$^:',+`, and the default value is **/**. This parameter is available only when
        `protocol` is set to **HTTP** or **HTTPS**.
        """
        return pulumi.get(self, "url_path")

    @url_path.setter
    def url_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url_path", value)


@pulumi.input_type
class _ElbMonitorState:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status_code: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 url_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ElbMonitor resources.
        :param pulumi.Input[_builtins.str] domain_name: Specifies the domain name that HTTP requests are sent to during the health check.
               The domain name consists of 1 to 100 characters, can contain only digits, letters, hyphens (-), and periods (.) and
               must start with a digit or letter. The value is left blank by default, indicating that the virtual IP address of the
               load balancer is used as the destination address of HTTP requests. This parameter is available only when `protocol`
               is set to **HTTP** or **HTTPS**.
        :param pulumi.Input[_builtins.int] interval: Specifies the interval between health checks, in seconds.
               Value ranges from **1** to **50**.
        :param pulumi.Input[_builtins.int] max_retries: Specifies the number of consecutive health checks when the health check result of
               a backend server changes from OFFLINE to ONLINE. Value ranges from **1** to **50**.
        :param pulumi.Input[_builtins.str] pool_id: Specifies the ID of the backend server group for which the health check is
               configured. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.int] port: Specifies the port used for the health check. If this parameter is left blank, a port of
               the backend server will be used by default.  Value ranges from **1** to **65535**.
        :param pulumi.Input[_builtins.str] protocol: Specifies the health check protocol. Value options: **TCP**, **UDP_CONNECT**,
               **HTTP**, or **HTTPS**.
               + If the protocol of the backend server is **QUIC**, the value can only be **UDP_CONNECT**.
               + If the protocol of the backend server is **UDP**, the value can only be **UDP_CONNECT**.
               + If the protocol of the backend server is **TCP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
               + If the protocol of the backend server is **HTTP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
               + If the protocol of the backend server is **HTTPS**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB monitor resource. If omitted, the
               provider-level region will be used. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.str] status_code: Specifies the expected HTTP status code. This parameter will take effect only when
               `protocol` is set to **HTTP** or **HTTPS**. Value options are as follows:
               + A specific value, for example: **200**.
               + A list of values that are separated with commas (,), for example: **200,202**.
               + A value range, for example: **200-204**.
               
               Defaults to **200**.
        :param pulumi.Input[_builtins.int] timeout: Specifies the maximum time required for waiting for a response from the health check,
               in seconds. Value ranges from **1** to **50**. It is recommended that you set the value less than that of
               parameter `interval`.
        :param pulumi.Input[_builtins.str] url_path: Specifies the HTTP request path for the health check. The value must start with a
               slash (/), can contain letters, digits, hyphens (-), slash (/), periods (.), percent signs (%), hashes(#), and(&)
               and the special characters: `~!()*[]@$^:',+`, and the default value is **/**. This parameter is available only when
               `protocol` is set to **HTTP** or **HTTPS**.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if pool_id is not None:
            pulumi.set(__self__, "pool_id", pool_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the domain name that HTTP requests are sent to during the health check.
        The domain name consists of 1 to 100 characters, can contain only digits, letters, hyphens (-), and periods (.) and
        must start with a digit or letter. The value is left blank by default, indicating that the virtual IP address of the
        load balancer is used as the destination address of HTTP requests. This parameter is available only when `protocol`
        is set to **HTTP** or **HTTPS**.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the interval between health checks, in seconds.
        Value ranges from **1** to **50**.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of consecutive health checks when the health check result of
        a backend server changes from OFFLINE to ONLINE. Value ranges from **1** to **50**.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the backend server group for which the health check is
        configured. Changing this creates a new monitor.
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_id", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the port used for the health check. If this parameter is left blank, a port of
        the backend server will be used by default.  Value ranges from **1** to **65535**.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the health check protocol. Value options: **TCP**, **UDP_CONNECT**,
        **HTTP**, or **HTTPS**.
        + If the protocol of the backend server is **QUIC**, the value can only be **UDP_CONNECT**.
        + If the protocol of the backend server is **UDP**, the value can only be **UDP_CONNECT**.
        + If the protocol of the backend server is **TCP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
        + If the protocol of the backend server is **HTTP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
        + If the protocol of the backend server is **HTTPS**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the ELB monitor resource. If omitted, the
        provider-level region will be used. Changing this creates a new monitor.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the expected HTTP status code. This parameter will take effect only when
        `protocol` is set to **HTTP** or **HTTPS**. Value options are as follows:
        + A specific value, for example: **200**.
        + A list of values that are separated with commas (,), for example: **200,202**.
        + A value range, for example: **200-204**.

        Defaults to **200**.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_code", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum time required for waiting for a response from the health check,
        in seconds. Value ranges from **1** to **50**. It is recommended that you set the value less than that of
        parameter `interval`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the HTTP request path for the health check. The value must start with a
        slash (/), can contain letters, digits, hyphens (-), slash (/), periods (.), percent signs (%), hashes(#), and(&)
        and the special characters: `~!()*[]@$^:',+`, and the default value is **/**. This parameter is available only when
        `protocol` is set to **HTTP** or **HTTPS**.
        """
        return pulumi.get(self, "url_path")

    @url_path.setter
    def url_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url_path", value)


@pulumi.type_token("sbercloud:index/elbMonitor:ElbMonitor")
class ElbMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status_code: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 url_path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an ELB monitor resource within Cloud.ru.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        pool_id = config.require_object("poolId")
        monitor1 = sbercloud.ElbMonitor("monitor_1",
            pool_id=pool_id,
            protocol="HTTPS",
            interval=30,
            timeout=20,
            max_retries=8,
            url_path="/bb",
            domain_name="www.bb.com",
            port=8888,
            status_code="200,301,404-500,504")
        ```

        ## Import

        ELB monitor can be imported using the monitor `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/elbMonitor:ElbMonitor test <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_name: Specifies the domain name that HTTP requests are sent to during the health check.
               The domain name consists of 1 to 100 characters, can contain only digits, letters, hyphens (-), and periods (.) and
               must start with a digit or letter. The value is left blank by default, indicating that the virtual IP address of the
               load balancer is used as the destination address of HTTP requests. This parameter is available only when `protocol`
               is set to **HTTP** or **HTTPS**.
        :param pulumi.Input[_builtins.int] interval: Specifies the interval between health checks, in seconds.
               Value ranges from **1** to **50**.
        :param pulumi.Input[_builtins.int] max_retries: Specifies the number of consecutive health checks when the health check result of
               a backend server changes from OFFLINE to ONLINE. Value ranges from **1** to **50**.
        :param pulumi.Input[_builtins.str] pool_id: Specifies the ID of the backend server group for which the health check is
               configured. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.int] port: Specifies the port used for the health check. If this parameter is left blank, a port of
               the backend server will be used by default.  Value ranges from **1** to **65535**.
        :param pulumi.Input[_builtins.str] protocol: Specifies the health check protocol. Value options: **TCP**, **UDP_CONNECT**,
               **HTTP**, or **HTTPS**.
               + If the protocol of the backend server is **QUIC**, the value can only be **UDP_CONNECT**.
               + If the protocol of the backend server is **UDP**, the value can only be **UDP_CONNECT**.
               + If the protocol of the backend server is **TCP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
               + If the protocol of the backend server is **HTTP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
               + If the protocol of the backend server is **HTTPS**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB monitor resource. If omitted, the
               provider-level region will be used. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.str] status_code: Specifies the expected HTTP status code. This parameter will take effect only when
               `protocol` is set to **HTTP** or **HTTPS**. Value options are as follows:
               + A specific value, for example: **200**.
               + A list of values that are separated with commas (,), for example: **200,202**.
               + A value range, for example: **200-204**.
               
               Defaults to **200**.
        :param pulumi.Input[_builtins.int] timeout: Specifies the maximum time required for waiting for a response from the health check,
               in seconds. Value ranges from **1** to **50**. It is recommended that you set the value less than that of
               parameter `interval`.
        :param pulumi.Input[_builtins.str] url_path: Specifies the HTTP request path for the health check. The value must start with a
               slash (/), can contain letters, digits, hyphens (-), slash (/), periods (.), percent signs (%), hashes(#), and(&)
               and the special characters: `~!()*[]@$^:',+`, and the default value is **/**. This parameter is available only when
               `protocol` is set to **HTTP** or **HTTPS**.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElbMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB monitor resource within Cloud.ru.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        pool_id = config.require_object("poolId")
        monitor1 = sbercloud.ElbMonitor("monitor_1",
            pool_id=pool_id,
            protocol="HTTPS",
            interval=30,
            timeout=20,
            max_retries=8,
            url_path="/bb",
            domain_name="www.bb.com",
            port=8888,
            status_code="200,301,404-500,504")
        ```

        ## Import

        ELB monitor can be imported using the monitor `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/elbMonitor:ElbMonitor test <id>
        ```

        :param str resource_name: The name of the resource.
        :param ElbMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElbMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status_code: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 url_path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElbMonitorArgs.__new__(ElbMonitorArgs)

            __props__.__dict__["domain_name"] = domain_name
            if interval is None and not opts.urn:
                raise TypeError("Missing required property 'interval'")
            __props__.__dict__["interval"] = interval
            if max_retries is None and not opts.urn:
                raise TypeError("Missing required property 'max_retries'")
            __props__.__dict__["max_retries"] = max_retries
            if pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'pool_id'")
            __props__.__dict__["pool_id"] = pool_id
            __props__.__dict__["port"] = port
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["status_code"] = status_code
            if timeout is None and not opts.urn:
                raise TypeError("Missing required property 'timeout'")
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["url_path"] = url_path
        super(ElbMonitor, __self__).__init__(
            'sbercloud:index/elbMonitor:ElbMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            interval: Optional[pulumi.Input[_builtins.int]] = None,
            max_retries: Optional[pulumi.Input[_builtins.int]] = None,
            pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status_code: Optional[pulumi.Input[_builtins.str]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            url_path: Optional[pulumi.Input[_builtins.str]] = None) -> 'ElbMonitor':
        """
        Get an existing ElbMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_name: Specifies the domain name that HTTP requests are sent to during the health check.
               The domain name consists of 1 to 100 characters, can contain only digits, letters, hyphens (-), and periods (.) and
               must start with a digit or letter. The value is left blank by default, indicating that the virtual IP address of the
               load balancer is used as the destination address of HTTP requests. This parameter is available only when `protocol`
               is set to **HTTP** or **HTTPS**.
        :param pulumi.Input[_builtins.int] interval: Specifies the interval between health checks, in seconds.
               Value ranges from **1** to **50**.
        :param pulumi.Input[_builtins.int] max_retries: Specifies the number of consecutive health checks when the health check result of
               a backend server changes from OFFLINE to ONLINE. Value ranges from **1** to **50**.
        :param pulumi.Input[_builtins.str] pool_id: Specifies the ID of the backend server group for which the health check is
               configured. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.int] port: Specifies the port used for the health check. If this parameter is left blank, a port of
               the backend server will be used by default.  Value ranges from **1** to **65535**.
        :param pulumi.Input[_builtins.str] protocol: Specifies the health check protocol. Value options: **TCP**, **UDP_CONNECT**,
               **HTTP**, or **HTTPS**.
               + If the protocol of the backend server is **QUIC**, the value can only be **UDP_CONNECT**.
               + If the protocol of the backend server is **UDP**, the value can only be **UDP_CONNECT**.
               + If the protocol of the backend server is **TCP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
               + If the protocol of the backend server is **HTTP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
               + If the protocol of the backend server is **HTTPS**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB monitor resource. If omitted, the
               provider-level region will be used. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.str] status_code: Specifies the expected HTTP status code. This parameter will take effect only when
               `protocol` is set to **HTTP** or **HTTPS**. Value options are as follows:
               + A specific value, for example: **200**.
               + A list of values that are separated with commas (,), for example: **200,202**.
               + A value range, for example: **200-204**.
               
               Defaults to **200**.
        :param pulumi.Input[_builtins.int] timeout: Specifies the maximum time required for waiting for a response from the health check,
               in seconds. Value ranges from **1** to **50**. It is recommended that you set the value less than that of
               parameter `interval`.
        :param pulumi.Input[_builtins.str] url_path: Specifies the HTTP request path for the health check. The value must start with a
               slash (/), can contain letters, digits, hyphens (-), slash (/), periods (.), percent signs (%), hashes(#), and(&)
               and the special characters: `~!()*[]@$^:',+`, and the default value is **/**. This parameter is available only when
               `protocol` is set to **HTTP** or **HTTPS**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElbMonitorState.__new__(_ElbMonitorState)

        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["interval"] = interval
        __props__.__dict__["max_retries"] = max_retries
        __props__.__dict__["pool_id"] = pool_id
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["status_code"] = status_code
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["url_path"] = url_path
        return ElbMonitor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the domain name that HTTP requests are sent to during the health check.
        The domain name consists of 1 to 100 characters, can contain only digits, letters, hyphens (-), and periods (.) and
        must start with a digit or letter. The value is left blank by default, indicating that the virtual IP address of the
        load balancer is used as the destination address of HTTP requests. This parameter is available only when `protocol`
        is set to **HTTP** or **HTTPS**.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the interval between health checks, in seconds.
        Value ranges from **1** to **50**.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of consecutive health checks when the health check result of
        a backend server changes from OFFLINE to ONLINE. Value ranges from **1** to **50**.
        """
        return pulumi.get(self, "max_retries")

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the backend server group for which the health check is
        configured. Changing this creates a new monitor.
        """
        return pulumi.get(self, "pool_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the port used for the health check. If this parameter is left blank, a port of
        the backend server will be used by default.  Value ranges from **1** to **65535**.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the health check protocol. Value options: **TCP**, **UDP_CONNECT**,
        **HTTP**, or **HTTPS**.
        + If the protocol of the backend server is **QUIC**, the value can only be **UDP_CONNECT**.
        + If the protocol of the backend server is **UDP**, the value can only be **UDP_CONNECT**.
        + If the protocol of the backend server is **TCP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
        + If the protocol of the backend server is **HTTP**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
        + If the protocol of the backend server is **HTTPS**, the value can only be **TCP**, **HTTP**, or **HTTPS**.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the ELB monitor resource. If omitted, the
        provider-level region will be used. Changing this creates a new monitor.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the expected HTTP status code. This parameter will take effect only when
        `protocol` is set to **HTTP** or **HTTPS**. Value options are as follows:
        + A specific value, for example: **200**.
        + A list of values that are separated with commas (,), for example: **200,202**.
        + A value range, for example: **200-204**.

        Defaults to **200**.
        """
        return pulumi.get(self, "status_code")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum time required for waiting for a response from the health check,
        in seconds. Value ranges from **1** to **50**. It is recommended that you set the value less than that of
        parameter `interval`.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the HTTP request path for the health check. The value must start with a
        slash (/), can contain letters, digits, hyphens (-), slash (/), periods (.), percent signs (%), hashes(#), and(&)
        and the special characters: `~!()*[]@$^:',+`, and the default value is **/**. This parameter is available only when
        `protocol` is set to **HTTP** or **HTTPS**.
        """
        return pulumi.get(self, "url_path")

