# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ElbPoolArgs', 'ElbPool']

@pulumi.input_type
class ElbPoolArgs:
    def __init__(__self__, *,
                 lb_method: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 any_port_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_drain_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_drain_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 deletion_protection_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_healthy_member_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence: Optional[pulumi.Input['ElbPoolPersistenceArgs']] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 public_border_group: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_start_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 slow_start_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ElbPool resource.
        :param pulumi.Input[_builtins.str] lb_method: The load balancing algorithm to distribute traffic to the pool's members. Must be one
               of ROUND_ROBIN, LEAST_CONNECTIONS, or SOURCE_IP.
        :param pulumi.Input[_builtins.str] protocol: The protocol - can either be TCP, UDP, HTTP, HTTPS or QUIC.
               
               + When the protocol used by the listener is UDP, the protocol of the backend pool must be UDP or QUIC.
               + When the protocol used by the listener is TCP, the protocol of the backend pool must be TCP.
               + When the protocol used by the listener is HTTP, the protocol of the backend pool must be HTTP.
               + When the protocol used by the listener is HTTPS, the protocol of the backend pool must be HTTPS.
               + When the protocol used by the listener is TERMINATED_HTTPS, the protocol of the backend pool must be HTTP.
               
               Changing this creates a new pool.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the pool.
        :param pulumi.Input[_builtins.str] listener_id: The Listener on which the members of the pool will be associated with.
               Changing this creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this pool. Changing this
               creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the pool.
        :param pulumi.Input['ElbPoolPersistenceArgs'] persistence: Omit this field to prevent session persistence. Indicates whether
               connections in the same session will be processed by the same Pool member or not. Changing this creates a new pool.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB pool resource. If omitted, the the
               provider-level region will be used. Changing this creates a new pool.
        """
        pulumi.set(__self__, "lb_method", lb_method)
        pulumi.set(__self__, "protocol", protocol)
        if any_port_enable is not None:
            pulumi.set(__self__, "any_port_enable", any_port_enable)
        if connection_drain_enabled is not None:
            pulumi.set(__self__, "connection_drain_enabled", connection_drain_enabled)
        if connection_drain_timeout is not None:
            pulumi.set(__self__, "connection_drain_timeout", connection_drain_timeout)
        if deletion_protection_enable is not None:
            pulumi.set(__self__, "deletion_protection_enable", deletion_protection_enable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if loadbalancer_id is not None:
            pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if minimum_healthy_member_count is not None:
            pulumi.set(__self__, "minimum_healthy_member_count", minimum_healthy_member_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if persistence is not None:
            pulumi.set(__self__, "persistence", persistence)
        if protection_reason is not None:
            pulumi.set(__self__, "protection_reason", protection_reason)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if public_border_group is not None:
            pulumi.set(__self__, "public_border_group", public_border_group)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if slow_start_duration is not None:
            pulumi.set(__self__, "slow_start_duration", slow_start_duration)
        if slow_start_enabled is not None:
            pulumi.set(__self__, "slow_start_enabled", slow_start_enabled)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="lbMethod")
    def lb_method(self) -> pulumi.Input[_builtins.str]:
        """
        The load balancing algorithm to distribute traffic to the pool's members. Must be one
        of ROUND_ROBIN, LEAST_CONNECTIONS, or SOURCE_IP.
        """
        return pulumi.get(self, "lb_method")

    @lb_method.setter
    def lb_method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lb_method", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The protocol - can either be TCP, UDP, HTTP, HTTPS or QUIC.

        + When the protocol used by the listener is UDP, the protocol of the backend pool must be UDP or QUIC.
        + When the protocol used by the listener is TCP, the protocol of the backend pool must be TCP.
        + When the protocol used by the listener is HTTP, the protocol of the backend pool must be HTTP.
        + When the protocol used by the listener is HTTPS, the protocol of the backend pool must be HTTPS.
        + When the protocol used by the listener is TERMINATED_HTTPS, the protocol of the backend pool must be HTTP.

        Changing this creates a new pool.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="anyPortEnable")
    def any_port_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "any_port_enable")

    @any_port_enable.setter
    def any_port_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "any_port_enable", value)

    @_builtins.property
    @pulumi.getter(name="connectionDrainEnabled")
    def connection_drain_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "connection_drain_enabled")

    @connection_drain_enabled.setter
    def connection_drain_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "connection_drain_enabled", value)

    @_builtins.property
    @pulumi.getter(name="connectionDrainTimeout")
    def connection_drain_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "connection_drain_timeout")

    @connection_drain_timeout.setter
    def connection_drain_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_drain_timeout", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnable")
    def deletion_protection_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection_enable")

    @deletion_protection_enable.setter
    def deletion_protection_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the pool.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Listener on which the members of the pool will be associated with.
        Changing this creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load balancer on which to provision this pool. Changing this
        creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter(name="minimumHealthyMemberCount")
    def minimum_healthy_member_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "minimum_healthy_member_count")

    @minimum_healthy_member_count.setter
    def minimum_healthy_member_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_healthy_member_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def persistence(self) -> Optional[pulumi.Input['ElbPoolPersistenceArgs']]:
        """
        Omit this field to prevent session persistence. Indicates whether
        connections in the same session will be processed by the same Pool member or not. Changing this creates a new pool.
        """
        return pulumi.get(self, "persistence")

    @persistence.setter
    def persistence(self, value: Optional[pulumi.Input['ElbPoolPersistenceArgs']]):
        pulumi.set(self, "persistence", value)

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @protection_reason.setter
    def protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_status", value)

    @_builtins.property
    @pulumi.getter(name="publicBorderGroup")
    def public_border_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_border_group")

    @public_border_group.setter
    def public_border_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_border_group", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the ELB pool resource. If omitted, the the
        provider-level region will be used. Changing this creates a new pool.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="slowStartDuration")
    def slow_start_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "slow_start_duration")

    @slow_start_duration.setter
    def slow_start_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slow_start_duration", value)

    @_builtins.property
    @pulumi.getter(name="slowStartEnabled")
    def slow_start_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "slow_start_enabled")

    @slow_start_enabled.setter
    def slow_start_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "slow_start_enabled", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _ElbPoolState:
    def __init__(__self__, *,
                 any_port_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_drain_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_drain_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 lb_method: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_healthy_member_count: Optional[pulumi.Input[_builtins.int]] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence: Optional[pulumi.Input['ElbPoolPersistenceArgs']] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 public_border_group: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_start_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 slow_start_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ElbPool resources.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the pool.
        :param pulumi.Input[_builtins.str] lb_method: The load balancing algorithm to distribute traffic to the pool's members. Must be one
               of ROUND_ROBIN, LEAST_CONNECTIONS, or SOURCE_IP.
        :param pulumi.Input[_builtins.str] listener_id: The Listener on which the members of the pool will be associated with.
               Changing this creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this pool. Changing this
               creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the pool.
        :param pulumi.Input['ElbPoolPersistenceArgs'] persistence: Omit this field to prevent session persistence. Indicates whether
               connections in the same session will be processed by the same Pool member or not. Changing this creates a new pool.
        :param pulumi.Input[_builtins.str] protocol: The protocol - can either be TCP, UDP, HTTP, HTTPS or QUIC.
               
               + When the protocol used by the listener is UDP, the protocol of the backend pool must be UDP or QUIC.
               + When the protocol used by the listener is TCP, the protocol of the backend pool must be TCP.
               + When the protocol used by the listener is HTTP, the protocol of the backend pool must be HTTP.
               + When the protocol used by the listener is HTTPS, the protocol of the backend pool must be HTTPS.
               + When the protocol used by the listener is TERMINATED_HTTPS, the protocol of the backend pool must be HTTP.
               
               Changing this creates a new pool.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB pool resource. If omitted, the the
               provider-level region will be used. Changing this creates a new pool.
        """
        if any_port_enable is not None:
            pulumi.set(__self__, "any_port_enable", any_port_enable)
        if connection_drain_enabled is not None:
            pulumi.set(__self__, "connection_drain_enabled", connection_drain_enabled)
        if connection_drain_timeout is not None:
            pulumi.set(__self__, "connection_drain_timeout", connection_drain_timeout)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletion_protection_enable is not None:
            pulumi.set(__self__, "deletion_protection_enable", deletion_protection_enable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if lb_method is not None:
            pulumi.set(__self__, "lb_method", lb_method)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if loadbalancer_id is not None:
            pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if minimum_healthy_member_count is not None:
            pulumi.set(__self__, "minimum_healthy_member_count", minimum_healthy_member_count)
        if monitor_id is not None:
            pulumi.set(__self__, "monitor_id", monitor_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if persistence is not None:
            pulumi.set(__self__, "persistence", persistence)
        if protection_reason is not None:
            pulumi.set(__self__, "protection_reason", protection_reason)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if public_border_group is not None:
            pulumi.set(__self__, "public_border_group", public_border_group)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if slow_start_duration is not None:
            pulumi.set(__self__, "slow_start_duration", slow_start_duration)
        if slow_start_enabled is not None:
            pulumi.set(__self__, "slow_start_enabled", slow_start_enabled)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="anyPortEnable")
    def any_port_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "any_port_enable")

    @any_port_enable.setter
    def any_port_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "any_port_enable", value)

    @_builtins.property
    @pulumi.getter(name="connectionDrainEnabled")
    def connection_drain_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "connection_drain_enabled")

    @connection_drain_enabled.setter
    def connection_drain_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "connection_drain_enabled", value)

    @_builtins.property
    @pulumi.getter(name="connectionDrainTimeout")
    def connection_drain_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "connection_drain_timeout")

    @connection_drain_timeout.setter
    def connection_drain_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_drain_timeout", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnable")
    def deletion_protection_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection_enable")

    @deletion_protection_enable.setter
    def deletion_protection_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the pool.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="lbMethod")
    def lb_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load balancing algorithm to distribute traffic to the pool's members. Must be one
        of ROUND_ROBIN, LEAST_CONNECTIONS, or SOURCE_IP.
        """
        return pulumi.get(self, "lb_method")

    @lb_method.setter
    def lb_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lb_method", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Listener on which the members of the pool will be associated with.
        Changing this creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load balancer on which to provision this pool. Changing this
        creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter(name="minimumHealthyMemberCount")
    def minimum_healthy_member_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "minimum_healthy_member_count")

    @minimum_healthy_member_count.setter
    def minimum_healthy_member_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_healthy_member_count", value)

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "monitor_id")

    @monitor_id.setter
    def monitor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def persistence(self) -> Optional[pulumi.Input['ElbPoolPersistenceArgs']]:
        """
        Omit this field to prevent session persistence. Indicates whether
        connections in the same session will be processed by the same Pool member or not. Changing this creates a new pool.
        """
        return pulumi.get(self, "persistence")

    @persistence.setter
    def persistence(self, value: Optional[pulumi.Input['ElbPoolPersistenceArgs']]):
        pulumi.set(self, "persistence", value)

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @protection_reason.setter
    def protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_status", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol - can either be TCP, UDP, HTTP, HTTPS or QUIC.

        + When the protocol used by the listener is UDP, the protocol of the backend pool must be UDP or QUIC.
        + When the protocol used by the listener is TCP, the protocol of the backend pool must be TCP.
        + When the protocol used by the listener is HTTP, the protocol of the backend pool must be HTTP.
        + When the protocol used by the listener is HTTPS, the protocol of the backend pool must be HTTPS.
        + When the protocol used by the listener is TERMINATED_HTTPS, the protocol of the backend pool must be HTTP.

        Changing this creates a new pool.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="publicBorderGroup")
    def public_border_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_border_group")

    @public_border_group.setter
    def public_border_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_border_group", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the ELB pool resource. If omitted, the the
        provider-level region will be used. Changing this creates a new pool.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="slowStartDuration")
    def slow_start_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "slow_start_duration")

    @slow_start_duration.setter
    def slow_start_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slow_start_duration", value)

    @_builtins.property
    @pulumi.getter(name="slowStartEnabled")
    def slow_start_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "slow_start_enabled")

    @slow_start_enabled.setter
    def slow_start_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "slow_start_enabled", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:index/elbPool:ElbPool")
class ElbPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 any_port_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_drain_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_drain_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 deletion_protection_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 lb_method: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_healthy_member_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence: Optional[pulumi.Input[Union['ElbPoolPersistenceArgs', 'ElbPoolPersistenceArgsDict']]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 public_border_group: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_start_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 slow_start_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an ELB pool resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        pool1 = sbercloud.ElbPool("pool_1",
            protocol="HTTP",
            lb_method="ROUND_ROBIN",
            listener_id="{{ listener_id }}",
            persistence={
                "type": "HTTP_COOKIE",
                "cookie_name": "testCookie",
            })
        ```

        ## Import

        ELB pool can be imported using the pool ID, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbPool:ElbPool pool_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the pool.
        :param pulumi.Input[_builtins.str] lb_method: The load balancing algorithm to distribute traffic to the pool's members. Must be one
               of ROUND_ROBIN, LEAST_CONNECTIONS, or SOURCE_IP.
        :param pulumi.Input[_builtins.str] listener_id: The Listener on which the members of the pool will be associated with.
               Changing this creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this pool. Changing this
               creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the pool.
        :param pulumi.Input[Union['ElbPoolPersistenceArgs', 'ElbPoolPersistenceArgsDict']] persistence: Omit this field to prevent session persistence. Indicates whether
               connections in the same session will be processed by the same Pool member or not. Changing this creates a new pool.
        :param pulumi.Input[_builtins.str] protocol: The protocol - can either be TCP, UDP, HTTP, HTTPS or QUIC.
               
               + When the protocol used by the listener is UDP, the protocol of the backend pool must be UDP or QUIC.
               + When the protocol used by the listener is TCP, the protocol of the backend pool must be TCP.
               + When the protocol used by the listener is HTTP, the protocol of the backend pool must be HTTP.
               + When the protocol used by the listener is HTTPS, the protocol of the backend pool must be HTTPS.
               + When the protocol used by the listener is TERMINATED_HTTPS, the protocol of the backend pool must be HTTP.
               
               Changing this creates a new pool.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB pool resource. If omitted, the the
               provider-level region will be used. Changing this creates a new pool.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElbPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB pool resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        pool1 = sbercloud.ElbPool("pool_1",
            protocol="HTTP",
            lb_method="ROUND_ROBIN",
            listener_id="{{ listener_id }}",
            persistence={
                "type": "HTTP_COOKIE",
                "cookie_name": "testCookie",
            })
        ```

        ## Import

        ELB pool can be imported using the pool ID, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbPool:ElbPool pool_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param ElbPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElbPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 any_port_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_drain_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_drain_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 deletion_protection_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 lb_method: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_healthy_member_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence: Optional[pulumi.Input[Union['ElbPoolPersistenceArgs', 'ElbPoolPersistenceArgsDict']]] = None,
                 protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 public_border_group: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_start_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 slow_start_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElbPoolArgs.__new__(ElbPoolArgs)

            __props__.__dict__["any_port_enable"] = any_port_enable
            __props__.__dict__["connection_drain_enabled"] = connection_drain_enabled
            __props__.__dict__["connection_drain_timeout"] = connection_drain_timeout
            __props__.__dict__["deletion_protection_enable"] = deletion_protection_enable
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_force_new"] = enable_force_new
            __props__.__dict__["ip_version"] = ip_version
            if lb_method is None and not opts.urn:
                raise TypeError("Missing required property 'lb_method'")
            __props__.__dict__["lb_method"] = lb_method
            __props__.__dict__["listener_id"] = listener_id
            __props__.__dict__["loadbalancer_id"] = loadbalancer_id
            __props__.__dict__["minimum_healthy_member_count"] = minimum_healthy_member_count
            __props__.__dict__["name"] = name
            __props__.__dict__["persistence"] = persistence
            __props__.__dict__["protection_reason"] = protection_reason
            __props__.__dict__["protection_status"] = protection_status
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["public_border_group"] = public_border_group
            __props__.__dict__["region"] = region
            __props__.__dict__["slow_start_duration"] = slow_start_duration
            __props__.__dict__["slow_start_enabled"] = slow_start_enabled
            __props__.__dict__["type"] = type
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["enterprise_project_id"] = None
            __props__.__dict__["monitor_id"] = None
            __props__.__dict__["updated_at"] = None
        super(ElbPool, __self__).__init__(
            'sbercloud:index/elbPool:ElbPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            any_port_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            connection_drain_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            connection_drain_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            lb_method: Optional[pulumi.Input[_builtins.str]] = None,
            listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            minimum_healthy_member_count: Optional[pulumi.Input[_builtins.int]] = None,
            monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            persistence: Optional[pulumi.Input[Union['ElbPoolPersistenceArgs', 'ElbPoolPersistenceArgsDict']]] = None,
            protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
            protection_status: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            public_border_group: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            slow_start_duration: Optional[pulumi.Input[_builtins.int]] = None,
            slow_start_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ElbPool':
        """
        Get an existing ElbPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the pool.
        :param pulumi.Input[_builtins.str] lb_method: The load balancing algorithm to distribute traffic to the pool's members. Must be one
               of ROUND_ROBIN, LEAST_CONNECTIONS, or SOURCE_IP.
        :param pulumi.Input[_builtins.str] listener_id: The Listener on which the members of the pool will be associated with.
               Changing this creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this pool. Changing this
               creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the pool.
        :param pulumi.Input[Union['ElbPoolPersistenceArgs', 'ElbPoolPersistenceArgsDict']] persistence: Omit this field to prevent session persistence. Indicates whether
               connections in the same session will be processed by the same Pool member or not. Changing this creates a new pool.
        :param pulumi.Input[_builtins.str] protocol: The protocol - can either be TCP, UDP, HTTP, HTTPS or QUIC.
               
               + When the protocol used by the listener is UDP, the protocol of the backend pool must be UDP or QUIC.
               + When the protocol used by the listener is TCP, the protocol of the backend pool must be TCP.
               + When the protocol used by the listener is HTTP, the protocol of the backend pool must be HTTP.
               + When the protocol used by the listener is HTTPS, the protocol of the backend pool must be HTTPS.
               + When the protocol used by the listener is TERMINATED_HTTPS, the protocol of the backend pool must be HTTP.
               
               Changing this creates a new pool.
        :param pulumi.Input[_builtins.str] region: The region in which to create the ELB pool resource. If omitted, the the
               provider-level region will be used. Changing this creates a new pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElbPoolState.__new__(_ElbPoolState)

        __props__.__dict__["any_port_enable"] = any_port_enable
        __props__.__dict__["connection_drain_enabled"] = connection_drain_enabled
        __props__.__dict__["connection_drain_timeout"] = connection_drain_timeout
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletion_protection_enable"] = deletion_protection_enable
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_force_new"] = enable_force_new
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["lb_method"] = lb_method
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["loadbalancer_id"] = loadbalancer_id
        __props__.__dict__["minimum_healthy_member_count"] = minimum_healthy_member_count
        __props__.__dict__["monitor_id"] = monitor_id
        __props__.__dict__["name"] = name
        __props__.__dict__["persistence"] = persistence
        __props__.__dict__["protection_reason"] = protection_reason
        __props__.__dict__["protection_status"] = protection_status
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["public_border_group"] = public_border_group
        __props__.__dict__["region"] = region
        __props__.__dict__["slow_start_duration"] = slow_start_duration
        __props__.__dict__["slow_start_enabled"] = slow_start_enabled
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["vpc_id"] = vpc_id
        return ElbPool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="anyPortEnable")
    def any_port_enable(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "any_port_enable")

    @_builtins.property
    @pulumi.getter(name="connectionDrainEnabled")
    def connection_drain_enabled(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "connection_drain_enabled")

    @_builtins.property
    @pulumi.getter(name="connectionDrainTimeout")
    def connection_drain_timeout(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "connection_drain_timeout")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnable")
    def deletion_protection_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection_enable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable description for the pool.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="lbMethod")
    def lb_method(self) -> pulumi.Output[_builtins.str]:
        """
        The load balancing algorithm to distribute traffic to the pool's members. Must be one
        of ROUND_ROBIN, LEAST_CONNECTIONS, or SOURCE_IP.
        """
        return pulumi.get(self, "lb_method")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Listener on which the members of the pool will be associated with.
        Changing this creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The load balancer on which to provision this pool. Changing this
        creates a new pool. Note:  Exactly one of LoadbalancerID or ListenerID must be provided.
        """
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter(name="minimumHealthyMemberCount")
    def minimum_healthy_member_count(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "minimum_healthy_member_count")

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "monitor_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable name for the pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def persistence(self) -> pulumi.Output[Optional['outputs.ElbPoolPersistence']]:
        """
        Omit this field to prevent session persistence. Indicates whether
        connections in the same session will be processed by the same Pool member or not. Changing this creates a new pool.
        """
        return pulumi.get(self, "persistence")

    @_builtins.property
    @pulumi.getter(name="protectionReason")
    def protection_reason(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "protection_reason")

    @_builtins.property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "protection_status")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol - can either be TCP, UDP, HTTP, HTTPS or QUIC.

        + When the protocol used by the listener is UDP, the protocol of the backend pool must be UDP or QUIC.
        + When the protocol used by the listener is TCP, the protocol of the backend pool must be TCP.
        + When the protocol used by the listener is HTTP, the protocol of the backend pool must be HTTP.
        + When the protocol used by the listener is HTTPS, the protocol of the backend pool must be HTTPS.
        + When the protocol used by the listener is TERMINATED_HTTPS, the protocol of the backend pool must be HTTP.

        Changing this creates a new pool.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="publicBorderGroup")
    def public_border_group(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "public_border_group")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the ELB pool resource. If omitted, the the
        provider-level region will be used. Changing this creates a new pool.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="slowStartDuration")
    def slow_start_duration(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "slow_start_duration")

    @_builtins.property
    @pulumi.getter(name="slowStartEnabled")
    def slow_start_enabled(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "slow_start_enabled")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "vpc_id")

