# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ElbSecurityPolicyArgs', 'ElbSecurityPolicy']

@pulumi.input_type
class ElbSecurityPolicyArgs:
    def __init__(__self__, *,
                 ciphers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 protocols: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ElbSecurityPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ciphers: Specifies the cipher suite list of the security policy.
               The protocol and cipher suite must match. That is to say, there must be at least one cipher suite in
               ciphers that matches the protocol. The following cipher suites are supported:
               **ECDHE-RSA-AES256-GCM-SHA384**, **ECDHE-RSA-AES128-GCM-SHA256**, **ECDHE-ECDSA-AES256-GCM-SHA384**,
               **ECDHE-ECDSA-AES128-GCM-SHA256**, **AES128-GCM-SHA256**, **AES256-GCM-SHA384**, **ECDHE-ECDSA-AES128-SHA256**,
               **ECDHE-RSA-AES128-SHA256**, **AES128-SHA256**, **AES256-SHA256**, **ECDHE-ECDSA-AES256-SHA384**,
               **ECDHE-RSA-AES256-SHA384**, **ECDHE-ECDSA-AES128-SHA**, **ECDHE-RSA-AES128-SHA**, **ECDHE-RSA-AES256-SHA**,
               **ECDHE-ECDSA-AES256-SHA**, **AES128-SHA**, **AES256-SHA**, **CAMELLIA128-SHA**, **DES-CBC3-SHA**,
               **CAMELLIA256-SHA**, **ECDHE-RSA-CHACHA20-POLY1305**, **ECDHE-ECDSA-CHACHA20-POLY1305**, **TLS_AES_128_GCM_SHA256**,
               **TLS_AES_256_GCM_SHA384**, **TLS_CHACHA20_POLY1305_SHA256**, **TLS_AES_128_CCM_SHA256**,
               **TLS_AES_128_CCM_8_SHA256**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: Specifies the TSL protocol list which the security policy select.
               Value options: **TLSv1**, **TLSv1.1**, **TLSv1.2**, and **TLSv1.3**.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the ELB security policy.
               The value can contain 0 to 255 characters.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID to which the Enterprise
               router belongs.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the ELB security policy name.
               The name contains only Chinese characters, letters, digits, underscores (_), and hyphens (-),
               and cannot exceed 255 characters.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "ciphers", ciphers)
        pulumi.set(__self__, "protocols", protocols)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def ciphers(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the cipher suite list of the security policy.
        The protocol and cipher suite must match. That is to say, there must be at least one cipher suite in
        ciphers that matches the protocol. The following cipher suites are supported:
        **ECDHE-RSA-AES256-GCM-SHA384**, **ECDHE-RSA-AES128-GCM-SHA256**, **ECDHE-ECDSA-AES256-GCM-SHA384**,
        **ECDHE-ECDSA-AES128-GCM-SHA256**, **AES128-GCM-SHA256**, **AES256-GCM-SHA384**, **ECDHE-ECDSA-AES128-SHA256**,
        **ECDHE-RSA-AES128-SHA256**, **AES128-SHA256**, **AES256-SHA256**, **ECDHE-ECDSA-AES256-SHA384**,
        **ECDHE-RSA-AES256-SHA384**, **ECDHE-ECDSA-AES128-SHA**, **ECDHE-RSA-AES128-SHA**, **ECDHE-RSA-AES256-SHA**,
        **ECDHE-ECDSA-AES256-SHA**, **AES128-SHA**, **AES256-SHA**, **CAMELLIA128-SHA**, **DES-CBC3-SHA**,
        **CAMELLIA256-SHA**, **ECDHE-RSA-CHACHA20-POLY1305**, **ECDHE-ECDSA-CHACHA20-POLY1305**, **TLS_AES_128_GCM_SHA256**,
        **TLS_AES_256_GCM_SHA384**, **TLS_CHACHA20_POLY1305_SHA256**, **TLS_AES_128_CCM_SHA256**,
        **TLS_AES_128_CCM_8_SHA256**.
        """
        return pulumi.get(self, "ciphers")

    @ciphers.setter
    def ciphers(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "ciphers", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the TSL protocol list which the security policy select.
        Value options: **TLSv1**, **TLSv1.1**, **TLSv1.2**, and **TLSv1.3**.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "protocols", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the ELB security policy.
        The value can contain 0 to 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID to which the Enterprise
        router belongs.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ELB security policy name.
        The name contains only Chinese characters, letters, digits, underscores (_), and hyphens (-),
        and cannot exceed 255 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ElbSecurityPolicyState:
    def __init__(__self__, *,
                 ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input['ElbSecurityPolicyListenerArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ElbSecurityPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ciphers: Specifies the cipher suite list of the security policy.
               The protocol and cipher suite must match. That is to say, there must be at least one cipher suite in
               ciphers that matches the protocol. The following cipher suites are supported:
               **ECDHE-RSA-AES256-GCM-SHA384**, **ECDHE-RSA-AES128-GCM-SHA256**, **ECDHE-ECDSA-AES256-GCM-SHA384**,
               **ECDHE-ECDSA-AES128-GCM-SHA256**, **AES128-GCM-SHA256**, **AES256-GCM-SHA384**, **ECDHE-ECDSA-AES128-SHA256**,
               **ECDHE-RSA-AES128-SHA256**, **AES128-SHA256**, **AES256-SHA256**, **ECDHE-ECDSA-AES256-SHA384**,
               **ECDHE-RSA-AES256-SHA384**, **ECDHE-ECDSA-AES128-SHA**, **ECDHE-RSA-AES128-SHA**, **ECDHE-RSA-AES256-SHA**,
               **ECDHE-ECDSA-AES256-SHA**, **AES128-SHA**, **AES256-SHA**, **CAMELLIA128-SHA**, **DES-CBC3-SHA**,
               **CAMELLIA256-SHA**, **ECDHE-RSA-CHACHA20-POLY1305**, **ECDHE-ECDSA-CHACHA20-POLY1305**, **TLS_AES_128_GCM_SHA256**,
               **TLS_AES_256_GCM_SHA384**, **TLS_CHACHA20_POLY1305_SHA256**, **TLS_AES_128_CCM_SHA256**,
               **TLS_AES_128_CCM_8_SHA256**.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the ELB security policy.
               The value can contain 0 to 255 characters.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID to which the Enterprise
               router belongs.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['ElbSecurityPolicyListenerArgs']]] listeners: The listener which the security policy associated with.
               The ListenerRef structure is documented below.
        :param pulumi.Input[_builtins.str] name: Specifies the ELB security policy name.
               The name contains only Chinese characters, letters, digits, underscores (_), and hyphens (-),
               and cannot exceed 255 characters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: Specifies the TSL protocol list which the security policy select.
               Value options: **TLSv1**, **TLSv1.1**, **TLSv1.2**, and **TLSv1.3**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        if ciphers is not None:
            pulumi.set(__self__, "ciphers", ciphers)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def ciphers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the cipher suite list of the security policy.
        The protocol and cipher suite must match. That is to say, there must be at least one cipher suite in
        ciphers that matches the protocol. The following cipher suites are supported:
        **ECDHE-RSA-AES256-GCM-SHA384**, **ECDHE-RSA-AES128-GCM-SHA256**, **ECDHE-ECDSA-AES256-GCM-SHA384**,
        **ECDHE-ECDSA-AES128-GCM-SHA256**, **AES128-GCM-SHA256**, **AES256-GCM-SHA384**, **ECDHE-ECDSA-AES128-SHA256**,
        **ECDHE-RSA-AES128-SHA256**, **AES128-SHA256**, **AES256-SHA256**, **ECDHE-ECDSA-AES256-SHA384**,
        **ECDHE-RSA-AES256-SHA384**, **ECDHE-ECDSA-AES128-SHA**, **ECDHE-RSA-AES128-SHA**, **ECDHE-RSA-AES256-SHA**,
        **ECDHE-ECDSA-AES256-SHA**, **AES128-SHA**, **AES256-SHA**, **CAMELLIA128-SHA**, **DES-CBC3-SHA**,
        **CAMELLIA256-SHA**, **ECDHE-RSA-CHACHA20-POLY1305**, **ECDHE-ECDSA-CHACHA20-POLY1305**, **TLS_AES_128_GCM_SHA256**,
        **TLS_AES_256_GCM_SHA384**, **TLS_CHACHA20_POLY1305_SHA256**, **TLS_AES_128_CCM_SHA256**,
        **TLS_AES_128_CCM_8_SHA256**.
        """
        return pulumi.get(self, "ciphers")

    @ciphers.setter
    def ciphers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ciphers", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the ELB security policy.
        The value can contain 0 to 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID to which the Enterprise
        router belongs.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElbSecurityPolicyListenerArgs']]]]:
        """
        The listener which the security policy associated with.
        The ListenerRef structure is documented below.
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElbSecurityPolicyListenerArgs']]]]):
        pulumi.set(self, "listeners", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ELB security policy name.
        The name contains only Chinese characters, letters, digits, underscores (_), and hyphens (-),
        and cannot exceed 255 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the TSL protocol list which the security policy select.
        Value options: **TLSv1**, **TLSv1.1**, **TLSv1.2**, and **TLSv1.3**.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protocols", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:index/elbSecurityPolicy:ElbSecurityPolicy")
class ElbSecurityPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an ELB security policy resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.ElbSecurityPolicy("test",
            name="security_policy_test",
            description="this is a security policy",
            protocols=[
                "TLSv1",
                "TLSv1.1",
                "TLSv1.2",
                "TLSv1.3",
            ],
            ciphers=[
                "ECDHE-RSA-AES256-GCM-SHA384",
                "ECDHE-RSA-AES128-GCM-SHA256",
            ])
        ```

        ## Import

        The elb security policies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbSecurityPolicy:ElbSecurityPolicy test 0ce123456a00f2591fabc00385ff1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ciphers: Specifies the cipher suite list of the security policy.
               The protocol and cipher suite must match. That is to say, there must be at least one cipher suite in
               ciphers that matches the protocol. The following cipher suites are supported:
               **ECDHE-RSA-AES256-GCM-SHA384**, **ECDHE-RSA-AES128-GCM-SHA256**, **ECDHE-ECDSA-AES256-GCM-SHA384**,
               **ECDHE-ECDSA-AES128-GCM-SHA256**, **AES128-GCM-SHA256**, **AES256-GCM-SHA384**, **ECDHE-ECDSA-AES128-SHA256**,
               **ECDHE-RSA-AES128-SHA256**, **AES128-SHA256**, **AES256-SHA256**, **ECDHE-ECDSA-AES256-SHA384**,
               **ECDHE-RSA-AES256-SHA384**, **ECDHE-ECDSA-AES128-SHA**, **ECDHE-RSA-AES128-SHA**, **ECDHE-RSA-AES256-SHA**,
               **ECDHE-ECDSA-AES256-SHA**, **AES128-SHA**, **AES256-SHA**, **CAMELLIA128-SHA**, **DES-CBC3-SHA**,
               **CAMELLIA256-SHA**, **ECDHE-RSA-CHACHA20-POLY1305**, **ECDHE-ECDSA-CHACHA20-POLY1305**, **TLS_AES_128_GCM_SHA256**,
               **TLS_AES_256_GCM_SHA384**, **TLS_CHACHA20_POLY1305_SHA256**, **TLS_AES_128_CCM_SHA256**,
               **TLS_AES_128_CCM_8_SHA256**.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the ELB security policy.
               The value can contain 0 to 255 characters.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID to which the Enterprise
               router belongs.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the ELB security policy name.
               The name contains only Chinese characters, letters, digits, underscores (_), and hyphens (-),
               and cannot exceed 255 characters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: Specifies the TSL protocol list which the security policy select.
               Value options: **TLSv1**, **TLSv1.1**, **TLSv1.2**, and **TLSv1.3**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElbSecurityPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB security policy resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.ElbSecurityPolicy("test",
            name="security_policy_test",
            description="this is a security policy",
            protocols=[
                "TLSv1",
                "TLSv1.1",
                "TLSv1.2",
                "TLSv1.3",
            ],
            ciphers=[
                "ECDHE-RSA-AES256-GCM-SHA384",
                "ECDHE-RSA-AES128-GCM-SHA256",
            ])
        ```

        ## Import

        The elb security policies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:index/elbSecurityPolicy:ElbSecurityPolicy test 0ce123456a00f2591fabc00385ff1234
        ```

        :param str resource_name: The name of the resource.
        :param ElbSecurityPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElbSecurityPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElbSecurityPolicyArgs.__new__(ElbSecurityPolicyArgs)

            if ciphers is None and not opts.urn:
                raise TypeError("Missing required property 'ciphers'")
            __props__.__dict__["ciphers"] = ciphers
            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            if protocols is None and not opts.urn:
                raise TypeError("Missing required property 'protocols'")
            __props__.__dict__["protocols"] = protocols
            __props__.__dict__["region"] = region
            __props__.__dict__["created_at"] = None
            __props__.__dict__["listeners"] = None
            __props__.__dict__["updated_at"] = None
        super(ElbSecurityPolicy, __self__).__init__(
            'sbercloud:index/elbSecurityPolicy:ElbSecurityPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElbSecurityPolicyListenerArgs', 'ElbSecurityPolicyListenerArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'ElbSecurityPolicy':
        """
        Get an existing ElbSecurityPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ciphers: Specifies the cipher suite list of the security policy.
               The protocol and cipher suite must match. That is to say, there must be at least one cipher suite in
               ciphers that matches the protocol. The following cipher suites are supported:
               **ECDHE-RSA-AES256-GCM-SHA384**, **ECDHE-RSA-AES128-GCM-SHA256**, **ECDHE-ECDSA-AES256-GCM-SHA384**,
               **ECDHE-ECDSA-AES128-GCM-SHA256**, **AES128-GCM-SHA256**, **AES256-GCM-SHA384**, **ECDHE-ECDSA-AES128-SHA256**,
               **ECDHE-RSA-AES128-SHA256**, **AES128-SHA256**, **AES256-SHA256**, **ECDHE-ECDSA-AES256-SHA384**,
               **ECDHE-RSA-AES256-SHA384**, **ECDHE-ECDSA-AES128-SHA**, **ECDHE-RSA-AES128-SHA**, **ECDHE-RSA-AES256-SHA**,
               **ECDHE-ECDSA-AES256-SHA**, **AES128-SHA**, **AES256-SHA**, **CAMELLIA128-SHA**, **DES-CBC3-SHA**,
               **CAMELLIA256-SHA**, **ECDHE-RSA-CHACHA20-POLY1305**, **ECDHE-ECDSA-CHACHA20-POLY1305**, **TLS_AES_128_GCM_SHA256**,
               **TLS_AES_256_GCM_SHA384**, **TLS_CHACHA20_POLY1305_SHA256**, **TLS_AES_128_CCM_SHA256**,
               **TLS_AES_128_CCM_8_SHA256**.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the ELB security policy.
               The value can contain 0 to 255 characters.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID to which the Enterprise
               router belongs.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElbSecurityPolicyListenerArgs', 'ElbSecurityPolicyListenerArgsDict']]]] listeners: The listener which the security policy associated with.
               The ListenerRef structure is documented below.
        :param pulumi.Input[_builtins.str] name: Specifies the ELB security policy name.
               The name contains only Chinese characters, letters, digits, underscores (_), and hyphens (-),
               and cannot exceed 255 characters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: Specifies the TSL protocol list which the security policy select.
               Value options: **TLSv1**, **TLSv1.1**, **TLSv1.2**, and **TLSv1.3**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElbSecurityPolicyState.__new__(_ElbSecurityPolicyState)

        __props__.__dict__["ciphers"] = ciphers
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["listeners"] = listeners
        __props__.__dict__["name"] = name
        __props__.__dict__["protocols"] = protocols
        __props__.__dict__["region"] = region
        __props__.__dict__["updated_at"] = updated_at
        return ElbSecurityPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def ciphers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the cipher suite list of the security policy.
        The protocol and cipher suite must match. That is to say, there must be at least one cipher suite in
        ciphers that matches the protocol. The following cipher suites are supported:
        **ECDHE-RSA-AES256-GCM-SHA384**, **ECDHE-RSA-AES128-GCM-SHA256**, **ECDHE-ECDSA-AES256-GCM-SHA384**,
        **ECDHE-ECDSA-AES128-GCM-SHA256**, **AES128-GCM-SHA256**, **AES256-GCM-SHA384**, **ECDHE-ECDSA-AES128-SHA256**,
        **ECDHE-RSA-AES128-SHA256**, **AES128-SHA256**, **AES256-SHA256**, **ECDHE-ECDSA-AES256-SHA384**,
        **ECDHE-RSA-AES256-SHA384**, **ECDHE-ECDSA-AES128-SHA**, **ECDHE-RSA-AES128-SHA**, **ECDHE-RSA-AES256-SHA**,
        **ECDHE-ECDSA-AES256-SHA**, **AES128-SHA**, **AES256-SHA**, **CAMELLIA128-SHA**, **DES-CBC3-SHA**,
        **CAMELLIA256-SHA**, **ECDHE-RSA-CHACHA20-POLY1305**, **ECDHE-ECDSA-CHACHA20-POLY1305**, **TLS_AES_128_GCM_SHA256**,
        **TLS_AES_256_GCM_SHA384**, **TLS_CHACHA20_POLY1305_SHA256**, **TLS_AES_128_CCM_SHA256**,
        **TLS_AES_128_CCM_8_SHA256**.
        """
        return pulumi.get(self, "ciphers")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the description of the ELB security policy.
        The value can contain 0 to 255 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project ID to which the Enterprise
        router belongs.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> pulumi.Output[Sequence['outputs.ElbSecurityPolicyListener']]:
        """
        The listener which the security policy associated with.
        The ListenerRef structure is documented below.
        """
        return pulumi.get(self, "listeners")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ELB security policy name.
        The name contains only Chinese characters, letters, digits, underscores (_), and hyphens (-),
        and cannot exceed 255 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the TSL protocol list which the security policy select.
        Value options: **TLSv1**, **TLSv1.1**, **TLSv1.2**, and **TLSv1.3**.
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

