# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, created_at=None, description=None, id=None, name=None, status=None, updated_at=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, int):
            raise TypeError("Expected argument 'status' to be a int")
        pulumi.set(__self__, "status", status)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Specifies the time (UTC) when the enterprise project was created. Example: 2018-05-18T06:49:06Z
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Provides supplementary information about the enterprise project.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Specifies the time (UTC) when the enterprise project was modified. Example: 2018-05-28T02:21:36Z
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            created_at=self.created_at,
            description=self.description,
            id=self.id,
            name=self.name,
            status=self.status,
            updated_at=self.updated_at)


def get_project(id: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                status: Optional[_builtins.int] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Use this data source to get an enterprise project from SberCloud

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Eps.get_project(name="test")
    ```

    ## Resources Supported Currently

    <!-- markdownlint-disable MD033 -->
    Service Name | Resource Name | Sub Resource Name
    ---- | --- | ---
    AS  | As.Group |
    CBR | Cbr.Vault |
    CCE | Cce.Cluster | sbercloud_cce_node<br>sbercloud_cce_node_pool
    CDM | Cdm.Cluster |
    CES | Ces.Alarmrule |
    DCS | Dcs.Instance |
    DDS | Dds.Instance |
    DMS | sbercloud_dms_kafka_instance<br>sbercloud_dms_rabbitmq_instance |
    DNS | sbercloud_dns_ptrrecord<br>sbercloud_dns_zone |
    ECS | Ecs.Instance |
    EIP | sbercloud_vpc_eip<br>sbercloud_vpc_bandwidth |
    ELB | Elb.Loadbalancer |
    EVS | Evs.Volume |
    FGS | FunctionGraph.Function |
    IMS | Ims.Image |
    NAT | Nat.Gateway | sbercloud_nat_snat_rule<br>sbercloud_nat_dnat_rule
    OBS | Obs.Bucket | sbercloud_obs_bucket_object<br>sbercloud_obs_bucket_policy
    RDS | sbercloud_rds_instance<br>sbercloud_rds_read_replica_instance |
    SFS | sbercloud_sfs_file_system<br>sbercloud_sfs_turbo | Sfs.AccessRule
    VPC | sbercloud_vpc<br>sbercloud_networking_secgroup | sbercloud_vpc_subnet<br>sbercloud_vpc_route<br>sbercloud_networking_secgroup_rule
    <!-- markdownlint-enable MD033 -->


    :param _builtins.str id: Specifies the ID of an enterprise project. The value 0 indicates enterprise project default.
    :param _builtins.str name: Specifies the enterprise project name. Fuzzy search is supported.
    :param _builtins.int status: Specifies the status of an enterprise project.
           + 1 indicates Enabled.
           + 2 indicates Disabled.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Eps/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_project_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       status: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectResult]:
    """
    Use this data source to get an enterprise project from SberCloud

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Eps.get_project(name="test")
    ```

    ## Resources Supported Currently

    <!-- markdownlint-disable MD033 -->
    Service Name | Resource Name | Sub Resource Name
    ---- | --- | ---
    AS  | As.Group |
    CBR | Cbr.Vault |
    CCE | Cce.Cluster | sbercloud_cce_node<br>sbercloud_cce_node_pool
    CDM | Cdm.Cluster |
    CES | Ces.Alarmrule |
    DCS | Dcs.Instance |
    DDS | Dds.Instance |
    DMS | sbercloud_dms_kafka_instance<br>sbercloud_dms_rabbitmq_instance |
    DNS | sbercloud_dns_ptrrecord<br>sbercloud_dns_zone |
    ECS | Ecs.Instance |
    EIP | sbercloud_vpc_eip<br>sbercloud_vpc_bandwidth |
    ELB | Elb.Loadbalancer |
    EVS | Evs.Volume |
    FGS | FunctionGraph.Function |
    IMS | Ims.Image |
    NAT | Nat.Gateway | sbercloud_nat_snat_rule<br>sbercloud_nat_dnat_rule
    OBS | Obs.Bucket | sbercloud_obs_bucket_object<br>sbercloud_obs_bucket_policy
    RDS | sbercloud_rds_instance<br>sbercloud_rds_read_replica_instance |
    SFS | sbercloud_sfs_file_system<br>sbercloud_sfs_turbo | Sfs.AccessRule
    VPC | sbercloud_vpc<br>sbercloud_networking_secgroup | sbercloud_vpc_subnet<br>sbercloud_vpc_route<br>sbercloud_networking_secgroup_rule
    <!-- markdownlint-enable MD033 -->


    :param _builtins.str id: Specifies the ID of an enterprise project. The value 0 indicates enterprise project default.
    :param _builtins.str name: Specifies the enterprise project name. Fuzzy search is supported.
    :param _builtins.int status: Specifies the status of an enterprise project.
           + 1 indicates Enabled.
           + 2 indicates Disabled.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Eps/getProject:getProject', __args__, opts=opts, typ=GetProjectResult)
    return __ret__.apply(lambda __response__: GetProjectResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status'),
        updated_at=pulumi.get(__response__, 'updated_at')))
