# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AssociationArgs', 'Association']

@pulumi.input_type
class AssociationArgs:
    def __init__(__self__, *,
                 attachment_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 route_table_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Association resource.
        :param pulumi.Input[_builtins.str] attachment_id: Specifies the ID of the attachment corresponding to the association.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the route table and the
               attachment belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] route_table_id: Specifies the ID of the route table to which the association
               belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the ER instance and route table are located.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "attachment_id", attachment_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "route_table_id", route_table_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the attachment corresponding to the association.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "attachment_id")

    @attachment_id.setter
    def attachment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the ER instance to which the route table and the
        attachment belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the route table to which the association
        belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the ER instance and route table are located.  
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AssociationState:
    def __init__(__self__, *,
                 attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 attachment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Association resources.
        :param pulumi.Input[_builtins.str] attachment_id: Specifies the ID of the attachment corresponding to the association.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] attachment_type: The type of the attachment corresponding to the association.
        :param pulumi.Input[_builtins.str] created_at: The creation time.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the route table and the
               attachment belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the ER instance and route table are located.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] route_table_id: Specifies the ID of the route table to which the association
               belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The current status of the association.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time.
        """
        if attachment_id is not None:
            pulumi.set(__self__, "attachment_id", attachment_id)
        if attachment_type is not None:
            pulumi.set(__self__, "attachment_type", attachment_type)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the attachment corresponding to the association.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "attachment_id")

    @attachment_id.setter
    def attachment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the attachment corresponding to the association.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attachment_type", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the ER instance to which the route table and the
        attachment belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the ER instance and route table are located.  
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the route table to which the association
        belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the association.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update time.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:Er/association:Association")
class Association(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an association resource under the route table for ER service within SberCloud.

        Before using enterprise router, define custom endpoint as shown below:
        ```python
        import pulumi
        ```

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        route_table_id = config.require_object("routeTableId")
        attachment_id = config.require_object("attachmentId")
        test = sbercloud.er.Association("test",
            instance_id=instance_id,
            route_table_id=route_table_id,
            attachment_id=attachment_id)
        ```

        ## Import

        Associations can be imported using their `id` and the related `instance_id` and `route_table_id`, separated by

        slashes (/), e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Er/association:Association test <instance_id>/<route_table_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] attachment_id: Specifies the ID of the attachment corresponding to the association.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the route table and the
               attachment belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the ER instance and route table are located.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] route_table_id: Specifies the ID of the route table to which the association
               belongs.
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an association resource under the route table for ER service within SberCloud.

        Before using enterprise router, define custom endpoint as shown below:
        ```python
        import pulumi
        ```

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        route_table_id = config.require_object("routeTableId")
        attachment_id = config.require_object("attachmentId")
        test = sbercloud.er.Association("test",
            instance_id=instance_id,
            route_table_id=route_table_id,
            attachment_id=attachment_id)
        ```

        ## Import

        Associations can be imported using their `id` and the related `instance_id` and `route_table_id`, separated by

        slashes (/), e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Er/association:Association test <instance_id>/<route_table_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param AssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssociationArgs.__new__(AssociationArgs)

            if attachment_id is None and not opts.urn:
                raise TypeError("Missing required property 'attachment_id'")
            __props__.__dict__["attachment_id"] = attachment_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
            if route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_id'")
            __props__.__dict__["route_table_id"] = route_table_id
            __props__.__dict__["attachment_type"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(Association, __self__).__init__(
            'sbercloud:Er/association:Association',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
            attachment_type: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'Association':
        """
        Get an existing Association resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] attachment_id: Specifies the ID of the attachment corresponding to the association.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] attachment_type: The type of the attachment corresponding to the association.
        :param pulumi.Input[_builtins.str] created_at: The creation time.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the route table and the
               attachment belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the ER instance and route table are located.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] route_table_id: Specifies the ID of the route table to which the association
               belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The current status of the association.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssociationState.__new__(_AssociationState)

        __props__.__dict__["attachment_id"] = attachment_id
        __props__.__dict__["attachment_type"] = attachment_type
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region"] = region
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        return Association(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the attachment corresponding to the association.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "attachment_id")

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the attachment corresponding to the association.
        """
        return pulumi.get(self, "attachment_type")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the ER instance to which the route table and the
        attachment belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region where the ER instance and route table are located.  
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the route table to which the association
        belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the association.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update time.
        """
        return pulumi.get(self, "updated_at")

