# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FlowLogArgs', 'FlowLog']

@pulumi.input_type
class FlowLogArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 log_group_id: pulumi.Input[_builtins.str],
                 log_store_type: pulumi.Input[_builtins.str],
                 log_stream_id: pulumi.Input[_builtins.str],
                 resource_id: pulumi.Input[_builtins.str],
                 resource_type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FlowLog resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the flow log belongs.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] log_group_id: Specifies the LTS log group ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] log_store_type: Specifies the storage type of flow log. The valid value is **LTS**.  
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] log_stream_id: Specifies the LTS log stream ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] resource_id: Specifies the resource ID to which the logs to be collected.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] resource_type: Specifies the resource type to which the logs to be collected.
               The valid value is **attachment**.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the flow log.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether to enable the flow log function. The default value is **true**.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the flow log.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_store_type", log_store_type)
        pulumi.set(__self__, "log_stream_id", log_stream_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the ER instance to which the flow log belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the LTS log group ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_group_id", value)

    @_builtins.property
    @pulumi.getter(name="logStoreType")
    def log_store_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the storage type of flow log. The valid value is **LTS**.  
        Changing this creates a new resource.
        """
        return pulumi.get(self, "log_store_type")

    @log_store_type.setter
    def log_store_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_store_type", value)

    @_builtins.property
    @pulumi.getter(name="logStreamId")
    def log_stream_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the LTS log stream ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "log_stream_id")

    @log_stream_id.setter
    def log_stream_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_stream_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the resource ID to which the logs to be collected.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the resource type to which the logs to be collected.
        The valid value is **attachment**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the flow log.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the flow log function. The default value is **true**.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the flow log.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _FlowLogState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlowLog resources.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the flow log.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the flow log.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether to enable the flow log function. The default value is **true**.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the flow log belongs.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] log_group_id: Specifies the LTS log group ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] log_store_type: Specifies the storage type of flow log. The valid value is **LTS**.  
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] log_stream_id: Specifies the LTS log stream ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the flow log.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] resource_id: Specifies the resource ID to which the logs to be collected.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] resource_type: Specifies the resource type to which the logs to be collected.
               The valid value is **attachment**.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] state: The current status of the flow log.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the flow log.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if log_store_type is not None:
            pulumi.set(__self__, "log_store_type", log_store_type)
        if log_stream_id is not None:
            pulumi.set(__self__, "log_stream_id", log_stream_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the flow log.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the flow log.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the flow log function. The default value is **true**.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the ER instance to which the flow log belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the LTS log group ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_group_id", value)

    @_builtins.property
    @pulumi.getter(name="logStoreType")
    def log_store_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the storage type of flow log. The valid value is **LTS**.  
        Changing this creates a new resource.
        """
        return pulumi.get(self, "log_store_type")

    @log_store_type.setter
    def log_store_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_store_type", value)

    @_builtins.property
    @pulumi.getter(name="logStreamId")
    def log_stream_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the LTS log stream ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "log_stream_id")

    @log_stream_id.setter
    def log_stream_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_stream_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the flow log.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the resource ID to which the logs to be collected.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the resource type to which the logs to be collected.
        The valid value is **attachment**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the flow log.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update time of the flow log.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:Er/flowLog:FlowLog")
class FlowLog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a flow log resource under the ER instance within SberCloud.

        Before using enterprise router, define custom endpoint as shown below:
        ```python
        import pulumi
        ```

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        log_group_id = config.require_object("logGroupId")
        log_stream_id = config.require_object("logStreamId")
        resource_id = config.require_object("resourceId")
        flow_log_name = config.require_object("flowLogName")
        test = sbercloud.er.FlowLog("test",
            instance_id=instance_id,
            log_store_type="LTS",
            log_group_id=log_group_id,
            log_stream_id=log_stream_id,
            resource_type="attachment",
            resource_id=resource_id,
            name=flow_log_name,
            description="Flow log created by terraform",
            enabled=False)
        ```

        ## Import

        The flow log can be imported using the related `instance_id` and their `id`, separated by a slash (/), e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Er/flowLog:FlowLog test <instance_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the flow log.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether to enable the flow log function. The default value is **true**.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the flow log belongs.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] log_group_id: Specifies the LTS log group ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] log_store_type: Specifies the storage type of flow log. The valid value is **LTS**.  
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] log_stream_id: Specifies the LTS log stream ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the flow log.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] resource_id: Specifies the resource ID to which the logs to be collected.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] resource_type: Specifies the resource type to which the logs to be collected.
               The valid value is **attachment**.
               Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlowLogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a flow log resource under the ER instance within SberCloud.

        Before using enterprise router, define custom endpoint as shown below:
        ```python
        import pulumi
        ```

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        log_group_id = config.require_object("logGroupId")
        log_stream_id = config.require_object("logStreamId")
        resource_id = config.require_object("resourceId")
        flow_log_name = config.require_object("flowLogName")
        test = sbercloud.er.FlowLog("test",
            instance_id=instance_id,
            log_store_type="LTS",
            log_group_id=log_group_id,
            log_stream_id=log_stream_id,
            resource_type="attachment",
            resource_id=resource_id,
            name=flow_log_name,
            description="Flow log created by terraform",
            enabled=False)
        ```

        ## Import

        The flow log can be imported using the related `instance_id` and their `id`, separated by a slash (/), e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Er/flowLog:FlowLog test <instance_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param FlowLogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlowLogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store_type: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlowLogArgs.__new__(FlowLogArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if log_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_group_id'")
            __props__.__dict__["log_group_id"] = log_group_id
            if log_store_type is None and not opts.urn:
                raise TypeError("Missing required property 'log_store_type'")
            __props__.__dict__["log_store_type"] = log_store_type
            if log_stream_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_stream_id'")
            __props__.__dict__["log_stream_id"] = log_stream_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["updated_at"] = None
        super(FlowLog, __self__).__init__(
            'sbercloud:Er/flowLog:FlowLog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            log_store_type: Optional[pulumi.Input[_builtins.str]] = None,
            log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'FlowLog':
        """
        Get an existing FlowLog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the flow log.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the flow log.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether to enable the flow log function. The default value is **true**.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the flow log belongs.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] log_group_id: Specifies the LTS log group ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] log_store_type: Specifies the storage type of flow log. The valid value is **LTS**.  
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] log_stream_id: Specifies the LTS log stream ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the flow log.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] resource_id: Specifies the resource ID to which the logs to be collected.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] resource_type: Specifies the resource type to which the logs to be collected.
               The valid value is **attachment**.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] state: The current status of the flow log.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the flow log.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlowLogState.__new__(_FlowLogState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["log_group_id"] = log_group_id
        __props__.__dict__["log_store_type"] = log_store_type
        __props__.__dict__["log_stream_id"] = log_stream_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["state"] = state
        __props__.__dict__["updated_at"] = updated_at
        return FlowLog(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the flow log.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the flow log.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the flow log function. The default value is **true**.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the ER instance to which the flow log belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the LTS log group ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logStoreType")
    def log_store_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the storage type of flow log. The valid value is **LTS**.  
        Changing this creates a new resource.
        """
        return pulumi.get(self, "log_store_type")

    @_builtins.property
    @pulumi.getter(name="logStreamId")
    def log_stream_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the LTS log stream ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "log_stream_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the flow log.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the resource ID to which the logs to be collected.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the resource type to which the logs to be collected.
        The valid value is **attachment**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the flow log.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update time of the flow log.
        """
        return pulumi.get(self, "updated_at")

