# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAttachmentsResult',
    'AwaitableGetAttachmentsResult',
    'get_attachments',
    'get_attachments_output',
]

@pulumi.output_type
class GetAttachmentsResult:
    """
    A collection of values returned by getAttachments.
    """
    def __init__(__self__, attachment_id=None, attachments=None, id=None, instance_id=None, name=None, region=None, resource_id=None, status=None, tags=None, type=None):
        if attachment_id and not isinstance(attachment_id, str):
            raise TypeError("Expected argument 'attachment_id' to be a str")
        pulumi.set(__self__, "attachment_id", attachment_id)
        if attachments and not isinstance(attachments, list):
            raise TypeError("Expected argument 'attachments' to be a list")
        pulumi.set(__self__, "attachments", attachments)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "attachment_id")

    @_builtins.property
    @pulumi.getter
    def attachments(self) -> Sequence['outputs.GetAttachmentsAttachmentResult']:
        """
        All attachments that match the filter parameters.  
        The object structure is documented below.
        """
        return pulumi.get(self, "attachments")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The attachment name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[_builtins.str]:
        """
        The associated resource ID.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The current status of the attachment.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The key/value pairs to associate with the attachment.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The attachment type.
        """
        return pulumi.get(self, "type")


class AwaitableGetAttachmentsResult(GetAttachmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAttachmentsResult(
            attachment_id=self.attachment_id,
            attachments=self.attachments,
            id=self.id,
            instance_id=self.instance_id,
            name=self.name,
            region=self.region,
            resource_id=self.resource_id,
            status=self.status,
            tags=self.tags,
            type=self.type)


def get_attachments(attachment_id: Optional[_builtins.str] = None,
                    instance_id: Optional[_builtins.str] = None,
                    name: Optional[_builtins.str] = None,
                    region: Optional[_builtins.str] = None,
                    resource_id: Optional[_builtins.str] = None,
                    status: Optional[_builtins.str] = None,
                    tags: Optional[Mapping[str, _builtins.str]] = None,
                    type: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAttachmentsResult:
    """
    Use this data source to filter ER attachments within SberCloud.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.Er.get_attachments(instance_id=instance_id,
        tags={
            "foo": "bar",
        })
    ```


    :param _builtins.str attachment_id: Specifies the specified attachment ID used to query.
    :param _builtins.str instance_id: Specifies the ER instance ID to which the attachment belongs.
    :param _builtins.str name: Specifies the name used to filter the attachments.
    :param _builtins.str region: Specifies the region where the ER attachments are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str resource_id: Specifies the associated resource ID used to filter the attachments.
    :param _builtins.str status: Specifies the status used to filter the attachments.
           The valid values are as follows:
           + **available**
           + **failed**
           + **pending_acceptance**
           + **rejected**
    :param Mapping[str, _builtins.str] tags: The key/value pairs used to filter the attachments.
    :param _builtins.str type: Specifies the resource type to be filtered.  
           The valid values are as follows:
           + **vpc**: Virtual private cloud.
           + **vpn**: VPN gateway.
           + **vgw**: Virtual gateway of cloud private line.
           + **peering**: Peering connection, through the cloud connection (CC) to load ERs in different regions to create a
           peering connection.
    """
    __args__ = dict()
    __args__['attachmentId'] = attachment_id
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['resourceId'] = resource_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Er/getAttachments:getAttachments', __args__, opts=opts, typ=GetAttachmentsResult).value

    return AwaitableGetAttachmentsResult(
        attachment_id=pulumi.get(__ret__, 'attachment_id'),
        attachments=pulumi.get(__ret__, 'attachments'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))
def get_attachments_output(attachment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                           name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           resource_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                           type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAttachmentsResult]:
    """
    Use this data source to filter ER attachments within SberCloud.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.Er.get_attachments(instance_id=instance_id,
        tags={
            "foo": "bar",
        })
    ```


    :param _builtins.str attachment_id: Specifies the specified attachment ID used to query.
    :param _builtins.str instance_id: Specifies the ER instance ID to which the attachment belongs.
    :param _builtins.str name: Specifies the name used to filter the attachments.
    :param _builtins.str region: Specifies the region where the ER attachments are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str resource_id: Specifies the associated resource ID used to filter the attachments.
    :param _builtins.str status: Specifies the status used to filter the attachments.
           The valid values are as follows:
           + **available**
           + **failed**
           + **pending_acceptance**
           + **rejected**
    :param Mapping[str, _builtins.str] tags: The key/value pairs used to filter the attachments.
    :param _builtins.str type: Specifies the resource type to be filtered.  
           The valid values are as follows:
           + **vpc**: Virtual private cloud.
           + **vpn**: VPN gateway.
           + **vgw**: Virtual gateway of cloud private line.
           + **peering**: Peering connection, through the cloud connection (CC) to load ERs in different regions to create a
           peering connection.
    """
    __args__ = dict()
    __args__['attachmentId'] = attachment_id
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['resourceId'] = resource_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Er/getAttachments:getAttachments', __args__, opts=opts, typ=GetAttachmentsResult)
    return __ret__.apply(lambda __response__: GetAttachmentsResult(
        attachment_id=pulumi.get(__response__, 'attachment_id'),
        attachments=pulumi.get(__response__, 'attachments'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type')))
