# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAvailableRoutesResult',
    'AwaitableGetAvailableRoutesResult',
    'get_available_routes',
    'get_available_routes_output',
]

@pulumi.output_type
class GetAvailableRoutesResult:
    """
    A collection of values returned by getAvailableRoutes.
    """
    def __init__(__self__, destination=None, id=None, region=None, resource_type=None, route_table_id=None, routes=None):
        if destination and not isinstance(destination, str):
            raise TypeError("Expected argument 'destination' to be a str")
        pulumi.set(__self__, "destination", destination)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if route_table_id and not isinstance(route_table_id, str):
            raise TypeError("Expected argument 'route_table_id' to be a str")
        pulumi.set(__self__, "route_table_id", route_table_id)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[_builtins.str]:
        """
        The destination address of the route.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The attachment type.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetAvailableRoutesRouteResult']:
        """
        All available routes that match the filter parameters.
        """
        return pulumi.get(self, "routes")


class AwaitableGetAvailableRoutesResult(GetAvailableRoutesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAvailableRoutesResult(
            destination=self.destination,
            id=self.id,
            region=self.region,
            resource_type=self.resource_type,
            route_table_id=self.route_table_id,
            routes=self.routes)


def get_available_routes(destination: Optional[_builtins.str] = None,
                         region: Optional[_builtins.str] = None,
                         resource_type: Optional[_builtins.str] = None,
                         route_table_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAvailableRoutesResult:
    """
    Using this data source to query the list of available routes within SberCloud.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    route_table_id = config.require_object("routeTableId")
    test = sbercloud.Er.get_available_routes(route_table_id=route_table_id)
    ```


    :param _builtins.str destination: The destination address of the routes to be queried.
    :param _builtins.str region: Specifies the region in which to query the available routes.
           If omitted, the provider-level region will be used.
    :param _builtins.str resource_type: The attachment type.
           The valid values are as follows:
           + **vpc**: VPC attachment.
           + **vpn**: VPN gateway attachment.
           + **vgw**: virtual gateway attachment.
           + **peering**: peering connection attachment.
           + **ecn**: ECN attachment.
           + **cfw**: CFW instance attachment.
    :param _builtins.str route_table_id: The route table ID to which the available routes belong.
    """
    __args__ = dict()
    __args__['destination'] = destination
    __args__['region'] = region
    __args__['resourceType'] = resource_type
    __args__['routeTableId'] = route_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Er/getAvailableRoutes:getAvailableRoutes', __args__, opts=opts, typ=GetAvailableRoutesResult).value

    return AwaitableGetAvailableRoutesResult(
        destination=pulumi.get(__ret__, 'destination'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        route_table_id=pulumi.get(__ret__, 'route_table_id'),
        routes=pulumi.get(__ret__, 'routes'))
def get_available_routes_output(destination: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                resource_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAvailableRoutesResult]:
    """
    Using this data source to query the list of available routes within SberCloud.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    route_table_id = config.require_object("routeTableId")
    test = sbercloud.Er.get_available_routes(route_table_id=route_table_id)
    ```


    :param _builtins.str destination: The destination address of the routes to be queried.
    :param _builtins.str region: Specifies the region in which to query the available routes.
           If omitted, the provider-level region will be used.
    :param _builtins.str resource_type: The attachment type.
           The valid values are as follows:
           + **vpc**: VPC attachment.
           + **vpn**: VPN gateway attachment.
           + **vgw**: virtual gateway attachment.
           + **peering**: peering connection attachment.
           + **ecn**: ECN attachment.
           + **cfw**: CFW instance attachment.
    :param _builtins.str route_table_id: The route table ID to which the available routes belong.
    """
    __args__ = dict()
    __args__['destination'] = destination
    __args__['region'] = region
    __args__['resourceType'] = resource_type
    __args__['routeTableId'] = route_table_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Er/getAvailableRoutes:getAvailableRoutes', __args__, opts=opts, typ=GetAvailableRoutesResult)
    return __ret__.apply(lambda __response__: GetAvailableRoutesResult(
        destination=pulumi.get(__response__, 'destination'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        route_table_id=pulumi.get(__response__, 'route_table_id'),
        routes=pulumi.get(__response__, 'routes')))
