# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlowLogsResult',
    'AwaitableGetFlowLogsResult',
    'get_flow_logs',
    'get_flow_logs_output',
]

@pulumi.output_type
class GetFlowLogsResult:
    """
    A collection of values returned by getFlowLogs.
    """
    def __init__(__self__, enabled=None, flow_log_id=None, flow_logs=None, id=None, instance_id=None, log_group_id=None, log_stream_id=None, name=None, region=None, resource_id=None, resource_type=None, status=None):
        if enabled and not isinstance(enabled, str):
            raise TypeError("Expected argument 'enabled' to be a str")
        pulumi.set(__self__, "enabled", enabled)
        if flow_log_id and not isinstance(flow_log_id, str):
            raise TypeError("Expected argument 'flow_log_id' to be a str")
        pulumi.set(__self__, "flow_log_id", flow_log_id)
        if flow_logs and not isinstance(flow_logs, list):
            raise TypeError("Expected argument 'flow_logs' to be a list")
        pulumi.set(__self__, "flow_logs", flow_logs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if log_group_id and not isinstance(log_group_id, str):
            raise TypeError("Expected argument 'log_group_id' to be a str")
        pulumi.set(__self__, "log_group_id", log_group_id)
        if log_stream_id and not isinstance(log_stream_id, str):
            raise TypeError("Expected argument 'log_stream_id' to be a str")
        pulumi.set(__self__, "log_stream_id", log_stream_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.str]:
        """
        The switch of the flow log.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="flowLogId")
    def flow_log_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "flow_log_id")

    @_builtins.property
    @pulumi.getter(name="flowLogs")
    def flow_logs(self) -> Sequence['outputs.GetFlowLogsFlowLogResult']:
        """
        The list ot the flow logs.
        The flow_logs structure is documented below.
        """
        return pulumi.get(self, "flow_logs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the log group to which the flow log belongs.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logStreamId")
    def log_stream_id(self) -> Optional[_builtins.str]:
        """
        The ID of the log stream to which the flow log belongs.
        """
        return pulumi.get(self, "log_stream_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the flow log.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[_builtins.str]:
        """
        The ID of the attachment to which the flow log belongs.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The type of the flow log.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the flow log.
        """
        return pulumi.get(self, "status")


class AwaitableGetFlowLogsResult(GetFlowLogsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlowLogsResult(
            enabled=self.enabled,
            flow_log_id=self.flow_log_id,
            flow_logs=self.flow_logs,
            id=self.id,
            instance_id=self.instance_id,
            log_group_id=self.log_group_id,
            log_stream_id=self.log_stream_id,
            name=self.name,
            region=self.region,
            resource_id=self.resource_id,
            resource_type=self.resource_type,
            status=self.status)


def get_flow_logs(enabled: Optional[_builtins.str] = None,
                  flow_log_id: Optional[_builtins.str] = None,
                  instance_id: Optional[_builtins.str] = None,
                  log_group_id: Optional[_builtins.str] = None,
                  log_stream_id: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  resource_id: Optional[_builtins.str] = None,
                  resource_type: Optional[_builtins.str] = None,
                  status: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlowLogsResult:
    """
    Use this data source to get the list of flow logs.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    resource_id = config.require_object("resourceId")
    test = sbercloud.Er.get_flow_logs(instance_id=instance_id,
        resource_id=resource_id)
    ```


    :param _builtins.str enabled: Specifies the switch status of the flow log.
           The value can be **true** and **false**.
    :param _builtins.str flow_log_id: Specifies the ID of the flow log.
    :param _builtins.str instance_id: Specifies the ID of the ER instance to which the flow logs belong.
    :param _builtins.str log_group_id: Specifies the ID of the log group to which the flow logs belong.
    :param _builtins.str log_stream_id: Specifies the ID of the log stream to which the flow logs belong.
    :param _builtins.str name: Specifies the name of the flow log.
    :param _builtins.str region: Specifies the region where the flow logs are located.
           If omitted, the provider-level region will be used.
    :param _builtins.str resource_id: Specifies the ID of the attachment to which the flow logs belong.
    :param _builtins.str resource_type: Specifies the type of the flow logs.
           The valid values are as follows:
           + **attachment**: The flow logs type are attachment.
    :param _builtins.str status: Specifies the status of the flow logs.
    """
    __args__ = dict()
    __args__['enabled'] = enabled
    __args__['flowLogId'] = flow_log_id
    __args__['instanceId'] = instance_id
    __args__['logGroupId'] = log_group_id
    __args__['logStreamId'] = log_stream_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['resourceId'] = resource_id
    __args__['resourceType'] = resource_type
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Er/getFlowLogs:getFlowLogs', __args__, opts=opts, typ=GetFlowLogsResult).value

    return AwaitableGetFlowLogsResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        flow_log_id=pulumi.get(__ret__, 'flow_log_id'),
        flow_logs=pulumi.get(__ret__, 'flow_logs'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        log_group_id=pulumi.get(__ret__, 'log_group_id'),
        log_stream_id=pulumi.get(__ret__, 'log_stream_id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        status=pulumi.get(__ret__, 'status'))
def get_flow_logs_output(enabled: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         flow_log_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                         log_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         log_stream_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         resource_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         resource_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlowLogsResult]:
    """
    Use this data source to get the list of flow logs.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    resource_id = config.require_object("resourceId")
    test = sbercloud.Er.get_flow_logs(instance_id=instance_id,
        resource_id=resource_id)
    ```


    :param _builtins.str enabled: Specifies the switch status of the flow log.
           The value can be **true** and **false**.
    :param _builtins.str flow_log_id: Specifies the ID of the flow log.
    :param _builtins.str instance_id: Specifies the ID of the ER instance to which the flow logs belong.
    :param _builtins.str log_group_id: Specifies the ID of the log group to which the flow logs belong.
    :param _builtins.str log_stream_id: Specifies the ID of the log stream to which the flow logs belong.
    :param _builtins.str name: Specifies the name of the flow log.
    :param _builtins.str region: Specifies the region where the flow logs are located.
           If omitted, the provider-level region will be used.
    :param _builtins.str resource_id: Specifies the ID of the attachment to which the flow logs belong.
    :param _builtins.str resource_type: Specifies the type of the flow logs.
           The valid values are as follows:
           + **attachment**: The flow logs type are attachment.
    :param _builtins.str status: Specifies the status of the flow logs.
    """
    __args__ = dict()
    __args__['enabled'] = enabled
    __args__['flowLogId'] = flow_log_id
    __args__['instanceId'] = instance_id
    __args__['logGroupId'] = log_group_id
    __args__['logStreamId'] = log_stream_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['resourceId'] = resource_id
    __args__['resourceType'] = resource_type
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Er/getFlowLogs:getFlowLogs', __args__, opts=opts, typ=GetFlowLogsResult)
    return __ret__.apply(lambda __response__: GetFlowLogsResult(
        enabled=pulumi.get(__response__, 'enabled'),
        flow_log_id=pulumi.get(__response__, 'flow_log_id'),
        flow_logs=pulumi.get(__response__, 'flow_logs'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        log_group_id=pulumi.get(__response__, 'log_group_id'),
        log_stream_id=pulumi.get(__response__, 'log_stream_id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        status=pulumi.get(__response__, 'status')))
