# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, enterprise_project_id=None, id=None, instance_id=None, instances=None, name=None, owned_by_self=None, region=None, status=None, tags=None):
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owned_by_self and not isinstance(owned_by_self, bool):
            raise TypeError("Expected argument 'owned_by_self' to be a bool")
        pulumi.set(__self__, "owned_by_self", owned_by_self)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        """
        The ID of enterprise project to which the ER instance belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetInstancesInstanceResult']:
        """
        All instances that match the filter parameters.  
        The object structure is documented below.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the ER instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownedBySelf")
    def owned_by_self(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "owned_by_self")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The current status of the ER instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The key/value pairs to associate with the ER instance.
        """
        return pulumi.get(self, "tags")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            instance_id=self.instance_id,
            instances=self.instances,
            name=self.name,
            owned_by_self=self.owned_by_self,
            region=self.region,
            status=self.status,
            tags=self.tags)


def get_instances(enterprise_project_id: Optional[_builtins.str] = None,
                  instance_id: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  owned_by_self: Optional[_builtins.bool] = None,
                  region: Optional[_builtins.str] = None,
                  status: Optional[_builtins.str] = None,
                  tags: Optional[Mapping[str, _builtins.str]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    Use this data source to filter ER instances within SberCloud.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Er.get_instances(tags={
        "foo": "bar",
    })
    ```


    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID of the ER instances to be queried.
    :param _builtins.str instance_id: Specifies the ID used to query specified ER instance.
    :param _builtins.str name: Specifies the name used to filter the ER instances.
           The valid length is limited from `1` to `64`, only Chinese and English letters, digits, underscores (_) and
           hyphens (-) are allowed.
    :param _builtins.bool owned_by_self: Specifies whether resources belong to the current renant.
    :param _builtins.str region: Specifies the region where the ER instances are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the status used to filter the ER instances.
    :param Mapping[str, _builtins.str] tags: Specifies the key/value pairs used to filter the ER instances.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['ownedBySelf'] = owned_by_self
    __args__['region'] = region
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Er/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        instances=pulumi.get(__ret__, 'instances'),
        name=pulumi.get(__ret__, 'name'),
        owned_by_self=pulumi.get(__ret__, 'owned_by_self'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_instances_output(enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         owned_by_self: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancesResult]:
    """
    Use this data source to filter ER instances within SberCloud.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Er.get_instances(tags={
        "foo": "bar",
    })
    ```


    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID of the ER instances to be queried.
    :param _builtins.str instance_id: Specifies the ID used to query specified ER instance.
    :param _builtins.str name: Specifies the name used to filter the ER instances.
           The valid length is limited from `1` to `64`, only Chinese and English letters, digits, underscores (_) and
           hyphens (-) are allowed.
    :param _builtins.bool owned_by_self: Specifies whether resources belong to the current renant.
    :param _builtins.str region: Specifies the region where the ER instances are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the status used to filter the ER instances.
    :param Mapping[str, _builtins.str] tags: Specifies the key/value pairs used to filter the ER instances.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['ownedBySelf'] = owned_by_self
    __args__['region'] = region
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Er/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult)
    return __ret__.apply(lambda __response__: GetInstancesResult(
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        instances=pulumi.get(__response__, 'instances'),
        name=pulumi.get(__response__, 'name'),
        owned_by_self=pulumi.get(__response__, 'owned_by_self'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
