# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPropagationsResult',
    'AwaitableGetPropagationsResult',
    'get_propagations',
    'get_propagations_output',
]

@pulumi.output_type
class GetPropagationsResult:
    """
    A collection of values returned by getPropagations.
    """
    def __init__(__self__, attachment_id=None, attachment_type=None, id=None, instance_id=None, propagations=None, region=None, route_table_id=None, status=None):
        if attachment_id and not isinstance(attachment_id, str):
            raise TypeError("Expected argument 'attachment_id' to be a str")
        pulumi.set(__self__, "attachment_id", attachment_id)
        if attachment_type and not isinstance(attachment_type, str):
            raise TypeError("Expected argument 'attachment_type' to be a str")
        pulumi.set(__self__, "attachment_type", attachment_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if propagations and not isinstance(propagations, list):
            raise TypeError("Expected argument 'propagations' to be a list")
        pulumi.set(__self__, "propagations", propagations)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if route_table_id and not isinstance(route_table_id, str):
            raise TypeError("Expected argument 'route_table_id' to be a str")
        pulumi.set(__self__, "route_table_id", route_table_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> Optional[_builtins.str]:
        """
        The attachment ID corresponding to the propagation.
        """
        return pulumi.get(self, "attachment_id")

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[_builtins.str]:
        """
        The attachment type corresponding to the propagation.
        """
        return pulumi.get(self, "attachment_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ER instance ID to which the propagation belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def propagations(self) -> Sequence['outputs.GetPropagationsPropagationResult']:
        """
        All propagations that match the filter parameters.
        The propagations structure is documented below.
        """
        return pulumi.get(self, "propagations")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        """
        The route table ID of corresponding to the propagation.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The current status of the propagation.
        """
        return pulumi.get(self, "status")


class AwaitableGetPropagationsResult(GetPropagationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPropagationsResult(
            attachment_id=self.attachment_id,
            attachment_type=self.attachment_type,
            id=self.id,
            instance_id=self.instance_id,
            propagations=self.propagations,
            region=self.region,
            route_table_id=self.route_table_id,
            status=self.status)


def get_propagations(attachment_id: Optional[_builtins.str] = None,
                     attachment_type: Optional[_builtins.str] = None,
                     instance_id: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     route_table_id: Optional[_builtins.str] = None,
                     status: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPropagationsResult:
    """
    Use this data source to get the list of propagations.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    route_table_id = config.require_object("routeTableId")
    attachment_id = config.require_object("attachmentId")
    test = sbercloud.Er.get_propagations(instance_id=instance_id,
        route_table_id=route_table_id,
        attachment_id=attachment_id)
    ```


    :param _builtins.str attachment_id: Specifies the attachment ID to which the propagation belongs.
    :param _builtins.str attachment_type: Specifies the attachment type of corresponding to the propagation.  
           The valid values are as follows:
           + **vpc**: Virtual private cloud.
           + **vpn**: VPN gateway.
           + **vgw**: Virtual gateway of cloud private line.
           + **peering**: Peering connection, through the cloud connection (CC) to load ERs in different regions to create a
           peering connection.
           + **enc**: Enterprise connect network in EC.
           + **cfw**: VPC border firewall.
    :param _builtins.str instance_id: Specifies the ER instance ID to which the propagation belongs.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param _builtins.str route_table_id: Specifies the route table ID to which the propagation belongs.
    :param _builtins.str status: Specifies the status of the propagation. Default value is `available`.
           The valid values are as follows:
           + **available**
           + **failed**
    """
    __args__ = dict()
    __args__['attachmentId'] = attachment_id
    __args__['attachmentType'] = attachment_type
    __args__['instanceId'] = instance_id
    __args__['region'] = region
    __args__['routeTableId'] = route_table_id
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Er/getPropagations:getPropagations', __args__, opts=opts, typ=GetPropagationsResult).value

    return AwaitableGetPropagationsResult(
        attachment_id=pulumi.get(__ret__, 'attachment_id'),
        attachment_type=pulumi.get(__ret__, 'attachment_type'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        propagations=pulumi.get(__ret__, 'propagations'),
        region=pulumi.get(__ret__, 'region'),
        route_table_id=pulumi.get(__ret__, 'route_table_id'),
        status=pulumi.get(__ret__, 'status'))
def get_propagations_output(attachment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            attachment_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                            status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPropagationsResult]:
    """
    Use this data source to get the list of propagations.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    route_table_id = config.require_object("routeTableId")
    attachment_id = config.require_object("attachmentId")
    test = sbercloud.Er.get_propagations(instance_id=instance_id,
        route_table_id=route_table_id,
        attachment_id=attachment_id)
    ```


    :param _builtins.str attachment_id: Specifies the attachment ID to which the propagation belongs.
    :param _builtins.str attachment_type: Specifies the attachment type of corresponding to the propagation.  
           The valid values are as follows:
           + **vpc**: Virtual private cloud.
           + **vpn**: VPN gateway.
           + **vgw**: Virtual gateway of cloud private line.
           + **peering**: Peering connection, through the cloud connection (CC) to load ERs in different regions to create a
           peering connection.
           + **enc**: Enterprise connect network in EC.
           + **cfw**: VPC border firewall.
    :param _builtins.str instance_id: Specifies the ER instance ID to which the propagation belongs.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param _builtins.str route_table_id: Specifies the route table ID to which the propagation belongs.
    :param _builtins.str status: Specifies the status of the propagation. Default value is `available`.
           The valid values are as follows:
           + **available**
           + **failed**
    """
    __args__ = dict()
    __args__['attachmentId'] = attachment_id
    __args__['attachmentType'] = attachment_type
    __args__['instanceId'] = instance_id
    __args__['region'] = region
    __args__['routeTableId'] = route_table_id
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Er/getPropagations:getPropagations', __args__, opts=opts, typ=GetPropagationsResult)
    return __ret__.apply(lambda __response__: GetPropagationsResult(
        attachment_id=pulumi.get(__response__, 'attachment_id'),
        attachment_type=pulumi.get(__response__, 'attachment_type'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        propagations=pulumi.get(__response__, 'propagations'),
        region=pulumi.get(__response__, 'region'),
        route_table_id=pulumi.get(__response__, 'route_table_id'),
        status=pulumi.get(__response__, 'status')))
