# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetQuotasResult',
    'AwaitableGetQuotasResult',
    'get_quotas',
    'get_quotas_output',
]

@pulumi.output_type
class GetQuotasResult:
    """
    A collection of values returned by getQuotas.
    """
    def __init__(__self__, id=None, instance_id=None, quotas=None, region=None, route_table_id=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if quotas and not isinstance(quotas, list):
            raise TypeError("Expected argument 'quotas' to be a list")
        pulumi.set(__self__, "quotas", quotas)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if route_table_id and not isinstance(route_table_id, str):
            raise TypeError("Expected argument 'route_table_id' to be a str")
        pulumi.set(__self__, "route_table_id", route_table_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def quotas(self) -> Sequence['outputs.GetQuotasQuotaResult']:
        """
        All quotas that match the filter parameters.
        """
        return pulumi.get(self, "quotas")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The quota type.
        """
        return pulumi.get(self, "type")


class AwaitableGetQuotasResult(GetQuotasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQuotasResult(
            id=self.id,
            instance_id=self.instance_id,
            quotas=self.quotas,
            region=self.region,
            route_table_id=self.route_table_id,
            type=self.type)


def get_quotas(instance_id: Optional[_builtins.str] = None,
               region: Optional[_builtins.str] = None,
               route_table_id: Optional[_builtins.str] = None,
               type: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQuotasResult:
    """
    Using this data source to query the list of available resource quotas within SberCloud.

    > Using an invalid ID to filter the results will not report an error or return an empty list, but will return a quota
       list with all usage equal to 0.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Er.get_quotas()
    ```


    :param _builtins.str instance_id: The instance ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str route_table_id: The route table ID.
    :param _builtins.str type: The quota type to be queried.
           The valid values are as follows:
           + **er_instance**: Quotas and usage for enterprise router instances.
           + **dc_attachment**: Quotas and usage for DC attachment.
           + **vpc_attachment**: Quotas and usage for VPC attachment.
           + **vpn_attachment**: Quotas and usage for VPN attachment.
           + **peering_attachment**: Quotas and usage for peering attachment.
           + **can_attachment**: Quotas and usage for can attachment.
           + **route_table**: Quotas and usage for route table.
           + **static_route**: Quotas and usage for static route.
           + **vpc_er**: The number of enterprise routers that each VPC can access and the current usage.
           + **flow_log**: The number of flow logs that can be created per attachment.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['region'] = region
    __args__['routeTableId'] = route_table_id
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Er/getQuotas:getQuotas', __args__, opts=opts, typ=GetQuotasResult).value

    return AwaitableGetQuotasResult(
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        quotas=pulumi.get(__ret__, 'quotas'),
        region=pulumi.get(__ret__, 'region'),
        route_table_id=pulumi.get(__ret__, 'route_table_id'),
        type=pulumi.get(__ret__, 'type'))
def get_quotas_output(instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      route_table_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQuotasResult]:
    """
    Using this data source to query the list of available resource quotas within SberCloud.

    > Using an invalid ID to filter the results will not report an error or return an empty list, but will return a quota
       list with all usage equal to 0.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Er.get_quotas()
    ```


    :param _builtins.str instance_id: The instance ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str route_table_id: The route table ID.
    :param _builtins.str type: The quota type to be queried.
           The valid values are as follows:
           + **er_instance**: Quotas and usage for enterprise router instances.
           + **dc_attachment**: Quotas and usage for DC attachment.
           + **vpc_attachment**: Quotas and usage for VPC attachment.
           + **vpn_attachment**: Quotas and usage for VPN attachment.
           + **peering_attachment**: Quotas and usage for peering attachment.
           + **can_attachment**: Quotas and usage for can attachment.
           + **route_table**: Quotas and usage for route table.
           + **static_route**: Quotas and usage for static route.
           + **vpc_er**: The number of enterprise routers that each VPC can access and the current usage.
           + **flow_log**: The number of flow logs that can be created per attachment.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['region'] = region
    __args__['routeTableId'] = route_table_id
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Er/getQuotas:getQuotas', __args__, opts=opts, typ=GetQuotasResult)
    return __ret__.apply(lambda __response__: GetQuotasResult(
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        quotas=pulumi.get(__response__, 'quotas'),
        region=pulumi.get(__response__, 'region'),
        route_table_id=pulumi.get(__response__, 'route_table_id'),
        type=pulumi.get(__response__, 'type')))
