# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetResourceTagsResult',
    'AwaitableGetResourceTagsResult',
    'get_resource_tags',
    'get_resource_tags_output',
]

@pulumi.output_type
class GetResourceTagsResult:
    """
    A collection of values returned by getResourceTags.
    """
    def __init__(__self__, id=None, region=None, resource_id=None, resource_type=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tags of a specified resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResourceTagsResult(GetResourceTagsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceTagsResult(
            id=self.id,
            region=self.region,
            resource_id=self.resource_id,
            resource_type=self.resource_type,
            tags=self.tags)


def get_resource_tags(region: Optional[_builtins.str] = None,
                      resource_id: Optional[_builtins.str] = None,
                      resource_type: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceTagsResult:
    """
    Use this data source to query the tag list of a specifies resource within SberCloud.

    ## Example Usage

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.Er.get_resource_tags(resource_type="instance",
        resource_id=instance_id)
    ```


    :param _builtins.str region: Specifies the region in which to query the resource tags.  
           If omitted, the provider-level region will be used.
    :param _builtins.str resource_id: Specifies the resource ID to which the tags belong that to be queried.
    :param _builtins.str resource_type: Specifies the resource type to which the tags belong that to be queried.  
           The valid values are as follows:
           + **instance**: enterprise router instance.
           + **route-table**: route table.
           + **vpc-attachment**: VPC connection.
           + **vgw-attachment**: virtual gateway connection.
           + **peering-attachment**: peering connection.
           + **vpn-attachment**: VPN gateway connection.
           + **ecn-attachment**: enterprise network connection.
           + **cfw-attachment**: cloud firewall connection.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['resourceId'] = resource_id
    __args__['resourceType'] = resource_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Er/getResourceTags:getResourceTags', __args__, opts=opts, typ=GetResourceTagsResult).value

    return AwaitableGetResourceTagsResult(
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        tags=pulumi.get(__ret__, 'tags'))
def get_resource_tags_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                             resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceTagsResult]:
    """
    Use this data source to query the tag list of a specifies resource within SberCloud.

    ## Example Usage

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.Er.get_resource_tags(resource_type="instance",
        resource_id=instance_id)
    ```


    :param _builtins.str region: Specifies the region in which to query the resource tags.  
           If omitted, the provider-level region will be used.
    :param _builtins.str resource_id: Specifies the resource ID to which the tags belong that to be queried.
    :param _builtins.str resource_type: Specifies the resource type to which the tags belong that to be queried.  
           The valid values are as follows:
           + **instance**: enterprise router instance.
           + **route-table**: route table.
           + **vpc-attachment**: VPC connection.
           + **vgw-attachment**: virtual gateway connection.
           + **peering-attachment**: peering connection.
           + **vpn-attachment**: VPN gateway connection.
           + **ecn-attachment**: enterprise network connection.
           + **cfw-attachment**: cloud firewall connection.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['resourceId'] = resource_id
    __args__['resourceType'] = resource_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Er/getResourceTags:getResourceTags', __args__, opts=opts, typ=GetResourceTagsResult)
    return __ret__.apply(lambda __response__: GetResourceTagsResult(
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        tags=pulumi.get(__response__, 'tags')))
