# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRouteTablesResult',
    'AwaitableGetRouteTablesResult',
    'get_route_tables',
    'get_route_tables_output',
]

@pulumi.output_type
class GetRouteTablesResult:
    """
    A collection of values returned by getRouteTables.
    """
    def __init__(__self__, id=None, instance_id=None, name=None, region=None, route_table_id=None, route_tables=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if route_table_id and not isinstance(route_table_id, str):
            raise TypeError("Expected argument 'route_table_id' to be a str")
        pulumi.set(__self__, "route_table_id", route_table_id)
        if route_tables and not isinstance(route_tables, list):
            raise TypeError("Expected argument 'route_tables' to be a list")
        pulumi.set(__self__, "route_tables", route_tables)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the route table.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> Sequence['outputs.GetRouteTablesRouteTableResult']:
        """
        All route tables that match the filter parameters.  
        The object structure is documented below.
        """
        return pulumi.get(self, "route_tables")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags")


class AwaitableGetRouteTablesResult(GetRouteTablesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteTablesResult(
            id=self.id,
            instance_id=self.instance_id,
            name=self.name,
            region=self.region,
            route_table_id=self.route_table_id,
            route_tables=self.route_tables,
            tags=self.tags)


def get_route_tables(instance_id: Optional[_builtins.str] = None,
                     name: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     route_table_id: Optional[_builtins.str] = None,
                     tags: Optional[Mapping[str, _builtins.str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteTablesResult:
    """
    Use this data source to query the route tables under the ER instance within SberCloud.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ### Querying specified route tables under ER instance using name

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    route_table_name = config.require_object("routeTableName")
    test = sbercloud.Er.get_route_tables(instance_id=instance_id,
        name=route_table_name)
    ```

    ### Querying specified route tables under ER instance using tags

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.Er.get_route_tables(instance_id=instance_id,
        tags={
            "foo": "bar",
        })
    ```


    :param _builtins.str instance_id: Specifies the ID of the ER instance to which the route tables belongs.
    :param _builtins.str name: Specifies the name used to filter the route tables.  
           The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
           hyphens (-) and dots (.) allowed.
    :param _builtins.str region: Specifies the region where the ER instance and route table are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str route_table_id: Specifies the route table ID used to query specified route table.
    :param Mapping[str, _builtins.str] tags: Specifies the key/value pairs used to filter the route tables.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['routeTableId'] = route_table_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Er/getRouteTables:getRouteTables', __args__, opts=opts, typ=GetRouteTablesResult).value

    return AwaitableGetRouteTablesResult(
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        route_table_id=pulumi.get(__ret__, 'route_table_id'),
        route_tables=pulumi.get(__ret__, 'route_tables'),
        tags=pulumi.get(__ret__, 'tags'))
def get_route_tables_output(instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                            name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            route_table_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRouteTablesResult]:
    """
    Use this data source to query the route tables under the ER instance within SberCloud.

    Before using enterprise router, define custom endpoint as shown below:
    ```python
    import pulumi
    ```

    ## Example Usage

    ### Querying specified route tables under ER instance using name

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    route_table_name = config.require_object("routeTableName")
    test = sbercloud.Er.get_route_tables(instance_id=instance_id,
        name=route_table_name)
    ```

    ### Querying specified route tables under ER instance using tags

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.Er.get_route_tables(instance_id=instance_id,
        tags={
            "foo": "bar",
        })
    ```


    :param _builtins.str instance_id: Specifies the ID of the ER instance to which the route tables belongs.
    :param _builtins.str name: Specifies the name used to filter the route tables.  
           The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
           hyphens (-) and dots (.) allowed.
    :param _builtins.str region: Specifies the region where the ER instance and route table are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str route_table_id: Specifies the route table ID used to query specified route table.
    :param Mapping[str, _builtins.str] tags: Specifies the key/value pairs used to filter the route tables.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['routeTableId'] = route_table_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Er/getRouteTables:getRouteTables', __args__, opts=opts, typ=GetRouteTablesResult)
    return __ret__.apply(lambda __response__: GetRouteTablesResult(
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        route_table_id=pulumi.get(__response__, 'route_table_id'),
        route_tables=pulumi.get(__response__, 'route_tables'),
        tags=pulumi.get(__response__, 'tags')))
