# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 asn: pulumi.Input[_builtins.int],
                 availability_zones: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 auto_accept_shared_attachments: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_association_route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_propagation_route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_default_association: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_default_propagation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.int] asn: The BGP AS number of the ER instance.  
               The valid value is range from `64,512` to `65534` or range from `4,200,000,000` to `4,294,967,294`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The availability zone list where the ER instance is located.
               The maximum number of availability zone is two. Select two AZs to configure active-active deployment for high
               availability which will ensure reliability and disaster recovery.
        :param pulumi.Input[_builtins.bool] auto_accept_shared_attachments: Whether to automatically accept the creation of shared
               attachment.
               The default value is **false**.
        :param pulumi.Input[_builtins.str] default_association_route_table_id: The ID of the default association route table.
               
               > Before modifying the default routing table of this instance (except cancel the default route table), make sure
               `enable_default_association` is set to **true**.
        :param pulumi.Input[_builtins.str] default_propagation_route_table_id: The ID of the default propagation route table.
               
               > Before modifying the default routing table of this instance (except cancel the default route table), make sure
               `enable_default_propagation` is set to **true**.
        :param pulumi.Input[_builtins.str] description: The description of the ER instance.  
               The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[_builtins.bool] enable_default_association: Whether to enable the association of the default route table.  
               The default value is **false**.
        :param pulumi.Input[_builtins.bool] enable_default_propagation: Whether to enable the propagation of the default route table.  
               The default value is **false**.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID to which the ER instance
               belongs.
        :param pulumi.Input[_builtins.str] name: The router name.  
               The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
               hyphens (-) and dots (.) allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the instance.
        """
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "availability_zones", availability_zones)
        if auto_accept_shared_attachments is not None:
            pulumi.set(__self__, "auto_accept_shared_attachments", auto_accept_shared_attachments)
        if default_association_route_table_id is not None:
            pulumi.set(__self__, "default_association_route_table_id", default_association_route_table_id)
        if default_propagation_route_table_id is not None:
            pulumi.set(__self__, "default_propagation_route_table_id", default_propagation_route_table_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_default_association is not None:
            pulumi.set(__self__, "enable_default_association", enable_default_association)
        if enable_default_propagation is not None:
            pulumi.set(__self__, "enable_default_propagation", enable_default_propagation)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> pulumi.Input[_builtins.int]:
        """
        The BGP AS number of the ER instance.  
        The valid value is range from `64,512` to `65534` or range from `4,200,000,000` to `4,294,967,294`.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "asn", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The availability zone list where the ER instance is located.
        The maximum number of availability zone is two. Select two AZs to configure active-active deployment for high
        availability which will ensure reliability and disaster recovery.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="autoAcceptSharedAttachments")
    def auto_accept_shared_attachments(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically accept the creation of shared
        attachment.
        The default value is **false**.
        """
        return pulumi.get(self, "auto_accept_shared_attachments")

    @auto_accept_shared_attachments.setter
    def auto_accept_shared_attachments(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_accept_shared_attachments", value)

    @_builtins.property
    @pulumi.getter(name="defaultAssociationRouteTableId")
    def default_association_route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the default association route table.

        > Before modifying the default routing table of this instance (except cancel the default route table), make sure
        `enable_default_association` is set to **true**.
        """
        return pulumi.get(self, "default_association_route_table_id")

    @default_association_route_table_id.setter
    def default_association_route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_association_route_table_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultPropagationRouteTableId")
    def default_propagation_route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the default propagation route table.

        > Before modifying the default routing table of this instance (except cancel the default route table), make sure
        `enable_default_propagation` is set to **true**.
        """
        return pulumi.get(self, "default_propagation_route_table_id")

    @default_propagation_route_table_id.setter
    def default_propagation_route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_propagation_route_table_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the ER instance.  
        The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableDefaultAssociation")
    def enable_default_association(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the association of the default route table.  
        The default value is **false**.
        """
        return pulumi.get(self, "enable_default_association")

    @enable_default_association.setter
    def enable_default_association(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_default_association", value)

    @_builtins.property
    @pulumi.getter(name="enableDefaultPropagation")
    def enable_default_propagation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the propagation of the default route table.  
        The default value is **false**.
        """
        return pulumi.get(self, "enable_default_propagation")

    @enable_default_propagation.setter
    def enable_default_propagation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_default_propagation", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID to which the ER instance
        belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The router name.  
        The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
        hyphens (-) and dots (.) allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_accept_shared_attachments: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 default_association_route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_propagation_route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_default_association: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_default_propagation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.int] asn: The BGP AS number of the ER instance.  
               The valid value is range from `64,512` to `65534` or range from `4,200,000,000` to `4,294,967,294`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] auto_accept_shared_attachments: Whether to automatically accept the creation of shared
               attachment.
               The default value is **false**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The availability zone list where the ER instance is located.
               The maximum number of availability zone is two. Select two AZs to configure active-active deployment for high
               availability which will ensure reliability and disaster recovery.
        :param pulumi.Input[_builtins.str] created_at: The creation time.
        :param pulumi.Input[_builtins.str] default_association_route_table_id: The ID of the default association route table.
               
               > Before modifying the default routing table of this instance (except cancel the default route table), make sure
               `enable_default_association` is set to **true**.
        :param pulumi.Input[_builtins.str] default_propagation_route_table_id: The ID of the default propagation route table.
               
               > Before modifying the default routing table of this instance (except cancel the default route table), make sure
               `enable_default_propagation` is set to **true**.
        :param pulumi.Input[_builtins.str] description: The description of the ER instance.  
               The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[_builtins.bool] enable_default_association: Whether to enable the association of the default route table.  
               The default value is **false**.
        :param pulumi.Input[_builtins.bool] enable_default_propagation: Whether to enable the propagation of the default route table.  
               The default value is **false**.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID to which the ER instance
               belongs.
        :param pulumi.Input[_builtins.str] name: The router name.  
               The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
               hyphens (-) and dots (.) allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: Current status of the router.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the instance.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time.
        """
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if auto_accept_shared_attachments is not None:
            pulumi.set(__self__, "auto_accept_shared_attachments", auto_accept_shared_attachments)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if default_association_route_table_id is not None:
            pulumi.set(__self__, "default_association_route_table_id", default_association_route_table_id)
        if default_propagation_route_table_id is not None:
            pulumi.set(__self__, "default_propagation_route_table_id", default_propagation_route_table_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_default_association is not None:
            pulumi.set(__self__, "enable_default_association", enable_default_association)
        if enable_default_propagation is not None:
            pulumi.set(__self__, "enable_default_propagation", enable_default_propagation)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The BGP AS number of the ER instance.  
        The valid value is range from `64,512` to `65534` or range from `4,200,000,000` to `4,294,967,294`.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "asn", value)

    @_builtins.property
    @pulumi.getter(name="autoAcceptSharedAttachments")
    def auto_accept_shared_attachments(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically accept the creation of shared
        attachment.
        The default value is **false**.
        """
        return pulumi.get(self, "auto_accept_shared_attachments")

    @auto_accept_shared_attachments.setter
    def auto_accept_shared_attachments(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_accept_shared_attachments", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The availability zone list where the ER instance is located.
        The maximum number of availability zone is two. Select two AZs to configure active-active deployment for high
        availability which will ensure reliability and disaster recovery.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="defaultAssociationRouteTableId")
    def default_association_route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the default association route table.

        > Before modifying the default routing table of this instance (except cancel the default route table), make sure
        `enable_default_association` is set to **true**.
        """
        return pulumi.get(self, "default_association_route_table_id")

    @default_association_route_table_id.setter
    def default_association_route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_association_route_table_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultPropagationRouteTableId")
    def default_propagation_route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the default propagation route table.

        > Before modifying the default routing table of this instance (except cancel the default route table), make sure
        `enable_default_propagation` is set to **true**.
        """
        return pulumi.get(self, "default_propagation_route_table_id")

    @default_propagation_route_table_id.setter
    def default_propagation_route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_propagation_route_table_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the ER instance.  
        The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableDefaultAssociation")
    def enable_default_association(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the association of the default route table.  
        The default value is **false**.
        """
        return pulumi.get(self, "enable_default_association")

    @enable_default_association.setter
    def enable_default_association(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_default_association", value)

    @_builtins.property
    @pulumi.getter(name="enableDefaultPropagation")
    def enable_default_propagation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the propagation of the default route table.  
        The default value is **false**.
        """
        return pulumi.get(self, "enable_default_propagation")

    @enable_default_propagation.setter
    def enable_default_propagation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_default_propagation", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID to which the ER instance
        belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The router name.  
        The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
        hyphens (-) and dots (.) allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current status of the router.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update time.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:Er/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_accept_shared_attachments: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_association_route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_propagation_route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_default_association: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_default_propagation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an ER instance resource within SberCloud.

        Before using enterprise router, define custom endpoint as shown below:
        ```python
        import pulumi
        ```

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        router_name = config.require_object("routerName")
        bgp_as_number = config.require_object("bgpAsNumber")
        availability_zones = config.require_object("availabilityZones")
        test = sbercloud.er.Instance("test",
            availability_zones=availability_zones,
            name=router_name,
            asn=bgp_as_number)
        ```

        ## Import

        The router instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Er/instance:Instance test 0ce123456a00f2591fabc00385ff1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] asn: The BGP AS number of the ER instance.  
               The valid value is range from `64,512` to `65534` or range from `4,200,000,000` to `4,294,967,294`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] auto_accept_shared_attachments: Whether to automatically accept the creation of shared
               attachment.
               The default value is **false**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The availability zone list where the ER instance is located.
               The maximum number of availability zone is two. Select two AZs to configure active-active deployment for high
               availability which will ensure reliability and disaster recovery.
        :param pulumi.Input[_builtins.str] default_association_route_table_id: The ID of the default association route table.
               
               > Before modifying the default routing table of this instance (except cancel the default route table), make sure
               `enable_default_association` is set to **true**.
        :param pulumi.Input[_builtins.str] default_propagation_route_table_id: The ID of the default propagation route table.
               
               > Before modifying the default routing table of this instance (except cancel the default route table), make sure
               `enable_default_propagation` is set to **true**.
        :param pulumi.Input[_builtins.str] description: The description of the ER instance.  
               The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[_builtins.bool] enable_default_association: Whether to enable the association of the default route table.  
               The default value is **false**.
        :param pulumi.Input[_builtins.bool] enable_default_propagation: Whether to enable the propagation of the default route table.  
               The default value is **false**.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID to which the ER instance
               belongs.
        :param pulumi.Input[_builtins.str] name: The router name.  
               The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
               hyphens (-) and dots (.) allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ER instance resource within SberCloud.

        Before using enterprise router, define custom endpoint as shown below:
        ```python
        import pulumi
        ```

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        router_name = config.require_object("routerName")
        bgp_as_number = config.require_object("bgpAsNumber")
        availability_zones = config.require_object("availabilityZones")
        test = sbercloud.er.Instance("test",
            availability_zones=availability_zones,
            name=router_name,
            asn=bgp_as_number)
        ```

        ## Import

        The router instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Er/instance:Instance test 0ce123456a00f2591fabc00385ff1234
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_accept_shared_attachments: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_association_route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_propagation_route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_default_association: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_default_propagation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            if asn is None and not opts.urn:
                raise TypeError("Missing required property 'asn'")
            __props__.__dict__["asn"] = asn
            __props__.__dict__["auto_accept_shared_attachments"] = auto_accept_shared_attachments
            if availability_zones is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zones'")
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["default_association_route_table_id"] = default_association_route_table_id
            __props__.__dict__["default_propagation_route_table_id"] = default_propagation_route_table_id
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_default_association"] = enable_default_association
            __props__.__dict__["enable_default_propagation"] = enable_default_propagation
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(Instance, __self__).__init__(
            'sbercloud:Er/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            asn: Optional[pulumi.Input[_builtins.int]] = None,
            auto_accept_shared_attachments: Optional[pulumi.Input[_builtins.bool]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            default_association_route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_propagation_route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_default_association: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_default_propagation: Optional[pulumi.Input[_builtins.bool]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] asn: The BGP AS number of the ER instance.  
               The valid value is range from `64,512` to `65534` or range from `4,200,000,000` to `4,294,967,294`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] auto_accept_shared_attachments: Whether to automatically accept the creation of shared
               attachment.
               The default value is **false**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The availability zone list where the ER instance is located.
               The maximum number of availability zone is two. Select two AZs to configure active-active deployment for high
               availability which will ensure reliability and disaster recovery.
        :param pulumi.Input[_builtins.str] created_at: The creation time.
        :param pulumi.Input[_builtins.str] default_association_route_table_id: The ID of the default association route table.
               
               > Before modifying the default routing table of this instance (except cancel the default route table), make sure
               `enable_default_association` is set to **true**.
        :param pulumi.Input[_builtins.str] default_propagation_route_table_id: The ID of the default propagation route table.
               
               > Before modifying the default routing table of this instance (except cancel the default route table), make sure
               `enable_default_propagation` is set to **true**.
        :param pulumi.Input[_builtins.str] description: The description of the ER instance.  
               The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[_builtins.bool] enable_default_association: Whether to enable the association of the default route table.  
               The default value is **false**.
        :param pulumi.Input[_builtins.bool] enable_default_propagation: Whether to enable the propagation of the default route table.  
               The default value is **false**.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID to which the ER instance
               belongs.
        :param pulumi.Input[_builtins.str] name: The router name.  
               The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
               hyphens (-) and dots (.) allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: Current status of the router.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the instance.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["asn"] = asn
        __props__.__dict__["auto_accept_shared_attachments"] = auto_accept_shared_attachments
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["default_association_route_table_id"] = default_association_route_table_id
        __props__.__dict__["default_propagation_route_table_id"] = default_propagation_route_table_id
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_default_association"] = enable_default_association
        __props__.__dict__["enable_default_propagation"] = enable_default_propagation
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> pulumi.Output[_builtins.int]:
        """
        The BGP AS number of the ER instance.  
        The valid value is range from `64,512` to `65534` or range from `4,200,000,000` to `4,294,967,294`.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "asn")

    @_builtins.property
    @pulumi.getter(name="autoAcceptSharedAttachments")
    def auto_accept_shared_attachments(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to automatically accept the creation of shared
        attachment.
        The default value is **false**.
        """
        return pulumi.get(self, "auto_accept_shared_attachments")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The availability zone list where the ER instance is located.
        The maximum number of availability zone is two. Select two AZs to configure active-active deployment for high
        availability which will ensure reliability and disaster recovery.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="defaultAssociationRouteTableId")
    def default_association_route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the default association route table.

        > Before modifying the default routing table of this instance (except cancel the default route table), make sure
        `enable_default_association` is set to **true**.
        """
        return pulumi.get(self, "default_association_route_table_id")

    @_builtins.property
    @pulumi.getter(name="defaultPropagationRouteTableId")
    def default_propagation_route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the default propagation route table.

        > Before modifying the default routing table of this instance (except cancel the default route table), make sure
        `enable_default_propagation` is set to **true**.
        """
        return pulumi.get(self, "default_propagation_route_table_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the ER instance.  
        The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableDefaultAssociation")
    def enable_default_association(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable the association of the default route table.  
        The default value is **false**.
        """
        return pulumi.get(self, "enable_default_association")

    @_builtins.property
    @pulumi.getter(name="enableDefaultPropagation")
    def enable_default_propagation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable the propagation of the default route table.  
        The default value is **false**.
        """
        return pulumi.get(self, "enable_default_propagation")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project ID to which the ER instance
        belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The router name.  
        The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
        hyphens (-) and dots (.) allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Current status of the router.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update time.
        """
        return pulumi.get(self, "updated_at")

