# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAssociationsAssociationResult',
    'GetAttachmentsAttachmentResult',
    'GetAvailableRoutesRouteResult',
    'GetAvailableRoutesRouteNextHopResult',
    'GetFlowLogsFlowLogResult',
    'GetInstancesInstanceResult',
    'GetPropagationsPropagationResult',
    'GetQuotasQuotaResult',
    'GetRouteTablesRouteTableResult',
    'GetRouteTablesRouteTableAssociationResult',
    'GetRouteTablesRouteTablePropagationResult',
    'GetRouteTablesRouteTableRouteResult',
    'GetRouteTablesRouteTableRouteAttachmentResult',
    'GetTagsTagResult',
]

@pulumi.output_type
class GetAssociationsAssociationResult(dict):
    def __init__(__self__, *,
                 attachment_id: _builtins.str,
                 attachment_type: _builtins.str,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 resource_id: _builtins.str,
                 route_policy_id: _builtins.str,
                 route_table_id: _builtins.str,
                 status: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.str attachment_id: Specifies the attachment ID corresponding to the association.
        :param _builtins.str attachment_type: Specifies the attachment type corresponding to the association.
        :param _builtins.str created_at: The creation time.
        :param _builtins.str id: The association ID.
        :param _builtins.str resource_id: The resource ID of the attachment corresponding to the association.
        :param _builtins.str route_policy_id: The route policy ID of the egress IPv4 protocol.
        :param _builtins.str route_table_id: Specifies the route table ID to which the association belongs.
        :param _builtins.str status: Specifies the status of the association. Default value is `available`.
               The valid values are as follows:
               + **available**
               + **failed**
        :param _builtins.str updated_at: The latest update time.
        """
        pulumi.set(__self__, "attachment_id", attachment_id)
        pulumi.set(__self__, "attachment_type", attachment_type)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "route_policy_id", route_policy_id)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> _builtins.str:
        """
        Specifies the attachment ID corresponding to the association.
        """
        return pulumi.get(self, "attachment_id")

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> _builtins.str:
        """
        Specifies the attachment type corresponding to the association.
        """
        return pulumi.get(self, "attachment_type")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation time.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The association ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The resource ID of the attachment corresponding to the association.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="routePolicyId")
    def route_policy_id(self) -> _builtins.str:
        """
        The route policy ID of the egress IPv4 protocol.
        """
        return pulumi.get(self, "route_policy_id")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        """
        Specifies the route table ID to which the association belongs.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the status of the association. Default value is `available`.
        The valid values are as follows:
        + **available**
        + **failed**
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The latest update time.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 associated: _builtins.bool,
                 created_at: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 resource_id: _builtins.str,
                 route_table_id: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 type: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.bool associated: Whether this attachment has been associated.
        :param _builtins.str created_at: The creation time of the attachment.
        :param _builtins.str description: The description of the attachment.
        :param _builtins.str id: The attachment ID.
        :param _builtins.str name: Specifies the name used to filter the attachments.
        :param _builtins.str resource_id: Specifies the associated resource ID used to filter the attachments.
        :param _builtins.str route_table_id: The associated route table ID.
        :param _builtins.str status: Specifies the status used to filter the attachments.
               The valid values are as follows:
               + **available**
               + **failed**
               + **pending_acceptance**
               + **rejected**
        :param Mapping[str, _builtins.str] tags: The key/value pairs used to filter the attachments.
        :param _builtins.str type: Specifies the resource type to be filtered.  
               The valid values are as follows:
               + **vpc**: Virtual private cloud.
               + **vpn**: VPN gateway.
               + **vgw**: Virtual gateway of cloud private line.
               + **peering**: Peering connection, through the cloud connection (CC) to load ERs in different regions to create a
               peering connection.
        :param _builtins.str updated_at: The latest update time of the attachment.
        """
        pulumi.set(__self__, "associated", associated)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def associated(self) -> _builtins.bool:
        """
        Whether this attachment has been associated.
        """
        return pulumi.get(self, "associated")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation time of the attachment.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the attachment.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The attachment ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name used to filter the attachments.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        Specifies the associated resource ID used to filter the attachments.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        """
        The associated route table ID.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the status used to filter the attachments.
        The valid values are as follows:
        + **available**
        + **failed**
        + **pending_acceptance**
        + **rejected**
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The key/value pairs used to filter the attachments.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the resource type to be filtered.  
        The valid values are as follows:
        + **vpc**: Virtual private cloud.
        + **vpn**: VPN gateway.
        + **vgw**: Virtual gateway of cloud private line.
        + **peering**: Peering connection, through the cloud connection (CC) to load ERs in different regions to create a
        peering connection.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The latest update time of the attachment.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetAvailableRoutesRouteResult(dict):
    def __init__(__self__, *,
                 destination: _builtins.str,
                 id: _builtins.str,
                 is_blackhole: _builtins.bool,
                 next_hops: Sequence['outputs.GetAvailableRoutesRouteNextHopResult'],
                 type: _builtins.str):
        """
        :param _builtins.str destination: The destination address of the routes to be queried.
        :param _builtins.str id: The route ID.
        :param _builtins.bool is_blackhole: Whether the route is a blackhole route.
        :param Sequence['GetAvailableRoutesRouteNextHopArgs'] next_hops: The next hops of the route.
        :param _builtins.str type: The route type.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_blackhole", is_blackhole)
        pulumi.set(__self__, "next_hops", next_hops)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        The destination address of the routes to be queried.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The route ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isBlackhole")
    def is_blackhole(self) -> _builtins.bool:
        """
        Whether the route is a blackhole route.
        """
        return pulumi.get(self, "is_blackhole")

    @_builtins.property
    @pulumi.getter(name="nextHops")
    def next_hops(self) -> Sequence['outputs.GetAvailableRoutesRouteNextHopResult']:
        """
        The next hops of the route.
        """
        return pulumi.get(self, "next_hops")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The route type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAvailableRoutesRouteNextHopResult(dict):
    def __init__(__self__, *,
                 attachment_id: _builtins.str,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str):
        """
        :param _builtins.str attachment_id: The attachment ID.
        :param _builtins.str resource_id: The attached resource ID.
        :param _builtins.str resource_type: The attachment type.
               The valid values are as follows:
               + **vpc**: VPC attachment.
               + **vpn**: VPN gateway attachment.
               + **vgw**: virtual gateway attachment.
               + **peering**: peering connection attachment.
               + **ecn**: ECN attachment.
               + **cfw**: CFW instance attachment.
        """
        pulumi.set(__self__, "attachment_id", attachment_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> _builtins.str:
        """
        The attachment ID.
        """
        return pulumi.get(self, "attachment_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The attached resource ID.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The attachment type.
        The valid values are as follows:
        + **vpc**: VPC attachment.
        + **vpn**: VPN gateway attachment.
        + **vgw**: virtual gateway attachment.
        + **peering**: peering connection attachment.
        + **ecn**: ECN attachment.
        + **cfw**: CFW instance attachment.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class GetFlowLogsFlowLogResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 description: _builtins.str,
                 enabled: _builtins.bool,
                 id: _builtins.str,
                 log_group_id: _builtins.str,
                 log_store_type: _builtins.str,
                 log_stream_id: _builtins.str,
                 name: _builtins.str,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 status: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.str created_at: The creation time of the flow log.
        :param _builtins.str description: The description of the flow log.
        :param _builtins.bool enabled: Specifies the switch status of the flow log.
               The value can be **true** and **false**.
        :param _builtins.str id: The ID of the flow log.
        :param _builtins.str log_group_id: Specifies the ID of the log group to which the flow logs belong.
        :param _builtins.str log_store_type: The storage type of the flow log.
        :param _builtins.str log_stream_id: Specifies the ID of the log stream to which the flow logs belong.
        :param _builtins.str name: Specifies the name of the flow log.
        :param _builtins.str resource_id: Specifies the ID of the attachment to which the flow logs belong.
        :param _builtins.str resource_type: Specifies the type of the flow logs.
               The valid values are as follows:
               + **attachment**: The flow logs type are attachment.
        :param _builtins.str status: Specifies the status of the flow logs.
        :param _builtins.str updated_at: The latest update time of the flow log.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_store_type", log_store_type)
        pulumi.set(__self__, "log_stream_id", log_stream_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation time of the flow log.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the flow log.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Specifies the switch status of the flow log.
        The value can be **true** and **false**.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the flow log.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> _builtins.str:
        """
        Specifies the ID of the log group to which the flow logs belong.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logStoreType")
    def log_store_type(self) -> _builtins.str:
        """
        The storage type of the flow log.
        """
        return pulumi.get(self, "log_store_type")

    @_builtins.property
    @pulumi.getter(name="logStreamId")
    def log_stream_id(self) -> _builtins.str:
        """
        Specifies the ID of the log stream to which the flow logs belong.
        """
        return pulumi.get(self, "log_stream_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the flow log.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        Specifies the ID of the attachment to which the flow logs belong.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        Specifies the type of the flow logs.
        The valid values are as follows:
        + **attachment**: The flow logs type are attachment.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the status of the flow logs.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The latest update time of the flow log.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 asn: _builtins.int,
                 auto_accept_shared_attachments: _builtins.bool,
                 availability_zones: Sequence[_builtins.str],
                 created_at: _builtins.str,
                 default_association_route_table_id: _builtins.str,
                 default_propagation_route_table_id: _builtins.str,
                 description: _builtins.str,
                 enable_default_association: _builtins.bool,
                 enable_default_propagation: _builtins.bool,
                 enterprise_project_id: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 updated_at: _builtins.str):
        """
        :param _builtins.int asn: The BGP AS number of the ER instance.
        :param _builtins.bool auto_accept_shared_attachments: Whether to automatically accept the creation of shared attachment.
        :param Sequence[_builtins.str] availability_zones: The availability zone list where the ER instance is located.
        :param _builtins.str created_at: The creation time of the ER instance.
        :param _builtins.str default_association_route_table_id: The ID of the default association route table.
        :param _builtins.str default_propagation_route_table_id: The ID of the default propagation route table.
        :param _builtins.str description: The description of the ER instance.
        :param _builtins.bool enable_default_association: Whether to enable the association of the default route table.
        :param _builtins.bool enable_default_propagation: Whether to enable the propagation of the default route table.
        :param _builtins.str enterprise_project_id: Specifies the enterprise project ID of the ER instances to be queried.
        :param _builtins.str id: The ER instance ID.
        :param _builtins.str name: Specifies the name used to filter the ER instances.
               The valid length is limited from `1` to `64`, only Chinese and English letters, digits, underscores (_) and
               hyphens (-) are allowed.
        :param _builtins.str status: Specifies the status used to filter the ER instances.
        :param Mapping[str, _builtins.str] tags: Specifies the key/value pairs used to filter the ER instances.
        :param _builtins.str updated_at: The last update time of the ER instance.
        """
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "auto_accept_shared_attachments", auto_accept_shared_attachments)
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "default_association_route_table_id", default_association_route_table_id)
        pulumi.set(__self__, "default_propagation_route_table_id", default_propagation_route_table_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enable_default_association", enable_default_association)
        pulumi.set(__self__, "enable_default_propagation", enable_default_propagation)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> _builtins.int:
        """
        The BGP AS number of the ER instance.
        """
        return pulumi.get(self, "asn")

    @_builtins.property
    @pulumi.getter(name="autoAcceptSharedAttachments")
    def auto_accept_shared_attachments(self) -> _builtins.bool:
        """
        Whether to automatically accept the creation of shared attachment.
        """
        return pulumi.get(self, "auto_accept_shared_attachments")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[_builtins.str]:
        """
        The availability zone list where the ER instance is located.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation time of the ER instance.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="defaultAssociationRouteTableId")
    def default_association_route_table_id(self) -> _builtins.str:
        """
        The ID of the default association route table.
        """
        return pulumi.get(self, "default_association_route_table_id")

    @_builtins.property
    @pulumi.getter(name="defaultPropagationRouteTableId")
    def default_propagation_route_table_id(self) -> _builtins.str:
        """
        The ID of the default propagation route table.
        """
        return pulumi.get(self, "default_propagation_route_table_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the ER instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableDefaultAssociation")
    def enable_default_association(self) -> _builtins.bool:
        """
        Whether to enable the association of the default route table.
        """
        return pulumi.get(self, "enable_default_association")

    @_builtins.property
    @pulumi.getter(name="enableDefaultPropagation")
    def enable_default_propagation(self) -> _builtins.bool:
        """
        Whether to enable the propagation of the default route table.
        """
        return pulumi.get(self, "enable_default_propagation")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        """
        Specifies the enterprise project ID of the ER instances to be queried.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ER instance ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name used to filter the ER instances.
        The valid length is limited from `1` to `64`, only Chinese and English letters, digits, underscores (_) and
        hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the status used to filter the ER instances.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Specifies the key/value pairs used to filter the ER instances.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The last update time of the ER instance.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetPropagationsPropagationResult(dict):
    def __init__(__self__, *,
                 attachment_id: _builtins.str,
                 attachment_type: _builtins.str,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 resource_id: _builtins.str,
                 route_policy_id: _builtins.str,
                 route_table_id: _builtins.str,
                 status: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.str attachment_id: Specifies the attachment ID to which the propagation belongs.
        :param _builtins.str attachment_type: Specifies the attachment type of corresponding to the propagation.  
               The valid values are as follows:
               + **vpc**: Virtual private cloud.
               + **vpn**: VPN gateway.
               + **vgw**: Virtual gateway of cloud private line.
               + **peering**: Peering connection, through the cloud connection (CC) to load ERs in different regions to create a
               peering connection.
               + **enc**: Enterprise connect network in EC.
               + **cfw**: VPC border firewall.
        :param _builtins.str created_at: The creation time of the propagation.
        :param _builtins.str id: The propagation ID.
        :param _builtins.str instance_id: Specifies the ER instance ID to which the propagation belongs.
        :param _builtins.str resource_id: The resource ID of the attachment associated with the propagation.
        :param _builtins.str route_policy_id: The route policy ID of the ingress IPv4 protocol.
        :param _builtins.str route_table_id: Specifies the route table ID to which the propagation belongs.
        :param _builtins.str status: Specifies the status of the propagation. Default value is `available`.
               The valid values are as follows:
               + **available**
               + **failed**
        :param _builtins.str updated_at: The latest update time of the propagation.
        """
        pulumi.set(__self__, "attachment_id", attachment_id)
        pulumi.set(__self__, "attachment_type", attachment_type)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "route_policy_id", route_policy_id)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> _builtins.str:
        """
        Specifies the attachment ID to which the propagation belongs.
        """
        return pulumi.get(self, "attachment_id")

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> _builtins.str:
        """
        Specifies the attachment type of corresponding to the propagation.  
        The valid values are as follows:
        + **vpc**: Virtual private cloud.
        + **vpn**: VPN gateway.
        + **vgw**: Virtual gateway of cloud private line.
        + **peering**: Peering connection, through the cloud connection (CC) to load ERs in different regions to create a
        peering connection.
        + **enc**: Enterprise connect network in EC.
        + **cfw**: VPC border firewall.
        """
        return pulumi.get(self, "attachment_type")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation time of the propagation.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The propagation ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        Specifies the ER instance ID to which the propagation belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The resource ID of the attachment associated with the propagation.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="routePolicyId")
    def route_policy_id(self) -> _builtins.str:
        """
        The route policy ID of the ingress IPv4 protocol.
        """
        return pulumi.get(self, "route_policy_id")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        """
        Specifies the route table ID to which the propagation belongs.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the status of the propagation. Default value is `available`.
        The valid values are as follows:
        + **available**
        + **failed**
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The latest update time of the propagation.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetQuotasQuotaResult(dict):
    def __init__(__self__, *,
                 limit: _builtins.int,
                 type: _builtins.str,
                 unit: _builtins.str,
                 used: _builtins.int):
        """
        :param _builtins.int limit: The number of available quotas, `-1` means unlimited.
        :param _builtins.str type: The quota type to be queried.
               The valid values are as follows:
               + **er_instance**: Quotas and usage for enterprise router instances.
               + **dc_attachment**: Quotas and usage for DC attachment.
               + **vpc_attachment**: Quotas and usage for VPC attachment.
               + **vpn_attachment**: Quotas and usage for VPN attachment.
               + **peering_attachment**: Quotas and usage for peering attachment.
               + **can_attachment**: Quotas and usage for can attachment.
               + **route_table**: Quotas and usage for route table.
               + **static_route**: Quotas and usage for static route.
               + **vpc_er**: The number of enterprise routers that each VPC can access and the current usage.
               + **flow_log**: The number of flow logs that can be created per attachment.
        :param _builtins.str unit: The unit of usage.
        :param _builtins.int used: The number of quota used.
        """
        pulumi.set(__self__, "limit", limit)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "used", used)

    @_builtins.property
    @pulumi.getter
    def limit(self) -> _builtins.int:
        """
        The number of available quotas, `-1` means unlimited.
        """
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The quota type to be queried.
        The valid values are as follows:
        + **er_instance**: Quotas and usage for enterprise router instances.
        + **dc_attachment**: Quotas and usage for DC attachment.
        + **vpc_attachment**: Quotas and usage for VPC attachment.
        + **vpn_attachment**: Quotas and usage for VPN attachment.
        + **peering_attachment**: Quotas and usage for peering attachment.
        + **can_attachment**: Quotas and usage for can attachment.
        + **route_table**: Quotas and usage for route table.
        + **static_route**: Quotas and usage for static route.
        + **vpc_er**: The number of enterprise routers that each VPC can access and the current usage.
        + **flow_log**: The number of flow logs that can be created per attachment.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        """
        The unit of usage.
        """
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def used(self) -> _builtins.int:
        """
        The number of quota used.
        """
        return pulumi.get(self, "used")


@pulumi.output_type
class GetRouteTablesRouteTableResult(dict):
    def __init__(__self__, *,
                 associations: Sequence['outputs.GetRouteTablesRouteTableAssociationResult'],
                 created_at: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 is_default_association: _builtins.bool,
                 is_default_propagation: _builtins.bool,
                 name: _builtins.str,
                 propagations: Sequence['outputs.GetRouteTablesRouteTablePropagationResult'],
                 routes: Sequence['outputs.GetRouteTablesRouteTableRouteResult'],
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 updated_at: _builtins.str):
        """
        :param Sequence['GetRouteTablesRouteTableAssociationArgs'] associations: The association configurations of the route table.  
               The object structure is documented below.
        :param _builtins.str created_at: The creation time.
        :param _builtins.str description: The description of the route table.
        :param _builtins.str id: The route ID.
        :param _builtins.bool is_default_association: Whether this route table is the default association route table.
        :param _builtins.bool is_default_propagation: Whether this route table is the default propagation route table.
        :param _builtins.str name: Specifies the name used to filter the route tables.  
               The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
               hyphens (-) and dots (.) allowed.
        :param Sequence['GetRouteTablesRouteTablePropagationArgs'] propagations: The propagation configurations of the route table.  
               The object structure is documented below.
        :param Sequence['GetRouteTablesRouteTableRouteArgs'] routes: The route details of the route table.  
               The object structure is documented below.
        :param _builtins.str status: The current status of the route.
        :param Mapping[str, _builtins.str] tags: Specifies the key/value pairs used to filter the route tables.
        :param _builtins.str updated_at: The latest update time.
        """
        pulumi.set(__self__, "associations", associations)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default_association", is_default_association)
        pulumi.set(__self__, "is_default_propagation", is_default_propagation)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "propagations", propagations)
        pulumi.set(__self__, "routes", routes)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def associations(self) -> Sequence['outputs.GetRouteTablesRouteTableAssociationResult']:
        """
        The association configurations of the route table.  
        The object structure is documented below.
        """
        return pulumi.get(self, "associations")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation time.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the route table.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The route ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefaultAssociation")
    def is_default_association(self) -> _builtins.bool:
        """
        Whether this route table is the default association route table.
        """
        return pulumi.get(self, "is_default_association")

    @_builtins.property
    @pulumi.getter(name="isDefaultPropagation")
    def is_default_propagation(self) -> _builtins.bool:
        """
        Whether this route table is the default propagation route table.
        """
        return pulumi.get(self, "is_default_propagation")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name used to filter the route tables.  
        The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
        hyphens (-) and dots (.) allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def propagations(self) -> Sequence['outputs.GetRouteTablesRouteTablePropagationResult']:
        """
        The propagation configurations of the route table.  
        The object structure is documented below.
        """
        return pulumi.get(self, "propagations")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetRouteTablesRouteTableRouteResult']:
        """
        The route details of the route table.  
        The object structure is documented below.
        """
        return pulumi.get(self, "routes")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the route.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Specifies the key/value pairs used to filter the route tables.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The latest update time.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetRouteTablesRouteTableAssociationResult(dict):
    def __init__(__self__, *,
                 attachment_id: _builtins.str,
                 attachment_type: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str attachment_id: The ID of the nexthop attachment.
        :param _builtins.str attachment_type: The type of the nexthop attachment.
        :param _builtins.str id: The route ID.
        """
        pulumi.set(__self__, "attachment_id", attachment_id)
        pulumi.set(__self__, "attachment_type", attachment_type)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> _builtins.str:
        """
        The ID of the nexthop attachment.
        """
        return pulumi.get(self, "attachment_id")

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> _builtins.str:
        """
        The type of the nexthop attachment.
        """
        return pulumi.get(self, "attachment_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The route ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetRouteTablesRouteTablePropagationResult(dict):
    def __init__(__self__, *,
                 attachment_id: _builtins.str,
                 attachment_type: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str attachment_id: The ID of the nexthop attachment.
        :param _builtins.str attachment_type: The type of the nexthop attachment.
        :param _builtins.str id: The route ID.
        """
        pulumi.set(__self__, "attachment_id", attachment_id)
        pulumi.set(__self__, "attachment_type", attachment_type)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> _builtins.str:
        """
        The ID of the nexthop attachment.
        """
        return pulumi.get(self, "attachment_id")

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> _builtins.str:
        """
        The type of the nexthop attachment.
        """
        return pulumi.get(self, "attachment_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The route ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetRouteTablesRouteTableRouteResult(dict):
    def __init__(__self__, *,
                 attachments: Sequence['outputs.GetRouteTablesRouteTableRouteAttachmentResult'],
                 destination: _builtins.str,
                 id: _builtins.str,
                 is_blackhole: _builtins.bool,
                 status: _builtins.str):
        """
        :param Sequence['GetRouteTablesRouteTableRouteAttachmentArgs'] attachments: The details of the attachment corresponding to the route.  
               The object structure is documented below.
        :param _builtins.str destination: The destination address (CIDR) of the route.
        :param _builtins.str id: The route ID.
        :param _builtins.bool is_blackhole: Whether route is the black hole route.
        :param _builtins.str status: The current status of the route.
        """
        pulumi.set(__self__, "attachments", attachments)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_blackhole", is_blackhole)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def attachments(self) -> Sequence['outputs.GetRouteTablesRouteTableRouteAttachmentResult']:
        """
        The details of the attachment corresponding to the route.  
        The object structure is documented below.
        """
        return pulumi.get(self, "attachments")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        The destination address (CIDR) of the route.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The route ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isBlackhole")
    def is_blackhole(self) -> _builtins.bool:
        """
        Whether route is the black hole route.
        """
        return pulumi.get(self, "is_blackhole")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the route.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRouteTablesRouteTableRouteAttachmentResult(dict):
    def __init__(__self__, *,
                 attachment_id: _builtins.str,
                 attachment_type: _builtins.str,
                 resource_id: _builtins.str):
        """
        :param _builtins.str attachment_id: The ID of the nexthop attachment.
        :param _builtins.str attachment_type: The type of the nexthop attachment.
        :param _builtins.str resource_id: The ID of the resource associated with the attachment.
        """
        pulumi.set(__self__, "attachment_id", attachment_id)
        pulumi.set(__self__, "attachment_type", attachment_type)
        pulumi.set(__self__, "resource_id", resource_id)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> _builtins.str:
        """
        The ID of the nexthop attachment.
        """
        return pulumi.get(self, "attachment_id")

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> _builtins.str:
        """
        The type of the nexthop attachment.
        """
        return pulumi.get(self, "attachment_type")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The ID of the resource associated with the attachment.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class GetTagsTagResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: The key of the resource tag.
        :param Sequence[_builtins.str] values: All values corresponding to the key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of the resource tag.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        All values corresponding to the key.
        """
        return pulumi.get(self, "values")


