# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouteTableArgs', 'RouteTable']

@pulumi.input_type
class RouteTableArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RouteTable resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the route table belongs.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the route table.  
               The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the route table.  
               The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
               hyphens (-) and dots (.) allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the ER instance and route table are located.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the route table.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the ER instance to which the route table belongs.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the route table.  
        The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the route table.  
        The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
        hyphens (-) and dots (.) allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the ER instance and route table are located.  
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the route table.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RouteTableState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_default_association: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default_propagation: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouteTable resources.
        :param pulumi.Input[_builtins.str] created_at: The creation time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the route table.  
               The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the route table belongs.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] is_default_association: Whether this route table is the default association route table.
        :param pulumi.Input[_builtins.bool] is_default_propagation: Whether this route table is the default propagation route table.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the route table.  
               The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
               hyphens (-) and dots (.) allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the ER instance and route table are located.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The current status of the route table.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the route table.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_default_association is not None:
            pulumi.set(__self__, "is_default_association", is_default_association)
        if is_default_propagation is not None:
            pulumi.set(__self__, "is_default_propagation", is_default_propagation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the route table.  
        The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the ER instance to which the route table belongs.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="isDefaultAssociation")
    def is_default_association(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this route table is the default association route table.
        """
        return pulumi.get(self, "is_default_association")

    @is_default_association.setter
    def is_default_association(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default_association", value)

    @_builtins.property
    @pulumi.getter(name="isDefaultPropagation")
    def is_default_propagation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this route table is the default propagation route table.
        """
        return pulumi.get(self, "is_default_propagation")

    @is_default_propagation.setter
    def is_default_propagation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default_propagation", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the route table.  
        The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
        hyphens (-) and dots (.) allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the ER instance and route table are located.  
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the route table.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the route table.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update time.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:Er/routeTable:RouteTable")
class RouteTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a route table resource under the ER instance within SberCloud.

        Before using enterprise router, define custom endpoint as shown below:
        ```python
        import pulumi
        ```

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        route_table_name = config.require_object("routeTableName")
        test = sbercloud.er.RouteTable("test",
            instance_id=instance_id,
            name=route_table_name,
            description="Route table created by terraform",
            tags={
                "foo": "bar",
                "owner": "terraform",
            })
        ```

        ## Import

        Route tables can be imported using their `id` and the related `instance_id`, separated by slashes (/), e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Er/routeTable:RouteTable test <instance_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the route table.  
               The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the route table belongs.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the route table.  
               The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
               hyphens (-) and dots (.) allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the ER instance and route table are located.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the route table.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a route table resource under the ER instance within SberCloud.

        Before using enterprise router, define custom endpoint as shown below:
        ```python
        import pulumi
        ```

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        route_table_name = config.require_object("routeTableName")
        test = sbercloud.er.RouteTable("test",
            instance_id=instance_id,
            name=route_table_name,
            description="Route table created by terraform",
            tags={
                "foo": "bar",
                "owner": "terraform",
            })
        ```

        ## Import

        Route tables can be imported using their `id` and the related `instance_id`, separated by slashes (/), e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Er/routeTable:RouteTable test <instance_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param RouteTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteTableArgs.__new__(RouteTableArgs)

            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["is_default_association"] = None
            __props__.__dict__["is_default_propagation"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(RouteTable, __self__).__init__(
            'sbercloud:Er/routeTable:RouteTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_default_association: Optional[pulumi.Input[_builtins.bool]] = None,
            is_default_propagation: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'RouteTable':
        """
        Get an existing RouteTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the route table.  
               The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the route table belongs.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] is_default_association: Whether this route table is the default association route table.
        :param pulumi.Input[_builtins.bool] is_default_propagation: Whether this route table is the default propagation route table.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the route table.  
               The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
               hyphens (-) and dots (.) allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the ER instance and route table are located.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The current status of the route table.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the route table.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteTableState.__new__(_RouteTableState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_default_association"] = is_default_association
        __props__.__dict__["is_default_propagation"] = is_default_propagation
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        return RouteTable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the route table.  
        The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the ER instance to which the route table belongs.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isDefaultAssociation")
    def is_default_association(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this route table is the default association route table.
        """
        return pulumi.get(self, "is_default_association")

    @_builtins.property
    @pulumi.getter(name="isDefaultPropagation")
    def is_default_propagation(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this route table is the default propagation route table.
        """
        return pulumi.get(self, "is_default_propagation")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the route table.  
        The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
        hyphens (-) and dots (.) allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region where the ER instance and route table are located.  
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the route table.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the route table.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update time.
        """
        return pulumi.get(self, "updated_at")

