# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StaticRouteArgs', 'StaticRoute']

@pulumi.input_type
class StaticRouteArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[_builtins.str],
                 route_table_id: pulumi.Input[_builtins.str],
                 attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_blackhole: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StaticRoute resource.
        :param pulumi.Input[_builtins.str] destination: Specifies the destination of the static route.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] route_table_id: Specifies the ID of the route table to which the static route
               belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] attachment_id: Specifies the ID of the corresponding attachment.
        :param pulumi.Input[_builtins.bool] is_blackhole: Specifies whether route is the black hole route, defaults to `false`.  
               + If the value is empty or `false`, the parameter `attachment_id` is required.
               + If the value is `true`, the parameter `attachment_id` must be empty.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the static route and related route table are
               located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "route_table_id", route_table_id)
        if attachment_id is not None:
            pulumi.set(__self__, "attachment_id", attachment_id)
        if is_blackhole is not None:
            pulumi.set(__self__, "is_blackhole", is_blackhole)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the destination of the static route.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the route table to which the static route
        belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the corresponding attachment.
        """
        return pulumi.get(self, "attachment_id")

    @attachment_id.setter
    def attachment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="isBlackhole")
    def is_blackhole(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether route is the black hole route, defaults to `false`.  
        + If the value is empty or `false`, the parameter `attachment_id` is required.
        + If the value is `true`, the parameter `attachment_id` must be empty.
        """
        return pulumi.get(self, "is_blackhole")

    @is_blackhole.setter
    def is_blackhole(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_blackhole", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the static route and related route table are
        located.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _StaticRouteState:
    def __init__(__self__, *,
                 attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 is_blackhole: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StaticRoute resources.
        :param pulumi.Input[_builtins.str] attachment_id: Specifies the ID of the corresponding attachment.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the static route.
        :param pulumi.Input[_builtins.str] destination: Specifies the destination of the static route.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] is_blackhole: Specifies whether route is the black hole route, defaults to `false`.  
               + If the value is empty or `false`, the parameter `attachment_id` is required.
               + If the value is `true`, the parameter `attachment_id` must be empty.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the static route and related route table are
               located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] route_table_id: Specifies the ID of the route table to which the static route
               belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The current status of the static route.
        :param pulumi.Input[_builtins.str] type: The type of the static route.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the static route.
        """
        if attachment_id is not None:
            pulumi.set(__self__, "attachment_id", attachment_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if is_blackhole is not None:
            pulumi.set(__self__, "is_blackhole", is_blackhole)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the corresponding attachment.
        """
        return pulumi.get(self, "attachment_id")

    @attachment_id.setter
    def attachment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the static route.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination of the static route.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="isBlackhole")
    def is_blackhole(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether route is the black hole route, defaults to `false`.  
        + If the value is empty or `false`, the parameter `attachment_id` is required.
        + If the value is `true`, the parameter `attachment_id` must be empty.
        """
        return pulumi.get(self, "is_blackhole")

    @is_blackhole.setter
    def is_blackhole(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_blackhole", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the static route and related route table are
        located.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the route table to which the static route
        belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the static route.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the static route.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update time of the static route.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:Er/staticRoute:StaticRoute")
class StaticRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 is_blackhole: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a static route under the ER route table within SberCloud.

        Before using enterprise router, define custom endpoint as shown below:
        ```python
        import pulumi
        ```

        ## Example Usage

        ### Create a static route and cross the VPC

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        route_table_id = config.require_object("routeTableId")
        destination_vpc_cidr = config.require_object("destinationVpcCidr")
        source_vpc_attachment_id = config.require_object("sourceVpcAttachmentId")
        test = sbercloud.er.StaticRoute("test",
            route_table_id=route_table_id,
            destination=destination_vpc_cidr,
            attachment_id=source_vpc_attachment_id)
        ```

        ### Create a black hole route

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        route_table_id = config.require_object("routeTableId")
        destination_vpc_cidr = config.require_object("destinationVpcCidr")
        test = sbercloud.er.StaticRoute("test",
            route_table_id=route_table_id,
            destination=destination_vpc_cidr,
            is_blackhole=True)
        ```

        ## Import

        Static routes can be imported using the related `route_table_id` and their `id`, separated by a slash (/), e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Er/staticRoute:StaticRoute test <route_table_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] attachment_id: Specifies the ID of the corresponding attachment.
        :param pulumi.Input[_builtins.str] destination: Specifies the destination of the static route.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] is_blackhole: Specifies whether route is the black hole route, defaults to `false`.  
               + If the value is empty or `false`, the parameter `attachment_id` is required.
               + If the value is `true`, the parameter `attachment_id` must be empty.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the static route and related route table are
               located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] route_table_id: Specifies the ID of the route table to which the static route
               belongs.
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StaticRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a static route under the ER route table within SberCloud.

        Before using enterprise router, define custom endpoint as shown below:
        ```python
        import pulumi
        ```

        ## Example Usage

        ### Create a static route and cross the VPC

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        route_table_id = config.require_object("routeTableId")
        destination_vpc_cidr = config.require_object("destinationVpcCidr")
        source_vpc_attachment_id = config.require_object("sourceVpcAttachmentId")
        test = sbercloud.er.StaticRoute("test",
            route_table_id=route_table_id,
            destination=destination_vpc_cidr,
            attachment_id=source_vpc_attachment_id)
        ```

        ### Create a black hole route

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        route_table_id = config.require_object("routeTableId")
        destination_vpc_cidr = config.require_object("destinationVpcCidr")
        test = sbercloud.er.StaticRoute("test",
            route_table_id=route_table_id,
            destination=destination_vpc_cidr,
            is_blackhole=True)
        ```

        ## Import

        Static routes can be imported using the related `route_table_id` and their `id`, separated by a slash (/), e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Er/staticRoute:StaticRoute test <route_table_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param StaticRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StaticRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 is_blackhole: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StaticRouteArgs.__new__(StaticRouteArgs)

            __props__.__dict__["attachment_id"] = attachment_id
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["is_blackhole"] = is_blackhole
            __props__.__dict__["region"] = region
            if route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_id'")
            __props__.__dict__["route_table_id"] = route_table_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["updated_at"] = None
        super(StaticRoute, __self__).__init__(
            'sbercloud:Er/staticRoute:StaticRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[_builtins.str]] = None,
            is_blackhole: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'StaticRoute':
        """
        Get an existing StaticRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] attachment_id: Specifies the ID of the corresponding attachment.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the static route.
        :param pulumi.Input[_builtins.str] destination: Specifies the destination of the static route.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] is_blackhole: Specifies whether route is the black hole route, defaults to `false`.  
               + If the value is empty or `false`, the parameter `attachment_id` is required.
               + If the value is `true`, the parameter `attachment_id` must be empty.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the static route and related route table are
               located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] route_table_id: Specifies the ID of the route table to which the static route
               belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The current status of the static route.
        :param pulumi.Input[_builtins.str] type: The type of the static route.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the static route.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StaticRouteState.__new__(_StaticRouteState)

        __props__.__dict__["attachment_id"] = attachment_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["destination"] = destination
        __props__.__dict__["is_blackhole"] = is_blackhole
        __props__.__dict__["region"] = region
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        return StaticRoute(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the corresponding attachment.
        """
        return pulumi.get(self, "attachment_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the static route.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the destination of the static route.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="isBlackhole")
    def is_blackhole(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether route is the black hole route, defaults to `false`.  
        + If the value is empty or `false`, the parameter `attachment_id` is required.
        + If the value is `true`, the parameter `attachment_id` must be empty.
        """
        return pulumi.get(self, "is_blackhole")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region where the static route and related route table are
        located.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the route table to which the static route
        belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the static route.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the static route.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update time of the static route.
        """
        return pulumi.get(self, "updated_at")

