# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VpcAttachmentArgs', 'VpcAttachment']

@pulumi.input_type
class VpcAttachmentArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 auto_create_vpc_routes: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a VpcAttachment resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the VPC attachment
               belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of the VPC subnet to which the VPC attachment belongs.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC to which the VPC attachment belongs.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] auto_create_vpc_routes: Specifies whether to automatically configure routes for the VPC
               which pointing to the ER instance.
               The destination CIDRs of the routes are fixed as follows:
               + **10.0.0.0/8**
               + **172.16.0.0/12**
               + **192.168.0.0/16**
               
               The default value is false. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the VPC attachment.  
               The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC attachment.  
               The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
               hyphens (-) and dots (.) allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the ER instance and the VPC attachment are
               located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the VPC attachment.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if auto_create_vpc_routes is not None:
            pulumi.set(__self__, "auto_create_vpc_routes", auto_create_vpc_routes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the ER instance to which the VPC attachment
        belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the VPC subnet to which the VPC attachment belongs.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the VPC to which the VPC attachment belongs.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="autoCreateVpcRoutes")
    def auto_create_vpc_routes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically configure routes for the VPC
        which pointing to the ER instance.
        The destination CIDRs of the routes are fixed as follows:
        + **10.0.0.0/8**
        + **172.16.0.0/12**
        + **192.168.0.0/16**

        The default value is false. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_create_vpc_routes")

    @auto_create_vpc_routes.setter
    def auto_create_vpc_routes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_create_vpc_routes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the VPC attachment.  
        The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the VPC attachment.  
        The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
        hyphens (-) and dots (.) allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the ER instance and the VPC attachment are
        located.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the VPC attachment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VpcAttachmentState:
    def __init__(__self__, *,
                 auto_create_vpc_routes: Optional[pulumi.Input[_builtins.bool]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpcAttachment resources.
        :param pulumi.Input[_builtins.bool] auto_create_vpc_routes: Specifies whether to automatically configure routes for the VPC
               which pointing to the ER instance.
               The destination CIDRs of the routes are fixed as follows:
               + **10.0.0.0/8**
               + **172.16.0.0/12**
               + **192.168.0.0/16**
               
               The default value is false. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] created_at: The creation time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the VPC attachment.  
               The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the VPC attachment
               belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC attachment.  
               The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
               hyphens (-) and dots (.) allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the ER instance and the VPC attachment are
               located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The current status of the VPC attachment.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of the VPC subnet to which the VPC attachment belongs.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the VPC attachment.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC to which the VPC attachment belongs.  
               Changing this parameter will create a new resource.
        """
        if auto_create_vpc_routes is not None:
            pulumi.set(__self__, "auto_create_vpc_routes", auto_create_vpc_routes)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="autoCreateVpcRoutes")
    def auto_create_vpc_routes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically configure routes for the VPC
        which pointing to the ER instance.
        The destination CIDRs of the routes are fixed as follows:
        + **10.0.0.0/8**
        + **172.16.0.0/12**
        + **192.168.0.0/16**

        The default value is false. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_create_vpc_routes")

    @auto_create_vpc_routes.setter
    def auto_create_vpc_routes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_create_vpc_routes", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the VPC attachment.  
        The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the ER instance to which the VPC attachment
        belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the VPC attachment.  
        The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
        hyphens (-) and dots (.) allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the ER instance and the VPC attachment are
        located.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the VPC attachment.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the VPC subnet to which the VPC attachment belongs.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the VPC attachment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update time.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the VPC to which the VPC attachment belongs.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Er/vpcAttachment:VpcAttachment")
class VpcAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create_vpc_routes: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a VPC attachment resource under the ER instance within SberCloud.

        Before using enterprise router, define custom endpoint as shown below:
        ```python
        import pulumi
        ```

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        attachment_name = config.require_object("attachmentName")
        test = sbercloud.er.VpcAttachment("test",
            instance_id=instance_id,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            name=attachment_name,
            description="VPC attachment created by terraform",
            auto_create_vpc_routes=True,
            tags={
                "foo": "bar",
                "owner": "terraform",
            })
        ```

        ## Import

        VPC attachments can be imported using their `id` and the related `instance_id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Er/vpcAttachment:VpcAttachment test <instance_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_create_vpc_routes: Specifies whether to automatically configure routes for the VPC
               which pointing to the ER instance.
               The destination CIDRs of the routes are fixed as follows:
               + **10.0.0.0/8**
               + **172.16.0.0/12**
               + **192.168.0.0/16**
               
               The default value is false. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the VPC attachment.  
               The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the VPC attachment
               belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC attachment.  
               The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
               hyphens (-) and dots (.) allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the ER instance and the VPC attachment are
               located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of the VPC subnet to which the VPC attachment belongs.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the VPC attachment.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC to which the VPC attachment belongs.  
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPC attachment resource under the ER instance within SberCloud.

        Before using enterprise router, define custom endpoint as shown below:
        ```python
        import pulumi
        ```

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        attachment_name = config.require_object("attachmentName")
        test = sbercloud.er.VpcAttachment("test",
            instance_id=instance_id,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            name=attachment_name,
            description="VPC attachment created by terraform",
            auto_create_vpc_routes=True,
            tags={
                "foo": "bar",
                "owner": "terraform",
            })
        ```

        ## Import

        VPC attachments can be imported using their `id` and the related `instance_id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Er/vpcAttachment:VpcAttachment test <instance_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param VpcAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create_vpc_routes: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcAttachmentArgs.__new__(VpcAttachmentArgs)

            __props__.__dict__["auto_create_vpc_routes"] = auto_create_vpc_routes
            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(VpcAttachment, __self__).__init__(
            'sbercloud:Er/vpcAttachment:VpcAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_create_vpc_routes: Optional[pulumi.Input[_builtins.bool]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VpcAttachment':
        """
        Get an existing VpcAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_create_vpc_routes: Specifies whether to automatically configure routes for the VPC
               which pointing to the ER instance.
               The destination CIDRs of the routes are fixed as follows:
               + **10.0.0.0/8**
               + **172.16.0.0/12**
               + **192.168.0.0/16**
               
               The default value is false. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] created_at: The creation time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the VPC attachment.  
               The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the ER instance to which the VPC attachment
               belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC attachment.  
               The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
               hyphens (-) and dots (.) allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the ER instance and the VPC attachment are
               located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The current status of the VPC attachment.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of the VPC subnet to which the VPC attachment belongs.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the VPC attachment.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC to which the VPC attachment belongs.  
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcAttachmentState.__new__(_VpcAttachmentState)

        __props__.__dict__["auto_create_vpc_routes"] = auto_create_vpc_routes
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["vpc_id"] = vpc_id
        return VpcAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoCreateVpcRoutes")
    def auto_create_vpc_routes(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to automatically configure routes for the VPC
        which pointing to the ER instance.
        The destination CIDRs of the routes are fixed as follows:
        + **10.0.0.0/8**
        + **172.16.0.0/12**
        + **192.168.0.0/16**

        The default value is false. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_create_vpc_routes")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the VPC attachment.  
        The description contain a maximum of `255` characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the ER instance to which the VPC attachment
        belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the VPC attachment.  
        The name can contain `1` to `64` characters, only English letters, Chinese characters, digits, underscore (_),
        hyphens (-) and dots (.) allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region where the ER instance and the VPC attachment are
        located.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the VPC attachment.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the VPC subnet to which the VPC attachment belongs.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the VPC attachment.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update time.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the VPC to which the VPC attachment belongs.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

