# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVolumesResult',
    'AwaitableGetVolumesResult',
    'get_volumes',
    'get_volumes_output',
]

@pulumi.output_type
class GetVolumesResult:
    """
    A collection of values returned by getVolumes.
    """
    def __init__(__self__, availability_zone=None, dedicated_storage_id=None, dedicated_storage_name=None, enterprise_project_id=None, id=None, ids=None, metadata=None, name=None, region=None, server_id=None, service_type=None, shareable=None, sort_dir=None, sort_key=None, status=None, tags=None, volume_id=None, volume_type_id=None, volumes=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if dedicated_storage_id and not isinstance(dedicated_storage_id, str):
            raise TypeError("Expected argument 'dedicated_storage_id' to be a str")
        pulumi.set(__self__, "dedicated_storage_id", dedicated_storage_id)
        if dedicated_storage_name and not isinstance(dedicated_storage_name, str):
            raise TypeError("Expected argument 'dedicated_storage_name' to be a str")
        pulumi.set(__self__, "dedicated_storage_name", dedicated_storage_name)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, str):
            raise TypeError("Expected argument 'ids' to be a str")
        pulumi.set(__self__, "ids", ids)
        if metadata and not isinstance(metadata, str):
            raise TypeError("Expected argument 'metadata' to be a str")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if service_type and not isinstance(service_type, str):
            raise TypeError("Expected argument 'service_type' to be a str")
        pulumi.set(__self__, "service_type", service_type)
        if shareable and not isinstance(shareable, bool):
            raise TypeError("Expected argument 'shareable' to be a bool")
        pulumi.set(__self__, "shareable", shareable)
        if sort_dir and not isinstance(sort_dir, str):
            raise TypeError("Expected argument 'sort_dir' to be a str")
        pulumi.set(__self__, "sort_dir", sort_dir)
        if sort_key and not isinstance(sort_key, str):
            raise TypeError("Expected argument 'sort_key' to be a str")
        pulumi.set(__self__, "sort_key", sort_key)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if volume_id and not isinstance(volume_id, str):
            raise TypeError("Expected argument 'volume_id' to be a str")
        pulumi.set(__self__, "volume_id", volume_id)
        if volume_type_id and not isinstance(volume_type_id, str):
            raise TypeError("Expected argument 'volume_type_id' to be a str")
        pulumi.set(__self__, "volume_type_id", volume_type_id)
        if volumes and not isinstance(volumes, list):
            raise TypeError("Expected argument 'volumes' to be a list")
        pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[_builtins.str]:
        """
        The availability zone of the disk.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="dedicatedStorageId")
    def dedicated_storage_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dedicated_storage_id")

    @_builtins.property
    @pulumi.getter(name="dedicatedStorageName")
    def dedicated_storage_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dedicated_storage_name")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        """
        The ID of the enterprise project associated with the disk.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[_builtins.str]:
        """
        The ID of the server to which the disk is attached.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[_builtins.str]:
        """
        The service type, such as EVS, DSS or DESS.
        """
        return pulumi.get(self, "service_type")

    @_builtins.property
    @pulumi.getter
    def shareable(self) -> Optional[_builtins.bool]:
        """
        Whether the disk is shareable.
        """
        return pulumi.get(self, "shareable")

    @_builtins.property
    @pulumi.getter(name="sortDir")
    def sort_dir(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sort_dir")

    @_builtins.property
    @pulumi.getter(name="sortKey")
    def sort_key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sort_key")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The disk status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The disk tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "volume_id")

    @_builtins.property
    @pulumi.getter(name="volumeTypeId")
    def volume_type_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "volume_type_id")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetVolumesVolumeResult']:
        """
        The detailed information of the disks. Structure is documented below.
        """
        return pulumi.get(self, "volumes")


class AwaitableGetVolumesResult(GetVolumesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumesResult(
            availability_zone=self.availability_zone,
            dedicated_storage_id=self.dedicated_storage_id,
            dedicated_storage_name=self.dedicated_storage_name,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            ids=self.ids,
            metadata=self.metadata,
            name=self.name,
            region=self.region,
            server_id=self.server_id,
            service_type=self.service_type,
            shareable=self.shareable,
            sort_dir=self.sort_dir,
            sort_key=self.sort_key,
            status=self.status,
            tags=self.tags,
            volume_id=self.volume_id,
            volume_type_id=self.volume_type_id,
            volumes=self.volumes)


def get_volumes(availability_zone: Optional[_builtins.str] = None,
                dedicated_storage_id: Optional[_builtins.str] = None,
                dedicated_storage_name: Optional[_builtins.str] = None,
                enterprise_project_id: Optional[_builtins.str] = None,
                ids: Optional[_builtins.str] = None,
                metadata: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                server_id: Optional[_builtins.str] = None,
                service_type: Optional[_builtins.str] = None,
                shareable: Optional[_builtins.bool] = None,
                sort_dir: Optional[_builtins.str] = None,
                sort_key: Optional[_builtins.str] = None,
                status: Optional[_builtins.str] = None,
                tags: Optional[Mapping[str, _builtins.str]] = None,
                volume_id: Optional[_builtins.str] = None,
                volume_type_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumesResult:
    """
    Use this data source to query the detailed information list of the EVS disks within SberCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    target_server = config.require_object("targetServer")
    test = sbercloud.Evs.get_volumes(server_id=target_server)
    ```


    :param _builtins.str availability_zone: Specifies the availability zone for the disks.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID for filtering.
    :param _builtins.str name: The disk name.
    :param _builtins.str region: Specifies the region in which to query the disk list.
           If omitted, the provider-level region will be used.
    :param _builtins.str server_id: Specifies the server ID to which the disks are attached.
    :param _builtins.str service_type: The service type, such as EVS, DSS or DESS.
    :param _builtins.bool shareable: Specifies whether the disk is shareable.
    :param _builtins.str status: Specifies the disk status. The valid values are as following:
           + **FREEZED**
           + **BIND_ERROR**
           + **BINDING**
           + **PENDING_DELETE**
           + **PENDING_CREATE**
           + **NOTIFYING**
           + **NOTIFY_DELETE**
           + **PENDING_UPDATE**
           + **DOWN**
           + **ACTIVE**
           + **ELB**
           + **ERROR**
           + **VPN**
    :param Mapping[str, _builtins.str] tags: Specifies the included key/value pairs which associated with the desired disk.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['dedicatedStorageId'] = dedicated_storage_id
    __args__['dedicatedStorageName'] = dedicated_storage_name
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['ids'] = ids
    __args__['metadata'] = metadata
    __args__['name'] = name
    __args__['region'] = region
    __args__['serverId'] = server_id
    __args__['serviceType'] = service_type
    __args__['shareable'] = shareable
    __args__['sortDir'] = sort_dir
    __args__['sortKey'] = sort_key
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['volumeId'] = volume_id
    __args__['volumeTypeId'] = volume_type_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Evs/getVolumes:getVolumes', __args__, opts=opts, typ=GetVolumesResult).value

    return AwaitableGetVolumesResult(
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        dedicated_storage_id=pulumi.get(__ret__, 'dedicated_storage_id'),
        dedicated_storage_name=pulumi.get(__ret__, 'dedicated_storage_name'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        server_id=pulumi.get(__ret__, 'server_id'),
        service_type=pulumi.get(__ret__, 'service_type'),
        shareable=pulumi.get(__ret__, 'shareable'),
        sort_dir=pulumi.get(__ret__, 'sort_dir'),
        sort_key=pulumi.get(__ret__, 'sort_key'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        volume_id=pulumi.get(__ret__, 'volume_id'),
        volume_type_id=pulumi.get(__ret__, 'volume_type_id'),
        volumes=pulumi.get(__ret__, 'volumes'))
def get_volumes_output(availability_zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       dedicated_storage_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       dedicated_storage_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       ids: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       metadata: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       server_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       service_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       shareable: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                       sort_dir: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       sort_key: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                       volume_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       volume_type_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumesResult]:
    """
    Use this data source to query the detailed information list of the EVS disks within SberCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    target_server = config.require_object("targetServer")
    test = sbercloud.Evs.get_volumes(server_id=target_server)
    ```


    :param _builtins.str availability_zone: Specifies the availability zone for the disks.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID for filtering.
    :param _builtins.str name: The disk name.
    :param _builtins.str region: Specifies the region in which to query the disk list.
           If omitted, the provider-level region will be used.
    :param _builtins.str server_id: Specifies the server ID to which the disks are attached.
    :param _builtins.str service_type: The service type, such as EVS, DSS or DESS.
    :param _builtins.bool shareable: Specifies whether the disk is shareable.
    :param _builtins.str status: Specifies the disk status. The valid values are as following:
           + **FREEZED**
           + **BIND_ERROR**
           + **BINDING**
           + **PENDING_DELETE**
           + **PENDING_CREATE**
           + **NOTIFYING**
           + **NOTIFY_DELETE**
           + **PENDING_UPDATE**
           + **DOWN**
           + **ACTIVE**
           + **ELB**
           + **ERROR**
           + **VPN**
    :param Mapping[str, _builtins.str] tags: Specifies the included key/value pairs which associated with the desired disk.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['dedicatedStorageId'] = dedicated_storage_id
    __args__['dedicatedStorageName'] = dedicated_storage_name
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['ids'] = ids
    __args__['metadata'] = metadata
    __args__['name'] = name
    __args__['region'] = region
    __args__['serverId'] = server_id
    __args__['serviceType'] = service_type
    __args__['shareable'] = shareable
    __args__['sortDir'] = sort_dir
    __args__['sortKey'] = sort_key
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['volumeId'] = volume_id
    __args__['volumeTypeId'] = volume_type_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Evs/getVolumes:getVolumes', __args__, opts=opts, typ=GetVolumesResult)
    return __ret__.apply(lambda __response__: GetVolumesResult(
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        dedicated_storage_id=pulumi.get(__response__, 'dedicated_storage_id'),
        dedicated_storage_name=pulumi.get(__response__, 'dedicated_storage_name'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        metadata=pulumi.get(__response__, 'metadata'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        server_id=pulumi.get(__response__, 'server_id'),
        service_type=pulumi.get(__response__, 'service_type'),
        shareable=pulumi.get(__response__, 'shareable'),
        sort_dir=pulumi.get(__response__, 'sort_dir'),
        sort_key=pulumi.get(__response__, 'sort_key'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        volume_id=pulumi.get(__response__, 'volume_id'),
        volume_type_id=pulumi.get(__response__, 'volume_type_id'),
        volumes=pulumi.get(__response__, 'volumes')))
