# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeArgs', 'Volume']

@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[_builtins.str],
                 volume_type: pulumi.Input[_builtins.str],
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cascade: Optional[pulumi.Input[_builtins.bool]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_storage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iops: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_id: Optional[pulumi.Input[_builtins.str]] = None,
                 multiattach: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 throughput: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Volume resource.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone for the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] volume_type: Specifies the disk type.
               Currently, the value can be SSD, SAS, or SATA.
               - SSD: specifies the ultra-high I/O disk type.
               - SAS: specifies the high I/O disk type.
               - SATA: specifies the common I/O disk type.
               If the specified disk type is not available in the AZ, the disk will fail to create.
        :param pulumi.Input[_builtins.str] backup_id: The backup ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.bool] cascade: Specifies the delete mode of snapshot. The default value is false. All snapshot
               associated with the disk will also be deleted when the parameter is set to true.
        :param pulumi.Input[_builtins.str] description: Specifies the disk description. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[_builtins.str] device_type: The device type of volume to create. Valid options are VBD and SCSI.
               Defaults to VBD. Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the disk. Changing this
               creates a new disk.
        :param pulumi.Input[_builtins.str] image_id: The image ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] kms_id: The Encryption KMS ID to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.bool] multiattach: Default:false. Specifies the shared EVS disk information.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] name: Specifies the disk name.
               If you create disks one by one, the name value is the disk name. The value can contain a maximum of 255 bytes.
               If you create multiple disks (the count value is greater than 1), the system automatically adds a hyphen followed
               by a four-digit incremental number, such as -0000, to the end of each disk name. For example,
               the disk names can be volume-0001 and volume-0002. The value can contain a maximum of 250 bytes.
        :param pulumi.Input[_builtins.str] region: The region in which to create the EVS volume resource. If omitted, the provider-level region will be used. Changing this creates a new EVS resource.
        :param pulumi.Input[_builtins.int] size: Specifies the disk size, in GB. Its value can be as follows:
               - System disk: 1 GB to 1024 GB
               - Data disk: 10 GB to 32768 GB
               This parameter is mandatory when you create an empty disk. You can specify the parameter value as required within the value range.
               This parameter is mandatory when you create the disk from a snapshot. Ensure that the disk size is greater than or equal to the snapshot size.
               This parameter is mandatory when you create the disk from an image. Ensure that the disk size is greater than or equal to
               the minimum disk capacity required by min_disk in the image attributes.
               This parameter is optional when you create the disk from a backup. If this parameter is not specified, the disk size is equal to the backup size.
               Changing this parameter will update the disk. You can extend the disk by setting this parameter to a new value, which must be between current size
               and the max size(System disk: 1024 GB; Data disk: 32768 GB). Shrinking the disk is not supported.
        :param pulumi.Input[_builtins.str] snapshot_id: The snapshot ID from which to create the volume.
               Changing this creates a new volume.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "volume_type", volume_type)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if cascade is not None:
            pulumi.set(__self__, "cascade", cascade)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if dedicated_storage_id is not None:
            pulumi.set(__self__, "dedicated_storage_id", dedicated_storage_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_id is not None:
            pulumi.set(__self__, "kms_id", kms_id)
        if multiattach is not None:
            pulumi.set(__self__, "multiattach", multiattach)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[_builtins.str]:
        """
        The availability zone for the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the disk type.
        Currently, the value can be SSD, SAS, or SATA.
        - SSD: specifies the ultra-high I/O disk type.
        - SAS: specifies the high I/O disk type.
        - SATA: specifies the common I/O disk type.
        If the specified disk type is not available in the AZ, the disk will fail to create.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "volume_type", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup ID from which to create the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter
    def cascade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the delete mode of snapshot. The default value is false. All snapshot
        associated with the disk will also be deleted when the parameter is set to true.
        """
        return pulumi.get(self, "cascade")

    @cascade.setter
    def cascade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cascade", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedStorageId")
    def dedicated_storage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dedicated_storage_id")

    @dedicated_storage_id.setter
    def dedicated_storage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_storage_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the disk description. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device type of volume to create. Valid options are VBD and SCSI.
        Defaults to VBD. Changing this creates a new volume.
        """
        return pulumi.get(self, "device_type")

    @device_type.setter
    def device_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device_type", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the disk. Changing this
        creates a new disk.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image ID from which to create the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "iops", value)

    @_builtins.property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Encryption KMS ID to create the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "kms_id")

    @kms_id.setter
    def kms_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_id", value)

    @_builtins.property
    @pulumi.getter
    def multiattach(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Default:false. Specifies the shared EVS disk information.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "multiattach")

    @multiattach.setter
    def multiattach(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multiattach", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the disk name.
        If you create disks one by one, the name value is the disk name. The value can contain a maximum of 255 bytes.
        If you create multiple disks (the count value is greater than 1), the system automatically adds a hyphen followed
        by a four-digit incremental number, such as -0000, to the end of each disk name. For example,
        the disk names can be volume-0001 and volume-0002. The value can contain a maximum of 250 bytes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the EVS volume resource. If omitted, the provider-level region will be used. Changing this creates a new EVS resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the disk size, in GB. Its value can be as follows:
        - System disk: 1 GB to 1024 GB
        - Data disk: 10 GB to 32768 GB
        This parameter is mandatory when you create an empty disk. You can specify the parameter value as required within the value range.
        This parameter is mandatory when you create the disk from a snapshot. Ensure that the disk size is greater than or equal to the snapshot size.
        This parameter is mandatory when you create the disk from an image. Ensure that the disk size is greater than or equal to
        the minimum disk capacity required by min_disk in the image attributes.
        This parameter is optional when you create the disk from a backup. If this parameter is not specified, the disk size is equal to the backup size.
        Changing this parameter will update the disk. You can extend the disk by setting this parameter to a new value, which must be between current size
        and the max size(System disk: 1024 GB; Data disk: 32768 GB). Shrinking the disk is not supported.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snapshot ID from which to create the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "throughput", value)


@pulumi.input_type
class _VolumeState:
    def __init__(__self__, *,
                 all_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 all_volume_image_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentArgs']]]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bootable: Optional[pulumi.Input[_builtins.str]] = None,
                 cascade: Optional[pulumi.Input[_builtins.bool]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_storage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_storage_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iops: Optional[pulumi.Input[_builtins.int]] = None,
                 iops_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeIopsAttributeArgs']]]] = None,
                 kms_id: Optional[pulumi.Input[_builtins.str]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeLinkArgs']]]] = None,
                 multiattach: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 throughput_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeThroughputAttributeArgs']]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 wwn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Volume resources.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentArgs']]] attachments: If a volume is attached to an instance, this attribute will
               display the Attachment ID, Instance ID, and the Device as the Instance
               sees it.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone for the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] backup_id: The backup ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.bool] cascade: Specifies the delete mode of snapshot. The default value is false. All snapshot
               associated with the disk will also be deleted when the parameter is set to true.
        :param pulumi.Input[_builtins.str] description: Specifies the disk description. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[_builtins.str] device_type: The device type of volume to create. Valid options are VBD and SCSI.
               Defaults to VBD. Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the disk. Changing this
               creates a new disk.
        :param pulumi.Input[_builtins.str] image_id: The image ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] kms_id: The Encryption KMS ID to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.bool] multiattach: Default:false. Specifies the shared EVS disk information.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] name: Specifies the disk name.
               If you create disks one by one, the name value is the disk name. The value can contain a maximum of 255 bytes.
               If you create multiple disks (the count value is greater than 1), the system automatically adds a hyphen followed
               by a four-digit incremental number, such as -0000, to the end of each disk name. For example,
               the disk names can be volume-0001 and volume-0002. The value can contain a maximum of 250 bytes.
        :param pulumi.Input[_builtins.str] region: The region in which to create the EVS volume resource. If omitted, the provider-level region will be used. Changing this creates a new EVS resource.
        :param pulumi.Input[_builtins.int] size: Specifies the disk size, in GB. Its value can be as follows:
               - System disk: 1 GB to 1024 GB
               - Data disk: 10 GB to 32768 GB
               This parameter is mandatory when you create an empty disk. You can specify the parameter value as required within the value range.
               This parameter is mandatory when you create the disk from a snapshot. Ensure that the disk size is greater than or equal to the snapshot size.
               This parameter is mandatory when you create the disk from an image. Ensure that the disk size is greater than or equal to
               the minimum disk capacity required by min_disk in the image attributes.
               This parameter is optional when you create the disk from a backup. If this parameter is not specified, the disk size is equal to the backup size.
               Changing this parameter will update the disk. You can extend the disk by setting this parameter to a new value, which must be between current size
               and the max size(System disk: 1024 GB; Data disk: 32768 GB). Shrinking the disk is not supported.
        :param pulumi.Input[_builtins.str] snapshot_id: The snapshot ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] volume_type: Specifies the disk type.
               Currently, the value can be SSD, SAS, or SATA.
               - SSD: specifies the ultra-high I/O disk type.
               - SAS: specifies the high I/O disk type.
               - SATA: specifies the common I/O disk type.
               If the specified disk type is not available in the AZ, the disk will fail to create.
        :param pulumi.Input[_builtins.str] wwn: Specifies the unique identifier used for mounting the EVS disk.
        """
        if all_metadata is not None:
            pulumi.set(__self__, "all_metadata", all_metadata)
        if all_volume_image_metadata is not None:
            pulumi.set(__self__, "all_volume_image_metadata", all_volume_image_metadata)
        if attachments is not None:
            pulumi.set(__self__, "attachments", attachments)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if bootable is not None:
            pulumi.set(__self__, "bootable", bootable)
        if cascade is not None:
            pulumi.set(__self__, "cascade", cascade)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if dedicated_storage_id is not None:
            pulumi.set(__self__, "dedicated_storage_id", dedicated_storage_id)
        if dedicated_storage_name is not None:
            pulumi.set(__self__, "dedicated_storage_name", dedicated_storage_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if iops_attributes is not None:
            pulumi.set(__self__, "iops_attributes", iops_attributes)
        if kms_id is not None:
            pulumi.set(__self__, "kms_id", kms_id)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if multiattach is not None:
            pulumi.set(__self__, "multiattach", multiattach)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if throughput_attributes is not None:
            pulumi.set(__self__, "throughput_attributes", throughput_attributes)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)
        if wwn is not None:
            pulumi.set(__self__, "wwn", wwn)

    @_builtins.property
    @pulumi.getter(name="allMetadata")
    def all_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "all_metadata")

    @all_metadata.setter
    def all_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "all_metadata", value)

    @_builtins.property
    @pulumi.getter(name="allVolumeImageMetadata")
    def all_volume_image_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "all_volume_image_metadata")

    @all_volume_image_metadata.setter
    def all_volume_image_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "all_volume_image_metadata", value)

    @_builtins.property
    @pulumi.getter
    def attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentArgs']]]]:
        """
        If a volume is attached to an instance, this attribute will
        display the Attachment ID, Instance ID, and the Device as the Instance
        sees it.
        """
        return pulumi.get(self, "attachments")

    @attachments.setter
    def attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeAttachmentArgs']]]]):
        pulumi.set(self, "attachments", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability zone for the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup ID from which to create the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter
    def bootable(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "bootable")

    @bootable.setter
    def bootable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bootable", value)

    @_builtins.property
    @pulumi.getter
    def cascade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the delete mode of snapshot. The default value is false. All snapshot
        associated with the disk will also be deleted when the parameter is set to true.
        """
        return pulumi.get(self, "cascade")

    @cascade.setter
    def cascade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cascade", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedStorageId")
    def dedicated_storage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dedicated_storage_id")

    @dedicated_storage_id.setter
    def dedicated_storage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_storage_id", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedStorageName")
    def dedicated_storage_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dedicated_storage_name")

    @dedicated_storage_name.setter
    def dedicated_storage_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_storage_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the disk description. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device type of volume to create. Valid options are VBD and SCSI.
        Defaults to VBD. Changing this creates a new volume.
        """
        return pulumi.get(self, "device_type")

    @device_type.setter
    def device_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device_type", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the disk. Changing this
        creates a new disk.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image ID from which to create the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "iops", value)

    @_builtins.property
    @pulumi.getter(name="iopsAttributes")
    def iops_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeIopsAttributeArgs']]]]:
        return pulumi.get(self, "iops_attributes")

    @iops_attributes.setter
    def iops_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeIopsAttributeArgs']]]]):
        pulumi.set(self, "iops_attributes", value)

    @_builtins.property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Encryption KMS ID to create the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "kms_id")

    @kms_id.setter
    def kms_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_id", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeLinkArgs']]]]:
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeLinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def multiattach(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Default:false. Specifies the shared EVS disk information.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "multiattach")

    @multiattach.setter
    def multiattach(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multiattach", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the disk name.
        If you create disks one by one, the name value is the disk name. The value can contain a maximum of 255 bytes.
        If you create multiple disks (the count value is greater than 1), the system automatically adds a hyphen followed
        by a four-digit incremental number, such as -0000, to the end of each disk name. For example,
        the disk names can be volume-0001 and volume-0002. The value can contain a maximum of 250 bytes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the EVS volume resource. If omitted, the provider-level region will be used. Changing this creates a new EVS resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial_number", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_type", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the disk size, in GB. Its value can be as follows:
        - System disk: 1 GB to 1024 GB
        - Data disk: 10 GB to 32768 GB
        This parameter is mandatory when you create an empty disk. You can specify the parameter value as required within the value range.
        This parameter is mandatory when you create the disk from a snapshot. Ensure that the disk size is greater than or equal to the snapshot size.
        This parameter is mandatory when you create the disk from an image. Ensure that the disk size is greater than or equal to
        the minimum disk capacity required by min_disk in the image attributes.
        This parameter is optional when you create the disk from a backup. If this parameter is not specified, the disk size is equal to the backup size.
        Changing this parameter will update the disk. You can extend the disk by setting this parameter to a new value, which must be between current size
        and the max size(System disk: 1024 GB; Data disk: 32768 GB). Shrinking the disk is not supported.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snapshot ID from which to create the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "throughput", value)

    @_builtins.property
    @pulumi.getter(name="throughputAttributes")
    def throughput_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeThroughputAttributeArgs']]]]:
        return pulumi.get(self, "throughput_attributes")

    @throughput_attributes.setter
    def throughput_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeThroughputAttributeArgs']]]]):
        pulumi.set(self, "throughput_attributes", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the disk type.
        Currently, the value can be SSD, SAS, or SATA.
        - SSD: specifies the ultra-high I/O disk type.
        - SAS: specifies the high I/O disk type.
        - SATA: specifies the common I/O disk type.
        If the specified disk type is not available in the AZ, the disk will fail to create.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)

    @_builtins.property
    @pulumi.getter
    def wwn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the unique identifier used for mounting the EVS disk.
        """
        return pulumi.get(self, "wwn")

    @wwn.setter
    def wwn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wwn", value)


@pulumi.type_token("sbercloud:Evs/volume:Volume")
class Volume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cascade: Optional[pulumi.Input[_builtins.bool]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_storage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iops: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_id: Optional[pulumi.Input[_builtins.str]] = None,
                 multiattach: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a volume resource within sbercloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        volume = sbercloud.evs.Volume("volume",
            name="volume",
            description="my volume",
            volume_type="SSD",
            size=20,
            availability_zone="ru-moscow-1a")
        ```

        ### With KMS Encryption

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        volume = sbercloud.evs.Volume("volume",
            name="volume",
            description="my volume",
            volume_type="SSD",
            size=20,
            kms_id=kms_id,
            availability_zone="ru-moscow-1a")
        ```

        ## Import

        Volumes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Evs/volume:Volume volume_1 14a80bc7-c12c-4fe0-a38a-cb77eeac9bd6
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone for the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] backup_id: The backup ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.bool] cascade: Specifies the delete mode of snapshot. The default value is false. All snapshot
               associated with the disk will also be deleted when the parameter is set to true.
        :param pulumi.Input[_builtins.str] description: Specifies the disk description. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[_builtins.str] device_type: The device type of volume to create. Valid options are VBD and SCSI.
               Defaults to VBD. Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the disk. Changing this
               creates a new disk.
        :param pulumi.Input[_builtins.str] image_id: The image ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] kms_id: The Encryption KMS ID to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.bool] multiattach: Default:false. Specifies the shared EVS disk information.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] name: Specifies the disk name.
               If you create disks one by one, the name value is the disk name. The value can contain a maximum of 255 bytes.
               If you create multiple disks (the count value is greater than 1), the system automatically adds a hyphen followed
               by a four-digit incremental number, such as -0000, to the end of each disk name. For example,
               the disk names can be volume-0001 and volume-0002. The value can contain a maximum of 250 bytes.
        :param pulumi.Input[_builtins.str] region: The region in which to create the EVS volume resource. If omitted, the provider-level region will be used. Changing this creates a new EVS resource.
        :param pulumi.Input[_builtins.int] size: Specifies the disk size, in GB. Its value can be as follows:
               - System disk: 1 GB to 1024 GB
               - Data disk: 10 GB to 32768 GB
               This parameter is mandatory when you create an empty disk. You can specify the parameter value as required within the value range.
               This parameter is mandatory when you create the disk from a snapshot. Ensure that the disk size is greater than or equal to the snapshot size.
               This parameter is mandatory when you create the disk from an image. Ensure that the disk size is greater than or equal to
               the minimum disk capacity required by min_disk in the image attributes.
               This parameter is optional when you create the disk from a backup. If this parameter is not specified, the disk size is equal to the backup size.
               Changing this parameter will update the disk. You can extend the disk by setting this parameter to a new value, which must be between current size
               and the max size(System disk: 1024 GB; Data disk: 32768 GB). Shrinking the disk is not supported.
        :param pulumi.Input[_builtins.str] snapshot_id: The snapshot ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] volume_type: Specifies the disk type.
               Currently, the value can be SSD, SAS, or SATA.
               - SSD: specifies the ultra-high I/O disk type.
               - SAS: specifies the high I/O disk type.
               - SATA: specifies the common I/O disk type.
               If the specified disk type is not available in the AZ, the disk will fail to create.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a volume resource within sbercloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        volume = sbercloud.evs.Volume("volume",
            name="volume",
            description="my volume",
            volume_type="SSD",
            size=20,
            availability_zone="ru-moscow-1a")
        ```

        ### With KMS Encryption

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        volume = sbercloud.evs.Volume("volume",
            name="volume",
            description="my volume",
            volume_type="SSD",
            size=20,
            kms_id=kms_id,
            availability_zone="ru-moscow-1a")
        ```

        ## Import

        Volumes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Evs/volume:Volume volume_1 14a80bc7-c12c-4fe0-a38a-cb77eeac9bd6
        ```

        :param str resource_name: The name of the resource.
        :param VolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cascade: Optional[pulumi.Input[_builtins.bool]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_storage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iops: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_id: Optional[pulumi.Input[_builtins.str]] = None,
                 multiattach: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeArgs.__new__(VolumeArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_id"] = backup_id
            __props__.__dict__["cascade"] = cascade
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["dedicated_storage_id"] = dedicated_storage_id
            __props__.__dict__["description"] = description
            __props__.__dict__["device_type"] = device_type
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["iops"] = iops
            __props__.__dict__["kms_id"] = kms_id
            __props__.__dict__["multiattach"] = multiattach
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["region"] = region
            __props__.__dict__["server_id"] = server_id
            __props__.__dict__["size"] = size
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["throughput"] = throughput
            if volume_type is None and not opts.urn:
                raise TypeError("Missing required property 'volume_type'")
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["all_metadata"] = None
            __props__.__dict__["all_volume_image_metadata"] = None
            __props__.__dict__["attachments"] = None
            __props__.__dict__["bootable"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["dedicated_storage_name"] = None
            __props__.__dict__["iops_attributes"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["serial_number"] = None
            __props__.__dict__["service_type"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["throughput_attributes"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["wwn"] = None
        super(Volume, __self__).__init__(
            'sbercloud:Evs/volume:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            all_volume_image_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeAttachmentArgs', 'VolumeAttachmentArgsDict']]]]] = None,
            auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            backup_id: Optional[pulumi.Input[_builtins.str]] = None,
            bootable: Optional[pulumi.Input[_builtins.str]] = None,
            cascade: Optional[pulumi.Input[_builtins.bool]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            dedicated_storage_id: Optional[pulumi.Input[_builtins.str]] = None,
            dedicated_storage_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device_type: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            iops: Optional[pulumi.Input[_builtins.int]] = None,
            iops_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeIopsAttributeArgs', 'VolumeIopsAttributeArgsDict']]]]] = None,
            kms_id: Optional[pulumi.Input[_builtins.str]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeLinkArgs', 'VolumeLinkArgsDict']]]]] = None,
            multiattach: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            serial_number: Optional[pulumi.Input[_builtins.str]] = None,
            server_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_type: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            throughput: Optional[pulumi.Input[_builtins.int]] = None,
            throughput_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeThroughputAttributeArgs', 'VolumeThroughputAttributeArgsDict']]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            volume_type: Optional[pulumi.Input[_builtins.str]] = None,
            wwn: Optional[pulumi.Input[_builtins.str]] = None) -> 'Volume':
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeAttachmentArgs', 'VolumeAttachmentArgsDict']]]] attachments: If a volume is attached to an instance, this attribute will
               display the Attachment ID, Instance ID, and the Device as the Instance
               sees it.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone for the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] backup_id: The backup ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.bool] cascade: Specifies the delete mode of snapshot. The default value is false. All snapshot
               associated with the disk will also be deleted when the parameter is set to true.
        :param pulumi.Input[_builtins.str] description: Specifies the disk description. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[_builtins.str] device_type: The device type of volume to create. Valid options are VBD and SCSI.
               Defaults to VBD. Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the disk. Changing this
               creates a new disk.
        :param pulumi.Input[_builtins.str] image_id: The image ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] kms_id: The Encryption KMS ID to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.bool] multiattach: Default:false. Specifies the shared EVS disk information.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] name: Specifies the disk name.
               If you create disks one by one, the name value is the disk name. The value can contain a maximum of 255 bytes.
               If you create multiple disks (the count value is greater than 1), the system automatically adds a hyphen followed
               by a four-digit incremental number, such as -0000, to the end of each disk name. For example,
               the disk names can be volume-0001 and volume-0002. The value can contain a maximum of 250 bytes.
        :param pulumi.Input[_builtins.str] region: The region in which to create the EVS volume resource. If omitted, the provider-level region will be used. Changing this creates a new EVS resource.
        :param pulumi.Input[_builtins.int] size: Specifies the disk size, in GB. Its value can be as follows:
               - System disk: 1 GB to 1024 GB
               - Data disk: 10 GB to 32768 GB
               This parameter is mandatory when you create an empty disk. You can specify the parameter value as required within the value range.
               This parameter is mandatory when you create the disk from a snapshot. Ensure that the disk size is greater than or equal to the snapshot size.
               This parameter is mandatory when you create the disk from an image. Ensure that the disk size is greater than or equal to
               the minimum disk capacity required by min_disk in the image attributes.
               This parameter is optional when you create the disk from a backup. If this parameter is not specified, the disk size is equal to the backup size.
               Changing this parameter will update the disk. You can extend the disk by setting this parameter to a new value, which must be between current size
               and the max size(System disk: 1024 GB; Data disk: 32768 GB). Shrinking the disk is not supported.
        :param pulumi.Input[_builtins.str] snapshot_id: The snapshot ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[_builtins.str] volume_type: Specifies the disk type.
               Currently, the value can be SSD, SAS, or SATA.
               - SSD: specifies the ultra-high I/O disk type.
               - SAS: specifies the high I/O disk type.
               - SATA: specifies the common I/O disk type.
               If the specified disk type is not available in the AZ, the disk will fail to create.
        :param pulumi.Input[_builtins.str] wwn: Specifies the unique identifier used for mounting the EVS disk.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeState.__new__(_VolumeState)

        __props__.__dict__["all_metadata"] = all_metadata
        __props__.__dict__["all_volume_image_metadata"] = all_volume_image_metadata
        __props__.__dict__["attachments"] = attachments
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["backup_id"] = backup_id
        __props__.__dict__["bootable"] = bootable
        __props__.__dict__["cascade"] = cascade
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["dedicated_storage_id"] = dedicated_storage_id
        __props__.__dict__["dedicated_storage_name"] = dedicated_storage_name
        __props__.__dict__["description"] = description
        __props__.__dict__["device_type"] = device_type
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["iops"] = iops
        __props__.__dict__["iops_attributes"] = iops_attributes
        __props__.__dict__["kms_id"] = kms_id
        __props__.__dict__["links"] = links
        __props__.__dict__["multiattach"] = multiattach
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["region"] = region
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["server_id"] = server_id
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["size"] = size
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["throughput"] = throughput
        __props__.__dict__["throughput_attributes"] = throughput_attributes
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["volume_type"] = volume_type
        __props__.__dict__["wwn"] = wwn
        return Volume(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allMetadata")
    def all_metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "all_metadata")

    @_builtins.property
    @pulumi.getter(name="allVolumeImageMetadata")
    def all_volume_image_metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "all_volume_image_metadata")

    @_builtins.property
    @pulumi.getter
    def attachments(self) -> pulumi.Output[Sequence['outputs.VolumeAttachment']]:
        """
        If a volume is attached to an instance, this attribute will
        display the Attachment ID, Instance ID, and the Device as the Instance
        sees it.
        """
        return pulumi.get(self, "attachments")

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The availability zone for the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The backup ID from which to create the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter
    def bootable(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "bootable")

    @_builtins.property
    @pulumi.getter
    def cascade(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies the delete mode of snapshot. The default value is false. All snapshot
        associated with the disk will also be deleted when the parameter is set to true.
        """
        return pulumi.get(self, "cascade")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dedicatedStorageId")
    def dedicated_storage_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "dedicated_storage_id")

    @_builtins.property
    @pulumi.getter(name="dedicatedStorageName")
    def dedicated_storage_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "dedicated_storage_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the disk description. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device type of volume to create. Valid options are VBD and SCSI.
        Defaults to VBD. Changing this creates a new volume.
        """
        return pulumi.get(self, "device_type")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project id of the disk. Changing this
        creates a new disk.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The image ID from which to create the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter(name="iopsAttributes")
    def iops_attributes(self) -> pulumi.Output[Sequence['outputs.VolumeIopsAttribute']]:
        return pulumi.get(self, "iops_attributes")

    @_builtins.property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Encryption KMS ID to create the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "kms_id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.VolumeLink']]:
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def multiattach(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Default:false. Specifies the shared EVS disk information.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "multiattach")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the disk name.
        If you create disks one by one, the name value is the disk name. The value can contain a maximum of 255 bytes.
        If you create multiple disks (the count value is greater than 1), the system automatically adds a hyphen followed
        by a four-digit incremental number, such as -0000, to the end of each disk name. For example,
        the disk names can be volume-0001 and volume-0002. The value can contain a maximum of 250 bytes.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the EVS volume resource. If omitted, the provider-level region will be used. Changing this creates a new EVS resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "service_type")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the disk size, in GB. Its value can be as follows:
        - System disk: 1 GB to 1024 GB
        - Data disk: 10 GB to 32768 GB
        This parameter is mandatory when you create an empty disk. You can specify the parameter value as required within the value range.
        This parameter is mandatory when you create the disk from a snapshot. Ensure that the disk size is greater than or equal to the snapshot size.
        This parameter is mandatory when you create the disk from an image. Ensure that the disk size is greater than or equal to
        the minimum disk capacity required by min_disk in the image attributes.
        This parameter is optional when you create the disk from a backup. If this parameter is not specified, the disk size is equal to the backup size.
        Changing this parameter will update the disk. You can extend the disk by setting this parameter to a new value, which must be between current size
        and the max size(System disk: 1024 GB; Data disk: 32768 GB). Shrinking the disk is not supported.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snapshot ID from which to create the volume.
        Changing this creates a new volume.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "throughput")

    @_builtins.property
    @pulumi.getter(name="throughputAttributes")
    def throughput_attributes(self) -> pulumi.Output[Sequence['outputs.VolumeThroughputAttribute']]:
        return pulumi.get(self, "throughput_attributes")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the disk type.
        Currently, the value can be SSD, SAS, or SATA.
        - SSD: specifies the ultra-high I/O disk type.
        - SAS: specifies the high I/O disk type.
        - SATA: specifies the common I/O disk type.
        If the specified disk type is not available in the AZ, the disk will fail to create.
        """
        return pulumi.get(self, "volume_type")

    @_builtins.property
    @pulumi.getter
    def wwn(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the unique identifier used for mounting the EVS disk.
        """
        return pulumi.get(self, "wwn")

