# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FgsApplicationArgs', 'FgsApplication']

@pulumi.input_type
class FgsApplicationArgs:
    def __init__(__self__, *,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FgsApplication resource.
        :param pulumi.Input[_builtins.str] agency_name: Specifies the agency name used by the application.  
               Changing this parameter will create a new resource.
               
               > If omitted, the service will automatically create an agency, please ensure that the tenant has IAM related
               permissions. The agency will be deleted when the application is deleted.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the application.  
               The description can contain a maximum of `1,024` characters.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the application name.  
               The name can contain a maximum of 60 characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_) and hyphens (-) are allowed.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] params: Specifies the template parameters, in JSON format.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create an application.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] template_id: Specifies the ID of the template used by the application.  
               Changing this parameter will create a new resource.
        """
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the agency name used by the application.  
        Changing this parameter will create a new resource.

        > If omitted, the service will automatically create an agency, please ensure that the tenant has IAM related
        permissions. The agency will be deleted when the application is deleted.
        """
        return pulumi.get(self, "agency_name")

    @agency_name.setter
    def agency_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agency_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the application.  
        The description can contain a maximum of `1,024` characters.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the application name.  
        The name can contain a maximum of 60 characters and must start with a letter and end with a letter or digit.
        Only letters, digits, underscores (_) and hyphens (-) are allowed.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the template parameters, in JSON format.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create an application.  
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the template used by the application.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_id", value)


@pulumi.input_type
class _FgsApplicationState:
    def __init__(__self__, *,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input['FgsApplicationRepositoryArgs']]]] = None,
                 stack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_resources: Optional[pulumi.Input[Sequence[pulumi.Input['FgsApplicationStackResourceArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FgsApplication resources.
        :param pulumi.Input[_builtins.str] agency_name: Specifies the agency name used by the application.  
               Changing this parameter will create a new resource.
               
               > If omitted, the service will automatically create an agency, please ensure that the tenant has IAM related
               permissions. The agency will be deleted when the application is deleted.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the application.  
               The description can contain a maximum of `1,024` characters.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the application name.  
               The name can contain a maximum of 60 characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_) and hyphens (-) are allowed.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] params: Specifies the template parameters, in JSON format.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create an application.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['FgsApplicationRepositoryArgs']]] repositories: The repository information.  
               The repository structure is documented below.
        :param pulumi.Input[_builtins.str] stack_id: The ID of the stack where the application is deployed.
        :param pulumi.Input[Sequence[pulumi.Input['FgsApplicationStackResourceArgs']]] stack_resources: The list of the stack resources information.  
               The stack_resources structure is documented below.
        :param pulumi.Input[_builtins.str] status: The repository status.
        :param pulumi.Input[_builtins.str] template_id: Specifies the ID of the template used by the application.  
               Changing this parameter will create a new resource.
        """
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if repositories is not None:
            pulumi.set(__self__, "repositories", repositories)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)
        if stack_resources is not None:
            pulumi.set(__self__, "stack_resources", stack_resources)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the agency name used by the application.  
        Changing this parameter will create a new resource.

        > If omitted, the service will automatically create an agency, please ensure that the tenant has IAM related
        permissions. The agency will be deleted when the application is deleted.
        """
        return pulumi.get(self, "agency_name")

    @agency_name.setter
    def agency_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agency_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the application.  
        The description can contain a maximum of `1,024` characters.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the application name.  
        The name can contain a maximum of 60 characters and must start with a letter and end with a letter or digit.
        Only letters, digits, underscores (_) and hyphens (-) are allowed.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the template parameters, in JSON format.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create an application.  
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FgsApplicationRepositoryArgs']]]]:
        """
        The repository information.  
        The repository structure is documented below.
        """
        return pulumi.get(self, "repositories")

    @repositories.setter
    def repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FgsApplicationRepositoryArgs']]]]):
        pulumi.set(self, "repositories", value)

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the stack where the application is deployed.
        """
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_id", value)

    @_builtins.property
    @pulumi.getter(name="stackResources")
    def stack_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FgsApplicationStackResourceArgs']]]]:
        """
        The list of the stack resources information.  
        The stack_resources structure is documented below.
        """
        return pulumi.get(self, "stack_resources")

    @stack_resources.setter
    def stack_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FgsApplicationStackResourceArgs']]]]):
        pulumi.set(self, "stack_resources", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The repository status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the template used by the application.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_id", value)


@pulumi.type_token("sbercloud:index/fgsApplication:FgsApplication")
class FgsApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an application within SberCloud.

        > Currently, only available in `cn-north-4` and `cn-east-3` regions.

        ## Example Usage

        ## Import

        Application can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/fgsApplication:FgsApplication test <id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response.

        The missing attributes include: `template_id`, `agency_name`, `params`.

        It is generally recommended running `pulumi preview` after importing the application.

        You can then decide if changes should be applied to the application, or the resource definition should be updated to

        align with the application. Also you can ignore changes as below.

        hcl

        resource "sbercloud_fgs_application" "test" {

          ...

          lifecycle {

            ignore_changes = [
            
              template_id, agency_name,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agency_name: Specifies the agency name used by the application.  
               Changing this parameter will create a new resource.
               
               > If omitted, the service will automatically create an agency, please ensure that the tenant has IAM related
               permissions. The agency will be deleted when the application is deleted.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the application.  
               The description can contain a maximum of `1,024` characters.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the application name.  
               The name can contain a maximum of 60 characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_) and hyphens (-) are allowed.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] params: Specifies the template parameters, in JSON format.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create an application.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] template_id: Specifies the ID of the template used by the application.  
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FgsApplicationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an application within SberCloud.

        > Currently, only available in `cn-north-4` and `cn-east-3` regions.

        ## Example Usage

        ## Import

        Application can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/fgsApplication:FgsApplication test <id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response.

        The missing attributes include: `template_id`, `agency_name`, `params`.

        It is generally recommended running `pulumi preview` after importing the application.

        You can then decide if changes should be applied to the application, or the resource definition should be updated to

        align with the application. Also you can ignore changes as below.

        hcl

        resource "sbercloud_fgs_application" "test" {

          ...

          lifecycle {

            ignore_changes = [
            
              template_id, agency_name,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param FgsApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FgsApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FgsApplicationArgs.__new__(FgsApplicationArgs)

            __props__.__dict__["agency_name"] = agency_name
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["params"] = params
            __props__.__dict__["region"] = region
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["repositories"] = None
            __props__.__dict__["stack_id"] = None
            __props__.__dict__["stack_resources"] = None
            __props__.__dict__["status"] = None
        super(FgsApplication, __self__).__init__(
            'sbercloud:index/fgsApplication:FgsApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agency_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            params: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FgsApplicationRepositoryArgs', 'FgsApplicationRepositoryArgsDict']]]]] = None,
            stack_id: Optional[pulumi.Input[_builtins.str]] = None,
            stack_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FgsApplicationStackResourceArgs', 'FgsApplicationStackResourceArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            template_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'FgsApplication':
        """
        Get an existing FgsApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agency_name: Specifies the agency name used by the application.  
               Changing this parameter will create a new resource.
               
               > If omitted, the service will automatically create an agency, please ensure that the tenant has IAM related
               permissions. The agency will be deleted when the application is deleted.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the application.  
               The description can contain a maximum of `1,024` characters.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the application name.  
               The name can contain a maximum of 60 characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_) and hyphens (-) are allowed.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] params: Specifies the template parameters, in JSON format.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create an application.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FgsApplicationRepositoryArgs', 'FgsApplicationRepositoryArgsDict']]]] repositories: The repository information.  
               The repository structure is documented below.
        :param pulumi.Input[_builtins.str] stack_id: The ID of the stack where the application is deployed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FgsApplicationStackResourceArgs', 'FgsApplicationStackResourceArgsDict']]]] stack_resources: The list of the stack resources information.  
               The stack_resources structure is documented below.
        :param pulumi.Input[_builtins.str] status: The repository status.
        :param pulumi.Input[_builtins.str] template_id: Specifies the ID of the template used by the application.  
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FgsApplicationState.__new__(_FgsApplicationState)

        __props__.__dict__["agency_name"] = agency_name
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["params"] = params
        __props__.__dict__["region"] = region
        __props__.__dict__["repositories"] = repositories
        __props__.__dict__["stack_id"] = stack_id
        __props__.__dict__["stack_resources"] = stack_resources
        __props__.__dict__["status"] = status
        __props__.__dict__["template_id"] = template_id
        return FgsApplication(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the agency name used by the application.  
        Changing this parameter will create a new resource.

        > If omitted, the service will automatically create an agency, please ensure that the tenant has IAM related
        permissions. The agency will be deleted when the application is deleted.
        """
        return pulumi.get(self, "agency_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the application.  
        The description can contain a maximum of `1,024` characters.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the application name.  
        The name can contain a maximum of 60 characters and must start with a letter and end with a letter or digit.
        Only letters, digits, underscores (_) and hyphens (-) are allowed.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def params(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the template parameters, in JSON format.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "params")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create an application.  
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def repositories(self) -> pulumi.Output[Sequence['outputs.FgsApplicationRepository']]:
        """
        The repository information.  
        The repository structure is documented below.
        """
        return pulumi.get(self, "repositories")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the stack where the application is deployed.
        """
        return pulumi.get(self, "stack_id")

    @_builtins.property
    @pulumi.getter(name="stackResources")
    def stack_resources(self) -> pulumi.Output[Sequence['outputs.FgsApplicationStackResource']]:
        """
        The list of the stack resources information.  
        The stack_resources structure is documented below.
        """
        return pulumi.get(self, "stack_resources")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The repository status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the template used by the application.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "template_id")

