# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FgsAsyncInvokeConfigurationArgs', 'FgsAsyncInvokeConfiguration']

@pulumi.input_type
class FgsAsyncInvokeConfigurationArgs:
    def __init__(__self__, *,
                 function_urn: pulumi.Input[_builtins.str],
                 max_async_event_age_in_seconds: pulumi.Input[_builtins.int],
                 max_async_retry_attempts: pulumi.Input[_builtins.int],
                 enable_async_status_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_failure: Optional[pulumi.Input['FgsAsyncInvokeConfigurationOnFailureArgs']] = None,
                 on_success: Optional[pulumi.Input['FgsAsyncInvokeConfigurationOnSuccessArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FgsAsyncInvokeConfiguration resource.
        :param pulumi.Input[_builtins.str] function_urn: Specifies the function URN to which the asynchronous invocation belongs.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] max_async_event_age_in_seconds: Specifies the maximum validity period of a message.  
               The valid value is range from `1` to `86,400`.
        :param pulumi.Input[_builtins.int] max_async_retry_attempts: Specifies the maximum number of retry attempts to be made if
               asynchronous invocation fails.
               The valid value is range from `0` to `3`.
        :param pulumi.Input[_builtins.bool] enable_async_status_log: Specifies whether to enable asynchronous invocation status persistence.
               
               <a name="functiongraph_destination_config"></a>
               The `on_success` and the `on_failure` blocks support:
        :param pulumi.Input['FgsAsyncInvokeConfigurationOnFailureArgs'] on_failure: Specifies the target to be invoked when a function fails to be executed due to a
               system error or an internal error.
               The object structure is documented below.
        :param pulumi.Input['FgsAsyncInvokeConfigurationOnSuccessArgs'] on_success: Specifies the target to be invoked when a function is successfully executed.  
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to configure the asynchronous invocation.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        pulumi.set(__self__, "function_urn", function_urn)
        pulumi.set(__self__, "max_async_event_age_in_seconds", max_async_event_age_in_seconds)
        pulumi.set(__self__, "max_async_retry_attempts", max_async_retry_attempts)
        if enable_async_status_log is not None:
            pulumi.set(__self__, "enable_async_status_log", enable_async_status_log)
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if on_success is not None:
            pulumi.set(__self__, "on_success", on_success)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the function URN to which the asynchronous invocation belongs.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_urn", value)

    @_builtins.property
    @pulumi.getter(name="maxAsyncEventAgeInSeconds")
    def max_async_event_age_in_seconds(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the maximum validity period of a message.  
        The valid value is range from `1` to `86,400`.
        """
        return pulumi.get(self, "max_async_event_age_in_seconds")

    @max_async_event_age_in_seconds.setter
    def max_async_event_age_in_seconds(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_async_event_age_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="maxAsyncRetryAttempts")
    def max_async_retry_attempts(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the maximum number of retry attempts to be made if
        asynchronous invocation fails.
        The valid value is range from `0` to `3`.
        """
        return pulumi.get(self, "max_async_retry_attempts")

    @max_async_retry_attempts.setter
    def max_async_retry_attempts(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_async_retry_attempts", value)

    @_builtins.property
    @pulumi.getter(name="enableAsyncStatusLog")
    def enable_async_status_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable asynchronous invocation status persistence.

        <a name="functiongraph_destination_config"></a>
        The `on_success` and the `on_failure` blocks support:
        """
        return pulumi.get(self, "enable_async_status_log")

    @enable_async_status_log.setter
    def enable_async_status_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_async_status_log", value)

    @_builtins.property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional[pulumi.Input['FgsAsyncInvokeConfigurationOnFailureArgs']]:
        """
        Specifies the target to be invoked when a function fails to be executed due to a
        system error or an internal error.
        The object structure is documented below.
        """
        return pulumi.get(self, "on_failure")

    @on_failure.setter
    def on_failure(self, value: Optional[pulumi.Input['FgsAsyncInvokeConfigurationOnFailureArgs']]):
        pulumi.set(self, "on_failure", value)

    @_builtins.property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> Optional[pulumi.Input['FgsAsyncInvokeConfigurationOnSuccessArgs']]:
        """
        Specifies the target to be invoked when a function is successfully executed.  
        The object structure is documented below.
        """
        return pulumi.get(self, "on_success")

    @on_success.setter
    def on_success(self, value: Optional[pulumi.Input['FgsAsyncInvokeConfigurationOnSuccessArgs']]):
        pulumi.set(self, "on_success", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to configure the asynchronous invocation.  
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _FgsAsyncInvokeConfigurationState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_async_status_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 max_async_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_async_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 on_failure: Optional[pulumi.Input['FgsAsyncInvokeConfigurationOnFailureArgs']] = None,
                 on_success: Optional[pulumi.Input['FgsAsyncInvokeConfigurationOnSuccessArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FgsAsyncInvokeConfiguration resources.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the asynchronous invocation, in RFC3339 format.
        :param pulumi.Input[_builtins.bool] enable_async_status_log: Specifies whether to enable asynchronous invocation status persistence.
               
               <a name="functiongraph_destination_config"></a>
               The `on_success` and the `on_failure` blocks support:
        :param pulumi.Input[_builtins.str] function_urn: Specifies the function URN to which the asynchronous invocation belongs.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] max_async_event_age_in_seconds: Specifies the maximum validity period of a message.  
               The valid value is range from `1` to `86,400`.
        :param pulumi.Input[_builtins.int] max_async_retry_attempts: Specifies the maximum number of retry attempts to be made if
               asynchronous invocation fails.
               The valid value is range from `0` to `3`.
        :param pulumi.Input['FgsAsyncInvokeConfigurationOnFailureArgs'] on_failure: Specifies the target to be invoked when a function fails to be executed due to a
               system error or an internal error.
               The object structure is documented below.
        :param pulumi.Input['FgsAsyncInvokeConfigurationOnSuccessArgs'] on_success: Specifies the target to be invoked when a function is successfully executed.  
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to configure the asynchronous invocation.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the asynchronous invocation, in RFC3339 format.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enable_async_status_log is not None:
            pulumi.set(__self__, "enable_async_status_log", enable_async_status_log)
        if function_urn is not None:
            pulumi.set(__self__, "function_urn", function_urn)
        if max_async_event_age_in_seconds is not None:
            pulumi.set(__self__, "max_async_event_age_in_seconds", max_async_event_age_in_seconds)
        if max_async_retry_attempts is not None:
            pulumi.set(__self__, "max_async_retry_attempts", max_async_retry_attempts)
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if on_success is not None:
            pulumi.set(__self__, "on_success", on_success)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the asynchronous invocation, in RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="enableAsyncStatusLog")
    def enable_async_status_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable asynchronous invocation status persistence.

        <a name="functiongraph_destination_config"></a>
        The `on_success` and the `on_failure` blocks support:
        """
        return pulumi.get(self, "enable_async_status_log")

    @enable_async_status_log.setter
    def enable_async_status_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_async_status_log", value)

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the function URN to which the asynchronous invocation belongs.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_urn", value)

    @_builtins.property
    @pulumi.getter(name="maxAsyncEventAgeInSeconds")
    def max_async_event_age_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum validity period of a message.  
        The valid value is range from `1` to `86,400`.
        """
        return pulumi.get(self, "max_async_event_age_in_seconds")

    @max_async_event_age_in_seconds.setter
    def max_async_event_age_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_async_event_age_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="maxAsyncRetryAttempts")
    def max_async_retry_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of retry attempts to be made if
        asynchronous invocation fails.
        The valid value is range from `0` to `3`.
        """
        return pulumi.get(self, "max_async_retry_attempts")

    @max_async_retry_attempts.setter
    def max_async_retry_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_async_retry_attempts", value)

    @_builtins.property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional[pulumi.Input['FgsAsyncInvokeConfigurationOnFailureArgs']]:
        """
        Specifies the target to be invoked when a function fails to be executed due to a
        system error or an internal error.
        The object structure is documented below.
        """
        return pulumi.get(self, "on_failure")

    @on_failure.setter
    def on_failure(self, value: Optional[pulumi.Input['FgsAsyncInvokeConfigurationOnFailureArgs']]):
        pulumi.set(self, "on_failure", value)

    @_builtins.property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> Optional[pulumi.Input['FgsAsyncInvokeConfigurationOnSuccessArgs']]:
        """
        Specifies the target to be invoked when a function is successfully executed.  
        The object structure is documented below.
        """
        return pulumi.get(self, "on_success")

    @on_success.setter
    def on_success(self, value: Optional[pulumi.Input['FgsAsyncInvokeConfigurationOnSuccessArgs']]):
        pulumi.set(self, "on_success", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to configure the asynchronous invocation.  
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update time of the asynchronous invocation, in RFC3339 format.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:index/fgsAsyncInvokeConfiguration:FgsAsyncInvokeConfiguration")
class FgsAsyncInvokeConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_async_status_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 max_async_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_async_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 on_failure: Optional[pulumi.Input[Union['FgsAsyncInvokeConfigurationOnFailureArgs', 'FgsAsyncInvokeConfigurationOnFailureArgsDict']]] = None,
                 on_success: Optional[pulumi.Input[Union['FgsAsyncInvokeConfigurationOnSuccessArgs', 'FgsAsyncInvokeConfigurationOnSuccessArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Using this resource to manage the configuration of the asynchronous invocation within HuaweiCloud.

        > A function only supports configuring one resource.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        bucket_name = config.require_object("bucketName")
        topic_urn = config.require_object("topicUrn")
        test = sbercloud.FgsAsyncInvokeConfiguration("test",
            function_urn=function_urn,
            max_async_event_age_in_seconds=3500,
            max_async_retry_attempts=2,
            enable_async_status_log=True,
            on_success={
                "destination": "OBS",
                "param": json.dumps({
                    "bucket": bucket_name,
                    "prefix": "/success",
                    "expires": 5,
                }),
            },
            on_failure={
                "destination": "SMN",
                "param": json.dumps({
                    "topic_urn": topic_urn,
                }),
            })
        ```

        ## Import

        The configurations can be imported using their related `function_urn`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/fgsAsyncInvokeConfiguration:FgsAsyncInvokeConfiguration test <function_urn>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enable_async_status_log: Specifies whether to enable asynchronous invocation status persistence.
               
               <a name="functiongraph_destination_config"></a>
               The `on_success` and the `on_failure` blocks support:
        :param pulumi.Input[_builtins.str] function_urn: Specifies the function URN to which the asynchronous invocation belongs.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] max_async_event_age_in_seconds: Specifies the maximum validity period of a message.  
               The valid value is range from `1` to `86,400`.
        :param pulumi.Input[_builtins.int] max_async_retry_attempts: Specifies the maximum number of retry attempts to be made if
               asynchronous invocation fails.
               The valid value is range from `0` to `3`.
        :param pulumi.Input[Union['FgsAsyncInvokeConfigurationOnFailureArgs', 'FgsAsyncInvokeConfigurationOnFailureArgsDict']] on_failure: Specifies the target to be invoked when a function fails to be executed due to a
               system error or an internal error.
               The object structure is documented below.
        :param pulumi.Input[Union['FgsAsyncInvokeConfigurationOnSuccessArgs', 'FgsAsyncInvokeConfigurationOnSuccessArgsDict']] on_success: Specifies the target to be invoked when a function is successfully executed.  
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to configure the asynchronous invocation.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FgsAsyncInvokeConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Using this resource to manage the configuration of the asynchronous invocation within HuaweiCloud.

        > A function only supports configuring one resource.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        bucket_name = config.require_object("bucketName")
        topic_urn = config.require_object("topicUrn")
        test = sbercloud.FgsAsyncInvokeConfiguration("test",
            function_urn=function_urn,
            max_async_event_age_in_seconds=3500,
            max_async_retry_attempts=2,
            enable_async_status_log=True,
            on_success={
                "destination": "OBS",
                "param": json.dumps({
                    "bucket": bucket_name,
                    "prefix": "/success",
                    "expires": 5,
                }),
            },
            on_failure={
                "destination": "SMN",
                "param": json.dumps({
                    "topic_urn": topic_urn,
                }),
            })
        ```

        ## Import

        The configurations can be imported using their related `function_urn`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/fgsAsyncInvokeConfiguration:FgsAsyncInvokeConfiguration test <function_urn>
        ```

        :param str resource_name: The name of the resource.
        :param FgsAsyncInvokeConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FgsAsyncInvokeConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_async_status_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 max_async_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_async_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 on_failure: Optional[pulumi.Input[Union['FgsAsyncInvokeConfigurationOnFailureArgs', 'FgsAsyncInvokeConfigurationOnFailureArgsDict']]] = None,
                 on_success: Optional[pulumi.Input[Union['FgsAsyncInvokeConfigurationOnSuccessArgs', 'FgsAsyncInvokeConfigurationOnSuccessArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FgsAsyncInvokeConfigurationArgs.__new__(FgsAsyncInvokeConfigurationArgs)

            __props__.__dict__["enable_async_status_log"] = enable_async_status_log
            if function_urn is None and not opts.urn:
                raise TypeError("Missing required property 'function_urn'")
            __props__.__dict__["function_urn"] = function_urn
            if max_async_event_age_in_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'max_async_event_age_in_seconds'")
            __props__.__dict__["max_async_event_age_in_seconds"] = max_async_event_age_in_seconds
            if max_async_retry_attempts is None and not opts.urn:
                raise TypeError("Missing required property 'max_async_retry_attempts'")
            __props__.__dict__["max_async_retry_attempts"] = max_async_retry_attempts
            __props__.__dict__["on_failure"] = on_failure
            __props__.__dict__["on_success"] = on_success
            __props__.__dict__["region"] = region
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(FgsAsyncInvokeConfiguration, __self__).__init__(
            'sbercloud:index/fgsAsyncInvokeConfiguration:FgsAsyncInvokeConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            enable_async_status_log: Optional[pulumi.Input[_builtins.bool]] = None,
            function_urn: Optional[pulumi.Input[_builtins.str]] = None,
            max_async_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            max_async_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
            on_failure: Optional[pulumi.Input[Union['FgsAsyncInvokeConfigurationOnFailureArgs', 'FgsAsyncInvokeConfigurationOnFailureArgsDict']]] = None,
            on_success: Optional[pulumi.Input[Union['FgsAsyncInvokeConfigurationOnSuccessArgs', 'FgsAsyncInvokeConfigurationOnSuccessArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'FgsAsyncInvokeConfiguration':
        """
        Get an existing FgsAsyncInvokeConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the asynchronous invocation, in RFC3339 format.
        :param pulumi.Input[_builtins.bool] enable_async_status_log: Specifies whether to enable asynchronous invocation status persistence.
               
               <a name="functiongraph_destination_config"></a>
               The `on_success` and the `on_failure` blocks support:
        :param pulumi.Input[_builtins.str] function_urn: Specifies the function URN to which the asynchronous invocation belongs.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] max_async_event_age_in_seconds: Specifies the maximum validity period of a message.  
               The valid value is range from `1` to `86,400`.
        :param pulumi.Input[_builtins.int] max_async_retry_attempts: Specifies the maximum number of retry attempts to be made if
               asynchronous invocation fails.
               The valid value is range from `0` to `3`.
        :param pulumi.Input[Union['FgsAsyncInvokeConfigurationOnFailureArgs', 'FgsAsyncInvokeConfigurationOnFailureArgsDict']] on_failure: Specifies the target to be invoked when a function fails to be executed due to a
               system error or an internal error.
               The object structure is documented below.
        :param pulumi.Input[Union['FgsAsyncInvokeConfigurationOnSuccessArgs', 'FgsAsyncInvokeConfigurationOnSuccessArgsDict']] on_success: Specifies the target to be invoked when a function is successfully executed.  
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to configure the asynchronous invocation.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the asynchronous invocation, in RFC3339 format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FgsAsyncInvokeConfigurationState.__new__(_FgsAsyncInvokeConfigurationState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enable_async_status_log"] = enable_async_status_log
        __props__.__dict__["function_urn"] = function_urn
        __props__.__dict__["max_async_event_age_in_seconds"] = max_async_event_age_in_seconds
        __props__.__dict__["max_async_retry_attempts"] = max_async_retry_attempts
        __props__.__dict__["on_failure"] = on_failure
        __props__.__dict__["on_success"] = on_success
        __props__.__dict__["region"] = region
        __props__.__dict__["updated_at"] = updated_at
        return FgsAsyncInvokeConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the asynchronous invocation, in RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="enableAsyncStatusLog")
    def enable_async_status_log(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable asynchronous invocation status persistence.

        <a name="functiongraph_destination_config"></a>
        The `on_success` and the `on_failure` blocks support:
        """
        return pulumi.get(self, "enable_async_status_log")

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the function URN to which the asynchronous invocation belongs.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "function_urn")

    @_builtins.property
    @pulumi.getter(name="maxAsyncEventAgeInSeconds")
    def max_async_event_age_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum validity period of a message.  
        The valid value is range from `1` to `86,400`.
        """
        return pulumi.get(self, "max_async_event_age_in_seconds")

    @_builtins.property
    @pulumi.getter(name="maxAsyncRetryAttempts")
    def max_async_retry_attempts(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum number of retry attempts to be made if
        asynchronous invocation fails.
        The valid value is range from `0` to `3`.
        """
        return pulumi.get(self, "max_async_retry_attempts")

    @_builtins.property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> pulumi.Output[Optional['outputs.FgsAsyncInvokeConfigurationOnFailure']]:
        """
        Specifies the target to be invoked when a function fails to be executed due to a
        system error or an internal error.
        The object structure is documented below.
        """
        return pulumi.get(self, "on_failure")

    @_builtins.property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> pulumi.Output[Optional['outputs.FgsAsyncInvokeConfigurationOnSuccess']]:
        """
        Specifies the target to be invoked when a function is successfully executed.  
        The object structure is documented below.
        """
        return pulumi.get(self, "on_success")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to configure the asynchronous invocation.  
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update time of the asynchronous invocation, in RFC3339 format.
        """
        return pulumi.get(self, "updated_at")

