# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FgsDependencyVersionArgs', 'FgsDependencyVersion']

@pulumi.input_type
class FgsDependencyVersionArgs:
    def __init__(__self__, *,
                 link: pulumi.Input[_builtins.str],
                 runtime: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FgsDependencyVersion resource.
        :param pulumi.Input[_builtins.str] link: The OBS bucket path where the dependency package is located.
        :param pulumi.Input[_builtins.str] runtime: Specifies the runtime of the custom dependency version.
               The valid values are as follows:
               + **Java8**
               + **Java11**
               + **Node.js6.10**
               + **Node.js8.10**
               + **Node.js10.16**
               + **Node.js12.13**
               + **Node.js14.18**
               + **Python2.7**
               + **Python3.6**
               + **Python3.9**
               + **Go1.8**
               + **Go1.x**
               + **C#(.NET Core 2.0)**
               + **C#(.NET Core 2.1)**
               + **C#(.NET Core 3.1)**
               + **Custom**
               + **PHP 7.3**
               + **http**
               
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the custom dependency version.  
               The description can contain a maximum of `512` characters.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the custom dependency package to which the version
               belongs.
               The name can contain a maximum of `96` characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the custom dependency version is located.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        pulumi.set(__self__, "link", link)
        pulumi.set(__self__, "runtime", runtime)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def link(self) -> pulumi.Input[_builtins.str]:
        """
        The OBS bucket path where the dependency package is located.
        """
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "link", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the runtime of the custom dependency version.
        The valid values are as follows:
        + **Java8**
        + **Java11**
        + **Node.js6.10**
        + **Node.js8.10**
        + **Node.js10.16**
        + **Node.js12.13**
        + **Node.js14.18**
        + **Python2.7**
        + **Python3.6**
        + **Python3.9**
        + **Go1.8**
        + **Go1.x**
        + **C#(.NET Core 2.0)**
        + **C#(.NET Core 2.1)**
        + **C#(.NET Core 3.1)**
        + **Custom**
        + **PHP 7.3**
        + **http**

        Changing this will create a new resource.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the custom dependency version.  
        The description can contain a maximum of `512` characters.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the custom dependency package to which the version
        belongs.
        The name can contain a maximum of `96` characters and must start with a letter and end with a letter or digit.
        Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the custom dependency version is located.  
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _FgsDependencyVersionState:
    def __init__(__self__, *,
                 dependency_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 link: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FgsDependencyVersion resources.
        :param pulumi.Input[_builtins.str] dependency_id: The ID of the dependency package corresponding to the version.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the custom dependency version.  
               The description can contain a maximum of `512` characters.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] etag: The unique ID of the dependency.
        :param pulumi.Input[_builtins.str] link: The OBS bucket path where the dependency package is located.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the custom dependency package to which the version
               belongs.
               The name can contain a maximum of `96` characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] owner: The dependency owner, **public** indicates a public dependency.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the custom dependency version is located.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] runtime: Specifies the runtime of the custom dependency version.
               The valid values are as follows:
               + **Java8**
               + **Java11**
               + **Node.js6.10**
               + **Node.js8.10**
               + **Node.js10.16**
               + **Node.js12.13**
               + **Node.js14.18**
               + **Python2.7**
               + **Python3.6**
               + **Python3.9**
               + **Go1.8**
               + **Go1.x**
               + **C#(.NET Core 2.0)**
               + **C#(.NET Core 2.1)**
               + **C#(.NET Core 3.1)**
               + **Custom**
               + **PHP 7.3**
               + **http**
               
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] size: The dependency size, in bytes.
        :param pulumi.Input[_builtins.int] version: The dependency package version.
        :param pulumi.Input[_builtins.str] version_id: The ID of the dependency package version.
        """
        if dependency_id is not None:
            pulumi.set(__self__, "dependency_id", dependency_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @_builtins.property
    @pulumi.getter(name="dependencyId")
    def dependency_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dependency package corresponding to the version.
        """
        return pulumi.get(self, "dependency_id")

    @dependency_id.setter
    def dependency_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dependency_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the custom dependency version.  
        The description can contain a maximum of `512` characters.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID of the dependency.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OBS bucket path where the dependency package is located.
        """
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the custom dependency package to which the version
        belongs.
        The name can contain a maximum of `96` characters and must start with a letter and end with a letter or digit.
        Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dependency owner, **public** indicates a public dependency.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the custom dependency version is located.  
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the runtime of the custom dependency version.
        The valid values are as follows:
        + **Java8**
        + **Java11**
        + **Node.js6.10**
        + **Node.js8.10**
        + **Node.js10.16**
        + **Node.js12.13**
        + **Node.js14.18**
        + **Python2.7**
        + **Python3.6**
        + **Python3.9**
        + **Go1.8**
        + **Go1.x**
        + **C#(.NET Core 2.0)**
        + **C#(.NET Core 2.1)**
        + **C#(.NET Core 3.1)**
        + **Custom**
        + **PHP 7.3**
        + **http**

        Changing this will create a new resource.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The dependency size, in bytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The dependency package version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dependency package version.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_id", value)


@pulumi.type_token("sbercloud:index/fgsDependencyVersion:FgsDependencyVersion")
class FgsDependencyVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 link: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a custom dependency version within SberCloud.

        > We recommend using this resource to replace the `FunctionGraph.Dependency` resource for managing dependency
        packages. You can migrate smoothly because the parameter behavior of the two resources is consistent.

        ## Example Usage

        ### Create a custom dependency version using an OBS bucket path where the ZIP file is located

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        dependency_name = config.require_object("dependencyName")
        custom_dependency_location = config.require_object("customDependencyLocation")
        test = sbercloud.FgsDependencyVersion("test",
            name=dependency_name,
            runtime="Python3.6",
            link=custom_dependency_location)
        ```

        ## Import

        Dependency version can be imported using the resource `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/fgsDependencyVersion:FgsDependencyVersion test <id>
        ```

        Or using related dependency package `name` and the `version` number, separated by a slash (/), e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/fgsDependencyVersion:FgsDependencyVersion test <name>/<version>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `link`.

        It is generally recommended running `pulumi preview` after importing a dependency package.

        You can then decide if changes should be applied to the resource, or the resource definition should be updated to

        align with the dependency package. Also you can ignore changes as below.

        hcl

        resource "sbercloud_fgs_dependency_version" "test" {

          ...

          lifecycle {

            ignore_changes = [
            
              link,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the custom dependency version.  
               The description can contain a maximum of `512` characters.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] link: The OBS bucket path where the dependency package is located.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the custom dependency package to which the version
               belongs.
               The name can contain a maximum of `96` characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the custom dependency version is located.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] runtime: Specifies the runtime of the custom dependency version.
               The valid values are as follows:
               + **Java8**
               + **Java11**
               + **Node.js6.10**
               + **Node.js8.10**
               + **Node.js10.16**
               + **Node.js12.13**
               + **Node.js14.18**
               + **Python2.7**
               + **Python3.6**
               + **Python3.9**
               + **Go1.8**
               + **Go1.x**
               + **C#(.NET Core 2.0)**
               + **C#(.NET Core 2.1)**
               + **C#(.NET Core 3.1)**
               + **Custom**
               + **PHP 7.3**
               + **http**
               
               Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FgsDependencyVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a custom dependency version within SberCloud.

        > We recommend using this resource to replace the `FunctionGraph.Dependency` resource for managing dependency
        packages. You can migrate smoothly because the parameter behavior of the two resources is consistent.

        ## Example Usage

        ### Create a custom dependency version using an OBS bucket path where the ZIP file is located

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        dependency_name = config.require_object("dependencyName")
        custom_dependency_location = config.require_object("customDependencyLocation")
        test = sbercloud.FgsDependencyVersion("test",
            name=dependency_name,
            runtime="Python3.6",
            link=custom_dependency_location)
        ```

        ## Import

        Dependency version can be imported using the resource `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/fgsDependencyVersion:FgsDependencyVersion test <id>
        ```

        Or using related dependency package `name` and the `version` number, separated by a slash (/), e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/fgsDependencyVersion:FgsDependencyVersion test <name>/<version>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `link`.

        It is generally recommended running `pulumi preview` after importing a dependency package.

        You can then decide if changes should be applied to the resource, or the resource definition should be updated to

        align with the dependency package. Also you can ignore changes as below.

        hcl

        resource "sbercloud_fgs_dependency_version" "test" {

          ...

          lifecycle {

            ignore_changes = [
            
              link,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param FgsDependencyVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FgsDependencyVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 link: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FgsDependencyVersionArgs.__new__(FgsDependencyVersionArgs)

            __props__.__dict__["description"] = description
            if link is None and not opts.urn:
                raise TypeError("Missing required property 'link'")
            __props__.__dict__["link"] = link
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["dependency_id"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["version"] = None
            __props__.__dict__["version_id"] = None
        super(FgsDependencyVersion, __self__).__init__(
            'sbercloud:index/fgsDependencyVersion:FgsDependencyVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dependency_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            link: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            runtime: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None,
            version_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'FgsDependencyVersion':
        """
        Get an existing FgsDependencyVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dependency_id: The ID of the dependency package corresponding to the version.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the custom dependency version.  
               The description can contain a maximum of `512` characters.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] etag: The unique ID of the dependency.
        :param pulumi.Input[_builtins.str] link: The OBS bucket path where the dependency package is located.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the custom dependency package to which the version
               belongs.
               The name can contain a maximum of `96` characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] owner: The dependency owner, **public** indicates a public dependency.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the custom dependency version is located.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] runtime: Specifies the runtime of the custom dependency version.
               The valid values are as follows:
               + **Java8**
               + **Java11**
               + **Node.js6.10**
               + **Node.js8.10**
               + **Node.js10.16**
               + **Node.js12.13**
               + **Node.js14.18**
               + **Python2.7**
               + **Python3.6**
               + **Python3.9**
               + **Go1.8**
               + **Go1.x**
               + **C#(.NET Core 2.0)**
               + **C#(.NET Core 2.1)**
               + **C#(.NET Core 3.1)**
               + **Custom**
               + **PHP 7.3**
               + **http**
               
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] size: The dependency size, in bytes.
        :param pulumi.Input[_builtins.int] version: The dependency package version.
        :param pulumi.Input[_builtins.str] version_id: The ID of the dependency package version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FgsDependencyVersionState.__new__(_FgsDependencyVersionState)

        __props__.__dict__["dependency_id"] = dependency_id
        __props__.__dict__["description"] = description
        __props__.__dict__["etag"] = etag
        __props__.__dict__["link"] = link
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["region"] = region
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["size"] = size
        __props__.__dict__["version"] = version
        __props__.__dict__["version_id"] = version_id
        return FgsDependencyVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dependencyId")
    def dependency_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dependency package corresponding to the version.
        """
        return pulumi.get(self, "dependency_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the description of the custom dependency version.  
        The description can contain a maximum of `512` characters.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        The unique ID of the dependency.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def link(self) -> pulumi.Output[_builtins.str]:
        """
        The OBS bucket path where the dependency package is located.
        """
        return pulumi.get(self, "link")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the custom dependency package to which the version
        belongs.
        The name can contain a maximum of `96` characters and must start with a letter and end with a letter or digit.
        Only letters, digits, underscores (_), periods (.), and hyphens (-) are allowed.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        The dependency owner, **public** indicates a public dependency.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region where the custom dependency version is located.  
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the runtime of the custom dependency version.
        The valid values are as follows:
        + **Java8**
        + **Java11**
        + **Node.js6.10**
        + **Node.js8.10**
        + **Node.js10.16**
        + **Node.js12.13**
        + **Node.js14.18**
        + **Python2.7**
        + **Python3.6**
        + **Python3.9**
        + **Go1.8**
        + **Go1.x**
        + **C#(.NET Core 2.0)**
        + **C#(.NET Core 2.1)**
        + **C#(.NET Core 3.1)**
        + **Custom**
        + **PHP 7.3**
        + **http**

        Changing this will create a new resource.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        The dependency size, in bytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The dependency package version.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dependency package version.
        """
        return pulumi.get(self, "version_id")

