# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FgsFunctionEventArgs', 'FgsFunctionEvent']

@pulumi.input_type
class FgsFunctionEventArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[_builtins.str],
                 function_urn: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FgsFunctionEvent resource.
        :param pulumi.Input[_builtins.str] content: Specifies the function event content.  
               The value is the base64 encoding of the JSON string.
        :param pulumi.Input[_builtins.str] function_urn: Specifies the URN of the function to which the event blongs.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the function event name.  
               The name can contain a maximum of `25` characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_) and hyphens (-) are allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the function event is located.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "function_urn", function_urn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the function event content.  
        The value is the base64 encoding of the JSON string.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the URN of the function to which the event blongs.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_urn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the function event name.  
        The name can contain a maximum of `25` characters and must start with a letter and end with a letter or digit.
        Only letters, digits, underscores (_) and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the function event is located.  
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _FgsFunctionEventState:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FgsFunctionEvent resources.
        :param pulumi.Input[_builtins.str] content: Specifies the function event content.  
               The value is the base64 encoding of the JSON string.
        :param pulumi.Input[_builtins.str] function_urn: Specifies the URN of the function to which the event blongs.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the function event name.  
               The name can contain a maximum of `25` characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_) and hyphens (-) are allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the function event is located.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] updated_at: The latest update (UTC) time of the function event, in RFC3339 format.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if function_urn is not None:
            pulumi.set(__self__, "function_urn", function_urn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the function event content.  
        The value is the base64 encoding of the JSON string.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the URN of the function to which the event blongs.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_urn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the function event name.  
        The name can contain a maximum of `25` characters and must start with a letter and end with a letter or digit.
        Only letters, digits, underscores (_) and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the function event is located.  
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update (UTC) time of the function event, in RFC3339 format.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:index/fgsFunctionEvent:FgsFunctionEvent")
class FgsFunctionEvent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an event for testing specified function within SberCloud.

        ## Example Usage

        ## Import

        Function event can be imported using the `function_urn` and `name`, separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/fgsFunctionEvent:FgsFunctionEvent test <function_urn>/<name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content: Specifies the function event content.  
               The value is the base64 encoding of the JSON string.
        :param pulumi.Input[_builtins.str] function_urn: Specifies the URN of the function to which the event blongs.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the function event name.  
               The name can contain a maximum of `25` characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_) and hyphens (-) are allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the function event is located.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FgsFunctionEventArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an event for testing specified function within SberCloud.

        ## Example Usage

        ## Import

        Function event can be imported using the `function_urn` and `name`, separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/fgsFunctionEvent:FgsFunctionEvent test <function_urn>/<name>
        ```

        :param str resource_name: The name of the resource.
        :param FgsFunctionEventArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FgsFunctionEventArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FgsFunctionEventArgs.__new__(FgsFunctionEventArgs)

            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            if function_urn is None and not opts.urn:
                raise TypeError("Missing required property 'function_urn'")
            __props__.__dict__["function_urn"] = function_urn
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["updated_at"] = None
        super(FgsFunctionEvent, __self__).__init__(
            'sbercloud:index/fgsFunctionEvent:FgsFunctionEvent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            function_urn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'FgsFunctionEvent':
        """
        Get an existing FgsFunctionEvent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content: Specifies the function event content.  
               The value is the base64 encoding of the JSON string.
        :param pulumi.Input[_builtins.str] function_urn: Specifies the URN of the function to which the event blongs.  
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the function event name.  
               The name can contain a maximum of `25` characters and must start with a letter and end with a letter or digit.
               Only letters, digits, underscores (_) and hyphens (-) are allowed.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the function event is located.  
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] updated_at: The latest update (UTC) time of the function event, in RFC3339 format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FgsFunctionEventState.__new__(_FgsFunctionEventState)

        __props__.__dict__["content"] = content
        __props__.__dict__["function_urn"] = function_urn
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["updated_at"] = updated_at
        return FgsFunctionEvent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the function event content.  
        The value is the base64 encoding of the JSON string.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the URN of the function to which the event blongs.  
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "function_urn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the function event name.  
        The name can contain a maximum of `25` characters and must start with a letter and end with a letter or digit.
        Only letters, digits, underscores (_) and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region where the function event is located.  
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update (UTC) time of the function event, in RFC3339 format.
        """
        return pulumi.get(self, "updated_at")

