# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FgsFunctionTriggerArgs', 'FgsFunctionTrigger']

@pulumi.input_type
class FgsFunctionTriggerArgs:
    def __init__(__self__, *,
                 event_data: pulumi.Input[_builtins.str],
                 function_urn: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FgsFunctionTrigger resource.
        :param pulumi.Input[_builtins.str] event_data: Specifies the detailed configuration of the function trigger event, in JSON
               format.
               For various types of trigger parameter configurations, please refer to the
               [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#functiongraph_06_0122__request_TriggerEventDataRequestBody).
               
               > Please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0124.html#functiongraph_06_0124__request_UpdateriggerEventData)
               for updateable fields.
        :param pulumi.Input[_builtins.str] function_urn: Specifies the function URN to which the function trigger belongs.  
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] type: Specifies the type of the function trigger.  
               The valid values are **TIMER**, **APIG**, **CTS**, **DDS**, **DEDICATEDGATEWAY**, etc.
               Changing this will create a new resource.
               
               > For more available values, please refer to the [documentation table 3](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#section2).
        :param pulumi.Input[_builtins.str] region: Specifies the region where the function trigger is located.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] status: Specifies the status of the function trigger.  
               The valid values are **ACTIVE** and **DISABLED**.
               About `DDS` and `Kafka` triggers, the default value is **DISABLED**, for the other triggers, the default value is
               **ACTIVE**.
               
               > Currently, only some triggers support setting the **DISABLED** value, such as `TIMER`, `DDS`, `DMS`, `KAFKA` and
               `LTS`. For more details, please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html).
        """
        pulumi.set(__self__, "event_data", event_data)
        pulumi.set(__self__, "function_urn", function_urn)
        pulumi.set(__self__, "type", type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="eventData")
    def event_data(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the detailed configuration of the function trigger event, in JSON
        format.
        For various types of trigger parameter configurations, please refer to the
        [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#functiongraph_06_0122__request_TriggerEventDataRequestBody).

        > Please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0124.html#functiongraph_06_0124__request_UpdateriggerEventData)
        for updateable fields.
        """
        return pulumi.get(self, "event_data")

    @event_data.setter
    def event_data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "event_data", value)

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the function URN to which the function trigger belongs.  
        Changing this will create a new resource.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_urn", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of the function trigger.  
        The valid values are **TIMER**, **APIG**, **CTS**, **DDS**, **DEDICATEDGATEWAY**, etc.
        Changing this will create a new resource.

        > For more available values, please refer to the [documentation table 3](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#section2).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the function trigger is located.  
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the status of the function trigger.  
        The valid values are **ACTIVE** and **DISABLED**.
        About `DDS` and `Kafka` triggers, the default value is **DISABLED**, for the other triggers, the default value is
        **ACTIVE**.

        > Currently, only some triggers support setting the **DISABLED** value, such as `TIMER`, `DDS`, `DMS`, `KAFKA` and
        `LTS`. For more details, please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _FgsFunctionTriggerState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 event_data: Optional[pulumi.Input[_builtins.str]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FgsFunctionTrigger resources.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the function trigger.
        :param pulumi.Input[_builtins.str] event_data: Specifies the detailed configuration of the function trigger event, in JSON
               format.
               For various types of trigger parameter configurations, please refer to the
               [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#functiongraph_06_0122__request_TriggerEventDataRequestBody).
               
               > Please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0124.html#functiongraph_06_0124__request_UpdateriggerEventData)
               for updateable fields.
        :param pulumi.Input[_builtins.str] function_urn: Specifies the function URN to which the function trigger belongs.  
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the function trigger is located.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] status: Specifies the status of the function trigger.  
               The valid values are **ACTIVE** and **DISABLED**.
               About `DDS` and `Kafka` triggers, the default value is **DISABLED**, for the other triggers, the default value is
               **ACTIVE**.
               
               > Currently, only some triggers support setting the **DISABLED** value, such as `TIMER`, `DDS`, `DMS`, `KAFKA` and
               `LTS`. For more details, please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html).
        :param pulumi.Input[_builtins.str] type: Specifies the type of the function trigger.  
               The valid values are **TIMER**, **APIG**, **CTS**, **DDS**, **DEDICATEDGATEWAY**, etc.
               Changing this will create a new resource.
               
               > For more available values, please refer to the [documentation table 3](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#section2).
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the function trigger.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if event_data is not None:
            pulumi.set(__self__, "event_data", event_data)
        if function_urn is not None:
            pulumi.set(__self__, "function_urn", function_urn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the function trigger.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="eventData")
    def event_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the detailed configuration of the function trigger event, in JSON
        format.
        For various types of trigger parameter configurations, please refer to the
        [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#functiongraph_06_0122__request_TriggerEventDataRequestBody).

        > Please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0124.html#functiongraph_06_0124__request_UpdateriggerEventData)
        for updateable fields.
        """
        return pulumi.get(self, "event_data")

    @event_data.setter
    def event_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_data", value)

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the function URN to which the function trigger belongs.  
        Changing this will create a new resource.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_urn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the function trigger is located.  
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the status of the function trigger.  
        The valid values are **ACTIVE** and **DISABLED**.
        About `DDS` and `Kafka` triggers, the default value is **DISABLED**, for the other triggers, the default value is
        **ACTIVE**.

        > Currently, only some triggers support setting the **DISABLED** value, such as `TIMER`, `DDS`, `DMS`, `KAFKA` and
        `LTS`. For more details, please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of the function trigger.  
        The valid values are **TIMER**, **APIG**, **CTS**, **DDS**, **DEDICATEDGATEWAY**, etc.
        Changing this will create a new resource.

        > For more available values, please refer to the [documentation table 3](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#section2).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update time of the function trigger.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:index/fgsFunctionTrigger:FgsFunctionTrigger")
class FgsFunctionTrigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_data: Optional[pulumi.Input[_builtins.str]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the function trigger resource within SberCloud.

        ## Example Usage

        ## Import

        Function trigger can be imported using the `function_urn`, `type` and `id`, separated by the slashes (/), e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/fgsFunctionTrigger:FgsFunctionTrigger test <function_urn>/<type>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] event_data: Specifies the detailed configuration of the function trigger event, in JSON
               format.
               For various types of trigger parameter configurations, please refer to the
               [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#functiongraph_06_0122__request_TriggerEventDataRequestBody).
               
               > Please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0124.html#functiongraph_06_0124__request_UpdateriggerEventData)
               for updateable fields.
        :param pulumi.Input[_builtins.str] function_urn: Specifies the function URN to which the function trigger belongs.  
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the function trigger is located.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] status: Specifies the status of the function trigger.  
               The valid values are **ACTIVE** and **DISABLED**.
               About `DDS` and `Kafka` triggers, the default value is **DISABLED**, for the other triggers, the default value is
               **ACTIVE**.
               
               > Currently, only some triggers support setting the **DISABLED** value, such as `TIMER`, `DDS`, `DMS`, `KAFKA` and
               `LTS`. For more details, please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html).
        :param pulumi.Input[_builtins.str] type: Specifies the type of the function trigger.  
               The valid values are **TIMER**, **APIG**, **CTS**, **DDS**, **DEDICATEDGATEWAY**, etc.
               Changing this will create a new resource.
               
               > For more available values, please refer to the [documentation table 3](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#section2).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FgsFunctionTriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the function trigger resource within SberCloud.

        ## Example Usage

        ## Import

        Function trigger can be imported using the `function_urn`, `type` and `id`, separated by the slashes (/), e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/fgsFunctionTrigger:FgsFunctionTrigger test <function_urn>/<type>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param FgsFunctionTriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FgsFunctionTriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_data: Optional[pulumi.Input[_builtins.str]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FgsFunctionTriggerArgs.__new__(FgsFunctionTriggerArgs)

            if event_data is None and not opts.urn:
                raise TypeError("Missing required property 'event_data'")
            __props__.__dict__["event_data"] = event_data
            if function_urn is None and not opts.urn:
                raise TypeError("Missing required property 'function_urn'")
            __props__.__dict__["function_urn"] = function_urn
            __props__.__dict__["region"] = region
            __props__.__dict__["status"] = status
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(FgsFunctionTrigger, __self__).__init__(
            'sbercloud:index/fgsFunctionTrigger:FgsFunctionTrigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            event_data: Optional[pulumi.Input[_builtins.str]] = None,
            function_urn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'FgsFunctionTrigger':
        """
        Get an existing FgsFunctionTrigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the function trigger.
        :param pulumi.Input[_builtins.str] event_data: Specifies the detailed configuration of the function trigger event, in JSON
               format.
               For various types of trigger parameter configurations, please refer to the
               [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#functiongraph_06_0122__request_TriggerEventDataRequestBody).
               
               > Please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0124.html#functiongraph_06_0124__request_UpdateriggerEventData)
               for updateable fields.
        :param pulumi.Input[_builtins.str] function_urn: Specifies the function URN to which the function trigger belongs.  
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the function trigger is located.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] status: Specifies the status of the function trigger.  
               The valid values are **ACTIVE** and **DISABLED**.
               About `DDS` and `Kafka` triggers, the default value is **DISABLED**, for the other triggers, the default value is
               **ACTIVE**.
               
               > Currently, only some triggers support setting the **DISABLED** value, such as `TIMER`, `DDS`, `DMS`, `KAFKA` and
               `LTS`. For more details, please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html).
        :param pulumi.Input[_builtins.str] type: Specifies the type of the function trigger.  
               The valid values are **TIMER**, **APIG**, **CTS**, **DDS**, **DEDICATEDGATEWAY**, etc.
               Changing this will create a new resource.
               
               > For more available values, please refer to the [documentation table 3](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#section2).
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the function trigger.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FgsFunctionTriggerState.__new__(_FgsFunctionTriggerState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["event_data"] = event_data
        __props__.__dict__["function_urn"] = function_urn
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        return FgsFunctionTrigger(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the function trigger.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="eventData")
    def event_data(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the detailed configuration of the function trigger event, in JSON
        format.
        For various types of trigger parameter configurations, please refer to the
        [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#functiongraph_06_0122__request_TriggerEventDataRequestBody).

        > Please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0124.html#functiongraph_06_0124__request_UpdateriggerEventData)
        for updateable fields.
        """
        return pulumi.get(self, "event_data")

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the function URN to which the function trigger belongs.  
        Changing this will create a new resource.
        """
        return pulumi.get(self, "function_urn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region where the function trigger is located.  
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the status of the function trigger.  
        The valid values are **ACTIVE** and **DISABLED**.
        About `DDS` and `Kafka` triggers, the default value is **DISABLED**, for the other triggers, the default value is
        **ACTIVE**.

        > Currently, only some triggers support setting the **DISABLED** value, such as `TIMER`, `DDS`, `DMS`, `KAFKA` and
        `LTS`. For more details, please refer to the [documentation](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of the function trigger.  
        The valid values are **TIMER**, **APIG**, **CTS**, **DDS**, **DEDICATEDGATEWAY**, etc.
        Changing this will create a new resource.

        > For more available values, please refer to the [documentation table 3](https://support.sbercloud.com/intl/en-us/api-functiongraph/functiongraph_06_0122.html#section2).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update time of the function trigger.
        """
        return pulumi.get(self, "updated_at")

