# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FgsFunctionTriggerStatusActionArgs', 'FgsFunctionTriggerStatusAction']

@pulumi.input_type
class FgsFunctionTriggerStatusActionArgs:
    def __init__(__self__, *,
                 event_data: pulumi.Input[_builtins.str],
                 function_urn: pulumi.Input[_builtins.str],
                 trigger_id: pulumi.Input[_builtins.str],
                 trigger_status: pulumi.Input[_builtins.str],
                 trigger_type_code: pulumi.Input[_builtins.str],
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FgsFunctionTriggerStatusAction resource.
        :param pulumi.Input[_builtins.str] event_data: The event data of the trigger.
        :param pulumi.Input[_builtins.str] function_urn: The URN of the function.
        :param pulumi.Input[_builtins.str] trigger_id: The trigger ID.
        :param pulumi.Input[_builtins.str] trigger_status: The status of the trigger. Valid values are ACTIVE and DISABLED.
        :param pulumi.Input[_builtins.str] trigger_type_code: The trigger type code.
        :param pulumi.Input[_builtins.str] region: The region where the function trigger is located.
        """
        pulumi.set(__self__, "event_data", event_data)
        pulumi.set(__self__, "function_urn", function_urn)
        pulumi.set(__self__, "trigger_id", trigger_id)
        pulumi.set(__self__, "trigger_status", trigger_status)
        pulumi.set(__self__, "trigger_type_code", trigger_type_code)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="eventData")
    def event_data(self) -> pulumi.Input[_builtins.str]:
        """
        The event data of the trigger.
        """
        return pulumi.get(self, "event_data")

    @event_data.setter
    def event_data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "event_data", value)

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Input[_builtins.str]:
        """
        The URN of the function.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_urn", value)

    @_builtins.property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> pulumi.Input[_builtins.str]:
        """
        The trigger ID.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trigger_id", value)

    @_builtins.property
    @pulumi.getter(name="triggerStatus")
    def trigger_status(self) -> pulumi.Input[_builtins.str]:
        """
        The status of the trigger. Valid values are ACTIVE and DISABLED.
        """
        return pulumi.get(self, "trigger_status")

    @trigger_status.setter
    def trigger_status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trigger_status", value)

    @_builtins.property
    @pulumi.getter(name="triggerTypeCode")
    def trigger_type_code(self) -> pulumi.Input[_builtins.str]:
        """
        The trigger type code.
        """
        return pulumi.get(self, "trigger_type_code")

    @trigger_type_code.setter
    def trigger_type_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trigger_type_code", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the function trigger is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _FgsFunctionTriggerStatusActionState:
    def __init__(__self__, *,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 event_data: Optional[pulumi.Input[_builtins.str]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_id: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_status: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_type_code: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FgsFunctionTriggerStatusAction resources.
        :param pulumi.Input[_builtins.str] event_data: The event data of the trigger.
        :param pulumi.Input[_builtins.str] function_urn: The URN of the function.
        :param pulumi.Input[_builtins.str] region: The region where the function trigger is located.
        :param pulumi.Input[_builtins.str] trigger_id: The trigger ID.
        :param pulumi.Input[_builtins.str] trigger_status: The status of the trigger. Valid values are ACTIVE and DISABLED.
        :param pulumi.Input[_builtins.str] trigger_type_code: The trigger type code.
        """
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if event_data is not None:
            pulumi.set(__self__, "event_data", event_data)
        if function_urn is not None:
            pulumi.set(__self__, "function_urn", function_urn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)
        if trigger_status is not None:
            pulumi.set(__self__, "trigger_status", trigger_status)
        if trigger_type_code is not None:
            pulumi.set(__self__, "trigger_type_code", trigger_type_code)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter(name="eventData")
    def event_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The event data of the trigger.
        """
        return pulumi.get(self, "event_data")

    @event_data.setter
    def event_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_data", value)

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URN of the function.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_urn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the function trigger is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The trigger ID.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_id", value)

    @_builtins.property
    @pulumi.getter(name="triggerStatus")
    def trigger_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the trigger. Valid values are ACTIVE and DISABLED.
        """
        return pulumi.get(self, "trigger_status")

    @trigger_status.setter
    def trigger_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_status", value)

    @_builtins.property
    @pulumi.getter(name="triggerTypeCode")
    def trigger_type_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The trigger type code.
        """
        return pulumi.get(self, "trigger_type_code")

    @trigger_type_code.setter
    def trigger_type_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_type_code", value)


@pulumi.type_token("sbercloud:index/fgsFunctionTriggerStatusAction:FgsFunctionTriggerStatusAction")
class FgsFunctionTriggerStatusAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 event_data: Optional[pulumi.Input[_builtins.str]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_id: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_status: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_type_code: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a FgsFunctionTriggerStatusAction resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] event_data: The event data of the trigger.
        :param pulumi.Input[_builtins.str] function_urn: The URN of the function.
        :param pulumi.Input[_builtins.str] region: The region where the function trigger is located.
        :param pulumi.Input[_builtins.str] trigger_id: The trigger ID.
        :param pulumi.Input[_builtins.str] trigger_status: The status of the trigger. Valid values are ACTIVE and DISABLED.
        :param pulumi.Input[_builtins.str] trigger_type_code: The trigger type code.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FgsFunctionTriggerStatusActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a FgsFunctionTriggerStatusAction resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param FgsFunctionTriggerStatusActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FgsFunctionTriggerStatusActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 event_data: Optional[pulumi.Input[_builtins.str]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_id: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_status: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_type_code: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FgsFunctionTriggerStatusActionArgs.__new__(FgsFunctionTriggerStatusActionArgs)

            __props__.__dict__["enable_force_new"] = enable_force_new
            if event_data is None and not opts.urn:
                raise TypeError("Missing required property 'event_data'")
            __props__.__dict__["event_data"] = event_data
            if function_urn is None and not opts.urn:
                raise TypeError("Missing required property 'function_urn'")
            __props__.__dict__["function_urn"] = function_urn
            __props__.__dict__["region"] = region
            if trigger_id is None and not opts.urn:
                raise TypeError("Missing required property 'trigger_id'")
            __props__.__dict__["trigger_id"] = trigger_id
            if trigger_status is None and not opts.urn:
                raise TypeError("Missing required property 'trigger_status'")
            __props__.__dict__["trigger_status"] = trigger_status
            if trigger_type_code is None and not opts.urn:
                raise TypeError("Missing required property 'trigger_type_code'")
            __props__.__dict__["trigger_type_code"] = trigger_type_code
        super(FgsFunctionTriggerStatusAction, __self__).__init__(
            'sbercloud:index/fgsFunctionTriggerStatusAction:FgsFunctionTriggerStatusAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
            event_data: Optional[pulumi.Input[_builtins.str]] = None,
            function_urn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            trigger_id: Optional[pulumi.Input[_builtins.str]] = None,
            trigger_status: Optional[pulumi.Input[_builtins.str]] = None,
            trigger_type_code: Optional[pulumi.Input[_builtins.str]] = None) -> 'FgsFunctionTriggerStatusAction':
        """
        Get an existing FgsFunctionTriggerStatusAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] event_data: The event data of the trigger.
        :param pulumi.Input[_builtins.str] function_urn: The URN of the function.
        :param pulumi.Input[_builtins.str] region: The region where the function trigger is located.
        :param pulumi.Input[_builtins.str] trigger_id: The trigger ID.
        :param pulumi.Input[_builtins.str] trigger_status: The status of the trigger. Valid values are ACTIVE and DISABLED.
        :param pulumi.Input[_builtins.str] trigger_type_code: The trigger type code.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FgsFunctionTriggerStatusActionState.__new__(_FgsFunctionTriggerStatusActionState)

        __props__.__dict__["enable_force_new"] = enable_force_new
        __props__.__dict__["event_data"] = event_data
        __props__.__dict__["function_urn"] = function_urn
        __props__.__dict__["region"] = region
        __props__.__dict__["trigger_id"] = trigger_id
        __props__.__dict__["trigger_status"] = trigger_status
        __props__.__dict__["trigger_type_code"] = trigger_type_code
        return FgsFunctionTriggerStatusAction(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @_builtins.property
    @pulumi.getter(name="eventData")
    def event_data(self) -> pulumi.Output[_builtins.str]:
        """
        The event data of the trigger.
        """
        return pulumi.get(self, "event_data")

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Output[_builtins.str]:
        """
        The URN of the function.
        """
        return pulumi.get(self, "function_urn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the function trigger is located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> pulumi.Output[_builtins.str]:
        """
        The trigger ID.
        """
        return pulumi.get(self, "trigger_id")

    @_builtins.property
    @pulumi.getter(name="triggerStatus")
    def trigger_status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the trigger. Valid values are ACTIVE and DISABLED.
        """
        return pulumi.get(self, "trigger_status")

    @_builtins.property
    @pulumi.getter(name="triggerTypeCode")
    def trigger_type_code(self) -> pulumi.Output[_builtins.str]:
        """
        The trigger type code.
        """
        return pulumi.get(self, "trigger_type_code")

