# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FgsLtsLogEnableArgs', 'FgsLtsLogEnable']

@pulumi.input_type
class FgsLtsLogEnableArgs:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FgsLtsLogEnable resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the LTS log function is to be enabled.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the LTS log function is to be enabled.  
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _FgsLtsLogEnableState:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FgsLtsLogEnable resources.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the LTS log function is to be enabled.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region where the LTS log function is to be enabled.  
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:index/fgsLtsLogEnable:FgsLtsLogEnable")
class FgsLtsLogEnable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Use this resource to enable LTS logs for FunctionGraph within SberCloud.

        > This resource is only a one-time action resource for enabling LTS logs for FunctionGraph. Deleting this resource will
           not disable the LTS logs, but will only remove the resource information from the tfstate file.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.FgsLtsLogEnable("test")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the LTS log function is to be enabled.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FgsLtsLogEnableArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to enable LTS logs for FunctionGraph within SberCloud.

        > This resource is only a one-time action resource for enabling LTS logs for FunctionGraph. Deleting this resource will
           not disable the LTS logs, but will only remove the resource information from the tfstate file.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.FgsLtsLogEnable("test")
        ```

        :param str resource_name: The name of the resource.
        :param FgsLtsLogEnableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FgsLtsLogEnableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FgsLtsLogEnableArgs.__new__(FgsLtsLogEnableArgs)

            __props__.__dict__["region"] = region
        super(FgsLtsLogEnable, __self__).__init__(
            'sbercloud:index/fgsLtsLogEnable:FgsLtsLogEnable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'FgsLtsLogEnable':
        """
        Get an existing FgsLtsLogEnable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region where the LTS log function is to be enabled.  
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FgsLtsLogEnableState.__new__(_FgsLtsLogEnableState)

        __props__.__dict__["region"] = region
        return FgsLtsLogEnable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region where the LTS log function is to be enabled.  
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

