# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 memory_size: pulumi.Input[_builtins.int],
                 runtime: pulumi.Input[_builtins.str],
                 timeout: pulumi.Input[_builtins.int],
                 agency: Optional[pulumi.Input[_builtins.str]] = None,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 app_agency: Optional[pulumi.Input[_builtins.str]] = None,
                 code_encrypt_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 code_filename: Optional[pulumi.Input[_builtins.str]] = None,
                 code_type: Optional[pulumi.Input[_builtins.str]] = None,
                 code_url: Optional[pulumi.Input[_builtins.str]] = None,
                 concurrency_num: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_image: Optional[pulumi.Input['FunctionCustomImageArgs']] = None,
                 depend_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_list: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_auth_in_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_class_isolation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dynamic_memory: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_lts_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypted_user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 func_code: Optional[pulumi.Input[_builtins.str]] = None,
                 func_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]]] = None,
                 functiongraph_version: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_memory: Optional[pulumi.Input[_builtins.int]] = None,
                 gpu_type: Optional[pulumi.Input[_builtins.str]] = None,
                 handler: Optional[pulumi.Input[_builtins.str]] = None,
                 heartbeat_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 initializer_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 initializer_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 is_stateful_function: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_custom_tag: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_instance_num: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_user_group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 mount_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_controller: Optional[pulumi.Input['FunctionNetworkControllerArgs']] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 package: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_stop_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_stop_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_instances: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionReservedInstanceArgs']]]] = None,
                 restore_hook_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_hook_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_encrypt_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionVersionArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 xrole: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[_builtins.int] memory_size: Specifies the memory size(MB) allocated to the function.
        :param pulumi.Input[_builtins.str] runtime: Specifies the environment for executing the function.
        :param pulumi.Input[_builtins.int] timeout: Specifies the timeout interval of the function, ranges from 3s to 900s.
        :param pulumi.Input[_builtins.str] agency: Specifies the agency. This parameter is mandatory if the function needs to access other cloud services.
        :param pulumi.Input[_builtins.str] app: Specifies the group to which the function belongs.
        :param pulumi.Input[_builtins.str] app_agency: Specifies An execution agency enables you to obtain a token or an AK/SK for accessing other cloud services.
        :param pulumi.Input[_builtins.str] code_encrypt_kms_key_id: The KMS key ID for encrypting the function code.
        :param pulumi.Input[_builtins.str] code_filename: Specifies the name of a function file, This field is mandatory only when coe_type is
               set to jar or zip.
        :param pulumi.Input[_builtins.str] code_type: Specifies the function code type, which can be inline: inline code, zip: ZIP file,
               jar: JAR file or java functions, obs: function code stored in an OBS bucket.
        :param pulumi.Input[_builtins.str] code_url: Specifies the code url. This parameter is mandatory when code_type is set to obs.
        :param pulumi.Input[_builtins.int] concurrency_num: The number of concurrent requests of the function.
        :param pulumi.Input['FunctionCustomImageArgs'] custom_image: The custom image configuration of the function.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] depend_lists: Specifies the dependencies of the function.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the function.
        :param pulumi.Input[_builtins.str] dns_list: The private DNS configuration of the function network.
        :param pulumi.Input[_builtins.bool] enable_auth_in_header: Whether the authentication in the request header is enabled.
        :param pulumi.Input[_builtins.bool] enable_class_isolation: Whether the class isolation is enabled for the JAVA runtime functions.
        :param pulumi.Input[_builtins.bool] enable_dynamic_memory: Whether the dynamic memory configuration is enabled.
        :param pulumi.Input[_builtins.bool] enable_lts_log: Whether to enable the LTS log.
        :param pulumi.Input[_builtins.str] encrypted_user_data: The key/value information defined to be encrypted for the function.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the function.
               Changing this creates a new function.
        :param pulumi.Input[_builtins.int] ephemeral_storage: The size of the function ephemeral storage.
        :param pulumi.Input[_builtins.str] func_code: Specifies the function code. When code_type is set to inline, zip, or jar, this parameter is mandatory,
               and the code can be encoded using Base64 or just with the text code.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]] func_mounts: Specifies the file system list. The `func_mounts` object structure is documented below.
        :param pulumi.Input[_builtins.str] functiongraph_version: The description of the function.
        :param pulumi.Input[_builtins.int] gpu_memory: The GPU memory size allocated to the function, in MByte (MB).
        :param pulumi.Input[_builtins.str] gpu_type: The GPU type of the function.
        :param pulumi.Input[_builtins.str] handler: Specifies the entry point of the function.
        :param pulumi.Input[_builtins.str] heartbeat_handler: The heartbeat handler of the function.
        :param pulumi.Input[_builtins.str] initializer_handler: Specifies the initializer of the function.
        :param pulumi.Input[_builtins.int] initializer_timeout: Specifies the maximum duration the function can be initialized. Value range: 1s to 300s.
        :param pulumi.Input[_builtins.bool] is_stateful_function: Whether the function is a stateful function.
        :param pulumi.Input[_builtins.str] log_group_id: The LTS group ID for collecting logs.
        :param pulumi.Input[_builtins.str] log_group_name: The LTS group name for collecting logs.
        :param pulumi.Input[_builtins.str] log_stream_id: The LTS stream ID for collecting logs.
        :param pulumi.Input[_builtins.str] log_stream_name: The LTS stream name for collecting logs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] lts_custom_tag: The custom tags configuration that used to filter the LTS logs.
        :param pulumi.Input[_builtins.str] max_instance_num: The maximum number of instances of the function.
        :param pulumi.Input[_builtins.int] mount_user_group_id: Specifies the user group ID, a non-0 integer from –1 to 65534. Default to -1.
        :param pulumi.Input[_builtins.int] mount_user_id: Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the function.
        :param pulumi.Input['FunctionNetworkControllerArgs'] network_controller: The network configuration of the function.
        :param pulumi.Input[_builtins.str] network_id: Specifies the ID of subnet.
        :param pulumi.Input[_builtins.str] peering_cidr: The VPC CIDR blocks used in the function code to detect whether it conflicts with the VPC
               CIDR blocks used by the service.
        :param pulumi.Input[_builtins.str] pre_stop_handler: The pre-stop handler of a function.
        :param pulumi.Input[_builtins.int] pre_stop_timeout: The maximum duration that the function can be initialized.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the Function resource.
               If omitted, the provider-level region will be used. Changing this creates a new Function resource.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionReservedInstanceArgs']]] reserved_instances: The reserved instance policies of the function.
        :param pulumi.Input[_builtins.str] restore_hook_handler: The restore hook handler of the function.
        :param pulumi.Input[_builtins.int] restore_hook_timeout: The timeout of the function restore hook.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the function.
        :param pulumi.Input[_builtins.str] user_data: The key/value information defined for the function.
        :param pulumi.Input[_builtins.str] user_data_encrypt_kms_key_id: The KMS key ID for encrypting the user data.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionVersionArgs']]] versions: The versions management of the function.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of VPC.
        """
        pulumi.set(__self__, "memory_size", memory_size)
        pulumi.set(__self__, "runtime", runtime)
        pulumi.set(__self__, "timeout", timeout)
        if agency is not None:
            pulumi.set(__self__, "agency", agency)
        if app is not None:
            pulumi.set(__self__, "app", app)
        if app_agency is not None:
            pulumi.set(__self__, "app_agency", app_agency)
        if code_encrypt_kms_key_id is not None:
            pulumi.set(__self__, "code_encrypt_kms_key_id", code_encrypt_kms_key_id)
        if code_filename is not None:
            pulumi.set(__self__, "code_filename", code_filename)
        if code_type is not None:
            pulumi.set(__self__, "code_type", code_type)
        if code_url is not None:
            pulumi.set(__self__, "code_url", code_url)
        if concurrency_num is not None:
            pulumi.set(__self__, "concurrency_num", concurrency_num)
        if custom_image is not None:
            pulumi.set(__self__, "custom_image", custom_image)
        if depend_lists is not None:
            pulumi.set(__self__, "depend_lists", depend_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_list is not None:
            pulumi.set(__self__, "dns_list", dns_list)
        if enable_auth_in_header is not None:
            pulumi.set(__self__, "enable_auth_in_header", enable_auth_in_header)
        if enable_class_isolation is not None:
            pulumi.set(__self__, "enable_class_isolation", enable_class_isolation)
        if enable_dynamic_memory is not None:
            pulumi.set(__self__, "enable_dynamic_memory", enable_dynamic_memory)
        if enable_lts_log is not None:
            pulumi.set(__self__, "enable_lts_log", enable_lts_log)
        if encrypted_user_data is not None:
            pulumi.set(__self__, "encrypted_user_data", encrypted_user_data)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if func_code is not None:
            pulumi.set(__self__, "func_code", func_code)
        if func_mounts is not None:
            pulumi.set(__self__, "func_mounts", func_mounts)
        if functiongraph_version is not None:
            pulumi.set(__self__, "functiongraph_version", functiongraph_version)
        if gpu_memory is not None:
            pulumi.set(__self__, "gpu_memory", gpu_memory)
        if gpu_type is not None:
            pulumi.set(__self__, "gpu_type", gpu_type)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if heartbeat_handler is not None:
            pulumi.set(__self__, "heartbeat_handler", heartbeat_handler)
        if initializer_handler is not None:
            pulumi.set(__self__, "initializer_handler", initializer_handler)
        if initializer_timeout is not None:
            pulumi.set(__self__, "initializer_timeout", initializer_timeout)
        if is_stateful_function is not None:
            pulumi.set(__self__, "is_stateful_function", is_stateful_function)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_stream_id is not None:
            pulumi.set(__self__, "log_stream_id", log_stream_id)
        if log_stream_name is not None:
            pulumi.set(__self__, "log_stream_name", log_stream_name)
        if lts_custom_tag is not None:
            pulumi.set(__self__, "lts_custom_tag", lts_custom_tag)
        if max_instance_num is not None:
            pulumi.set(__self__, "max_instance_num", max_instance_num)
        if mount_user_group_id is not None:
            pulumi.set(__self__, "mount_user_group_id", mount_user_group_id)
        if mount_user_id is not None:
            pulumi.set(__self__, "mount_user_id", mount_user_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_controller is not None:
            pulumi.set(__self__, "network_controller", network_controller)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if package is not None:
            warnings.warn("""use app instead""", DeprecationWarning)
            pulumi.log.warn("""package is deprecated: use app instead""")
        if package is not None:
            pulumi.set(__self__, "package", package)
        if peering_cidr is not None:
            pulumi.set(__self__, "peering_cidr", peering_cidr)
        if pre_stop_handler is not None:
            pulumi.set(__self__, "pre_stop_handler", pre_stop_handler)
        if pre_stop_timeout is not None:
            pulumi.set(__self__, "pre_stop_timeout", pre_stop_timeout)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_instances is not None:
            pulumi.set(__self__, "reserved_instances", reserved_instances)
        if restore_hook_handler is not None:
            pulumi.set(__self__, "restore_hook_handler", restore_hook_handler)
        if restore_hook_timeout is not None:
            pulumi.set(__self__, "restore_hook_timeout", restore_hook_timeout)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_data_encrypt_kms_key_id is not None:
            pulumi.set(__self__, "user_data_encrypt_kms_key_id", user_data_encrypt_kms_key_id)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if xrole is not None:
            warnings.warn("""use agency instead""", DeprecationWarning)
            pulumi.log.warn("""xrole is deprecated: use agency instead""")
        if xrole is not None:
            pulumi.set(__self__, "xrole", xrole)

    @_builtins.property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the memory size(MB) allocated to the function.
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "memory_size", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the environment for executing the function.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the timeout interval of the function, ranges from 3s to 900s.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def agency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the agency. This parameter is mandatory if the function needs to access other cloud services.
        """
        return pulumi.get(self, "agency")

    @agency.setter
    def agency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agency", value)

    @_builtins.property
    @pulumi.getter
    def app(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the group to which the function belongs.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app", value)

    @_builtins.property
    @pulumi.getter(name="appAgency")
    def app_agency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies An execution agency enables you to obtain a token or an AK/SK for accessing other cloud services.
        """
        return pulumi.get(self, "app_agency")

    @app_agency.setter
    def app_agency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_agency", value)

    @_builtins.property
    @pulumi.getter(name="codeEncryptKmsKeyId")
    def code_encrypt_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The KMS key ID for encrypting the function code.
        """
        return pulumi.get(self, "code_encrypt_kms_key_id")

    @code_encrypt_kms_key_id.setter
    def code_encrypt_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_encrypt_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="codeFilename")
    def code_filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of a function file, This field is mandatory only when coe_type is
        set to jar or zip.
        """
        return pulumi.get(self, "code_filename")

    @code_filename.setter
    def code_filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_filename", value)

    @_builtins.property
    @pulumi.getter(name="codeType")
    def code_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the function code type, which can be inline: inline code, zip: ZIP file,
        jar: JAR file or java functions, obs: function code stored in an OBS bucket.
        """
        return pulumi.get(self, "code_type")

    @code_type.setter
    def code_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_type", value)

    @_builtins.property
    @pulumi.getter(name="codeUrl")
    def code_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the code url. This parameter is mandatory when code_type is set to obs.
        """
        return pulumi.get(self, "code_url")

    @code_url.setter
    def code_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_url", value)

    @_builtins.property
    @pulumi.getter(name="concurrencyNum")
    def concurrency_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of concurrent requests of the function.
        """
        return pulumi.get(self, "concurrency_num")

    @concurrency_num.setter
    def concurrency_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "concurrency_num", value)

    @_builtins.property
    @pulumi.getter(name="customImage")
    def custom_image(self) -> Optional[pulumi.Input['FunctionCustomImageArgs']]:
        """
        The custom image configuration of the function.
        """
        return pulumi.get(self, "custom_image")

    @custom_image.setter
    def custom_image(self, value: Optional[pulumi.Input['FunctionCustomImageArgs']]):
        pulumi.set(self, "custom_image", value)

    @_builtins.property
    @pulumi.getter(name="dependLists")
    def depend_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the dependencies of the function.
        """
        return pulumi.get(self, "depend_lists")

    @depend_lists.setter
    def depend_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "depend_lists", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsList")
    def dns_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private DNS configuration of the function network.
        """
        return pulumi.get(self, "dns_list")

    @dns_list.setter
    def dns_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_list", value)

    @_builtins.property
    @pulumi.getter(name="enableAuthInHeader")
    def enable_auth_in_header(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the authentication in the request header is enabled.
        """
        return pulumi.get(self, "enable_auth_in_header")

    @enable_auth_in_header.setter
    def enable_auth_in_header(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_auth_in_header", value)

    @_builtins.property
    @pulumi.getter(name="enableClassIsolation")
    def enable_class_isolation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the class isolation is enabled for the JAVA runtime functions.
        """
        return pulumi.get(self, "enable_class_isolation")

    @enable_class_isolation.setter
    def enable_class_isolation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_class_isolation", value)

    @_builtins.property
    @pulumi.getter(name="enableDynamicMemory")
    def enable_dynamic_memory(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the dynamic memory configuration is enabled.
        """
        return pulumi.get(self, "enable_dynamic_memory")

    @enable_dynamic_memory.setter
    def enable_dynamic_memory(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dynamic_memory", value)

    @_builtins.property
    @pulumi.getter(name="enableLtsLog")
    def enable_lts_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the LTS log.
        """
        return pulumi.get(self, "enable_lts_log")

    @enable_lts_log.setter
    def enable_lts_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_lts_log", value)

    @_builtins.property
    @pulumi.getter(name="encryptedUserData")
    def encrypted_user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key/value information defined to be encrypted for the function.
        """
        return pulumi.get(self, "encrypted_user_data")

    @encrypted_user_data.setter
    def encrypted_user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypted_user_data", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the function.
        Changing this creates a new function.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the function ephemeral storage.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ephemeral_storage", value)

    @_builtins.property
    @pulumi.getter(name="funcCode")
    def func_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the function code. When code_type is set to inline, zip, or jar, this parameter is mandatory,
        and the code can be encoded using Base64 or just with the text code.
        """
        return pulumi.get(self, "func_code")

    @func_code.setter
    def func_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "func_code", value)

    @_builtins.property
    @pulumi.getter(name="funcMounts")
    def func_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]]]:
        """
        Specifies the file system list. The `func_mounts` object structure is documented below.
        """
        return pulumi.get(self, "func_mounts")

    @func_mounts.setter
    def func_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]]]):
        pulumi.set(self, "func_mounts", value)

    @_builtins.property
    @pulumi.getter(name="functiongraphVersion")
    def functiongraph_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the function.
        """
        return pulumi.get(self, "functiongraph_version")

    @functiongraph_version.setter
    def functiongraph_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "functiongraph_version", value)

    @_builtins.property
    @pulumi.getter(name="gpuMemory")
    def gpu_memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The GPU memory size allocated to the function, in MByte (MB).
        """
        return pulumi.get(self, "gpu_memory")

    @gpu_memory.setter
    def gpu_memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "gpu_memory", value)

    @_builtins.property
    @pulumi.getter(name="gpuType")
    def gpu_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GPU type of the function.
        """
        return pulumi.get(self, "gpu_type")

    @gpu_type.setter
    def gpu_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gpu_type", value)

    @_builtins.property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the entry point of the function.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "handler", value)

    @_builtins.property
    @pulumi.getter(name="heartbeatHandler")
    def heartbeat_handler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The heartbeat handler of the function.
        """
        return pulumi.get(self, "heartbeat_handler")

    @heartbeat_handler.setter
    def heartbeat_handler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "heartbeat_handler", value)

    @_builtins.property
    @pulumi.getter(name="initializerHandler")
    def initializer_handler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the initializer of the function.
        """
        return pulumi.get(self, "initializer_handler")

    @initializer_handler.setter
    def initializer_handler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "initializer_handler", value)

    @_builtins.property
    @pulumi.getter(name="initializerTimeout")
    def initializer_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum duration the function can be initialized. Value range: 1s to 300s.
        """
        return pulumi.get(self, "initializer_timeout")

    @initializer_timeout.setter
    def initializer_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initializer_timeout", value)

    @_builtins.property
    @pulumi.getter(name="isStatefulFunction")
    def is_stateful_function(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the function is a stateful function.
        """
        return pulumi.get(self, "is_stateful_function")

    @is_stateful_function.setter
    def is_stateful_function(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_stateful_function", value)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LTS group ID for collecting logs.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_group_id", value)

    @_builtins.property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LTS group name for collecting logs.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_group_name", value)

    @_builtins.property
    @pulumi.getter(name="logStreamId")
    def log_stream_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LTS stream ID for collecting logs.
        """
        return pulumi.get(self, "log_stream_id")

    @log_stream_id.setter
    def log_stream_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_stream_id", value)

    @_builtins.property
    @pulumi.getter(name="logStreamName")
    def log_stream_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LTS stream name for collecting logs.
        """
        return pulumi.get(self, "log_stream_name")

    @log_stream_name.setter
    def log_stream_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_stream_name", value)

    @_builtins.property
    @pulumi.getter(name="ltsCustomTag")
    def lts_custom_tag(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The custom tags configuration that used to filter the LTS logs.
        """
        return pulumi.get(self, "lts_custom_tag")

    @lts_custom_tag.setter
    def lts_custom_tag(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "lts_custom_tag", value)

    @_builtins.property
    @pulumi.getter(name="maxInstanceNum")
    def max_instance_num(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum number of instances of the function.
        """
        return pulumi.get(self, "max_instance_num")

    @max_instance_num.setter
    def max_instance_num(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_instance_num", value)

    @_builtins.property
    @pulumi.getter(name="mountUserGroupId")
    def mount_user_group_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the user group ID, a non-0 integer from –1 to 65534. Default to -1.
        """
        return pulumi.get(self, "mount_user_group_id")

    @mount_user_group_id.setter
    def mount_user_group_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mount_user_group_id", value)

    @_builtins.property
    @pulumi.getter(name="mountUserId")
    def mount_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        """
        return pulumi.get(self, "mount_user_id")

    @mount_user_id.setter
    def mount_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mount_user_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the function.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkController")
    def network_controller(self) -> Optional[pulumi.Input['FunctionNetworkControllerArgs']]:
        """
        The network configuration of the function.
        """
        return pulumi.get(self, "network_controller")

    @network_controller.setter
    def network_controller(self, value: Optional[pulumi.Input['FunctionNetworkControllerArgs']]):
        pulumi.set(self, "network_controller", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of subnet.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""use app instead""")
    def package(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package", value)

    @_builtins.property
    @pulumi.getter(name="peeringCidr")
    def peering_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC CIDR blocks used in the function code to detect whether it conflicts with the VPC
        CIDR blocks used by the service.
        """
        return pulumi.get(self, "peering_cidr")

    @peering_cidr.setter
    def peering_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peering_cidr", value)

    @_builtins.property
    @pulumi.getter(name="preStopHandler")
    def pre_stop_handler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pre-stop handler of a function.
        """
        return pulumi.get(self, "pre_stop_handler")

    @pre_stop_handler.setter
    def pre_stop_handler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_stop_handler", value)

    @_builtins.property
    @pulumi.getter(name="preStopTimeout")
    def pre_stop_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum duration that the function can be initialized.
        """
        return pulumi.get(self, "pre_stop_timeout")

    @pre_stop_timeout.setter
    def pre_stop_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "pre_stop_timeout", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the Function resource.
        If omitted, the provider-level region will be used. Changing this creates a new Function resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reservedInstances")
    def reserved_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionReservedInstanceArgs']]]]:
        """
        The reserved instance policies of the function.
        """
        return pulumi.get(self, "reserved_instances")

    @reserved_instances.setter
    def reserved_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionReservedInstanceArgs']]]]):
        pulumi.set(self, "reserved_instances", value)

    @_builtins.property
    @pulumi.getter(name="restoreHookHandler")
    def restore_hook_handler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The restore hook handler of the function.
        """
        return pulumi.get(self, "restore_hook_handler")

    @restore_hook_handler.setter
    def restore_hook_handler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_hook_handler", value)

    @_builtins.property
    @pulumi.getter(name="restoreHookTimeout")
    def restore_hook_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout of the function restore hook.
        """
        return pulumi.get(self, "restore_hook_timeout")

    @restore_hook_timeout.setter
    def restore_hook_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "restore_hook_timeout", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the function.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key/value information defined for the function.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="userDataEncryptKmsKeyId")
    def user_data_encrypt_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The KMS key ID for encrypting the user data.
        """
        return pulumi.get(self, "user_data_encrypt_kms_key_id")

    @user_data_encrypt_kms_key_id.setter
    def user_data_encrypt_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data_encrypt_kms_key_id", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionVersionArgs']]]]:
        """
        The versions management of the function.
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionVersionArgs']]]]):
        pulumi.set(self, "versions", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""use agency instead""")
    def xrole(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "xrole")

    @xrole.setter
    def xrole(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xrole", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 agency: Optional[pulumi.Input[_builtins.str]] = None,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 app_agency: Optional[pulumi.Input[_builtins.str]] = None,
                 code_encrypt_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 code_filename: Optional[pulumi.Input[_builtins.str]] = None,
                 code_type: Optional[pulumi.Input[_builtins.str]] = None,
                 code_url: Optional[pulumi.Input[_builtins.str]] = None,
                 concurrency_num: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_image: Optional[pulumi.Input['FunctionCustomImageArgs']] = None,
                 depend_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_list: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_auth_in_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_class_isolation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dynamic_memory: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_lts_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypted_user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 func_code: Optional[pulumi.Input[_builtins.str]] = None,
                 func_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]]] = None,
                 functiongraph_version: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_memory: Optional[pulumi.Input[_builtins.int]] = None,
                 gpu_type: Optional[pulumi.Input[_builtins.str]] = None,
                 handler: Optional[pulumi.Input[_builtins.str]] = None,
                 heartbeat_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 initializer_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 initializer_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 is_stateful_function: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_custom_tag: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lts_custom_tag_origin: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_instance_num: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size: Optional[pulumi.Input[_builtins.int]] = None,
                 mount_user_group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 mount_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_controller: Optional[pulumi.Input['FunctionNetworkControllerArgs']] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 package: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_stop_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_stop_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_instances: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionReservedInstanceArgs']]]] = None,
                 restore_hook_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_hook_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 urn: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_encrypt_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionVersionArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 xrole: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input[_builtins.str] agency: Specifies the agency. This parameter is mandatory if the function needs to access other cloud services.
        :param pulumi.Input[_builtins.str] app: Specifies the group to which the function belongs.
        :param pulumi.Input[_builtins.str] app_agency: Specifies An execution agency enables you to obtain a token or an AK/SK for accessing other cloud services.
        :param pulumi.Input[_builtins.str] code_encrypt_kms_key_id: The KMS key ID for encrypting the function code.
        :param pulumi.Input[_builtins.str] code_filename: Specifies the name of a function file, This field is mandatory only when coe_type is
               set to jar or zip.
        :param pulumi.Input[_builtins.str] code_type: Specifies the function code type, which can be inline: inline code, zip: ZIP file,
               jar: JAR file or java functions, obs: function code stored in an OBS bucket.
        :param pulumi.Input[_builtins.str] code_url: Specifies the code url. This parameter is mandatory when code_type is set to obs.
        :param pulumi.Input[_builtins.int] concurrency_num: The number of concurrent requests of the function.
        :param pulumi.Input['FunctionCustomImageArgs'] custom_image: The custom image configuration of the function.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] depend_lists: Specifies the dependencies of the function.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the function.
        :param pulumi.Input[_builtins.str] dns_list: The private DNS configuration of the function network.
        :param pulumi.Input[_builtins.bool] enable_auth_in_header: Whether the authentication in the request header is enabled.
        :param pulumi.Input[_builtins.bool] enable_class_isolation: Whether the class isolation is enabled for the JAVA runtime functions.
        :param pulumi.Input[_builtins.bool] enable_dynamic_memory: Whether the dynamic memory configuration is enabled.
        :param pulumi.Input[_builtins.bool] enable_lts_log: Whether to enable the LTS log.
        :param pulumi.Input[_builtins.str] encrypted_user_data: The key/value information defined to be encrypted for the function.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the function.
               Changing this creates a new function.
        :param pulumi.Input[_builtins.int] ephemeral_storage: The size of the function ephemeral storage.
        :param pulumi.Input[_builtins.str] func_code: Specifies the function code. When code_type is set to inline, zip, or jar, this parameter is mandatory,
               and the code can be encoded using Base64 or just with the text code.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]] func_mounts: Specifies the file system list. The `func_mounts` object structure is documented below.
        :param pulumi.Input[_builtins.str] functiongraph_version: The description of the function.
        :param pulumi.Input[_builtins.int] gpu_memory: The GPU memory size allocated to the function, in MByte (MB).
        :param pulumi.Input[_builtins.str] gpu_type: The GPU type of the function.
        :param pulumi.Input[_builtins.str] handler: Specifies the entry point of the function.
        :param pulumi.Input[_builtins.str] heartbeat_handler: The heartbeat handler of the function.
        :param pulumi.Input[_builtins.str] initializer_handler: Specifies the initializer of the function.
        :param pulumi.Input[_builtins.int] initializer_timeout: Specifies the maximum duration the function can be initialized. Value range: 1s to 300s.
        :param pulumi.Input[_builtins.bool] is_stateful_function: Whether the function is a stateful function.
        :param pulumi.Input[_builtins.str] log_group_id: The LTS group ID for collecting logs.
        :param pulumi.Input[_builtins.str] log_group_name: The LTS group name for collecting logs.
        :param pulumi.Input[_builtins.str] log_stream_id: The LTS stream ID for collecting logs.
        :param pulumi.Input[_builtins.str] log_stream_name: The LTS stream name for collecting logs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] lts_custom_tag: The custom tags configuration that used to filter the LTS logs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] lts_custom_tag_origin: The script configuration value of this change is also the original value used for comparison with
                the new value next time the change is made. The corresponding parameter name is 'lts_custom_tag'.
        :param pulumi.Input[_builtins.str] max_instance_num: The maximum number of instances of the function.
        :param pulumi.Input[_builtins.int] memory_size: Specifies the memory size(MB) allocated to the function.
        :param pulumi.Input[_builtins.int] mount_user_group_id: Specifies the user group ID, a non-0 integer from –1 to 65534. Default to -1.
        :param pulumi.Input[_builtins.int] mount_user_id: Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the function.
        :param pulumi.Input['FunctionNetworkControllerArgs'] network_controller: The network configuration of the function.
        :param pulumi.Input[_builtins.str] network_id: Specifies the ID of subnet.
        :param pulumi.Input[_builtins.str] peering_cidr: The VPC CIDR blocks used in the function code to detect whether it conflicts with the VPC
               CIDR blocks used by the service.
        :param pulumi.Input[_builtins.str] pre_stop_handler: The pre-stop handler of a function.
        :param pulumi.Input[_builtins.int] pre_stop_timeout: The maximum duration that the function can be initialized.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the Function resource.
               If omitted, the provider-level region will be used. Changing this creates a new Function resource.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionReservedInstanceArgs']]] reserved_instances: The reserved instance policies of the function.
        :param pulumi.Input[_builtins.str] restore_hook_handler: The restore hook handler of the function.
        :param pulumi.Input[_builtins.int] restore_hook_timeout: The timeout of the function restore hook.
        :param pulumi.Input[_builtins.str] runtime: Specifies the environment for executing the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the function.
        :param pulumi.Input[_builtins.int] timeout: Specifies the timeout interval of the function, ranges from 3s to 900s.
        :param pulumi.Input[_builtins.str] urn: Uniform Resource Name
        :param pulumi.Input[_builtins.str] user_data: The key/value information defined for the function.
        :param pulumi.Input[_builtins.str] user_data_encrypt_kms_key_id: The KMS key ID for encrypting the user data.
        :param pulumi.Input[_builtins.str] version: The version of the function
        :param pulumi.Input[Sequence[pulumi.Input['FunctionVersionArgs']]] versions: The versions management of the function.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of VPC.
        """
        if agency is not None:
            pulumi.set(__self__, "agency", agency)
        if app is not None:
            pulumi.set(__self__, "app", app)
        if app_agency is not None:
            pulumi.set(__self__, "app_agency", app_agency)
        if code_encrypt_kms_key_id is not None:
            pulumi.set(__self__, "code_encrypt_kms_key_id", code_encrypt_kms_key_id)
        if code_filename is not None:
            pulumi.set(__self__, "code_filename", code_filename)
        if code_type is not None:
            pulumi.set(__self__, "code_type", code_type)
        if code_url is not None:
            pulumi.set(__self__, "code_url", code_url)
        if concurrency_num is not None:
            pulumi.set(__self__, "concurrency_num", concurrency_num)
        if custom_image is not None:
            pulumi.set(__self__, "custom_image", custom_image)
        if depend_lists is not None:
            pulumi.set(__self__, "depend_lists", depend_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_list is not None:
            pulumi.set(__self__, "dns_list", dns_list)
        if enable_auth_in_header is not None:
            pulumi.set(__self__, "enable_auth_in_header", enable_auth_in_header)
        if enable_class_isolation is not None:
            pulumi.set(__self__, "enable_class_isolation", enable_class_isolation)
        if enable_dynamic_memory is not None:
            pulumi.set(__self__, "enable_dynamic_memory", enable_dynamic_memory)
        if enable_lts_log is not None:
            pulumi.set(__self__, "enable_lts_log", enable_lts_log)
        if encrypted_user_data is not None:
            pulumi.set(__self__, "encrypted_user_data", encrypted_user_data)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if func_code is not None:
            pulumi.set(__self__, "func_code", func_code)
        if func_mounts is not None:
            pulumi.set(__self__, "func_mounts", func_mounts)
        if functiongraph_version is not None:
            pulumi.set(__self__, "functiongraph_version", functiongraph_version)
        if gpu_memory is not None:
            pulumi.set(__self__, "gpu_memory", gpu_memory)
        if gpu_type is not None:
            pulumi.set(__self__, "gpu_type", gpu_type)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if heartbeat_handler is not None:
            pulumi.set(__self__, "heartbeat_handler", heartbeat_handler)
        if initializer_handler is not None:
            pulumi.set(__self__, "initializer_handler", initializer_handler)
        if initializer_timeout is not None:
            pulumi.set(__self__, "initializer_timeout", initializer_timeout)
        if is_stateful_function is not None:
            pulumi.set(__self__, "is_stateful_function", is_stateful_function)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_stream_id is not None:
            pulumi.set(__self__, "log_stream_id", log_stream_id)
        if log_stream_name is not None:
            pulumi.set(__self__, "log_stream_name", log_stream_name)
        if lts_custom_tag is not None:
            pulumi.set(__self__, "lts_custom_tag", lts_custom_tag)
        if lts_custom_tag_origin is not None:
            pulumi.set(__self__, "lts_custom_tag_origin", lts_custom_tag_origin)
        if max_instance_num is not None:
            pulumi.set(__self__, "max_instance_num", max_instance_num)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if mount_user_group_id is not None:
            pulumi.set(__self__, "mount_user_group_id", mount_user_group_id)
        if mount_user_id is not None:
            pulumi.set(__self__, "mount_user_id", mount_user_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_controller is not None:
            pulumi.set(__self__, "network_controller", network_controller)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if package is not None:
            warnings.warn("""use app instead""", DeprecationWarning)
            pulumi.log.warn("""package is deprecated: use app instead""")
        if package is not None:
            pulumi.set(__self__, "package", package)
        if peering_cidr is not None:
            pulumi.set(__self__, "peering_cidr", peering_cidr)
        if pre_stop_handler is not None:
            pulumi.set(__self__, "pre_stop_handler", pre_stop_handler)
        if pre_stop_timeout is not None:
            pulumi.set(__self__, "pre_stop_timeout", pre_stop_timeout)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_instances is not None:
            pulumi.set(__self__, "reserved_instances", reserved_instances)
        if restore_hook_handler is not None:
            pulumi.set(__self__, "restore_hook_handler", restore_hook_handler)
        if restore_hook_timeout is not None:
            pulumi.set(__self__, "restore_hook_timeout", restore_hook_timeout)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if urn is not None:
            pulumi.set(__self__, "urn", urn)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_data_encrypt_kms_key_id is not None:
            pulumi.set(__self__, "user_data_encrypt_kms_key_id", user_data_encrypt_kms_key_id)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if xrole is not None:
            warnings.warn("""use agency instead""", DeprecationWarning)
            pulumi.log.warn("""xrole is deprecated: use agency instead""")
        if xrole is not None:
            pulumi.set(__self__, "xrole", xrole)

    @_builtins.property
    @pulumi.getter
    def agency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the agency. This parameter is mandatory if the function needs to access other cloud services.
        """
        return pulumi.get(self, "agency")

    @agency.setter
    def agency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agency", value)

    @_builtins.property
    @pulumi.getter
    def app(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the group to which the function belongs.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app", value)

    @_builtins.property
    @pulumi.getter(name="appAgency")
    def app_agency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies An execution agency enables you to obtain a token or an AK/SK for accessing other cloud services.
        """
        return pulumi.get(self, "app_agency")

    @app_agency.setter
    def app_agency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_agency", value)

    @_builtins.property
    @pulumi.getter(name="codeEncryptKmsKeyId")
    def code_encrypt_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The KMS key ID for encrypting the function code.
        """
        return pulumi.get(self, "code_encrypt_kms_key_id")

    @code_encrypt_kms_key_id.setter
    def code_encrypt_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_encrypt_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="codeFilename")
    def code_filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of a function file, This field is mandatory only when coe_type is
        set to jar or zip.
        """
        return pulumi.get(self, "code_filename")

    @code_filename.setter
    def code_filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_filename", value)

    @_builtins.property
    @pulumi.getter(name="codeType")
    def code_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the function code type, which can be inline: inline code, zip: ZIP file,
        jar: JAR file or java functions, obs: function code stored in an OBS bucket.
        """
        return pulumi.get(self, "code_type")

    @code_type.setter
    def code_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_type", value)

    @_builtins.property
    @pulumi.getter(name="codeUrl")
    def code_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the code url. This parameter is mandatory when code_type is set to obs.
        """
        return pulumi.get(self, "code_url")

    @code_url.setter
    def code_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_url", value)

    @_builtins.property
    @pulumi.getter(name="concurrencyNum")
    def concurrency_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of concurrent requests of the function.
        """
        return pulumi.get(self, "concurrency_num")

    @concurrency_num.setter
    def concurrency_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "concurrency_num", value)

    @_builtins.property
    @pulumi.getter(name="customImage")
    def custom_image(self) -> Optional[pulumi.Input['FunctionCustomImageArgs']]:
        """
        The custom image configuration of the function.
        """
        return pulumi.get(self, "custom_image")

    @custom_image.setter
    def custom_image(self, value: Optional[pulumi.Input['FunctionCustomImageArgs']]):
        pulumi.set(self, "custom_image", value)

    @_builtins.property
    @pulumi.getter(name="dependLists")
    def depend_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the dependencies of the function.
        """
        return pulumi.get(self, "depend_lists")

    @depend_lists.setter
    def depend_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "depend_lists", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsList")
    def dns_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private DNS configuration of the function network.
        """
        return pulumi.get(self, "dns_list")

    @dns_list.setter
    def dns_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_list", value)

    @_builtins.property
    @pulumi.getter(name="enableAuthInHeader")
    def enable_auth_in_header(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the authentication in the request header is enabled.
        """
        return pulumi.get(self, "enable_auth_in_header")

    @enable_auth_in_header.setter
    def enable_auth_in_header(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_auth_in_header", value)

    @_builtins.property
    @pulumi.getter(name="enableClassIsolation")
    def enable_class_isolation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the class isolation is enabled for the JAVA runtime functions.
        """
        return pulumi.get(self, "enable_class_isolation")

    @enable_class_isolation.setter
    def enable_class_isolation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_class_isolation", value)

    @_builtins.property
    @pulumi.getter(name="enableDynamicMemory")
    def enable_dynamic_memory(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the dynamic memory configuration is enabled.
        """
        return pulumi.get(self, "enable_dynamic_memory")

    @enable_dynamic_memory.setter
    def enable_dynamic_memory(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dynamic_memory", value)

    @_builtins.property
    @pulumi.getter(name="enableLtsLog")
    def enable_lts_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the LTS log.
        """
        return pulumi.get(self, "enable_lts_log")

    @enable_lts_log.setter
    def enable_lts_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_lts_log", value)

    @_builtins.property
    @pulumi.getter(name="encryptedUserData")
    def encrypted_user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key/value information defined to be encrypted for the function.
        """
        return pulumi.get(self, "encrypted_user_data")

    @encrypted_user_data.setter
    def encrypted_user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypted_user_data", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the function.
        Changing this creates a new function.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the function ephemeral storage.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ephemeral_storage", value)

    @_builtins.property
    @pulumi.getter(name="funcCode")
    def func_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the function code. When code_type is set to inline, zip, or jar, this parameter is mandatory,
        and the code can be encoded using Base64 or just with the text code.
        """
        return pulumi.get(self, "func_code")

    @func_code.setter
    def func_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "func_code", value)

    @_builtins.property
    @pulumi.getter(name="funcMounts")
    def func_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]]]:
        """
        Specifies the file system list. The `func_mounts` object structure is documented below.
        """
        return pulumi.get(self, "func_mounts")

    @func_mounts.setter
    def func_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]]]):
        pulumi.set(self, "func_mounts", value)

    @_builtins.property
    @pulumi.getter(name="functiongraphVersion")
    def functiongraph_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the function.
        """
        return pulumi.get(self, "functiongraph_version")

    @functiongraph_version.setter
    def functiongraph_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "functiongraph_version", value)

    @_builtins.property
    @pulumi.getter(name="gpuMemory")
    def gpu_memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The GPU memory size allocated to the function, in MByte (MB).
        """
        return pulumi.get(self, "gpu_memory")

    @gpu_memory.setter
    def gpu_memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "gpu_memory", value)

    @_builtins.property
    @pulumi.getter(name="gpuType")
    def gpu_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GPU type of the function.
        """
        return pulumi.get(self, "gpu_type")

    @gpu_type.setter
    def gpu_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gpu_type", value)

    @_builtins.property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the entry point of the function.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "handler", value)

    @_builtins.property
    @pulumi.getter(name="heartbeatHandler")
    def heartbeat_handler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The heartbeat handler of the function.
        """
        return pulumi.get(self, "heartbeat_handler")

    @heartbeat_handler.setter
    def heartbeat_handler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "heartbeat_handler", value)

    @_builtins.property
    @pulumi.getter(name="initializerHandler")
    def initializer_handler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the initializer of the function.
        """
        return pulumi.get(self, "initializer_handler")

    @initializer_handler.setter
    def initializer_handler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "initializer_handler", value)

    @_builtins.property
    @pulumi.getter(name="initializerTimeout")
    def initializer_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum duration the function can be initialized. Value range: 1s to 300s.
        """
        return pulumi.get(self, "initializer_timeout")

    @initializer_timeout.setter
    def initializer_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initializer_timeout", value)

    @_builtins.property
    @pulumi.getter(name="isStatefulFunction")
    def is_stateful_function(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the function is a stateful function.
        """
        return pulumi.get(self, "is_stateful_function")

    @is_stateful_function.setter
    def is_stateful_function(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_stateful_function", value)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LTS group ID for collecting logs.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_group_id", value)

    @_builtins.property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LTS group name for collecting logs.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_group_name", value)

    @_builtins.property
    @pulumi.getter(name="logStreamId")
    def log_stream_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LTS stream ID for collecting logs.
        """
        return pulumi.get(self, "log_stream_id")

    @log_stream_id.setter
    def log_stream_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_stream_id", value)

    @_builtins.property
    @pulumi.getter(name="logStreamName")
    def log_stream_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LTS stream name for collecting logs.
        """
        return pulumi.get(self, "log_stream_name")

    @log_stream_name.setter
    def log_stream_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_stream_name", value)

    @_builtins.property
    @pulumi.getter(name="ltsCustomTag")
    def lts_custom_tag(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The custom tags configuration that used to filter the LTS logs.
        """
        return pulumi.get(self, "lts_custom_tag")

    @lts_custom_tag.setter
    def lts_custom_tag(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "lts_custom_tag", value)

    @_builtins.property
    @pulumi.getter(name="ltsCustomTagOrigin")
    def lts_custom_tag_origin(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The script configuration value of this change is also the original value used for comparison with
         the new value next time the change is made. The corresponding parameter name is 'lts_custom_tag'.
        """
        return pulumi.get(self, "lts_custom_tag_origin")

    @lts_custom_tag_origin.setter
    def lts_custom_tag_origin(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "lts_custom_tag_origin", value)

    @_builtins.property
    @pulumi.getter(name="maxInstanceNum")
    def max_instance_num(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum number of instances of the function.
        """
        return pulumi.get(self, "max_instance_num")

    @max_instance_num.setter
    def max_instance_num(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_instance_num", value)

    @_builtins.property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the memory size(MB) allocated to the function.
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size", value)

    @_builtins.property
    @pulumi.getter(name="mountUserGroupId")
    def mount_user_group_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the user group ID, a non-0 integer from –1 to 65534. Default to -1.
        """
        return pulumi.get(self, "mount_user_group_id")

    @mount_user_group_id.setter
    def mount_user_group_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mount_user_group_id", value)

    @_builtins.property
    @pulumi.getter(name="mountUserId")
    def mount_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        """
        return pulumi.get(self, "mount_user_id")

    @mount_user_id.setter
    def mount_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mount_user_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the function.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkController")
    def network_controller(self) -> Optional[pulumi.Input['FunctionNetworkControllerArgs']]:
        """
        The network configuration of the function.
        """
        return pulumi.get(self, "network_controller")

    @network_controller.setter
    def network_controller(self, value: Optional[pulumi.Input['FunctionNetworkControllerArgs']]):
        pulumi.set(self, "network_controller", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of subnet.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""use app instead""")
    def package(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package", value)

    @_builtins.property
    @pulumi.getter(name="peeringCidr")
    def peering_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC CIDR blocks used in the function code to detect whether it conflicts with the VPC
        CIDR blocks used by the service.
        """
        return pulumi.get(self, "peering_cidr")

    @peering_cidr.setter
    def peering_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peering_cidr", value)

    @_builtins.property
    @pulumi.getter(name="preStopHandler")
    def pre_stop_handler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pre-stop handler of a function.
        """
        return pulumi.get(self, "pre_stop_handler")

    @pre_stop_handler.setter
    def pre_stop_handler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_stop_handler", value)

    @_builtins.property
    @pulumi.getter(name="preStopTimeout")
    def pre_stop_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum duration that the function can be initialized.
        """
        return pulumi.get(self, "pre_stop_timeout")

    @pre_stop_timeout.setter
    def pre_stop_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "pre_stop_timeout", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the Function resource.
        If omitted, the provider-level region will be used. Changing this creates a new Function resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reservedInstances")
    def reserved_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionReservedInstanceArgs']]]]:
        """
        The reserved instance policies of the function.
        """
        return pulumi.get(self, "reserved_instances")

    @reserved_instances.setter
    def reserved_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionReservedInstanceArgs']]]]):
        pulumi.set(self, "reserved_instances", value)

    @_builtins.property
    @pulumi.getter(name="restoreHookHandler")
    def restore_hook_handler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The restore hook handler of the function.
        """
        return pulumi.get(self, "restore_hook_handler")

    @restore_hook_handler.setter
    def restore_hook_handler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_hook_handler", value)

    @_builtins.property
    @pulumi.getter(name="restoreHookTimeout")
    def restore_hook_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout of the function restore hook.
        """
        return pulumi.get(self, "restore_hook_timeout")

    @restore_hook_timeout.setter
    def restore_hook_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "restore_hook_timeout", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the environment for executing the function.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the function.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the timeout interval of the function, ranges from 3s to 900s.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Uniform Resource Name
        """
        return pulumi.get(self, "urn")

    @urn.setter
    def urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "urn", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key/value information defined for the function.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="userDataEncryptKmsKeyId")
    def user_data_encrypt_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The KMS key ID for encrypting the user data.
        """
        return pulumi.get(self, "user_data_encrypt_kms_key_id")

    @user_data_encrypt_kms_key_id.setter
    def user_data_encrypt_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data_encrypt_kms_key_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the function
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionVersionArgs']]]]:
        """
        The versions management of the function.
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionVersionArgs']]]]):
        pulumi.set(self, "versions", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""use agency instead""")
    def xrole(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "xrole")

    @xrole.setter
    def xrole(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xrole", value)


@pulumi.type_token("sbercloud:FunctionGraph/function:Function")
class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agency: Optional[pulumi.Input[_builtins.str]] = None,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 app_agency: Optional[pulumi.Input[_builtins.str]] = None,
                 code_encrypt_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 code_filename: Optional[pulumi.Input[_builtins.str]] = None,
                 code_type: Optional[pulumi.Input[_builtins.str]] = None,
                 code_url: Optional[pulumi.Input[_builtins.str]] = None,
                 concurrency_num: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_image: Optional[pulumi.Input[Union['FunctionCustomImageArgs', 'FunctionCustomImageArgsDict']]] = None,
                 depend_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_list: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_auth_in_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_class_isolation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dynamic_memory: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_lts_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypted_user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 func_code: Optional[pulumi.Input[_builtins.str]] = None,
                 func_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionFuncMountArgs', 'FunctionFuncMountArgsDict']]]]] = None,
                 functiongraph_version: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_memory: Optional[pulumi.Input[_builtins.int]] = None,
                 gpu_type: Optional[pulumi.Input[_builtins.str]] = None,
                 handler: Optional[pulumi.Input[_builtins.str]] = None,
                 heartbeat_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 initializer_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 initializer_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 is_stateful_function: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_custom_tag: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_instance_num: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size: Optional[pulumi.Input[_builtins.int]] = None,
                 mount_user_group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 mount_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_controller: Optional[pulumi.Input[Union['FunctionNetworkControllerArgs', 'FunctionNetworkControllerArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 package: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_stop_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_stop_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_instances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionReservedInstanceArgs', 'FunctionReservedInstanceArgsDict']]]]] = None,
                 restore_hook_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_hook_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_encrypt_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionVersionArgs', 'FunctionVersionArgsDict']]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 xrole: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Function resource within SberCloud.

        ## Example Usage

        ### With base64 func code

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        f1 = sbercloud.functiongraph.Function("f_1",
            name="func_1",
            app="default",
            agency="test",
            description="fuction test",
            handler="test.handler",
            memory_size=128,
            timeout=3,
            runtime="Python2.7",
            code_type="inline",
            func_code="aW1wb3J0IGpzb24KZGVmIGhhbmRsZXIgKGV2ZW50LCBjb250ZXh0KToKICAgIG91dHB1dCA9ICdIZWxsbyBtZXNzYWdlOiAnICsganNvbi5kdW1wcyhldmVudCkKICAgIHJldHVybiBvdXRwdXQ=")
        ```

        ### With text code

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        f1 = sbercloud.functiongraph.Function("f_1",
            name="func_1",
            app="default",
            agency="test",
            description="fuction test",
            handler="test.handler",
            memory_size=128,
            timeout=3,
            runtime="Python2.7",
            code_type="inline",
            func_code=\"\"\"# -*- coding:utf-8 -*-
        import json
        def handler (event, context):
            return {
                "statusCode": 200,
                "isBase64Encoded": False,
                "body": json.dumps(event),
                "headers": {
                    "Content-Type": "application/json"
                }
            }
        \"\"\")
        ```

        ## Import

        Functions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:FunctionGraph/function:Function my-func 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agency: Specifies the agency. This parameter is mandatory if the function needs to access other cloud services.
        :param pulumi.Input[_builtins.str] app: Specifies the group to which the function belongs.
        :param pulumi.Input[_builtins.str] app_agency: Specifies An execution agency enables you to obtain a token or an AK/SK for accessing other cloud services.
        :param pulumi.Input[_builtins.str] code_encrypt_kms_key_id: The KMS key ID for encrypting the function code.
        :param pulumi.Input[_builtins.str] code_filename: Specifies the name of a function file, This field is mandatory only when coe_type is
               set to jar or zip.
        :param pulumi.Input[_builtins.str] code_type: Specifies the function code type, which can be inline: inline code, zip: ZIP file,
               jar: JAR file or java functions, obs: function code stored in an OBS bucket.
        :param pulumi.Input[_builtins.str] code_url: Specifies the code url. This parameter is mandatory when code_type is set to obs.
        :param pulumi.Input[_builtins.int] concurrency_num: The number of concurrent requests of the function.
        :param pulumi.Input[Union['FunctionCustomImageArgs', 'FunctionCustomImageArgsDict']] custom_image: The custom image configuration of the function.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] depend_lists: Specifies the dependencies of the function.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the function.
        :param pulumi.Input[_builtins.str] dns_list: The private DNS configuration of the function network.
        :param pulumi.Input[_builtins.bool] enable_auth_in_header: Whether the authentication in the request header is enabled.
        :param pulumi.Input[_builtins.bool] enable_class_isolation: Whether the class isolation is enabled for the JAVA runtime functions.
        :param pulumi.Input[_builtins.bool] enable_dynamic_memory: Whether the dynamic memory configuration is enabled.
        :param pulumi.Input[_builtins.bool] enable_lts_log: Whether to enable the LTS log.
        :param pulumi.Input[_builtins.str] encrypted_user_data: The key/value information defined to be encrypted for the function.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the function.
               Changing this creates a new function.
        :param pulumi.Input[_builtins.int] ephemeral_storage: The size of the function ephemeral storage.
        :param pulumi.Input[_builtins.str] func_code: Specifies the function code. When code_type is set to inline, zip, or jar, this parameter is mandatory,
               and the code can be encoded using Base64 or just with the text code.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionFuncMountArgs', 'FunctionFuncMountArgsDict']]]] func_mounts: Specifies the file system list. The `func_mounts` object structure is documented below.
        :param pulumi.Input[_builtins.str] functiongraph_version: The description of the function.
        :param pulumi.Input[_builtins.int] gpu_memory: The GPU memory size allocated to the function, in MByte (MB).
        :param pulumi.Input[_builtins.str] gpu_type: The GPU type of the function.
        :param pulumi.Input[_builtins.str] handler: Specifies the entry point of the function.
        :param pulumi.Input[_builtins.str] heartbeat_handler: The heartbeat handler of the function.
        :param pulumi.Input[_builtins.str] initializer_handler: Specifies the initializer of the function.
        :param pulumi.Input[_builtins.int] initializer_timeout: Specifies the maximum duration the function can be initialized. Value range: 1s to 300s.
        :param pulumi.Input[_builtins.bool] is_stateful_function: Whether the function is a stateful function.
        :param pulumi.Input[_builtins.str] log_group_id: The LTS group ID for collecting logs.
        :param pulumi.Input[_builtins.str] log_group_name: The LTS group name for collecting logs.
        :param pulumi.Input[_builtins.str] log_stream_id: The LTS stream ID for collecting logs.
        :param pulumi.Input[_builtins.str] log_stream_name: The LTS stream name for collecting logs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] lts_custom_tag: The custom tags configuration that used to filter the LTS logs.
        :param pulumi.Input[_builtins.str] max_instance_num: The maximum number of instances of the function.
        :param pulumi.Input[_builtins.int] memory_size: Specifies the memory size(MB) allocated to the function.
        :param pulumi.Input[_builtins.int] mount_user_group_id: Specifies the user group ID, a non-0 integer from –1 to 65534. Default to -1.
        :param pulumi.Input[_builtins.int] mount_user_id: Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the function.
        :param pulumi.Input[Union['FunctionNetworkControllerArgs', 'FunctionNetworkControllerArgsDict']] network_controller: The network configuration of the function.
        :param pulumi.Input[_builtins.str] network_id: Specifies the ID of subnet.
        :param pulumi.Input[_builtins.str] peering_cidr: The VPC CIDR blocks used in the function code to detect whether it conflicts with the VPC
               CIDR blocks used by the service.
        :param pulumi.Input[_builtins.str] pre_stop_handler: The pre-stop handler of a function.
        :param pulumi.Input[_builtins.int] pre_stop_timeout: The maximum duration that the function can be initialized.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the Function resource.
               If omitted, the provider-level region will be used. Changing this creates a new Function resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionReservedInstanceArgs', 'FunctionReservedInstanceArgsDict']]]] reserved_instances: The reserved instance policies of the function.
        :param pulumi.Input[_builtins.str] restore_hook_handler: The restore hook handler of the function.
        :param pulumi.Input[_builtins.int] restore_hook_timeout: The timeout of the function restore hook.
        :param pulumi.Input[_builtins.str] runtime: Specifies the environment for executing the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the function.
        :param pulumi.Input[_builtins.int] timeout: Specifies the timeout interval of the function, ranges from 3s to 900s.
        :param pulumi.Input[_builtins.str] user_data: The key/value information defined for the function.
        :param pulumi.Input[_builtins.str] user_data_encrypt_kms_key_id: The KMS key ID for encrypting the user data.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionVersionArgs', 'FunctionVersionArgsDict']]]] versions: The versions management of the function.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Function resource within SberCloud.

        ## Example Usage

        ### With base64 func code

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        f1 = sbercloud.functiongraph.Function("f_1",
            name="func_1",
            app="default",
            agency="test",
            description="fuction test",
            handler="test.handler",
            memory_size=128,
            timeout=3,
            runtime="Python2.7",
            code_type="inline",
            func_code="aW1wb3J0IGpzb24KZGVmIGhhbmRsZXIgKGV2ZW50LCBjb250ZXh0KToKICAgIG91dHB1dCA9ICdIZWxsbyBtZXNzYWdlOiAnICsganNvbi5kdW1wcyhldmVudCkKICAgIHJldHVybiBvdXRwdXQ=")
        ```

        ### With text code

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        f1 = sbercloud.functiongraph.Function("f_1",
            name="func_1",
            app="default",
            agency="test",
            description="fuction test",
            handler="test.handler",
            memory_size=128,
            timeout=3,
            runtime="Python2.7",
            code_type="inline",
            func_code=\"\"\"# -*- coding:utf-8 -*-
        import json
        def handler (event, context):
            return {
                "statusCode": 200,
                "isBase64Encoded": False,
                "body": json.dumps(event),
                "headers": {
                    "Content-Type": "application/json"
                }
            }
        \"\"\")
        ```

        ## Import

        Functions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:FunctionGraph/function:Function my-func 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agency: Optional[pulumi.Input[_builtins.str]] = None,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 app_agency: Optional[pulumi.Input[_builtins.str]] = None,
                 code_encrypt_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 code_filename: Optional[pulumi.Input[_builtins.str]] = None,
                 code_type: Optional[pulumi.Input[_builtins.str]] = None,
                 code_url: Optional[pulumi.Input[_builtins.str]] = None,
                 concurrency_num: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_image: Optional[pulumi.Input[Union['FunctionCustomImageArgs', 'FunctionCustomImageArgsDict']]] = None,
                 depend_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_list: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_auth_in_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_class_isolation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dynamic_memory: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_lts_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypted_user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 func_code: Optional[pulumi.Input[_builtins.str]] = None,
                 func_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionFuncMountArgs', 'FunctionFuncMountArgsDict']]]]] = None,
                 functiongraph_version: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_memory: Optional[pulumi.Input[_builtins.int]] = None,
                 gpu_type: Optional[pulumi.Input[_builtins.str]] = None,
                 handler: Optional[pulumi.Input[_builtins.str]] = None,
                 heartbeat_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 initializer_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 initializer_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 is_stateful_function: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_custom_tag: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_instance_num: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size: Optional[pulumi.Input[_builtins.int]] = None,
                 mount_user_group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 mount_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_controller: Optional[pulumi.Input[Union['FunctionNetworkControllerArgs', 'FunctionNetworkControllerArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 package: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_stop_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_stop_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_instances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionReservedInstanceArgs', 'FunctionReservedInstanceArgsDict']]]]] = None,
                 restore_hook_handler: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_hook_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_encrypt_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionVersionArgs', 'FunctionVersionArgsDict']]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 xrole: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["agency"] = agency
            __props__.__dict__["app"] = app
            __props__.__dict__["app_agency"] = app_agency
            __props__.__dict__["code_encrypt_kms_key_id"] = code_encrypt_kms_key_id
            __props__.__dict__["code_filename"] = code_filename
            __props__.__dict__["code_type"] = code_type
            __props__.__dict__["code_url"] = code_url
            __props__.__dict__["concurrency_num"] = concurrency_num
            __props__.__dict__["custom_image"] = custom_image
            __props__.__dict__["depend_lists"] = depend_lists
            __props__.__dict__["description"] = description
            __props__.__dict__["dns_list"] = dns_list
            __props__.__dict__["enable_auth_in_header"] = enable_auth_in_header
            __props__.__dict__["enable_class_isolation"] = enable_class_isolation
            __props__.__dict__["enable_dynamic_memory"] = enable_dynamic_memory
            __props__.__dict__["enable_lts_log"] = enable_lts_log
            __props__.__dict__["encrypted_user_data"] = None if encrypted_user_data is None else pulumi.Output.secret(encrypted_user_data)
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["ephemeral_storage"] = ephemeral_storage
            __props__.__dict__["func_code"] = func_code
            __props__.__dict__["func_mounts"] = func_mounts
            __props__.__dict__["functiongraph_version"] = functiongraph_version
            __props__.__dict__["gpu_memory"] = gpu_memory
            __props__.__dict__["gpu_type"] = gpu_type
            __props__.__dict__["handler"] = handler
            __props__.__dict__["heartbeat_handler"] = heartbeat_handler
            __props__.__dict__["initializer_handler"] = initializer_handler
            __props__.__dict__["initializer_timeout"] = initializer_timeout
            __props__.__dict__["is_stateful_function"] = is_stateful_function
            __props__.__dict__["log_group_id"] = log_group_id
            __props__.__dict__["log_group_name"] = log_group_name
            __props__.__dict__["log_stream_id"] = log_stream_id
            __props__.__dict__["log_stream_name"] = log_stream_name
            __props__.__dict__["lts_custom_tag"] = lts_custom_tag
            __props__.__dict__["max_instance_num"] = max_instance_num
            if memory_size is None and not opts.urn:
                raise TypeError("Missing required property 'memory_size'")
            __props__.__dict__["memory_size"] = memory_size
            __props__.__dict__["mount_user_group_id"] = mount_user_group_id
            __props__.__dict__["mount_user_id"] = mount_user_id
            __props__.__dict__["name"] = name
            __props__.__dict__["network_controller"] = network_controller
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["package"] = package
            __props__.__dict__["peering_cidr"] = peering_cidr
            __props__.__dict__["pre_stop_handler"] = pre_stop_handler
            __props__.__dict__["pre_stop_timeout"] = pre_stop_timeout
            __props__.__dict__["region"] = region
            __props__.__dict__["reserved_instances"] = reserved_instances
            __props__.__dict__["restore_hook_handler"] = restore_hook_handler
            __props__.__dict__["restore_hook_timeout"] = restore_hook_timeout
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["tags"] = tags
            if timeout is None and not opts.urn:
                raise TypeError("Missing required property 'timeout'")
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["user_data_encrypt_kms_key_id"] = user_data_encrypt_kms_key_id
            __props__.__dict__["versions"] = versions
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["xrole"] = xrole
            __props__.__dict__["lts_custom_tag_origin"] = None
            __props__.__dict__["urn"] = None
            __props__.__dict__["version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["encryptedUserData"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Function, __self__).__init__(
            'sbercloud:FunctionGraph/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agency: Optional[pulumi.Input[_builtins.str]] = None,
            app: Optional[pulumi.Input[_builtins.str]] = None,
            app_agency: Optional[pulumi.Input[_builtins.str]] = None,
            code_encrypt_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            code_filename: Optional[pulumi.Input[_builtins.str]] = None,
            code_type: Optional[pulumi.Input[_builtins.str]] = None,
            code_url: Optional[pulumi.Input[_builtins.str]] = None,
            concurrency_num: Optional[pulumi.Input[_builtins.int]] = None,
            custom_image: Optional[pulumi.Input[Union['FunctionCustomImageArgs', 'FunctionCustomImageArgsDict']]] = None,
            depend_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dns_list: Optional[pulumi.Input[_builtins.str]] = None,
            enable_auth_in_header: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_class_isolation: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_dynamic_memory: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_lts_log: Optional[pulumi.Input[_builtins.bool]] = None,
            encrypted_user_data: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            ephemeral_storage: Optional[pulumi.Input[_builtins.int]] = None,
            func_code: Optional[pulumi.Input[_builtins.str]] = None,
            func_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionFuncMountArgs', 'FunctionFuncMountArgsDict']]]]] = None,
            functiongraph_version: Optional[pulumi.Input[_builtins.str]] = None,
            gpu_memory: Optional[pulumi.Input[_builtins.int]] = None,
            gpu_type: Optional[pulumi.Input[_builtins.str]] = None,
            handler: Optional[pulumi.Input[_builtins.str]] = None,
            heartbeat_handler: Optional[pulumi.Input[_builtins.str]] = None,
            initializer_handler: Optional[pulumi.Input[_builtins.str]] = None,
            initializer_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            is_stateful_function: Optional[pulumi.Input[_builtins.bool]] = None,
            log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            log_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
            log_stream_name: Optional[pulumi.Input[_builtins.str]] = None,
            lts_custom_tag: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lts_custom_tag_origin: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            max_instance_num: Optional[pulumi.Input[_builtins.str]] = None,
            memory_size: Optional[pulumi.Input[_builtins.int]] = None,
            mount_user_group_id: Optional[pulumi.Input[_builtins.int]] = None,
            mount_user_id: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_controller: Optional[pulumi.Input[Union['FunctionNetworkControllerArgs', 'FunctionNetworkControllerArgsDict']]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            package: Optional[pulumi.Input[_builtins.str]] = None,
            peering_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            pre_stop_handler: Optional[pulumi.Input[_builtins.str]] = None,
            pre_stop_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            reserved_instances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionReservedInstanceArgs', 'FunctionReservedInstanceArgsDict']]]]] = None,
            restore_hook_handler: Optional[pulumi.Input[_builtins.str]] = None,
            restore_hook_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            runtime: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            urn: Optional[pulumi.Input[_builtins.str]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            user_data_encrypt_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionVersionArgs', 'FunctionVersionArgsDict']]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            xrole: Optional[pulumi.Input[_builtins.str]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agency: Specifies the agency. This parameter is mandatory if the function needs to access other cloud services.
        :param pulumi.Input[_builtins.str] app: Specifies the group to which the function belongs.
        :param pulumi.Input[_builtins.str] app_agency: Specifies An execution agency enables you to obtain a token or an AK/SK for accessing other cloud services.
        :param pulumi.Input[_builtins.str] code_encrypt_kms_key_id: The KMS key ID for encrypting the function code.
        :param pulumi.Input[_builtins.str] code_filename: Specifies the name of a function file, This field is mandatory only when coe_type is
               set to jar or zip.
        :param pulumi.Input[_builtins.str] code_type: Specifies the function code type, which can be inline: inline code, zip: ZIP file,
               jar: JAR file or java functions, obs: function code stored in an OBS bucket.
        :param pulumi.Input[_builtins.str] code_url: Specifies the code url. This parameter is mandatory when code_type is set to obs.
        :param pulumi.Input[_builtins.int] concurrency_num: The number of concurrent requests of the function.
        :param pulumi.Input[Union['FunctionCustomImageArgs', 'FunctionCustomImageArgsDict']] custom_image: The custom image configuration of the function.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] depend_lists: Specifies the dependencies of the function.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the function.
        :param pulumi.Input[_builtins.str] dns_list: The private DNS configuration of the function network.
        :param pulumi.Input[_builtins.bool] enable_auth_in_header: Whether the authentication in the request header is enabled.
        :param pulumi.Input[_builtins.bool] enable_class_isolation: Whether the class isolation is enabled for the JAVA runtime functions.
        :param pulumi.Input[_builtins.bool] enable_dynamic_memory: Whether the dynamic memory configuration is enabled.
        :param pulumi.Input[_builtins.bool] enable_lts_log: Whether to enable the LTS log.
        :param pulumi.Input[_builtins.str] encrypted_user_data: The key/value information defined to be encrypted for the function.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the function.
               Changing this creates a new function.
        :param pulumi.Input[_builtins.int] ephemeral_storage: The size of the function ephemeral storage.
        :param pulumi.Input[_builtins.str] func_code: Specifies the function code. When code_type is set to inline, zip, or jar, this parameter is mandatory,
               and the code can be encoded using Base64 or just with the text code.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionFuncMountArgs', 'FunctionFuncMountArgsDict']]]] func_mounts: Specifies the file system list. The `func_mounts` object structure is documented below.
        :param pulumi.Input[_builtins.str] functiongraph_version: The description of the function.
        :param pulumi.Input[_builtins.int] gpu_memory: The GPU memory size allocated to the function, in MByte (MB).
        :param pulumi.Input[_builtins.str] gpu_type: The GPU type of the function.
        :param pulumi.Input[_builtins.str] handler: Specifies the entry point of the function.
        :param pulumi.Input[_builtins.str] heartbeat_handler: The heartbeat handler of the function.
        :param pulumi.Input[_builtins.str] initializer_handler: Specifies the initializer of the function.
        :param pulumi.Input[_builtins.int] initializer_timeout: Specifies the maximum duration the function can be initialized. Value range: 1s to 300s.
        :param pulumi.Input[_builtins.bool] is_stateful_function: Whether the function is a stateful function.
        :param pulumi.Input[_builtins.str] log_group_id: The LTS group ID for collecting logs.
        :param pulumi.Input[_builtins.str] log_group_name: The LTS group name for collecting logs.
        :param pulumi.Input[_builtins.str] log_stream_id: The LTS stream ID for collecting logs.
        :param pulumi.Input[_builtins.str] log_stream_name: The LTS stream name for collecting logs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] lts_custom_tag: The custom tags configuration that used to filter the LTS logs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] lts_custom_tag_origin: The script configuration value of this change is also the original value used for comparison with
                the new value next time the change is made. The corresponding parameter name is 'lts_custom_tag'.
        :param pulumi.Input[_builtins.str] max_instance_num: The maximum number of instances of the function.
        :param pulumi.Input[_builtins.int] memory_size: Specifies the memory size(MB) allocated to the function.
        :param pulumi.Input[_builtins.int] mount_user_group_id: Specifies the user group ID, a non-0 integer from –1 to 65534. Default to -1.
        :param pulumi.Input[_builtins.int] mount_user_id: Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the function.
        :param pulumi.Input[Union['FunctionNetworkControllerArgs', 'FunctionNetworkControllerArgsDict']] network_controller: The network configuration of the function.
        :param pulumi.Input[_builtins.str] network_id: Specifies the ID of subnet.
        :param pulumi.Input[_builtins.str] peering_cidr: The VPC CIDR blocks used in the function code to detect whether it conflicts with the VPC
               CIDR blocks used by the service.
        :param pulumi.Input[_builtins.str] pre_stop_handler: The pre-stop handler of a function.
        :param pulumi.Input[_builtins.int] pre_stop_timeout: The maximum duration that the function can be initialized.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the Function resource.
               If omitted, the provider-level region will be used. Changing this creates a new Function resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionReservedInstanceArgs', 'FunctionReservedInstanceArgsDict']]]] reserved_instances: The reserved instance policies of the function.
        :param pulumi.Input[_builtins.str] restore_hook_handler: The restore hook handler of the function.
        :param pulumi.Input[_builtins.int] restore_hook_timeout: The timeout of the function restore hook.
        :param pulumi.Input[_builtins.str] runtime: Specifies the environment for executing the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the function.
        :param pulumi.Input[_builtins.int] timeout: Specifies the timeout interval of the function, ranges from 3s to 900s.
        :param pulumi.Input[_builtins.str] urn: Uniform Resource Name
        :param pulumi.Input[_builtins.str] user_data: The key/value information defined for the function.
        :param pulumi.Input[_builtins.str] user_data_encrypt_kms_key_id: The KMS key ID for encrypting the user data.
        :param pulumi.Input[_builtins.str] version: The version of the function
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionVersionArgs', 'FunctionVersionArgsDict']]]] versions: The versions management of the function.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["agency"] = agency
        __props__.__dict__["app"] = app
        __props__.__dict__["app_agency"] = app_agency
        __props__.__dict__["code_encrypt_kms_key_id"] = code_encrypt_kms_key_id
        __props__.__dict__["code_filename"] = code_filename
        __props__.__dict__["code_type"] = code_type
        __props__.__dict__["code_url"] = code_url
        __props__.__dict__["concurrency_num"] = concurrency_num
        __props__.__dict__["custom_image"] = custom_image
        __props__.__dict__["depend_lists"] = depend_lists
        __props__.__dict__["description"] = description
        __props__.__dict__["dns_list"] = dns_list
        __props__.__dict__["enable_auth_in_header"] = enable_auth_in_header
        __props__.__dict__["enable_class_isolation"] = enable_class_isolation
        __props__.__dict__["enable_dynamic_memory"] = enable_dynamic_memory
        __props__.__dict__["enable_lts_log"] = enable_lts_log
        __props__.__dict__["encrypted_user_data"] = encrypted_user_data
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["ephemeral_storage"] = ephemeral_storage
        __props__.__dict__["func_code"] = func_code
        __props__.__dict__["func_mounts"] = func_mounts
        __props__.__dict__["functiongraph_version"] = functiongraph_version
        __props__.__dict__["gpu_memory"] = gpu_memory
        __props__.__dict__["gpu_type"] = gpu_type
        __props__.__dict__["handler"] = handler
        __props__.__dict__["heartbeat_handler"] = heartbeat_handler
        __props__.__dict__["initializer_handler"] = initializer_handler
        __props__.__dict__["initializer_timeout"] = initializer_timeout
        __props__.__dict__["is_stateful_function"] = is_stateful_function
        __props__.__dict__["log_group_id"] = log_group_id
        __props__.__dict__["log_group_name"] = log_group_name
        __props__.__dict__["log_stream_id"] = log_stream_id
        __props__.__dict__["log_stream_name"] = log_stream_name
        __props__.__dict__["lts_custom_tag"] = lts_custom_tag
        __props__.__dict__["lts_custom_tag_origin"] = lts_custom_tag_origin
        __props__.__dict__["max_instance_num"] = max_instance_num
        __props__.__dict__["memory_size"] = memory_size
        __props__.__dict__["mount_user_group_id"] = mount_user_group_id
        __props__.__dict__["mount_user_id"] = mount_user_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_controller"] = network_controller
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["package"] = package
        __props__.__dict__["peering_cidr"] = peering_cidr
        __props__.__dict__["pre_stop_handler"] = pre_stop_handler
        __props__.__dict__["pre_stop_timeout"] = pre_stop_timeout
        __props__.__dict__["region"] = region
        __props__.__dict__["reserved_instances"] = reserved_instances
        __props__.__dict__["restore_hook_handler"] = restore_hook_handler
        __props__.__dict__["restore_hook_timeout"] = restore_hook_timeout
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["urn"] = urn
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["user_data_encrypt_kms_key_id"] = user_data_encrypt_kms_key_id
        __props__.__dict__["version"] = version
        __props__.__dict__["versions"] = versions
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["xrole"] = xrole
        return Function(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def agency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the agency. This parameter is mandatory if the function needs to access other cloud services.
        """
        return pulumi.get(self, "agency")

    @_builtins.property
    @pulumi.getter
    def app(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the group to which the function belongs.
        """
        return pulumi.get(self, "app")

    @_builtins.property
    @pulumi.getter(name="appAgency")
    def app_agency(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies An execution agency enables you to obtain a token or an AK/SK for accessing other cloud services.
        """
        return pulumi.get(self, "app_agency")

    @_builtins.property
    @pulumi.getter(name="codeEncryptKmsKeyId")
    def code_encrypt_kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The KMS key ID for encrypting the function code.
        """
        return pulumi.get(self, "code_encrypt_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="codeFilename")
    def code_filename(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of a function file, This field is mandatory only when coe_type is
        set to jar or zip.
        """
        return pulumi.get(self, "code_filename")

    @_builtins.property
    @pulumi.getter(name="codeType")
    def code_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the function code type, which can be inline: inline code, zip: ZIP file,
        jar: JAR file or java functions, obs: function code stored in an OBS bucket.
        """
        return pulumi.get(self, "code_type")

    @_builtins.property
    @pulumi.getter(name="codeUrl")
    def code_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the code url. This parameter is mandatory when code_type is set to obs.
        """
        return pulumi.get(self, "code_url")

    @_builtins.property
    @pulumi.getter(name="concurrencyNum")
    def concurrency_num(self) -> pulumi.Output[_builtins.int]:
        """
        The number of concurrent requests of the function.
        """
        return pulumi.get(self, "concurrency_num")

    @_builtins.property
    @pulumi.getter(name="customImage")
    def custom_image(self) -> pulumi.Output['outputs.FunctionCustomImage']:
        """
        The custom image configuration of the function.
        """
        return pulumi.get(self, "custom_image")

    @_builtins.property
    @pulumi.getter(name="dependLists")
    def depend_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the dependencies of the function.
        """
        return pulumi.get(self, "depend_lists")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the function.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsList")
    def dns_list(self) -> pulumi.Output[_builtins.str]:
        """
        The private DNS configuration of the function network.
        """
        return pulumi.get(self, "dns_list")

    @_builtins.property
    @pulumi.getter(name="enableAuthInHeader")
    def enable_auth_in_header(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the authentication in the request header is enabled.
        """
        return pulumi.get(self, "enable_auth_in_header")

    @_builtins.property
    @pulumi.getter(name="enableClassIsolation")
    def enable_class_isolation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the class isolation is enabled for the JAVA runtime functions.
        """
        return pulumi.get(self, "enable_class_isolation")

    @_builtins.property
    @pulumi.getter(name="enableDynamicMemory")
    def enable_dynamic_memory(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the dynamic memory configuration is enabled.
        """
        return pulumi.get(self, "enable_dynamic_memory")

    @_builtins.property
    @pulumi.getter(name="enableLtsLog")
    def enable_lts_log(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable the LTS log.
        """
        return pulumi.get(self, "enable_lts_log")

    @_builtins.property
    @pulumi.getter(name="encryptedUserData")
    def encrypted_user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key/value information defined to be encrypted for the function.
        """
        return pulumi.get(self, "encrypted_user_data")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project id of the function.
        Changing this creates a new function.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the function ephemeral storage.
        """
        return pulumi.get(self, "ephemeral_storage")

    @_builtins.property
    @pulumi.getter(name="funcCode")
    def func_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the function code. When code_type is set to inline, zip, or jar, this parameter is mandatory,
        and the code can be encoded using Base64 or just with the text code.
        """
        return pulumi.get(self, "func_code")

    @_builtins.property
    @pulumi.getter(name="funcMounts")
    def func_mounts(self) -> pulumi.Output[Sequence['outputs.FunctionFuncMount']]:
        """
        Specifies the file system list. The `func_mounts` object structure is documented below.
        """
        return pulumi.get(self, "func_mounts")

    @_builtins.property
    @pulumi.getter(name="functiongraphVersion")
    def functiongraph_version(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the function.
        """
        return pulumi.get(self, "functiongraph_version")

    @_builtins.property
    @pulumi.getter(name="gpuMemory")
    def gpu_memory(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The GPU memory size allocated to the function, in MByte (MB).
        """
        return pulumi.get(self, "gpu_memory")

    @_builtins.property
    @pulumi.getter(name="gpuType")
    def gpu_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The GPU type of the function.
        """
        return pulumi.get(self, "gpu_type")

    @_builtins.property
    @pulumi.getter
    def handler(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the entry point of the function.
        """
        return pulumi.get(self, "handler")

    @_builtins.property
    @pulumi.getter(name="heartbeatHandler")
    def heartbeat_handler(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The heartbeat handler of the function.
        """
        return pulumi.get(self, "heartbeat_handler")

    @_builtins.property
    @pulumi.getter(name="initializerHandler")
    def initializer_handler(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the initializer of the function.
        """
        return pulumi.get(self, "initializer_handler")

    @_builtins.property
    @pulumi.getter(name="initializerTimeout")
    def initializer_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum duration the function can be initialized. Value range: 1s to 300s.
        """
        return pulumi.get(self, "initializer_timeout")

    @_builtins.property
    @pulumi.getter(name="isStatefulFunction")
    def is_stateful_function(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the function is a stateful function.
        """
        return pulumi.get(self, "is_stateful_function")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The LTS group ID for collecting logs.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The LTS group name for collecting logs.
        """
        return pulumi.get(self, "log_group_name")

    @_builtins.property
    @pulumi.getter(name="logStreamId")
    def log_stream_id(self) -> pulumi.Output[_builtins.str]:
        """
        The LTS stream ID for collecting logs.
        """
        return pulumi.get(self, "log_stream_id")

    @_builtins.property
    @pulumi.getter(name="logStreamName")
    def log_stream_name(self) -> pulumi.Output[_builtins.str]:
        """
        The LTS stream name for collecting logs.
        """
        return pulumi.get(self, "log_stream_name")

    @_builtins.property
    @pulumi.getter(name="ltsCustomTag")
    def lts_custom_tag(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The custom tags configuration that used to filter the LTS logs.
        """
        return pulumi.get(self, "lts_custom_tag")

    @_builtins.property
    @pulumi.getter(name="ltsCustomTagOrigin")
    def lts_custom_tag_origin(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The script configuration value of this change is also the original value used for comparison with
         the new value next time the change is made. The corresponding parameter name is 'lts_custom_tag'.
        """
        return pulumi.get(self, "lts_custom_tag_origin")

    @_builtins.property
    @pulumi.getter(name="maxInstanceNum")
    def max_instance_num(self) -> pulumi.Output[_builtins.str]:
        """
        The maximum number of instances of the function.
        """
        return pulumi.get(self, "max_instance_num")

    @_builtins.property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the memory size(MB) allocated to the function.
        """
        return pulumi.get(self, "memory_size")

    @_builtins.property
    @pulumi.getter(name="mountUserGroupId")
    def mount_user_group_id(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the user group ID, a non-0 integer from –1 to 65534. Default to -1.
        """
        return pulumi.get(self, "mount_user_group_id")

    @_builtins.property
    @pulumi.getter(name="mountUserId")
    def mount_user_id(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        """
        return pulumi.get(self, "mount_user_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the function.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkController")
    def network_controller(self) -> pulumi.Output[Optional['outputs.FunctionNetworkController']]:
        """
        The network configuration of the function.
        """
        return pulumi.get(self, "network_controller")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of subnet.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""use app instead""")
    def package(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "package")

    @_builtins.property
    @pulumi.getter(name="peeringCidr")
    def peering_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The VPC CIDR blocks used in the function code to detect whether it conflicts with the VPC
        CIDR blocks used by the service.
        """
        return pulumi.get(self, "peering_cidr")

    @_builtins.property
    @pulumi.getter(name="preStopHandler")
    def pre_stop_handler(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The pre-stop handler of a function.
        """
        return pulumi.get(self, "pre_stop_handler")

    @_builtins.property
    @pulumi.getter(name="preStopTimeout")
    def pre_stop_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum duration that the function can be initialized.
        """
        return pulumi.get(self, "pre_stop_timeout")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the Function resource.
        If omitted, the provider-level region will be used. Changing this creates a new Function resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="reservedInstances")
    def reserved_instances(self) -> pulumi.Output[Optional[Sequence['outputs.FunctionReservedInstance']]]:
        """
        The reserved instance policies of the function.
        """
        return pulumi.get(self, "reserved_instances")

    @_builtins.property
    @pulumi.getter(name="restoreHookHandler")
    def restore_hook_handler(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The restore hook handler of the function.
        """
        return pulumi.get(self, "restore_hook_handler")

    @_builtins.property
    @pulumi.getter(name="restoreHookTimeout")
    def restore_hook_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The timeout of the function restore hook.
        """
        return pulumi.get(self, "restore_hook_timeout")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the environment for executing the function.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the function.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the timeout interval of the function, ranges from 3s to 900s.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def urn(self) -> pulumi.Output[_builtins.str]:
        """
        Uniform Resource Name
        """
        return pulumi.get(self, "urn")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key/value information defined for the function.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="userDataEncryptKmsKeyId")
    def user_data_encrypt_kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The KMS key ID for encrypting the user data.
        """
        return pulumi.get(self, "user_data_encrypt_kms_key_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the function
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Output[Optional[Sequence['outputs.FunctionVersion']]]:
        """
        The versions management of the function.
        """
        return pulumi.get(self, "versions")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""use agency instead""")
    def xrole(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "xrole")

