# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDependenciesResult',
    'AwaitableGetDependenciesResult',
    'get_dependencies',
    'get_dependencies_output',
]

@pulumi.output_type
class GetDependenciesResult:
    """
    A collection of values returned by getDependencies.
    """
    def __init__(__self__, id=None, is_versions_query_allowed=None, name=None, packages=None, region=None, runtime=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_versions_query_allowed and not isinstance(is_versions_query_allowed, bool):
            raise TypeError("Expected argument 'is_versions_query_allowed' to be a bool")
        pulumi.set(__self__, "is_versions_query_allowed", is_versions_query_allowed)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if packages and not isinstance(packages, list):
            raise TypeError("Expected argument 'packages' to be a list")
        pulumi.set(__self__, "packages", packages)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if runtime and not isinstance(runtime, str):
            raise TypeError("Expected argument 'runtime' to be a str")
        pulumi.set(__self__, "runtime", runtime)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isVersionsQueryAllowed")
    def is_versions_query_allowed(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_versions_query_allowed")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the dependency package.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def packages(self) -> Sequence['outputs.GetDependenciesPackageResult']:
        """
        All dependency packages that match the filter parameters.
        The packages structure is documented below.
        """
        return pulumi.get(self, "packages")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[_builtins.str]:
        """
        The runtime of the dependency package.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


class AwaitableGetDependenciesResult(GetDependenciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDependenciesResult(
            id=self.id,
            is_versions_query_allowed=self.is_versions_query_allowed,
            name=self.name,
            packages=self.packages,
            region=self.region,
            runtime=self.runtime,
            type=self.type)


def get_dependencies(is_versions_query_allowed: Optional[_builtins.bool] = None,
                     name: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     runtime: Optional[_builtins.str] = None,
                     type: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDependenciesResult:
    """
    Use this data source to query dependency packages within SberCloud.

    > Between `1.64.2` and `1.72.1`, the version list of each dependency package is queried by default.
       <br>This will cause the query to take up a lot of time and may trigger flow control.
       <br>There are not recommended to use.

    ## Example Usage

    ### Obtain all public dependency packages

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.FunctionGraph.get_dependencies()
    ```

    ### Obtain specific public dependency package by name

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.FunctionGraph.get_dependencies(type="public",
        name="obssdk-3.0.2")
    ```

    ### Obtain all public Python2.7 dependency packages

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.FunctionGraph.get_dependencies(type="public",
        runtime="Python2.7")
    ```


    :param _builtins.bool is_versions_query_allowed: Specifies whether to query the versions of each dependency package.
           Defaults to **false**.
    :param _builtins.str name: Specifies the name of the dependency package.
    :param _builtins.str region: Specifies the region where the dependency packages are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str runtime: Specifies the runtime of the dependency package.  
           The valid values are as follows:
           + **Java8**
           + **Java11**
           + **Node.js6.10**
           + **Node.js8.10**
           + **Node.js10.16**
           + **Node.js12.13**
           + **Node.js14.18**
           + **Node.js16.17**
           + **Node.js18.15**
           + **Python2.7**
           + **Python3.6**
           + **Python3.9**
           + **Python3.10**
           + **Go1.x**
           + **C#(.NET Core 2.0)**
           + **C#(.NET Core 2.1)**
           + **C#(.NET Core 3.1)**
           + **Custom**
           + **PHP7.3**
           + **Cangjie1.0**
           + **http**
           + **Custom Image**
    :param _builtins.str type: Specifies the type of the dependency package.  
           The valid values are as follows:
           + **public**
           + **private**
    """
    __args__ = dict()
    __args__['isVersionsQueryAllowed'] = is_versions_query_allowed
    __args__['name'] = name
    __args__['region'] = region
    __args__['runtime'] = runtime
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:FunctionGraph/getDependencies:getDependencies', __args__, opts=opts, typ=GetDependenciesResult).value

    return AwaitableGetDependenciesResult(
        id=pulumi.get(__ret__, 'id'),
        is_versions_query_allowed=pulumi.get(__ret__, 'is_versions_query_allowed'),
        name=pulumi.get(__ret__, 'name'),
        packages=pulumi.get(__ret__, 'packages'),
        region=pulumi.get(__ret__, 'region'),
        runtime=pulumi.get(__ret__, 'runtime'),
        type=pulumi.get(__ret__, 'type'))
def get_dependencies_output(is_versions_query_allowed: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                            name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            runtime: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDependenciesResult]:
    """
    Use this data source to query dependency packages within SberCloud.

    > Between `1.64.2` and `1.72.1`, the version list of each dependency package is queried by default.
       <br>This will cause the query to take up a lot of time and may trigger flow control.
       <br>There are not recommended to use.

    ## Example Usage

    ### Obtain all public dependency packages

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.FunctionGraph.get_dependencies()
    ```

    ### Obtain specific public dependency package by name

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.FunctionGraph.get_dependencies(type="public",
        name="obssdk-3.0.2")
    ```

    ### Obtain all public Python2.7 dependency packages

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.FunctionGraph.get_dependencies(type="public",
        runtime="Python2.7")
    ```


    :param _builtins.bool is_versions_query_allowed: Specifies whether to query the versions of each dependency package.
           Defaults to **false**.
    :param _builtins.str name: Specifies the name of the dependency package.
    :param _builtins.str region: Specifies the region where the dependency packages are located.  
           If omitted, the provider-level region will be used.
    :param _builtins.str runtime: Specifies the runtime of the dependency package.  
           The valid values are as follows:
           + **Java8**
           + **Java11**
           + **Node.js6.10**
           + **Node.js8.10**
           + **Node.js10.16**
           + **Node.js12.13**
           + **Node.js14.18**
           + **Node.js16.17**
           + **Node.js18.15**
           + **Python2.7**
           + **Python3.6**
           + **Python3.9**
           + **Python3.10**
           + **Go1.x**
           + **C#(.NET Core 2.0)**
           + **C#(.NET Core 2.1)**
           + **C#(.NET Core 3.1)**
           + **Custom**
           + **PHP7.3**
           + **Cangjie1.0**
           + **http**
           + **Custom Image**
    :param _builtins.str type: Specifies the type of the dependency package.  
           The valid values are as follows:
           + **public**
           + **private**
    """
    __args__ = dict()
    __args__['isVersionsQueryAllowed'] = is_versions_query_allowed
    __args__['name'] = name
    __args__['region'] = region
    __args__['runtime'] = runtime
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:FunctionGraph/getDependencies:getDependencies', __args__, opts=opts, typ=GetDependenciesResult)
    return __ret__.apply(lambda __response__: GetDependenciesResult(
        id=pulumi.get(__response__, 'id'),
        is_versions_query_allowed=pulumi.get(__response__, 'is_versions_query_allowed'),
        name=pulumi.get(__response__, 'name'),
        packages=pulumi.get(__response__, 'packages'),
        region=pulumi.get(__response__, 'region'),
        runtime=pulumi.get(__response__, 'runtime'),
        type=pulumi.get(__response__, 'type')))
