# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'FunctionCustomImage',
    'FunctionFuncMount',
    'FunctionNetworkController',
    'FunctionNetworkControllerTriggerAccessVpc',
    'FunctionReservedInstance',
    'FunctionReservedInstanceTacticsConfig',
    'FunctionReservedInstanceTacticsConfigCronConfig',
    'FunctionReservedInstanceTacticsConfigMetricConfig',
    'FunctionVersion',
    'FunctionVersionAliases',
    'GetDependenciesPackageResult',
    'GetDependenciesPackageVersionResult',
]

@pulumi.output_type
class FunctionCustomImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userGroupId":
            suggest = "user_group_id"
        elif key == "userId":
            suggest = "user_id"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionCustomImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionCustomImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionCustomImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: _builtins.str,
                 args: Optional[_builtins.str] = None,
                 command: Optional[_builtins.str] = None,
                 user_group_id: Optional[_builtins.str] = None,
                 user_id: Optional[_builtins.str] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        :param _builtins.str url: The URL of SWR image.
        :param _builtins.str args: The command line arguments used to start the SWR image.
        :param _builtins.str command: The startup commands of the SWR image.
        :param _builtins.str user_group_id: The user group ID that used to run SWR image.
        :param _builtins.str user_id: The user ID that used to run SWR image.
        :param _builtins.str working_dir: The working directory of the SWR image.
        """
        pulumi.set(__self__, "url", url)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if user_group_id is not None:
            pulumi.set(__self__, "user_group_id", user_group_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL of SWR image.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[_builtins.str]:
        """
        The command line arguments used to start the SWR image.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[_builtins.str]:
        """
        The startup commands of the SWR image.
        """
        return pulumi.get(self, "command")

    @_builtins.property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> Optional[_builtins.str]:
        """
        The user group ID that used to run SWR image.
        """
        return pulumi.get(self, "user_group_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[_builtins.str]:
        """
        The user ID that used to run SWR image.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        The working directory of the SWR image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class FunctionFuncMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localMountPath":
            suggest = "local_mount_path"
        elif key == "mountResource":
            suggest = "mount_resource"
        elif key == "mountSharePath":
            suggest = "mount_share_path"
        elif key == "mountType":
            suggest = "mount_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionFuncMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionFuncMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionFuncMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_mount_path: _builtins.str,
                 mount_resource: _builtins.str,
                 mount_share_path: _builtins.str,
                 mount_type: _builtins.str,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str local_mount_path: Specifies the function access path.
        :param _builtins.str mount_resource: Specifies the ID of the mounted resource (corresponding cloud service).
        :param _builtins.str mount_share_path: Specifies the remote mount path. Example: 192.168.0.12:/data.
        :param _builtins.str mount_type: Specifies the mount type. Options: sfs, sfsTurbo, and ecs.
        :param _builtins.str status: The mount status.
        """
        pulumi.set(__self__, "local_mount_path", local_mount_path)
        pulumi.set(__self__, "mount_resource", mount_resource)
        pulumi.set(__self__, "mount_share_path", mount_share_path)
        pulumi.set(__self__, "mount_type", mount_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="localMountPath")
    def local_mount_path(self) -> _builtins.str:
        """
        Specifies the function access path.
        """
        return pulumi.get(self, "local_mount_path")

    @_builtins.property
    @pulumi.getter(name="mountResource")
    def mount_resource(self) -> _builtins.str:
        """
        Specifies the ID of the mounted resource (corresponding cloud service).
        """
        return pulumi.get(self, "mount_resource")

    @_builtins.property
    @pulumi.getter(name="mountSharePath")
    def mount_share_path(self) -> _builtins.str:
        """
        Specifies the remote mount path. Example: 192.168.0.12:/data.
        """
        return pulumi.get(self, "mount_share_path")

    @_builtins.property
    @pulumi.getter(name="mountType")
    def mount_type(self) -> _builtins.str:
        """
        Specifies the mount type. Options: sfs, sfsTurbo, and ecs.
        """
        return pulumi.get(self, "mount_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The mount status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class FunctionNetworkController(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disablePublicNetwork":
            suggest = "disable_public_network"
        elif key == "triggerAccessVpcs":
            suggest = "trigger_access_vpcs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionNetworkController. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionNetworkController.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionNetworkController.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_public_network: Optional[_builtins.bool] = None,
                 trigger_access_vpcs: Optional[Sequence['outputs.FunctionNetworkControllerTriggerAccessVpc']] = None):
        """
        :param _builtins.bool disable_public_network: Whether to disable the public network access.
        :param Sequence['FunctionNetworkControllerTriggerAccessVpcArgs'] trigger_access_vpcs: The configuration of the VPCs that can trigger the function.
        """
        if disable_public_network is not None:
            pulumi.set(__self__, "disable_public_network", disable_public_network)
        if trigger_access_vpcs is not None:
            pulumi.set(__self__, "trigger_access_vpcs", trigger_access_vpcs)

    @_builtins.property
    @pulumi.getter(name="disablePublicNetwork")
    def disable_public_network(self) -> Optional[_builtins.bool]:
        """
        Whether to disable the public network access.
        """
        return pulumi.get(self, "disable_public_network")

    @_builtins.property
    @pulumi.getter(name="triggerAccessVpcs")
    def trigger_access_vpcs(self) -> Optional[Sequence['outputs.FunctionNetworkControllerTriggerAccessVpc']]:
        """
        The configuration of the VPCs that can trigger the function.
        """
        return pulumi.get(self, "trigger_access_vpcs")


@pulumi.output_type
class FunctionNetworkControllerTriggerAccessVpc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"
        elif key == "vpcName":
            suggest = "vpc_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionNetworkControllerTriggerAccessVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionNetworkControllerTriggerAccessVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionNetworkControllerTriggerAccessVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: Optional[_builtins.str] = None,
                 vpc_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str vpc_id: Specifies the ID of VPC.
        :param _builtins.str vpc_name: The ID of the VPC that can trigger the function.
        """
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC that can trigger the function.
        """
        return pulumi.get(self, "vpc_name")


@pulumi.output_type
class FunctionReservedInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "qualifierName":
            suggest = "qualifier_name"
        elif key == "qualifierType":
            suggest = "qualifier_type"
        elif key == "idleMode":
            suggest = "idle_mode"
        elif key == "tacticsConfig":
            suggest = "tactics_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionReservedInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionReservedInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionReservedInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: _builtins.int,
                 qualifier_name: _builtins.str,
                 qualifier_type: _builtins.str,
                 idle_mode: Optional[_builtins.bool] = None,
                 tactics_config: Optional['outputs.FunctionReservedInstanceTacticsConfig'] = None):
        """
        :param _builtins.int count: The number of reserved instance.
        :param _builtins.str qualifier_name: The version name or alias name.
        :param _builtins.str qualifier_type: The qualifier type of reserved instance.
        :param _builtins.bool idle_mode: Whether to enable the idle mode.
        :param 'FunctionReservedInstanceTacticsConfigArgs' tactics_config: The auto scaling policies for reserved instance.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "qualifier_name", qualifier_name)
        pulumi.set(__self__, "qualifier_type", qualifier_type)
        if idle_mode is not None:
            pulumi.set(__self__, "idle_mode", idle_mode)
        if tactics_config is not None:
            pulumi.set(__self__, "tactics_config", tactics_config)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The number of reserved instance.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="qualifierName")
    def qualifier_name(self) -> _builtins.str:
        """
        The version name or alias name.
        """
        return pulumi.get(self, "qualifier_name")

    @_builtins.property
    @pulumi.getter(name="qualifierType")
    def qualifier_type(self) -> _builtins.str:
        """
        The qualifier type of reserved instance.
        """
        return pulumi.get(self, "qualifier_type")

    @_builtins.property
    @pulumi.getter(name="idleMode")
    def idle_mode(self) -> Optional[_builtins.bool]:
        """
        Whether to enable the idle mode.
        """
        return pulumi.get(self, "idle_mode")

    @_builtins.property
    @pulumi.getter(name="tacticsConfig")
    def tactics_config(self) -> Optional['outputs.FunctionReservedInstanceTacticsConfig']:
        """
        The auto scaling policies for reserved instance.
        """
        return pulumi.get(self, "tactics_config")


@pulumi.output_type
class FunctionReservedInstanceTacticsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronConfigs":
            suggest = "cron_configs"
        elif key == "metricConfigs":
            suggest = "metric_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionReservedInstanceTacticsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionReservedInstanceTacticsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionReservedInstanceTacticsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_configs: Optional[Sequence['outputs.FunctionReservedInstanceTacticsConfigCronConfig']] = None,
                 metric_configs: Optional[Sequence['outputs.FunctionReservedInstanceTacticsConfigMetricConfig']] = None):
        """
        :param Sequence['FunctionReservedInstanceTacticsConfigCronConfigArgs'] cron_configs: The list of scheduled policy configurations.
        :param Sequence['FunctionReservedInstanceTacticsConfigMetricConfigArgs'] metric_configs: The list of metric policy configurations.
        """
        if cron_configs is not None:
            pulumi.set(__self__, "cron_configs", cron_configs)
        if metric_configs is not None:
            pulumi.set(__self__, "metric_configs", metric_configs)

    @_builtins.property
    @pulumi.getter(name="cronConfigs")
    def cron_configs(self) -> Optional[Sequence['outputs.FunctionReservedInstanceTacticsConfigCronConfig']]:
        """
        The list of scheduled policy configurations.
        """
        return pulumi.get(self, "cron_configs")

    @_builtins.property
    @pulumi.getter(name="metricConfigs")
    def metric_configs(self) -> Optional[Sequence['outputs.FunctionReservedInstanceTacticsConfigMetricConfig']]:
        """
        The list of metric policy configurations.
        """
        return pulumi.get(self, "metric_configs")


@pulumi.output_type
class FunctionReservedInstanceTacticsConfigCronConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredTime":
            suggest = "expired_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionReservedInstanceTacticsConfigCronConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionReservedInstanceTacticsConfigCronConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionReservedInstanceTacticsConfigCronConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: _builtins.int,
                 cron: _builtins.str,
                 expired_time: _builtins.int,
                 name: _builtins.str,
                 start_time: _builtins.int):
        """
        :param _builtins.int count: The number of reserved instance to which the policy belongs.
        :param _builtins.str cron: The cron expression.
        :param _builtins.int expired_time: The expiration timestamp of the policy.
        :param _builtins.str name: Specifies the name of the function.
        :param _builtins.int start_time: The effective timestamp of policy.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "cron", cron)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The number of reserved instance to which the policy belongs.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def cron(self) -> _builtins.str:
        """
        The cron expression.
        """
        return pulumi.get(self, "cron")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.int:
        """
        The expiration timestamp of the policy.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the function.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.int:
        """
        The effective timestamp of policy.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class FunctionReservedInstanceTacticsConfigMetricConfig(dict):
    def __init__(__self__, *,
                 min: _builtins.int,
                 name: _builtins.str,
                 threshold: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.int min: The minimun of traffic.
        :param _builtins.str name: Specifies the name of the function.
        :param _builtins.int threshold: The metric policy threshold.
        :param _builtins.str type: The type of metric policy.
        """
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def min(self) -> _builtins.int:
        """
        The minimun of traffic.
        """
        return pulumi.get(self, "min")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the function.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.int:
        """
        The metric policy threshold.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of metric policy.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FunctionVersion(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 aliases: Optional['outputs.FunctionVersionAliases'] = None,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the name of the function.
        :param 'FunctionVersionAliasesArgs' aliases: The aliases management for specified version.
        :param _builtins.str description: Specifies the description of the function.
        """
        pulumi.set(__self__, "name", name)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the function.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> Optional['outputs.FunctionVersionAliases']:
        """
        The aliases management for specified version.
        """
        return pulumi.get(self, "aliases")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Specifies the description of the function.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class FunctionVersionAliases(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalVersionStrategy":
            suggest = "additional_version_strategy"
        elif key == "additionalVersionWeights":
            suggest = "additional_version_weights"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionVersionAliases. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionVersionAliases.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionVersionAliases.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 additional_version_strategy: Optional[_builtins.str] = None,
                 additional_version_weights: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the name of the function.
        :param _builtins.str additional_version_strategy: The description of the version alias.
        :param _builtins.str additional_version_weights: The percentage grayscale configuration of the version alias.
        :param _builtins.str description: Specifies the description of the function.
        """
        pulumi.set(__self__, "name", name)
        if additional_version_strategy is not None:
            pulumi.set(__self__, "additional_version_strategy", additional_version_strategy)
        if additional_version_weights is not None:
            pulumi.set(__self__, "additional_version_weights", additional_version_weights)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the function.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="additionalVersionStrategy")
    def additional_version_strategy(self) -> Optional[_builtins.str]:
        """
        The description of the version alias.
        """
        return pulumi.get(self, "additional_version_strategy")

    @_builtins.property
    @pulumi.getter(name="additionalVersionWeights")
    def additional_version_weights(self) -> Optional[_builtins.str]:
        """
        The percentage grayscale configuration of the version alias.
        """
        return pulumi.get(self, "additional_version_weights")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Specifies the description of the function.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetDependenciesPackageResult(dict):
    def __init__(__self__, *,
                 etag: _builtins.str,
                 file_name: _builtins.str,
                 id: _builtins.str,
                 link: _builtins.str,
                 name: _builtins.str,
                 owner: _builtins.str,
                 runtime: _builtins.str,
                 size: _builtins.int,
                 versions: Sequence['outputs.GetDependenciesPackageVersionResult']):
        """
        :param _builtins.str etag: The unique ID of the dependency package.
        :param _builtins.str file_name: The file name of the stored dependency package.
        :param _builtins.str id: The ID of the dependency package version.
        :param _builtins.str link: The OBS bucket path where the dependency package is located (FunctionGraph serivce side).
        :param _builtins.str name: Specifies the name of the dependency package.
        :param _builtins.str owner: The owner of the dependency package.
        :param _builtins.str runtime: Specifies the runtime of the dependency package.  
               The valid values are as follows:
               + **Java8**
               + **Java11**
               + **Node.js6.10**
               + **Node.js8.10**
               + **Node.js10.16**
               + **Node.js12.13**
               + **Node.js14.18**
               + **Node.js16.17**
               + **Node.js18.15**
               + **Python2.7**
               + **Python3.6**
               + **Python3.9**
               + **Python3.10**
               + **Go1.x**
               + **C#(.NET Core 2.0)**
               + **C#(.NET Core 2.1)**
               + **C#(.NET Core 3.1)**
               + **Custom**
               + **PHP7.3**
               + **Cangjie1.0**
               + **http**
               + **Custom Image**
        :param _builtins.int size: The size of the dependency package.
        :param Sequence['GetDependenciesPackageVersionArgs'] versions: The list of the versions for the dependency package.
               The versions structure is documented below.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "file_name", file_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "link", link)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "runtime", runtime)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        The unique ID of the dependency package.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="fileName")
    def file_name(self) -> _builtins.str:
        """
        The file name of the stored dependency package.
        """
        return pulumi.get(self, "file_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the dependency package version.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def link(self) -> _builtins.str:
        """
        The OBS bucket path where the dependency package is located (FunctionGraph serivce side).
        """
        return pulumi.get(self, "link")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the dependency package.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        The owner of the dependency package.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> _builtins.str:
        """
        Specifies the runtime of the dependency package.  
        The valid values are as follows:
        + **Java8**
        + **Java11**
        + **Node.js6.10**
        + **Node.js8.10**
        + **Node.js10.16**
        + **Node.js12.13**
        + **Node.js14.18**
        + **Node.js16.17**
        + **Node.js18.15**
        + **Python2.7**
        + **Python3.6**
        + **Python3.9**
        + **Python3.10**
        + **Go1.x**
        + **C#(.NET Core 2.0)**
        + **C#(.NET Core 2.1)**
        + **C#(.NET Core 3.1)**
        + **Custom**
        + **PHP7.3**
        + **Cangjie1.0**
        + **http**
        + **Custom Image**
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The size of the dependency package.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetDependenciesPackageVersionResult']:
        """
        The list of the versions for the dependency package.
        The versions structure is documented below.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetDependenciesPackageVersionResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 version: _builtins.int):
        """
        :param _builtins.str id: The ID of the dependency package version.
        :param _builtins.int version: The dependency package version.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the dependency package version.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The dependency package version.
        """
        return pulumi.get(self, "version")


