# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GesGraphArgs', 'GesGraph']

@pulumi.input_type
class GesGraphArgs:
    def __init__(__self__, *,
                 crypt_algorithm: pulumi.Input[_builtins.str],
                 enable_https: pulumi.Input[_builtins.bool],
                 graph_size_type_index: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 cpu_arch: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_full_text_index: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_hyg: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rbac: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input['GesGraphEncryptionArgs']] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 keep_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 lts_operation_trace: Optional[pulumi.Input['GesGraphLtsOperationTraceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input['GesGraphPublicIpArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vertex_id_type: Optional[pulumi.Input['GesGraphVertexIdTypeArgs']] = None):
        """
        The set of arguments for constructing a GesGraph resource.
        :param pulumi.Input[_builtins.str] crypt_algorithm: Graph instance cryptography algorithm.
        :param pulumi.Input[_builtins.bool] enable_https: Whether to enable the security mode. This mode may damage GES performance greatly.
        :param pulumi.Input[_builtins.str] graph_size_type_index: Graph size type index.
        :param pulumi.Input[_builtins.str] security_group_id: Indicates the security group ID.  Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Indicates the subnet ID in the specified VPC.  Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_id: Indicates the VPC ID.  Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] cpu_arch: Graph instance's CPU architecture type.
        :param pulumi.Input[_builtins.bool] enable_full_text_index: Whether to enable full-text index control for the created graph.
        :param pulumi.Input[_builtins.bool] enable_hyg: Whether to enable HyG for the graph. This parameter is available for database edition graphs only.
        :param pulumi.Input[_builtins.bool] enable_multi_az: Whether the created graph supports the cross-AZ mode. The default value is false.
        :param pulumi.Input[_builtins.bool] enable_rbac: Whether to enable granular permission control for the created graph.
        :param pulumi.Input['GesGraphEncryptionArgs'] encryption: Whether to enable data encryption The value can be true or false.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID.
        :param pulumi.Input[_builtins.bool] keep_backup: Whether to retain the backups of a graph after it is deleted.
        :param pulumi.Input[_builtins.str] name: Indicates the graph name.  Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] product_type: Graph product type
        :param pulumi.Input['GesGraphPublicIpArgs'] public_ip: Indicates the public network access address of a graph instance.
               Users can access the instance using the IP address from the Internet.
        :param pulumi.Input[_builtins.str] region: Indicates the region code.  Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the graph.
        :param pulumi.Input['GesGraphVertexIdTypeArgs'] vertex_id_type: ID type of vertices. This parameter is mandatory only for database edition graphs.
        """
        pulumi.set(__self__, "crypt_algorithm", crypt_algorithm)
        pulumi.set(__self__, "enable_https", enable_https)
        pulumi.set(__self__, "graph_size_type_index", graph_size_type_index)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if cpu_arch is not None:
            pulumi.set(__self__, "cpu_arch", cpu_arch)
        if enable_full_text_index is not None:
            pulumi.set(__self__, "enable_full_text_index", enable_full_text_index)
        if enable_hyg is not None:
            pulumi.set(__self__, "enable_hyg", enable_hyg)
        if enable_multi_az is not None:
            pulumi.set(__self__, "enable_multi_az", enable_multi_az)
        if enable_rbac is not None:
            pulumi.set(__self__, "enable_rbac", enable_rbac)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if keep_backup is not None:
            pulumi.set(__self__, "keep_backup", keep_backup)
        if lts_operation_trace is not None:
            pulumi.set(__self__, "lts_operation_trace", lts_operation_trace)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_type is not None:
            pulumi.set(__self__, "product_type", product_type)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vertex_id_type is not None:
            pulumi.set(__self__, "vertex_id_type", vertex_id_type)

    @_builtins.property
    @pulumi.getter(name="cryptAlgorithm")
    def crypt_algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        Graph instance cryptography algorithm.
        """
        return pulumi.get(self, "crypt_algorithm")

    @crypt_algorithm.setter
    def crypt_algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "crypt_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="enableHttps")
    def enable_https(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to enable the security mode. This mode may damage GES performance greatly.
        """
        return pulumi.get(self, "enable_https")

    @enable_https.setter
    def enable_https(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enable_https", value)

    @_builtins.property
    @pulumi.getter(name="graphSizeTypeIndex")
    def graph_size_type_index(self) -> pulumi.Input[_builtins.str]:
        """
        Graph size type index.
        """
        return pulumi.get(self, "graph_size_type_index")

    @graph_size_type_index.setter
    def graph_size_type_index(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "graph_size_type_index", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Indicates the security group ID.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Indicates the subnet ID in the specified VPC.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Indicates the VPC ID.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="cpuArch")
    def cpu_arch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Graph instance's CPU architecture type.
        """
        return pulumi.get(self, "cpu_arch")

    @cpu_arch.setter
    def cpu_arch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cpu_arch", value)

    @_builtins.property
    @pulumi.getter(name="enableFullTextIndex")
    def enable_full_text_index(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable full-text index control for the created graph.
        """
        return pulumi.get(self, "enable_full_text_index")

    @enable_full_text_index.setter
    def enable_full_text_index(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_full_text_index", value)

    @_builtins.property
    @pulumi.getter(name="enableHyg")
    def enable_hyg(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable HyG for the graph. This parameter is available for database edition graphs only.
        """
        return pulumi.get(self, "enable_hyg")

    @enable_hyg.setter
    def enable_hyg(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_hyg", value)

    @_builtins.property
    @pulumi.getter(name="enableMultiAz")
    def enable_multi_az(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the created graph supports the cross-AZ mode. The default value is false.
        """
        return pulumi.get(self, "enable_multi_az")

    @enable_multi_az.setter
    def enable_multi_az(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_multi_az", value)

    @_builtins.property
    @pulumi.getter(name="enableRbac")
    def enable_rbac(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable granular permission control for the created graph.
        """
        return pulumi.get(self, "enable_rbac")

    @enable_rbac.setter
    def enable_rbac(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_rbac", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['GesGraphEncryptionArgs']]:
        """
        Whether to enable data encryption The value can be true or false.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['GesGraphEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="keepBackup")
    def keep_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to retain the backups of a graph after it is deleted.
        """
        return pulumi.get(self, "keep_backup")

    @keep_backup.setter
    def keep_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_backup", value)

    @_builtins.property
    @pulumi.getter(name="ltsOperationTrace")
    def lts_operation_trace(self) -> Optional[pulumi.Input['GesGraphLtsOperationTraceArgs']]:
        return pulumi.get(self, "lts_operation_trace")

    @lts_operation_trace.setter
    def lts_operation_trace(self, value: Optional[pulumi.Input['GesGraphLtsOperationTraceArgs']]):
        pulumi.set(self, "lts_operation_trace", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the graph name.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Graph product type
        """
        return pulumi.get(self, "product_type")

    @product_type.setter
    def product_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_type", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input['GesGraphPublicIpArgs']]:
        """
        Indicates the public network access address of a graph instance.
        Users can access the instance using the IP address from the Internet.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input['GesGraphPublicIpArgs']]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the region code.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def replication(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replication", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the graph.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vertexIdType")
    def vertex_id_type(self) -> Optional[pulumi.Input['GesGraphVertexIdTypeArgs']]:
        """
        ID type of vertices. This parameter is mandatory only for database edition graphs.
        """
        return pulumi.get(self, "vertex_id_type")

    @vertex_id_type.setter
    def vertex_id_type(self, value: Optional[pulumi.Input['GesGraphVertexIdTypeArgs']]):
        pulumi.set(self, "vertex_id_type", value)


@pulumi.input_type
class _GesGraphState:
    def __init__(__self__, *,
                 az_code: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_arch: Optional[pulumi.Input[_builtins.str]] = None,
                 crypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_full_text_index: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_https: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_hyg: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rbac: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input['GesGraphEncryptionArgs']] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 graph_size_type_index: Optional[pulumi.Input[_builtins.str]] = None,
                 keep_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 lts_operation_trace: Optional[pulumi.Input['GesGraphLtsOperationTraceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input['GesGraphPublicIpArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 traffic_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vertex_id_type: Optional[pulumi.Input['GesGraphVertexIdTypeArgs']] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GesGraph resources.
        :param pulumi.Input[_builtins.str] az_code: AZ code
        :param pulumi.Input[_builtins.str] cpu_arch: Graph instance's CPU architecture type.
        :param pulumi.Input[_builtins.str] crypt_algorithm: Graph instance cryptography algorithm.
        :param pulumi.Input[_builtins.bool] enable_full_text_index: Whether to enable full-text index control for the created graph.
        :param pulumi.Input[_builtins.bool] enable_https: Whether to enable the security mode. This mode may damage GES performance greatly.
        :param pulumi.Input[_builtins.bool] enable_hyg: Whether to enable HyG for the graph. This parameter is available for database edition graphs only.
        :param pulumi.Input[_builtins.bool] enable_multi_az: Whether the created graph supports the cross-AZ mode. The default value is false.
        :param pulumi.Input[_builtins.bool] enable_rbac: Whether to enable granular permission control for the created graph.
        :param pulumi.Input['GesGraphEncryptionArgs'] encryption: Whether to enable data encryption The value can be true or false.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID.
        :param pulumi.Input[_builtins.str] graph_size_type_index: Graph size type index.
        :param pulumi.Input[_builtins.bool] keep_backup: Whether to retain the backups of a graph after it is deleted.
        :param pulumi.Input[_builtins.str] name: Indicates the graph name.  Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] private_ip: Indicates the private network access address of a graph instance.
               Users can access the instance using the IP address through the ECS
               deployed on the private network.
        :param pulumi.Input[_builtins.str] product_type: Graph product type
        :param pulumi.Input['GesGraphPublicIpArgs'] public_ip: Indicates the public network access address of a graph instance.
               Users can access the instance using the IP address from the Internet.
        :param pulumi.Input[_builtins.str] region: Indicates the region code.  Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] security_group_id: Indicates the security group ID.  Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: Indicates the OBS file import status:
               success: Imported successfully. partiallyFailed: Partially failed. failed: Failed to import the file.
        :param pulumi.Input[_builtins.str] subnet_id: Indicates the subnet ID in the specified VPC.  Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the graph.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] traffic_ip_lists: Physical addresses of a graph instance for access from private networks.
        :param pulumi.Input['GesGraphVertexIdTypeArgs'] vertex_id_type: ID type of vertices. This parameter is mandatory only for database edition graphs.
        :param pulumi.Input[_builtins.str] vpc_id: Indicates the VPC ID.  Changing this parameter will create a new resource.
        """
        if az_code is not None:
            pulumi.set(__self__, "az_code", az_code)
        if cpu_arch is not None:
            pulumi.set(__self__, "cpu_arch", cpu_arch)
        if crypt_algorithm is not None:
            pulumi.set(__self__, "crypt_algorithm", crypt_algorithm)
        if enable_full_text_index is not None:
            pulumi.set(__self__, "enable_full_text_index", enable_full_text_index)
        if enable_https is not None:
            pulumi.set(__self__, "enable_https", enable_https)
        if enable_hyg is not None:
            pulumi.set(__self__, "enable_hyg", enable_hyg)
        if enable_multi_az is not None:
            pulumi.set(__self__, "enable_multi_az", enable_multi_az)
        if enable_rbac is not None:
            pulumi.set(__self__, "enable_rbac", enable_rbac)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if graph_size_type_index is not None:
            pulumi.set(__self__, "graph_size_type_index", graph_size_type_index)
        if keep_backup is not None:
            pulumi.set(__self__, "keep_backup", keep_backup)
        if lts_operation_trace is not None:
            pulumi.set(__self__, "lts_operation_trace", lts_operation_trace)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if product_type is not None:
            pulumi.set(__self__, "product_type", product_type)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_ip_lists is not None:
            pulumi.set(__self__, "traffic_ip_lists", traffic_ip_lists)
        if vertex_id_type is not None:
            pulumi.set(__self__, "vertex_id_type", vertex_id_type)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="azCode")
    def az_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AZ code
        """
        return pulumi.get(self, "az_code")

    @az_code.setter
    def az_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "az_code", value)

    @_builtins.property
    @pulumi.getter(name="cpuArch")
    def cpu_arch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Graph instance's CPU architecture type.
        """
        return pulumi.get(self, "cpu_arch")

    @cpu_arch.setter
    def cpu_arch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cpu_arch", value)

    @_builtins.property
    @pulumi.getter(name="cryptAlgorithm")
    def crypt_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Graph instance cryptography algorithm.
        """
        return pulumi.get(self, "crypt_algorithm")

    @crypt_algorithm.setter
    def crypt_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "crypt_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="enableFullTextIndex")
    def enable_full_text_index(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable full-text index control for the created graph.
        """
        return pulumi.get(self, "enable_full_text_index")

    @enable_full_text_index.setter
    def enable_full_text_index(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_full_text_index", value)

    @_builtins.property
    @pulumi.getter(name="enableHttps")
    def enable_https(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the security mode. This mode may damage GES performance greatly.
        """
        return pulumi.get(self, "enable_https")

    @enable_https.setter
    def enable_https(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_https", value)

    @_builtins.property
    @pulumi.getter(name="enableHyg")
    def enable_hyg(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable HyG for the graph. This parameter is available for database edition graphs only.
        """
        return pulumi.get(self, "enable_hyg")

    @enable_hyg.setter
    def enable_hyg(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_hyg", value)

    @_builtins.property
    @pulumi.getter(name="enableMultiAz")
    def enable_multi_az(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the created graph supports the cross-AZ mode. The default value is false.
        """
        return pulumi.get(self, "enable_multi_az")

    @enable_multi_az.setter
    def enable_multi_az(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_multi_az", value)

    @_builtins.property
    @pulumi.getter(name="enableRbac")
    def enable_rbac(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable granular permission control for the created graph.
        """
        return pulumi.get(self, "enable_rbac")

    @enable_rbac.setter
    def enable_rbac(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_rbac", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['GesGraphEncryptionArgs']]:
        """
        Whether to enable data encryption The value can be true or false.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['GesGraphEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="graphSizeTypeIndex")
    def graph_size_type_index(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Graph size type index.
        """
        return pulumi.get(self, "graph_size_type_index")

    @graph_size_type_index.setter
    def graph_size_type_index(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "graph_size_type_index", value)

    @_builtins.property
    @pulumi.getter(name="keepBackup")
    def keep_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to retain the backups of a graph after it is deleted.
        """
        return pulumi.get(self, "keep_backup")

    @keep_backup.setter
    def keep_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_backup", value)

    @_builtins.property
    @pulumi.getter(name="ltsOperationTrace")
    def lts_operation_trace(self) -> Optional[pulumi.Input['GesGraphLtsOperationTraceArgs']]:
        return pulumi.get(self, "lts_operation_trace")

    @lts_operation_trace.setter
    def lts_operation_trace(self, value: Optional[pulumi.Input['GesGraphLtsOperationTraceArgs']]):
        pulumi.set(self, "lts_operation_trace", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the graph name.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the private network access address of a graph instance.
        Users can access the instance using the IP address through the ECS
        deployed on the private network.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Graph product type
        """
        return pulumi.get(self, "product_type")

    @product_type.setter
    def product_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_type", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input['GesGraphPublicIpArgs']]:
        """
        Indicates the public network access address of a graph instance.
        Users can access the instance using the IP address from the Internet.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input['GesGraphPublicIpArgs']]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the region code.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def replication(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replication", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the security group ID.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the OBS file import status:
        success: Imported successfully. partiallyFailed: Partially failed. failed: Failed to import the file.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the subnet ID in the specified VPC.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the graph.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trafficIpLists")
    def traffic_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Physical addresses of a graph instance for access from private networks.
        """
        return pulumi.get(self, "traffic_ip_lists")

    @traffic_ip_lists.setter
    def traffic_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "traffic_ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="vertexIdType")
    def vertex_id_type(self) -> Optional[pulumi.Input['GesGraphVertexIdTypeArgs']]:
        """
        ID type of vertices. This parameter is mandatory only for database edition graphs.
        """
        return pulumi.get(self, "vertex_id_type")

    @vertex_id_type.setter
    def vertex_id_type(self, value: Optional[pulumi.Input['GesGraphVertexIdTypeArgs']]):
        pulumi.set(self, "vertex_id_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the VPC ID.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:index/gesGraph:GesGraph")
class GesGraph(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cpu_arch: Optional[pulumi.Input[_builtins.str]] = None,
                 crypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_full_text_index: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_https: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_hyg: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rbac: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[Union['GesGraphEncryptionArgs', 'GesGraphEncryptionArgsDict']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 graph_size_type_index: Optional[pulumi.Input[_builtins.str]] = None,
                 keep_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 lts_operation_trace: Optional[pulumi.Input[Union['GesGraphLtsOperationTraceArgs', 'GesGraphLtsOperationTraceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[Union['GesGraphPublicIpArgs', 'GesGraphPublicIpArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vertex_id_type: Optional[pulumi.Input[Union['GesGraphVertexIdTypeArgs', 'GesGraphVertexIdTypeArgsDict']]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        GES graph management

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cpu_arch: Graph instance's CPU architecture type.
        :param pulumi.Input[_builtins.str] crypt_algorithm: Graph instance cryptography algorithm.
        :param pulumi.Input[_builtins.bool] enable_full_text_index: Whether to enable full-text index control for the created graph.
        :param pulumi.Input[_builtins.bool] enable_https: Whether to enable the security mode. This mode may damage GES performance greatly.
        :param pulumi.Input[_builtins.bool] enable_hyg: Whether to enable HyG for the graph. This parameter is available for database edition graphs only.
        :param pulumi.Input[_builtins.bool] enable_multi_az: Whether the created graph supports the cross-AZ mode. The default value is false.
        :param pulumi.Input[_builtins.bool] enable_rbac: Whether to enable granular permission control for the created graph.
        :param pulumi.Input[Union['GesGraphEncryptionArgs', 'GesGraphEncryptionArgsDict']] encryption: Whether to enable data encryption The value can be true or false.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID.
        :param pulumi.Input[_builtins.str] graph_size_type_index: Graph size type index.
        :param pulumi.Input[_builtins.bool] keep_backup: Whether to retain the backups of a graph after it is deleted.
        :param pulumi.Input[_builtins.str] name: Indicates the graph name.  Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] product_type: Graph product type
        :param pulumi.Input[Union['GesGraphPublicIpArgs', 'GesGraphPublicIpArgsDict']] public_ip: Indicates the public network access address of a graph instance.
               Users can access the instance using the IP address from the Internet.
        :param pulumi.Input[_builtins.str] region: Indicates the region code.  Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] security_group_id: Indicates the security group ID.  Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Indicates the subnet ID in the specified VPC.  Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the graph.
        :param pulumi.Input[Union['GesGraphVertexIdTypeArgs', 'GesGraphVertexIdTypeArgsDict']] vertex_id_type: ID type of vertices. This parameter is mandatory only for database edition graphs.
        :param pulumi.Input[_builtins.str] vpc_id: Indicates the VPC ID.  Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GesGraphArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        GES graph management

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param GesGraphArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GesGraphArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cpu_arch: Optional[pulumi.Input[_builtins.str]] = None,
                 crypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_full_text_index: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_https: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_hyg: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rbac: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[Union['GesGraphEncryptionArgs', 'GesGraphEncryptionArgsDict']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 graph_size_type_index: Optional[pulumi.Input[_builtins.str]] = None,
                 keep_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 lts_operation_trace: Optional[pulumi.Input[Union['GesGraphLtsOperationTraceArgs', 'GesGraphLtsOperationTraceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[Union['GesGraphPublicIpArgs', 'GesGraphPublicIpArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vertex_id_type: Optional[pulumi.Input[Union['GesGraphVertexIdTypeArgs', 'GesGraphVertexIdTypeArgsDict']]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GesGraphArgs.__new__(GesGraphArgs)

            __props__.__dict__["cpu_arch"] = cpu_arch
            if crypt_algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'crypt_algorithm'")
            __props__.__dict__["crypt_algorithm"] = crypt_algorithm
            __props__.__dict__["enable_full_text_index"] = enable_full_text_index
            if enable_https is None and not opts.urn:
                raise TypeError("Missing required property 'enable_https'")
            __props__.__dict__["enable_https"] = enable_https
            __props__.__dict__["enable_hyg"] = enable_hyg
            __props__.__dict__["enable_multi_az"] = enable_multi_az
            __props__.__dict__["enable_rbac"] = enable_rbac
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if graph_size_type_index is None and not opts.urn:
                raise TypeError("Missing required property 'graph_size_type_index'")
            __props__.__dict__["graph_size_type_index"] = graph_size_type_index
            __props__.__dict__["keep_backup"] = keep_backup
            __props__.__dict__["lts_operation_trace"] = lts_operation_trace
            __props__.__dict__["name"] = name
            __props__.__dict__["product_type"] = product_type
            __props__.__dict__["public_ip"] = public_ip
            __props__.__dict__["region"] = region
            __props__.__dict__["replication"] = replication
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vertex_id_type"] = vertex_id_type
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["az_code"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["traffic_ip_lists"] = None
        super(GesGraph, __self__).__init__(
            'sbercloud:index/gesGraph:GesGraph',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            az_code: Optional[pulumi.Input[_builtins.str]] = None,
            cpu_arch: Optional[pulumi.Input[_builtins.str]] = None,
            crypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            enable_full_text_index: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_https: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_hyg: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_rbac: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption: Optional[pulumi.Input[Union['GesGraphEncryptionArgs', 'GesGraphEncryptionArgsDict']]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            graph_size_type_index: Optional[pulumi.Input[_builtins.str]] = None,
            keep_backup: Optional[pulumi.Input[_builtins.bool]] = None,
            lts_operation_trace: Optional[pulumi.Input[Union['GesGraphLtsOperationTraceArgs', 'GesGraphLtsOperationTraceArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            product_type: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip: Optional[pulumi.Input[Union['GesGraphPublicIpArgs', 'GesGraphPublicIpArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replication: Optional[pulumi.Input[_builtins.int]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            traffic_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            vertex_id_type: Optional[pulumi.Input[Union['GesGraphVertexIdTypeArgs', 'GesGraphVertexIdTypeArgsDict']]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'GesGraph':
        """
        Get an existing GesGraph resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] az_code: AZ code
        :param pulumi.Input[_builtins.str] cpu_arch: Graph instance's CPU architecture type.
        :param pulumi.Input[_builtins.str] crypt_algorithm: Graph instance cryptography algorithm.
        :param pulumi.Input[_builtins.bool] enable_full_text_index: Whether to enable full-text index control for the created graph.
        :param pulumi.Input[_builtins.bool] enable_https: Whether to enable the security mode. This mode may damage GES performance greatly.
        :param pulumi.Input[_builtins.bool] enable_hyg: Whether to enable HyG for the graph. This parameter is available for database edition graphs only.
        :param pulumi.Input[_builtins.bool] enable_multi_az: Whether the created graph supports the cross-AZ mode. The default value is false.
        :param pulumi.Input[_builtins.bool] enable_rbac: Whether to enable granular permission control for the created graph.
        :param pulumi.Input[Union['GesGraphEncryptionArgs', 'GesGraphEncryptionArgsDict']] encryption: Whether to enable data encryption The value can be true or false.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID.
        :param pulumi.Input[_builtins.str] graph_size_type_index: Graph size type index.
        :param pulumi.Input[_builtins.bool] keep_backup: Whether to retain the backups of a graph after it is deleted.
        :param pulumi.Input[_builtins.str] name: Indicates the graph name.  Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] private_ip: Indicates the private network access address of a graph instance.
               Users can access the instance using the IP address through the ECS
               deployed on the private network.
        :param pulumi.Input[_builtins.str] product_type: Graph product type
        :param pulumi.Input[Union['GesGraphPublicIpArgs', 'GesGraphPublicIpArgsDict']] public_ip: Indicates the public network access address of a graph instance.
               Users can access the instance using the IP address from the Internet.
        :param pulumi.Input[_builtins.str] region: Indicates the region code.  Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] security_group_id: Indicates the security group ID.  Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: Indicates the OBS file import status:
               success: Imported successfully. partiallyFailed: Partially failed. failed: Failed to import the file.
        :param pulumi.Input[_builtins.str] subnet_id: Indicates the subnet ID in the specified VPC.  Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the graph.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] traffic_ip_lists: Physical addresses of a graph instance for access from private networks.
        :param pulumi.Input[Union['GesGraphVertexIdTypeArgs', 'GesGraphVertexIdTypeArgsDict']] vertex_id_type: ID type of vertices. This parameter is mandatory only for database edition graphs.
        :param pulumi.Input[_builtins.str] vpc_id: Indicates the VPC ID.  Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GesGraphState.__new__(_GesGraphState)

        __props__.__dict__["az_code"] = az_code
        __props__.__dict__["cpu_arch"] = cpu_arch
        __props__.__dict__["crypt_algorithm"] = crypt_algorithm
        __props__.__dict__["enable_full_text_index"] = enable_full_text_index
        __props__.__dict__["enable_https"] = enable_https
        __props__.__dict__["enable_hyg"] = enable_hyg
        __props__.__dict__["enable_multi_az"] = enable_multi_az
        __props__.__dict__["enable_rbac"] = enable_rbac
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["graph_size_type_index"] = graph_size_type_index
        __props__.__dict__["keep_backup"] = keep_backup
        __props__.__dict__["lts_operation_trace"] = lts_operation_trace
        __props__.__dict__["name"] = name
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["product_type"] = product_type
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["replication"] = replication
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["traffic_ip_lists"] = traffic_ip_lists
        __props__.__dict__["vertex_id_type"] = vertex_id_type
        __props__.__dict__["vpc_id"] = vpc_id
        return GesGraph(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="azCode")
    def az_code(self) -> pulumi.Output[_builtins.str]:
        """
        AZ code
        """
        return pulumi.get(self, "az_code")

    @_builtins.property
    @pulumi.getter(name="cpuArch")
    def cpu_arch(self) -> pulumi.Output[_builtins.str]:
        """
        Graph instance's CPU architecture type.
        """
        return pulumi.get(self, "cpu_arch")

    @_builtins.property
    @pulumi.getter(name="cryptAlgorithm")
    def crypt_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        Graph instance cryptography algorithm.
        """
        return pulumi.get(self, "crypt_algorithm")

    @_builtins.property
    @pulumi.getter(name="enableFullTextIndex")
    def enable_full_text_index(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable full-text index control for the created graph.
        """
        return pulumi.get(self, "enable_full_text_index")

    @_builtins.property
    @pulumi.getter(name="enableHttps")
    def enable_https(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable the security mode. This mode may damage GES performance greatly.
        """
        return pulumi.get(self, "enable_https")

    @_builtins.property
    @pulumi.getter(name="enableHyg")
    def enable_hyg(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable HyG for the graph. This parameter is available for database edition graphs only.
        """
        return pulumi.get(self, "enable_hyg")

    @_builtins.property
    @pulumi.getter(name="enableMultiAz")
    def enable_multi_az(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the created graph supports the cross-AZ mode. The default value is false.
        """
        return pulumi.get(self, "enable_multi_az")

    @_builtins.property
    @pulumi.getter(name="enableRbac")
    def enable_rbac(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable granular permission control for the created graph.
        """
        return pulumi.get(self, "enable_rbac")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> pulumi.Output['outputs.GesGraphEncryption']:
        """
        Whether to enable data encryption The value can be true or false.
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="graphSizeTypeIndex")
    def graph_size_type_index(self) -> pulumi.Output[_builtins.str]:
        """
        Graph size type index.
        """
        return pulumi.get(self, "graph_size_type_index")

    @_builtins.property
    @pulumi.getter(name="keepBackup")
    def keep_backup(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to retain the backups of a graph after it is deleted.
        """
        return pulumi.get(self, "keep_backup")

    @_builtins.property
    @pulumi.getter(name="ltsOperationTrace")
    def lts_operation_trace(self) -> pulumi.Output['outputs.GesGraphLtsOperationTrace']:
        return pulumi.get(self, "lts_operation_trace")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the graph name.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the private network access address of a graph instance.
        Users can access the instance using the IP address through the ECS
        deployed on the private network.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> pulumi.Output[_builtins.str]:
        """
        Graph product type
        """
        return pulumi.get(self, "product_type")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output['outputs.GesGraphPublicIp']:
        """
        Indicates the public network access address of a graph instance.
        Users can access the instance using the IP address from the Internet.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the region code.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def replication(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "replication")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the security group ID.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the OBS file import status:
        success: Imported successfully. partiallyFailed: Partially failed. failed: Failed to import the file.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the subnet ID in the specified VPC.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The key/value pairs to associate with the graph.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="trafficIpLists")
    def traffic_ip_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Physical addresses of a graph instance for access from private networks.
        """
        return pulumi.get(self, "traffic_ip_lists")

    @_builtins.property
    @pulumi.getter(name="vertexIdType")
    def vertex_id_type(self) -> pulumi.Output['outputs.GesGraphVertexIdType']:
        """
        ID type of vertices. This parameter is mandatory only for database edition graphs.
        """
        return pulumi.get(self, "vertex_id_type")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the VPC ID.  Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

